/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.ui.views;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import pw.palmpatch.models.TargetListInfo;
import pw.palmpatch.ui.views.View;
import pw.palmpatch.ui.widgets.ReadOnlySupportedTextArea;
import pw.palmpatch.ui.widgets.ReadOnlySupportedTextField;

public class TargetListInfoView
extends View {
    private JLabel versionLabel;
    private JLabel dateLabel;
    private JLabel creditsLabel;
    private JLabel numberOfTargetsLabel;
    private JLabel infoTextLabel;
    private JLabel updatesTextLabel;
    private ReadOnlySupportedTextField versionTextField;
    private ReadOnlySupportedTextField dateTextField;
    private ReadOnlySupportedTextField creditsTextField;
    private ReadOnlySupportedTextField numberOfTargetsValue;
    private ReadOnlySupportedTextArea infoTextTextArea;
    private JScrollPane infoTextScrollPane;
    private ReadOnlySupportedTextArea updatesTextArea;
    private JScrollPane updatesScrollPane;
    private Border emptyScrollPaneBorder;
    private TargetListInfo model;

    public TargetListInfoView() {
        this.initialize();
    }

    public void fillTargetListInfo(TargetListInfo targetListInfo) {
        targetListInfo.setVersion(this.versionTextField.getText().trim());
        targetListInfo.setDate(this.dateTextField.getText().trim());
        targetListInfo.setCredits(this.creditsTextField.getText().trim());
        targetListInfo.setInfoText(this.infoTextTextArea.getText().trim());
        targetListInfo.setUpdatesText(this.updatesTextArea.getText().trim());
    }

    public TargetListInfo getModel() {
        return this.model;
    }

    protected void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 10);
        gridBagConstraints.anchor = 17;
        this.versionLabel = new JLabel("Version:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.versionLabel, gridBagConstraints);
        this.add(this.versionLabel);
        this.versionTextField = new ReadOnlySupportedTextField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.versionTextField, gridBagConstraints);
        this.add(this.versionTextField);
        this.dateLabel = new JLabel("Date:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.dateLabel, gridBagConstraints);
        this.add(this.dateLabel);
        this.dateTextField = new ReadOnlySupportedTextField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.dateTextField, gridBagConstraints);
        this.add(this.dateTextField);
        this.creditsLabel = new JLabel("Credits:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.creditsLabel, gridBagConstraints);
        this.add(this.creditsLabel);
        this.creditsTextField = new ReadOnlySupportedTextField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.creditsTextField, gridBagConstraints);
        this.add(this.creditsTextField);
        this.numberOfTargetsLabel = new JLabel("Number of targets:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.numberOfTargetsLabel, gridBagConstraints);
        this.add(this.numberOfTargetsLabel);
        this.numberOfTargetsValue = new ReadOnlySupportedTextField("     ");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.numberOfTargetsValue, gridBagConstraints);
        this.add(this.numberOfTargetsValue);
        this.infoTextLabel = new JLabel("Info:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.infoTextLabel, gridBagConstraints);
        this.add(this.infoTextLabel);
        this.infoTextTextArea = new ReadOnlySupportedTextArea(4, 16);
        this.infoTextTextArea.setLineWrap(false);
        this.infoTextScrollPane = new JScrollPane(this.infoTextTextArea);
        this.infoTextScrollPane.setMinimumSize(new Dimension(100, 100));
        this.infoTextTextArea.setDisabledTextColor((Color)UIManager.get("TextArea.foreground"));
        this.infoTextTextArea.setFont(new Font("Monospaced", 0, 11));
        this.emptyScrollPaneBorder = new CompoundBorder(BorderFactory.createLineBorder(Color.gray), BorderFactory.createEmptyBorder(3, 3, 3, 3));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 0, 2, 0);
        gridBagLayout.setConstraints(this.infoTextScrollPane, gridBagConstraints);
        this.add(this.infoTextScrollPane);
        this.updatesTextLabel = new JLabel("Updates:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.updatesTextLabel, gridBagConstraints);
        this.add(this.updatesTextLabel);
        this.updatesTextArea = new ReadOnlySupportedTextArea(4, 16);
        this.updatesTextArea.setLineWrap(false);
        this.updatesTextArea.setDisabledTextColor((Color)UIManager.get("TextArea.foreground"));
        this.updatesTextArea.setFont(new Font("Monospaced", 0, 11));
        this.updatesScrollPane = new JScrollPane(this.updatesTextArea);
        this.updatesScrollPane.setMinimumSize(new Dimension(100, 100));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.updatesScrollPane, gridBagConstraints);
        this.add(this.updatesScrollPane);
        this.setPreferredSize(new Dimension(550, 500));
    }

    protected void modelChanged() {
        this.versionTextField.setText(this.model.getVersion());
        this.dateTextField.setText(this.model.getDate());
        this.creditsTextField.setText(this.model.getCredits());
        this.numberOfTargetsValue.setText(Integer.toString(this.model.getNumberOfTargets()));
        this.infoTextTextArea.setText(this.model.getInfoText());
        this.updatesTextArea.setText(this.model.getUpdatesText());
        this.versionTextField.select(0, 0);
        this.dateTextField.select(0, 0);
        this.creditsTextField.select(0, 0);
        this.numberOfTargetsValue.select(0, 0);
        this.updatesTextArea.select(0, 0);
        this.infoTextTextArea.select(0, 0);
    }

    public void setEnabled(boolean bl) {
        this.versionTextField.setEnabled(false);
        this.dateTextField.setEnabled(bl);
        this.creditsTextField.setEnabled(bl);
        this.numberOfTargetsValue.setEnabled(false);
        this.infoTextTextArea.setEnabled(bl);
        this.updatesTextArea.setEnabled(bl);
        if (bl) {
            this.infoTextScrollPane.setBorder((Border)UIManager.get("TextField.border"));
            this.updatesScrollPane.setBorder((Border)UIManager.get("TextField.border"));
        } else {
            this.infoTextScrollPane.setBorder(this.emptyScrollPaneBorder);
            this.updatesScrollPane.setBorder(this.emptyScrollPaneBorder);
        }
    }

    public void setModel(TargetListInfo targetListInfo) {
        if (targetListInfo != this.model) {
            this.model = targetListInfo;
            this.modelChanged();
        }
    }
}

