/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.ui.widgets;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import pw.palmpatch.PreferenceNode;

public class PreferenceNodeTreeCellRenderer
extends JComponent
implements TreeCellRenderer {
    protected JLabel textLabel;
    protected JLabel iconLabel;
    protected LineBorder focusBorder;
    protected Border noFocusBorder;
    protected Color textHighlightColor;
    protected Color textHighlightTextColor;

    public PreferenceNodeTreeCellRenderer() {
        this.setLayout(new BoxLayout(this, 0));
        this.textLabel = new JLabel();
        this.iconLabel = new JLabel();
        this.add(this.iconLabel);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.textLabel);
        this.textLabel.setOpaque(false);
        this.iconLabel.setOpaque(false);
        this.focusBorder = new LineBorder(UIManager.getColor("Tree.selectionBorderColor"));
        this.noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        this.textHighlightColor = UIManager.getColor("textHighlight");
        this.textHighlightTextColor = UIManager.getColor("textHighlightText");
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (object != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            PreferenceNode preferenceNode = (PreferenceNode)defaultMutableTreeNode.getUserObject();
            if (preferenceNode != null) {
                this.iconLabel.setIcon(preferenceNode.getIcon());
                this.textLabel.setText(preferenceNode.getTitle());
            } else {
                this.textLabel.setText("N/A");
            }
        }
        if (bl4) {
            this.textLabel.setBorder(new LineBorder(UIManager.getColor("Tree.selectionBorderColor")));
        } else {
            this.textLabel.setBorder(new EmptyBorder(1, 1, 1, 1));
        }
        if (bl) {
            this.textLabel.setOpaque(true);
            this.textLabel.setBackground(this.textHighlightColor);
            this.textLabel.setForeground(this.textHighlightTextColor);
        } else {
            this.textLabel.setOpaque(false);
            this.textLabel.setBackground(jTree.getBackground());
            this.textLabel.setForeground(jTree.getForeground());
        }
        this.invalidate();
        return this;
    }
}

