/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.ui.widgets;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class ProgressIndicator
extends JComponent {
    private JProgressBar progressBar;
    private JButton cancelButton;
    private JLabel messageLabel;
    private boolean canceled;

    public ProgressIndicator() {
        this(new Font("Arial", 0, 9));
    }

    public ProgressIndicator(Font font) {
        this.initialize();
        this.setFont(font);
    }

    public void cancel() {
        this.canceled = true;
        this.cancelButton.setEnabled(false);
    }

    public int getMax() {
        return this.progressBar.getMaximum();
    }

    public boolean hasBeenCanceled() {
        return this.canceled;
    }

    protected void initialize() {
        this.setLayout(new BoxLayout(this, 0));
        this.messageLabel = new JLabel();
        this.add(this.messageLabel);
        this.add(Box.createHorizontalStrut(5));
        this.progressBar = new JProgressBar();
        this.progressBar.setBorderPainted(false);
        this.add(this.progressBar);
        this.add(Box.createHorizontalStrut(5));
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setToolTipText("Cancel current activitiy");
        this.cancelButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProgressIndicator.this.cancel();
            }
        });
        this.cancelButton.setEnabled(false);
        this.add(this.cancelButton);
        this.add(Box.createHorizontalStrut(5));
    }

    public void reset() {
        this.use("", 0, 100);
    }

    public void setFont(Font font) {
        this.messageLabel.setFont(font);
        this.cancelButton.setFont(font);
        this.progressBar.setFont(font);
    }

    public void setMax(int n) {
        this.progressBar.setMaximum(n);
    }

    protected void setMessage(String string) {
        this.messageLabel.setText(string);
    }

    public void setMin(int n) {
        this.progressBar.setMinimum(n);
    }

    public void setProgress(int n) {
        this.progressBar.setValue(n);
    }

    public void use(String string, int n, int n2) {
        this.cancelButton.setEnabled(true);
        this.setMin(n);
        this.setMax(n2);
        this.setMessage(string);
        this.setProgress(0);
        this.canceled = false;
    }
}

