/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.ui.widgets;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class StripedTableCellRenderer
implements TableCellRenderer {
    protected TableCellRenderer targetRenderer;
    protected Color evenBack;
    protected Color evenFore;
    protected Color oddBack;
    protected Color oddFore;
    public static Color DEFAULT_ODD_BACK_COLOR = new Color(238, 238, 238);
    public static Color DEFAULT_EVEN_BACK_COLOR = Color.white;

    public StripedTableCellRenderer(TableCellRenderer tableCellRenderer, Color color, Color color2, Color color3, Color color4) {
        this.targetRenderer = tableCellRenderer;
        this.evenBack = color;
        this.evenFore = color2;
        this.oddBack = color3;
        this.oddFore = color4;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        TableCellRenderer tableCellRenderer = this.targetRenderer;
        if (tableCellRenderer == null) {
            tableCellRenderer = jTable.getDefaultRenderer(jTable.getColumnClass(n2));
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (!bl && !bl2) {
            if ((n & 1) == 0) {
                component.setBackground(this.evenBack != null ? this.evenBack : jTable.getBackground());
                component.setForeground(this.evenFore != null ? this.evenFore : jTable.getForeground());
            } else {
                component.setBackground(this.oddBack != null ? this.oddBack : jTable.getBackground());
                component.setForeground(this.oddFore != null ? this.oddFore : jTable.getForeground());
            }
        }
        return component;
    }

    public static void installInColumn(JTable jTable, int n, Color color, Color color2, Color color3, Color color4) {
        TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
        tableColumn.setCellRenderer(new StripedTableCellRenderer(tableCellRenderer, color, color2, color3, color4));
    }

    public static void installInTable(JTable jTable, Color color, Color color2, Color color3, Color color4) {
        StripedTableCellRenderer stripedTableCellRenderer = null;
        int n = jTable.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(n2);
            TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
            if (tableCellRenderer != null) {
                tableColumn.setCellRenderer(new StripedTableCellRenderer(tableCellRenderer, color, color2, color3, color4));
            } else {
                if (stripedTableCellRenderer == null) {
                    stripedTableCellRenderer = new StripedTableCellRenderer(null, color, color2, color3, color4);
                }
                tableColumn.setCellRenderer(stripedTableCellRenderer);
            }
            ++n2;
        }
    }
}

