/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.ui.widgets;

import java.awt.Component;
import java.io.Serializable;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import pw.palmpatch.models.TargetInfo;
import pw.palmpatch.util.ImageCache;

public class TargetInfoListCellRenderer
extends JLabel
implements ListCellRenderer,
Serializable {
    protected static Border noFocusBorder;
    protected Icon errorIcon;
    protected Icon attachmentIcon;

    public TargetInfoListCellRenderer() {
        noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
        this.errorIcon = ImageCache.loadIcon("icons/error.gif");
        this.attachmentIcon = ImageCache.loadIcon("icons/attachment.gif");
        this.setHorizontalTextPosition(2);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (bl) {
            this.setBackground(jList.getSelectionBackground());
            this.setForeground(jList.getSelectionForeground());
        } else {
            this.setBackground(jList.getBackground());
            this.setForeground(jList.getForeground());
        }
        if (object instanceof Icon) {
            this.setIcon((Icon)object);
        }
        if (object instanceof TargetInfo) {
            this.setText(((TargetInfo)object).getLongName());
            if (((TargetInfo)object).hasError()) {
                this.setIcon(this.errorIcon);
            } else if (((TargetInfo)object).getAttachments().size() > 0) {
                this.setIcon(this.attachmentIcon);
            } else {
                this.setIcon(null);
            }
        } else {
            this.setText(object == null ? "" : object.toString());
        }
        this.setEnabled(jList.isEnabled());
        this.setFont(jList.getFont());
        this.setBorder(bl2 ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
        return this;
    }

    public static class UIResource
    extends DefaultListCellRenderer
    implements javax.swing.plaf.UIResource {
    }
}

