/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch;

import com.holub.tools.Singleton_registry;
import com.sun.java.util.collections.HashMap;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;
import pw.palmpatch.ApplicationInfo;
import pw.palmpatch.Preferences;
import pw.palmpatch.SplashScreen;
import pw.palmpatch.controller.MessagesController;
import pw.palmpatch.controller.PatcherController;
import pw.palmpatch.controller.StatisticsController;
import pw.palmpatch.controller.TargetViewAndEditController;
import pw.palmpatch.models.PatcherMainModel;
import pw.palmpatch.models.StatisticsModel;
import pw.palmpatch.models.TargetViewAndEditModel;
import pw.palmpatch.ui.views.ApplicationFrame;
import pw.palmpatch.ui.views.PatcherMainView;
import pw.palmpatch.util.ActionManager;
import pw.palmpatch.util.ErrorMessage;
import pw.palmpatch.util.IActionManager;
import pw.palmpatch.util.ImageCache;
import pw.palmpatch.util.InfoMessage;
import pw.palmpatch.util.Log;
import pw.palmpatch.util.Tracing;
import pw.palmpatch.util.UIUtilities;

public class Application {
    public static final String PROPERTIES_FILE_NAME = "pwcpp.properties";
    protected ApplicationFrame applicationFrame;
    protected String[] args;
    protected HashMap programParameters;
    protected ApplicationInfo myApplicationInfo;
    protected static Application onlyInstance;
    protected PatcherController aPatcherController;
    protected IActionManager actionManager;
    protected SimpleDateFormat dateFormatter;
    protected Preferences preferences;
    private JWindow splashScreen;
    static /* synthetic */ Class class$pw$palmpatch$Application;

    static {
        Singleton_registry.register(class$pw$palmpatch$Application != null ? class$pw$palmpatch$Application : (class$pw$palmpatch$Application = Application.class$("pw.palmpatch.Application")));
    }

    private Application() {
        this.initialize();
    }

    protected Application(String[] stringArray) {
        this.args = stringArray;
        this.initialize();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void displaySplashScreen() {
        this.splashScreen = new SplashScreen();
        this.splashScreen.pack();
        UIUtilities.centerComponent(this.splashScreen);
        this.splashScreen.show();
    }

    private void disposeSplashScreen() {
        if (this.splashScreen != null) {
            this.splashScreen.dispose();
        }
    }

    public IActionManager getActionManager() {
        return this.actionManager;
    }

    public DateFormat getApplicationDateFormat() {
        return this.dateFormatter;
    }

    public ApplicationFrame getApplicationFrame() {
        return this.applicationFrame;
    }

    public ApplicationInfo getApplicationInfo() {
        if (this.myApplicationInfo == null) {
            this.myApplicationInfo = new ApplicationInfo();
        }
        return this.myApplicationInfo;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    protected void initialize() {
        this.displaySplashScreen();
        System.setSecurityManager(null);
        this.dateFormatter = new SimpleDateFormat("yyyy'-'MM'-'dd");
        UIManager.put("ScrollBar.width", new Integer(15));
        UIManager.put("TextArea.font", UIManager.get("TextField.font"));
        this.actionManager = new ActionManager();
        this.actionManager.setMnemonic("File", 'F');
        this.actionManager.setMnemonic("Target Infos", 'T');
        this.actionManager.setMnemonic("File Infos", 'l');
        this.actionManager.setMnemonic("Attachments", 'A');
        this.actionManager.setMnemonic("Messages", 'M');
        this.actionManager.setMnemonic("Info", 'i');
        this.parseArguments();
    }

    public Preferences loadPreferences() {
        Preferences preferences = new Preferences(PROPERTIES_FILE_NAME);
        try {
            try {
                preferences.load();
                Font font = preferences.getFont("font");
                UIManager.put("Tree.font", new FontUIResource(font));
                UIManager.put("EditorPane.font", new FontUIResource(font));
                UIManager.put("TextPane.font", new FontUIResource(font));
                UIManager.put("TextArea.font", new FontUIResource(font));
                UIManager.put("TextField.font", new FontUIResource(font));
                UIManager.put("List.font", new FontUIResource(font));
                UIManager.put("Table.font", new FontUIResource(font));
                UIManager.put("MenuBar.font", new FontUIResource(font));
                UIManager.put("MenuItem.font", new FontUIResource(font));
                UIManager.put("Menu.font", new FontUIResource(font));
                UIManager.put("Label.font", new FontUIResource(font));
                UIManager.put("TabbedPane.font", new FontUIResource(font));
                UIManager.put("Table.font", new FontUIResource(font));
                UIManager.put("TableHeader.font", new FontUIResource(font));
                UIManager.put("Button.font", new FontUIResource(font));
                UIManager.put("RadioButton.font", new FontUIResource(font));
                UIManager.put("ComboBox.font", new FontUIResource(font));
                UIManager.put("CheckBox.font", new FontUIResource(font));
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                if (!preferences.getString("lookAndFeel").equals("")) {
                    UIManager.setLookAndFeel(preferences.getString("lookAndFeel"));
                } else {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                SwingUtilities.updateComponentTreeUI(SwingUtilities.getRoot(Application.singleton().getApplicationFrame()));
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.singleton().logNewMessage(new ErrorMessage("The Look & Feel could not be changed." + System.getProperty("line.separator") + illegalAccessException));
            }
            catch (InstantiationException instantiationException) {
                Log.singleton().logNewMessage(new ErrorMessage("The Look & Feel could not be changed. " + System.getProperty("line.separator") + instantiationException));
            }
            catch (ClassNotFoundException classNotFoundException) {
                Log.singleton().logNewMessage(new ErrorMessage("The Look & Feel could not be changed." + System.getProperty("line.separator") + classNotFoundException));
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                Log.singleton().logNewMessage(new ErrorMessage("The Look & Feel could not be changed." + System.getProperty("line.separator") + unsupportedLookAndFeelException));
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                Log.singleton().logNewMessage(new ErrorMessage("The Look & Feel could not be changed." + System.getProperty("line.separator") + noClassDefFoundError));
            }
        }
        catch (Throwable throwable) {}
        preferences.setValue("lookAndFeel", UIManager.getLookAndFeel().getClass().getName());
        return preferences;
    }

    public static void main(String[] stringArray) {
        onlyInstance = new Application(stringArray);
        onlyInstance.processStartup();
    }

    protected void parseArguments() {
        if (this.args == null) {
            return;
        }
        this.programParameters = new HashMap();
        int n = 0;
        while (n < this.args.length) {
            if (this.args[n].startsWith("-")) {
                if (n + 1 >= this.args.length) break;
                this.programParameters.put((Object)this.args[n], (Object)this.args[n + 1]);
            } else {
                this.programParameters.put((Object)this.args[n], null);
            }
            n += 2;
        }
    }

    public void processStartup() {
        this.preferences = this.loadPreferences();
        Tracing.singleton().enable(this.preferences.getBool("trace"));
        Tracing.singleton().setLevel(this.preferences.getInt("traceLevel"));
        Tracing.singleton().setDestination(this.preferences.getString("traceDestination"));
        Tracing.singleton().trace("Loaded preferences");
        this.aPatcherController = new PatcherController();
        Tracing.singleton().trace("Instantiated PatcherController");
        PatcherMainView patcherMainView = new PatcherMainView();
        Tracing.singleton().trace("Instantiated PatcherMainView");
        this.aPatcherController.setView(patcherMainView);
        Tracing.singleton().trace("Set view on PatcherController");
        this.aPatcherController.setPreferences(this.preferences);
        Tracing.singleton().trace("Set preferences on PatcherController");
        TargetViewAndEditController targetViewAndEditController = new TargetViewAndEditController();
        Tracing.singleton().trace("Instantiated TargetViewAndEditController");
        targetViewAndEditController.setView(patcherMainView.getTargetViewAndEditView());
        Tracing.singleton().trace("Set view on TargetViewAndEditController");
        TargetViewAndEditModel targetViewAndEditModel = new TargetViewAndEditModel();
        Tracing.singleton().trace("Instantiated TargetViewAndEditModel");
        this.aPatcherController.addChild("targetViewAndEditController", targetViewAndEditController);
        Tracing.singleton().trace("Added TargetViewAndEditController as child to PatcherController");
        targetViewAndEditController.setModel(targetViewAndEditModel);
        Tracing.singleton().trace("Set model on TargetViewAndEditController");
        patcherMainView.getTargetViewAndEditView().setController(targetViewAndEditController);
        Tracing.singleton().trace("Set controller on TargetViewAndEditView");
        MessagesController messagesController = new MessagesController();
        Tracing.singleton().trace("Instantiated MessagesController");
        messagesController.setView(patcherMainView.getMessagesView());
        Tracing.singleton().trace("Set view on MessagesController");
        patcherMainView.getMessagesView().setController(messagesController);
        Tracing.singleton().trace("Set controller on MessagesView");
        StatisticsController statisticsController = new StatisticsController();
        Tracing.singleton().trace("Instantiated StatisticsController");
        statisticsController.setView(patcherMainView.getStatisticsView());
        Tracing.singleton().trace("Set view on StatisticsController");
        StatisticsModel statisticsModel = new StatisticsModel();
        Tracing.singleton().trace("Instantiated StatisticsModel");
        statisticsController.setModel(statisticsModel);
        Tracing.singleton().trace("Set model on StatisticsController");
        patcherMainView.getStatisticsView().setController(statisticsController);
        Tracing.singleton().trace("Set controller on StatisticsView");
        this.aPatcherController.addChild("statisticsController", statisticsController);
        Tracing.singleton().trace("Added StatisticsController as child to PatcherController");
        this.aPatcherController.addListener(statisticsController);
        Tracing.singleton().trace("Added StatisticsController as listener to PatcherController");
        this.aPatcherController.addListener(targetViewAndEditController);
        this.aPatcherController.addListener(this.aPatcherController);
        Tracing.singleton().trace("Added TargetViewAndEditController as listener to PatcherController");
        this.aPatcherController.setModel(new PatcherMainModel());
        Tracing.singleton().trace("Set model on StatisticsController");
        this.aPatcherController.addChild("messagesController", messagesController);
        Tracing.singleton().trace("Added MessagedController as child to PatcherController");
        this.aPatcherController.go();
        Tracing.singleton().trace("Sent go to PatcherController");
        ApplicationFrame applicationFrame = new ApplicationFrame(this.aPatcherController);
        Tracing.singleton().trace("Instantiated ApplicationFrame");
        applicationFrame.getContentPane().add("Center", patcherMainView);
        Tracing.singleton().trace("Added PatcherMainView to ApplicationFrame");
        applicationFrame.setTitle(this.getApplicationInfo().getName());
        Tracing.singleton().trace("Set title on ApplicationFrame");
        ((Frame)applicationFrame).setIconImage(ImageCache.singleton().getImage("icons/smile small.gif"));
        Tracing.singleton().trace("Set icon on ApplicationFrame");
        applicationFrame.setDefaultCloseOperation(0);
        Tracing.singleton().trace("Set default close operation on ApplicationFrame");
        applicationFrame.pack();
        Tracing.singleton().trace("Packed the ApplicationFrame");
        ((Component)applicationFrame).setSize(new Dimension(800, 600));
        Tracing.singleton().trace("Set size on ApplicationFrame");
        UIUtilities.centerComponent(applicationFrame);
        Tracing.singleton().trace("Centered ApplicationFrame");
        applicationFrame.show();
        Tracing.singleton().trace("Showed ApplicationFrame");
        applicationFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Application.this.aPatcherController.getExitAction().invokeFromCode();
            }
        });
        Tracing.singleton().trace("Added window listener on ApplicationFrame");
        this.setApplicationFrame(applicationFrame);
        Tracing.singleton().trace("Set ApplicationFrame");
        String string = System.getProperty("java.version");
        Tracing.singleton().trace("Retrieved java version from environment");
        String string2 = System.getProperty("java.vendor");
        Tracing.singleton().trace("Retrieved java vendor from environment");
        Log.singleton().logNewMessage(new InfoMessage("Running " + string2 + " Java version " + string));
        Tracing.singleton().trace("Logged java version and vendor");
        this.aPatcherController.processStartup();
        Tracing.singleton().trace("Sent processStartup to PatcherController");
        if (this.programParameters != null && this.programParameters.get((Object)"-target") != null) {
            this.aPatcherController.searchForTargetInfoForFile((String)this.programParameters.get((Object)"-target"));
        }
        this.disposeSplashScreen();
    }

    public void setApplicationFrame(ApplicationFrame applicationFrame) {
        Tracing.singleton().trace("Setting applicationFrame to: " + applicationFrame);
        this.applicationFrame = applicationFrame;
    }

    public static Application singleton() {
        return onlyInstance;
    }
}

