/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.controller;

import com.sun.java.util.collections.HashMap;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import pw.palmpatch.Application;
import pw.palmpatch.ui.views.ApplicationFrame;
import pw.palmpatch.util.ErrorMessage;
import pw.palmpatch.util.Log;
import pw.palmpatch.util.Tracing;

public abstract class PWAction
extends AbstractAction {
    public static final int ACTION_FOR_TOOLBAR = 1;
    public static final int ACTION_FOR_MENUBAR = 2;
    public static final int ACTION_FOR_MENU_AND_TOOLBAR = 3;
    protected int placeToPut;
    protected String nameOfMenuToAddTo;
    protected boolean invokedFromCode;
    protected KeyStroke keyboardAccelerator;
    protected HashMap properties;

    public PWAction() {
        this(-1);
    }

    public PWAction(int n) {
        this(n, null);
    }

    public PWAction(int n, String string) {
        this.placeToPut = n;
        this.nameOfMenuToAddTo = string;
        this.properties = new HashMap();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = "actionPerformed";
        Tracing.singleton().traceEntry(this, string, (String)this.getValue("LongDescription"));
        this.setBusy(true);
        try {
            try {
                this.perform(actionEvent);
            }
            catch (Throwable throwable) {
                StringWriter stringWriter = new StringWriter();
                throwable.printStackTrace(new PrintWriter(stringWriter));
                Log.singleton().logNewMessage(new ErrorMessage("UNCAUGHT THROWABLE! Message is: " + throwable.getMessage() + System.getProperty("line.separator") + stringWriter.toString() + System.getProperty("line.separator") + "Please inform the author."));
            }
            Object var4_5 = null;
            this.setBusy(false);
            Tracing.singleton().traceExit(this, string, (String)this.getValue("LongDescription"));
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.setBusy(false);
            Tracing.singleton().traceExit(this, string, (String)this.getValue("LongDescription"));
            throw throwable;
        }
    }

    public KeyStroke getKeyboardAccelerator() {
        return this.keyboardAccelerator;
    }

    public String getNameOfMenuToAddTo() {
        return this.nameOfMenuToAddTo;
    }

    public int getPlaceToPut() {
        return this.placeToPut;
    }

    public Object getProperty(Object object) {
        return this.properties.get(object);
    }

    public void invokeFromCode() {
        if (!this.isEnabled()) {
            throw new RuntimeException(String.valueOf(String.valueOf(this.getClass())) + " is disabled and my not be invoked from code");
        }
        this.invokedFromCode = true;
        this.actionPerformed(new ActionEvent(this, 2000, null));
        this.invokedFromCode = false;
    }

    public abstract void perform(ActionEvent var1);

    public void putProperty(Object object, Object object2) {
        if (object == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        this.properties.put(object, object2);
    }

    public void setBusy(boolean bl) {
        ApplicationFrame applicationFrame = Application.singleton().getApplicationFrame();
        Tracing.singleton().trace("Application.getApplicationFrame() is: " + applicationFrame);
        if (bl) {
            Cursor cursor = new Cursor(3);
            Tracing.singleton().trace("Cursor is: " + cursor);
            Tracing.singleton().trace("Setting wait cursor");
            applicationFrame.setCursor(cursor);
            Tracing.singleton().trace("Set wait cursor");
        } else {
            Cursor cursor = new Cursor(0);
            Tracing.singleton().trace("Cursor is: " + cursor);
            Tracing.singleton().trace("Setting default cursor");
            applicationFrame.setCursor(cursor);
            Tracing.singleton().trace("Set default cursor");
        }
    }

    public void setKeyboardAccelerator(KeyStroke keyStroke) {
        this.keyboardAccelerator = keyStroke;
    }
}

