/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.controller;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.List;
import edu.stanford.cs.ejalbert.BrowserLauncher;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.xml.sax.SAXException;
import pw.palmpatch.Application;
import pw.palmpatch.PreferenceNode;
import pw.palmpatch.Preferences;
import pw.palmpatch.controller.Controller;
import pw.palmpatch.controller.PWAction;
import pw.palmpatch.controller.PatcherController;
import pw.palmpatch.controller.TargetViewAndEditController;
import pw.palmpatch.controller.preferences.PatcherControllerPreferenceNode;
import pw.palmpatch.events.ControllerEvent;
import pw.palmpatch.events.ControllerListener;
import pw.palmpatch.events.PatcherControllerEvent;
import pw.palmpatch.models.Model;
import pw.palmpatch.models.PatcherMainModel;
import pw.palmpatch.models.TargetListInfo;
import pw.palmpatch.net.URL;
import pw.palmpatch.ui.views.AboutDialog;
import pw.palmpatch.ui.views.AboutView;
import pw.palmpatch.ui.views.PWFileChooser;
import pw.palmpatch.ui.views.PatcherMainView;
import pw.palmpatch.ui.views.PreferencesDialog;
import pw.palmpatch.ui.views.TargetListInfoDialog;
import pw.palmpatch.ui.views.TargetListInfoView;
import pw.palmpatch.ui.widgets.ProgressIndicator;
import pw.palmpatch.util.ActionManager;
import pw.palmpatch.util.ErrorMessage;
import pw.palmpatch.util.FileDownloader;
import pw.palmpatch.util.IMessage;
import pw.palmpatch.util.ImageCache;
import pw.palmpatch.util.InfoMessage;
import pw.palmpatch.util.Log;
import pw.palmpatch.util.LogListener;
import pw.palmpatch.util.Tracing;
import pw.palmpatch.util.UIUtilities;
import pw.palmpatch.util.WarningMessage;

public class PatcherController
extends Controller
implements LogListener,
ControllerListener {
    protected PWAction scanDirectoryAction;
    protected PWAction aboutAction;
    protected PWAction helpAction;
    protected PWAction gcAction;
    protected PWAction preferencesAction;
    protected PWAction newTargetListAction;
    protected PWAction loadTargetListAction;
    protected PWAction saveFileAction;
    protected PWAction saveAsFileAction;
    protected PWAction exitAction;
    private PWAction downloadAction;
    protected PWFileChooser fileChooser;
    protected Preferences preferences;
    protected Thread loaderThread;
    private Thread downloadThread;
    protected AboutDialog myAboutDialog;
    protected PreferenceNode myPreferenceNode;
    protected File fileLoaded;

    static /* synthetic */ void access$0(PatcherController patcherController, boolean bl) {
        patcherController.setActionsEnabled(bl);
    }

    static /* synthetic */ PWAction access$1(PatcherController patcherController) {
        return patcherController.getDownloadAction();
    }

    public void clearLog() {
        ((PatcherMainView)this.view).clearLog();
    }

    public void controllerEventOccurred(ControllerEvent controllerEvent) {
        if (controllerEvent instanceof PatcherControllerEvent) {
            switch (controllerEvent.getKind()) {
                case 4: {
                    if (!this.preferences.getBool("loadFileAfterDownload")) break;
                    this.getLoadTargetListAction().putProperty("filePath", controllerEvent.getUserObject());
                    this.getLoadTargetListAction().invokeFromCode();
                    break;
                }
            }
        }
    }

    private void exit() {
        if (this.loaderThread != null && this.loaderThread.isAlive()) {
            this.setStatusMessage("Terminating loading of file...");
            this.loaderThread.interrupt();
            ((PatcherMainView)this.view).getProgressIndicator().cancel();
            try {
                this.loaderThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.downloadThread != null && this.downloadThread.isAlive()) {
            this.setStatusMessage("Terminating download...");
            this.downloadThread.interrupt();
            ((PatcherMainView)this.view).getProgressIndicator().cancel();
            try {
                this.downloadThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.preferences.save();
        Tracing.singleton().cleanUp();
        System.exit(0);
    }

    private PWAction getAboutAction() {
        return this.aboutAction;
    }

    protected AboutDialog getAboutDialog() {
        if (this.myAboutDialog == null) {
            this.myAboutDialog = new AboutDialog((Frame)Application.singleton().getApplicationFrame(), new AboutView(Application.singleton().getApplicationInfo()));
        }
        return this.myAboutDialog;
    }

    public List getActions() {
        ArrayList arrayList = new ArrayList();
        arrayList.add((Object)this.getNewTargetListAction());
        arrayList.add((Object)this.getLoadTargetListAction());
        arrayList.add((Object)this.getScanDirectoryAction());
        arrayList.add((Object)this.getSaveFileAction());
        arrayList.add((Object)this.getSaveAsFileAction());
        arrayList.add((Object)this.getPreferencesAction());
        arrayList.add((Object)this.getDownloadAction());
        arrayList.add((Object)this.getExitAction());
        arrayList.add((Object)this.getAboutAction());
        arrayList.add((Object)this.getHelpAction());
        return arrayList;
    }

    private PWAction getDownloadAction() {
        return this.downloadAction;
    }

    public PWAction getExitAction() {
        return this.exitAction;
    }

    private PWAction getGCAction() {
        return this.gcAction;
    }

    private PWAction getHelpAction() {
        return this.helpAction;
    }

    private PWAction getLoadTargetListAction() {
        return this.loadTargetListAction;
    }

    private PWAction getNewTargetListAction() {
        return this.newTargetListAction;
    }

    public PreferenceNode getPreferenceNode() {
        if (this.myPreferenceNode == null) {
            this.myPreferenceNode = new PatcherControllerPreferenceNode();
        }
        return this.myPreferenceNode;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    private PWAction getPreferencesAction() {
        return this.preferencesAction;
    }

    public ProgressIndicator getProgressIndicator() {
        return ((PatcherMainView)this.view).getProgressIndicator();
    }

    private PWAction getSaveAsFileAction() {
        return this.saveAsFileAction;
    }

    private PWAction getSaveFileAction() {
        return this.saveFileAction;
    }

    private PWAction getScanDirectoryAction() {
        return this.scanDirectoryAction;
    }

    public void go() {
        super.go();
        int n = 0;
        ActionManager actionManager = (ActionManager)Application.singleton().getActionManager();
        actionManager.assignMenuPosition("File", n++);
        actionManager.assignMenuPosition("Target Infos", n++);
        actionManager.assignMenuPosition("File Infos", n++);
        actionManager.assignMenuPosition("Attachments", n++);
        actionManager.assignMenuPosition("Messages", n++);
        actionManager.assignMenuPosition("Info", n++);
    }

    protected void initialize() {
        super.initialize();
        this.scanDirectoryAction = new ScanDirectoryAction();
        this.newTargetListAction = new NewTargetListAction();
        this.loadTargetListAction = new LoadTargetListFileAction();
        this.saveFileAction = new SaveFileAction();
        this.saveFileAction.setEnabled(false);
        this.saveAsFileAction = new SaveAsFileAction();
        this.saveAsFileAction.setEnabled(true);
        this.aboutAction = new AboutAction();
        this.helpAction = new HelpAction();
        this.gcAction = new GCAction();
        this.preferencesAction = new PreferencesAction();
        this.exitAction = new ExitAction();
        this.downloadAction = new DownloadPalmpassAction();
        this.fileChooser = PWFileChooser.createFileChooserForTargetLists();
        this.fileChooser.setPreferredSize(new Dimension(this.fileChooser.getPreferredSize().width, 350));
        Log.singleton().addLogListener(this);
    }

    private void loadPatchListFile(File file) {
        try {
            PatcherMainModel patcherMainModel = new PatcherMainModel();
            this.setModel(patcherMainModel);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.singleton().logNewMessage(new ErrorMessage("The file " + file.getAbsolutePath() + " does not exist"));
            this.setActionsEnabled(true);
            return;
        }
        class LoadAndParseFileThread
        extends Thread {
            private final /* synthetic */ PatcherController this$0;
            private File aFile;

            LoadAndParseFileThread(PatcherController patcherController, File file) {
                this.this$0 = patcherController;
                this.aFile = file;
            }

            public void run() {
                try {
                    Tracing.singleton().trace("Loading file: " + this.aFile.getAbsolutePath(), Tracing.TRACE_SMALL_DETAIL);
                    this.this$0.setStatusMessage("Loading file: " + this.aFile.getAbsolutePath());
                    try {
                        ((PatcherMainModel)this.this$0.model).loadAndParse(this.aFile, ((PatcherMainView)this.this$0.view).getProgressIndicator());
                        if (this.aFile.isFile()) {
                            this.this$0.fileLoaded = this.aFile;
                            this.this$0.saveFileAction.setEnabled(true);
                        } else {
                            this.this$0.fileLoaded = null;
                            this.this$0.saveFileAction.setEnabled(false);
                        }
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        Log.singleton().logNewMessage(new InfoMessage("Reading of file: " + this.aFile + " canceled by user.", true));
                    }
                    catch (Throwable throwable) {
                        this.this$0.setStatusMessage("There was a problem loading file: " + this.aFile.getAbsolutePath());
                        Tracing.singleton().trace("There was a problem loading file: " + this.aFile.getAbsolutePath(), Tracing.TRACE_SMALL_DETAIL);
                        Log.singleton().logNewMessage(new ErrorMessage("There was a problem loading file: " + this.aFile.getAbsolutePath() + "\n" + throwable.toString()));
                    }
                    Object var2_2 = null;
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    PatcherController.access$0(this.this$0, true);
                    this.this$0.fireEvent(new PatcherControllerEvent(this.this$0, 3, (PatcherMainModel)this.this$0.getModel()));
                    throw throwable;
                }
                PatcherController.access$0(this.this$0, true);
                this.this$0.fireEvent(new PatcherControllerEvent(this.this$0, 3, (PatcherMainModel)this.this$0.getModel()));
            }
        }
        this.loaderThread = new LoadAndParseFileThread(this, file);
        this.fireEvent(new PatcherControllerEvent(this, 2));
        this.loaderThread.start();
    }

    public void logNewMessage(IMessage iMessage) {
        if (this.view != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                ((PatcherMainView)this.view).logNewMessage(iMessage);
            } else {
                class MessageSetterRunnable
                implements Runnable {
                    private final /* synthetic */ PatcherController this$0;
                    IMessage messageToSet;

                    public MessageSetterRunnable(PatcherController patcherController, IMessage iMessage) {
                        this.this$0 = patcherController;
                        this.messageToSet = iMessage;
                    }

                    public void run() {
                        ((PatcherMainView)this.this$0.view).logNewMessage(this.messageToSet);
                    }
                }
                SwingUtilities.invokeLater(new MessageSetterRunnable(this, iMessage));
            }
            if (iMessage.showOnStatusBar()) {
                this.setStatusMessage(iMessage.getText());
            }
        } else {
            System.out.println("NEW MESSAGE " + iMessage);
        }
    }

    private void performAboutAction() {
        AboutDialog aboutDialog = this.getAboutDialog();
        aboutDialog.setModal(true);
        aboutDialog.pack();
        aboutDialog.setLocationRelativeTo(null);
        aboutDialog.show();
    }

    public void performCopyTargetInfosForExportToClipboardAction() {
    }

    private void performDownloadPalmpassAction() {
        int n;
        File file;
        Object object;
        java.net.URL uRL = null;
        try {
            uRL = new java.net.URL(Application.singleton().getPreferences().getString("palmpassDownloadURL"));
        }
        catch (MalformedURLException malformedURLException) {
            Log.singleton().logNewMessage(new ErrorMessage(String.valueOf(String.valueOf(uRL)) + " is malformed."));
            return;
        }
        File file2 = new File(this.getPreferences().getString("directoryToDownloadTo"));
        if (!file2.exists()) {
            file2 = new File(System.getProperty("user.home"));
        }
        try {
            object = new URL(uRL.toExternalForm());
            ((URL)object).normalize();
            uRL = new java.net.URL(((URL)object).toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {
            Log.singleton().logNewMessage(new ErrorMessage(String.valueOf(String.valueOf(uRL)) + " is malformed."));
        }
        object = uRL.getPath();
        int n2 = ((String)object).lastIndexOf(47);
        if (n2 != -1) {
            object = ((String)object).substring(n2 + 1);
        }
        if ((file = new File(file2, (String)object)).exists() && this.getPreferences().getBool("askToOverwriteFileToDownload") && (n = JOptionPane.showConfirmDialog(Application.singleton().getApplicationFrame(), "File " + file.getAbsolutePath() + " already exists. Do you want to overwrite the file?", "Question", 0)) == 1) {
            return;
        }
        class DownloadFileThread
        extends Thread {
            private final /* synthetic */ PatcherController this$0;
            private File aFile;
            private java.net.URL urlToDownloadFrom;

            DownloadFileThread(PatcherController patcherController, File file, java.net.URL uRL) {
                this.this$0 = patcherController;
                this.aFile = file;
                this.urlToDownloadFrom = uRL;
            }

            public void run() {
                try {
                    Tracing.singleton().trace("Downloading from URL: " + this.urlToDownloadFrom.toExternalForm(), Tracing.TRACE_SMALL_DETAIL);
                    try {
                        PatcherController.access$1(this.this$0).setEnabled(false);
                        FileDownloader fileDownloader = new FileDownloader();
                        boolean bl = fileDownloader.downloadFile(this.urlToDownloadFrom, this.aFile, this.this$0.getProgressIndicator(), this.this$0.getPreferences().getBool("onlyDownloadFileIfNewerThanLocalFile"));
                        if (bl) {
                            PatcherControllerEvent patcherControllerEvent = new PatcherControllerEvent(this.this$0, 4, (PatcherMainModel)this.this$0.getModel());
                            patcherControllerEvent.setUserObject(this.aFile.getAbsolutePath());
                            this.this$0.fireEvent(patcherControllerEvent, true);
                        }
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        Log.singleton().logNewMessage(new InfoMessage("Downloading canceled by user.", true));
                    }
                    catch (Throwable throwable) {
                        String string = "There was a problem downloading from URL: " + this.urlToDownloadFrom.toExternalForm();
                        this.this$0.setStatusMessage(string);
                        Tracing.singleton().trace(string, Tracing.TRACE_SMALL_DETAIL);
                        Log.singleton().logNewMessage(new ErrorMessage(String.valueOf(string) + System.getProperty("line.separator") + throwable.toString()));
                    }
                    Object var2_6 = null;
                    PatcherController.access$1(this.this$0).setEnabled(true);
                }
                catch (Throwable throwable) {
                    Object var2_7 = null;
                    PatcherController.access$1(this.this$0).setEnabled(true);
                    throw throwable;
                }
            }
        }
        this.downloadThread = new DownloadFileThread(this, file, uRL);
        this.downloadThread.start();
    }

    private void performExitAction() {
        if (((TargetViewAndEditController)this.getChild("targetViewAndEditController")).wereChangesMade()) {
            int n = JOptionPane.showConfirmDialog(Application.singleton().getApplicationFrame(), "You did not save the changes you made. Do you really want to continue?", "Question", 0);
            if (n == 1) {
                return;
            }
            this.exit();
        } else if (this.preferences.getBool("confirmExit")) {
            int n = JOptionPane.showConfirmDialog(Application.singleton().getApplicationFrame(), "Do you really want to exit PWCPP?", "Question", 0);
            if (n == 1) {
                return;
            }
            if (n == 0) {
                this.exit();
            }
        } else {
            this.exit();
        }
    }

    protected void performGC() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Garbage Collection was requested");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("Memory values before Garbage Collection:");
        stringBuffer.append(System.getProperty("line.separator"));
        long l = Runtime.getRuntime().totalMemory();
        long l2 = Runtime.getRuntime().freeMemory();
        long l3 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        stringBuffer.append(String.valueOf(l2) + " / " + l3 + " / " + l);
        Log.singleton().logNewMessage(new InfoMessage(stringBuffer.toString()));
    }

    private void performHelpAction() {
        try {
            BrowserLauncher.openURL("http://www.pilotwarez.com/pwcpp/help/index.html");
        }
        catch (IOException iOException) {
            Log.singleton().logNewMessage(new ErrorMessage("Could not load the help file URL!"));
        }
    }

    private void performLoadTargetListAction(boolean bl, String string) {
        int n;
        if (((TargetViewAndEditController)this.getChild("targetViewAndEditController")).wereChangesMade() && (n = JOptionPane.showConfirmDialog(Application.singleton().getApplicationFrame(), "You did not save the changes you made. Do you really want to continue loading another file?", "Question", 0)) == 1) {
            return;
        }
        ((TargetViewAndEditController)this.getChild("targetViewAndEditController")).resetChanges();
        this.setActionsEnabled(false);
        if (bl) {
            this.loadPatchListFile(new File(string));
        } else {
            this.fileChooser.setFileSelectionMode(0);
            this.fileChooser.setDialogTitle("Choose the file to open");
            this.fileChooser.setApproveButtonText("Choose");
            this.fileChooser.setSelectedFile(null);
            String string2 = this.preferences.getString("lastDirectoryOpenedToLoadTargetList");
            this.fileChooser.setCurrentDirectory(new File(string2));
            this.fileChooser.rescanCurrentDirectory();
            int n2 = this.fileChooser.showOpenDialog(Application.singleton().getApplicationFrame());
            if (n2 == 0) {
                if (this.fileChooser.getSelectedFile() != null) {
                    Log.singleton().clearLog();
                    File file = this.fileChooser.getSelectedFile();
                    String string3 = file.getParent();
                    if (string3 != null) {
                        this.preferences.setValue("lastDirectoryOpenedToLoadTargetList", string3);
                    }
                    this.loadPatchListFile(file);
                }
            } else {
                this.setActionsEnabled(true);
            }
        }
    }

    public void performNewTargetListAction() {
        int n;
        if (((TargetViewAndEditController)this.getChild("targetViewAndEditController")).wereChangesMade() && (n = JOptionPane.showConfirmDialog(Application.singleton().getApplicationFrame(), "You did not save the changes you made. Do you really want to continue?", "Question", 0)) == 1) {
            return;
        }
        ((TargetViewAndEditController)this.getChild("targetViewAndEditController")).resetChanges();
        PatcherMainModel patcherMainModel = new PatcherMainModel();
        this.setModel(patcherMainModel);
        this.fileLoaded = null;
        this.getSaveFileAction().setEnabled(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void performSaveAsFileAction() {
        int n;
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setDialogTitle("Save file");
        this.fileChooser.setSelectedFile(null);
        String string = this.preferences.getString("lastDirectoryOpenedToSaveTargetList");
        if (string != null && string.equals("")) {
            string = this.preferences.getString("lastDirectoryOpenedToLoadTargetList");
        }
        this.fileChooser.rescanCurrentDirectory();
        int n2 = this.fileChooser.showSaveDialog(Application.singleton().getApplicationFrame());
        if (n2 != 0) return;
        File file = this.fileChooser.getSelectedFile();
        if (file == null) return;
        Tracing.singleton().trace("Save as: " + file.getAbsolutePath(), Tracing.TRACE_SMALL_DETAIL);
        if (file.exists() && (n = JOptionPane.showConfirmDialog(Application.singleton().getApplicationFrame(), "The filename you have chosen allready exists. Do you want to continue?", "Question", 0)) == 1) {
            return;
        }
        this.saveFile(file);
    }

    private void performSaveFileAction() {
        if (this.fileLoaded == null) {
            throw new IllegalStateException("fileLoaded is null");
        }
        this.saveFile(this.fileLoaded);
    }

    private void performScanDirectoryAction(boolean bl, String string) {
        int n;
        if (((TargetViewAndEditController)this.getChild("targetViewAndEditController")).wereChangesMade() && (n = JOptionPane.showConfirmDialog(Application.singleton().getApplicationFrame(), "You did not save the changes you made. Do you really want to continue?", "Question", 0)) == 1) {
            return;
        }
        ((TargetViewAndEditController)this.getChild("targetViewAndEditController")).resetChanges();
        this.setActionsEnabled(false);
        if (bl) {
            this.loadPatchListFile(new File(string));
        } else {
            File file;
            String string2;
            this.fileChooser.setFileSelectionMode(1);
            this.fileChooser.rescanCurrentDirectory();
            this.fileChooser.setDialogTitle("Choose the directory to scan");
            this.fileChooser.setApproveButtonText("Choose");
            this.fileChooser.setSelectedFile(null);
            String string3 = this.preferences.getString("lastDirectoryOpenedToLoadTargetList");
            if (string3 == null || string3 != null && string3.equals("")) {
                string3 = System.getProperty("user.dir");
            }
            if ((string2 = (file = new File(string3)).getParent()) != null) {
                this.fileChooser.setCurrentDirectory(new File(string2));
            } else {
                this.fileChooser.setCurrentDirectory(file);
            }
            this.fileChooser.rescanCurrentDirectory();
            int n2 = this.fileChooser.showOpenDialog(Application.singleton().getApplicationFrame());
            if (n2 == 0) {
                if (this.fileChooser.getSelectedFile() != null) {
                    Log.singleton().clearLog();
                    File file2 = this.fileChooser.getSelectedFile();
                    this.preferences.setValue("lastDirectoryOpenedToLoadTargetList", file2.getAbsolutePath());
                    this.scanDirectory(file2);
                }
            } else {
                this.setActionsEnabled(true);
            }
        }
    }

    protected void performShowPreferencesDialogAction() {
        PreferencesDialog preferencesDialog = new PreferencesDialog((Frame)Application.singleton().getApplicationFrame(), true);
        ((Component)preferencesDialog).setSize(450, 330);
        UIUtilities.centerComponent(preferencesDialog);
        preferencesDialog.show();
        preferencesDialog.setLocationRelativeTo(Application.singleton().getApplicationFrame());
    }

    public void processStartup() {
        if (this.preferences.getBool("startupActionsEnabled")) {
            if (this.preferences.getBool("scanDirectoryOnStartup")) {
                File file = new File(this.preferences.getString("directoryToScanOnStartup"));
                if (file.exists()) {
                    this.getScanDirectoryAction().putProperty("filePath", file.getAbsolutePath());
                    this.getScanDirectoryAction().invokeFromCode();
                    this.setActionsEnabled(false);
                } else {
                    Log.singleton().logNewMessage(new WarningMessage("The directory " + file + " specified as the directory to be scanned on startup does not exist"));
                }
            } else if (this.preferences.getBool("loadFileOnStartup")) {
                File file = new File(this.preferences.getString("fileToLoadOnStartup"));
                if (file.exists()) {
                    this.getLoadTargetListAction().putProperty("filePath", file.getAbsolutePath());
                    this.getLoadTargetListAction().invokeFromCode();
                    this.setActionsEnabled(false);
                } else {
                    Log.singleton().logNewMessage(new WarningMessage("The file " + file + " specified as the file to be loaded on startup does not exist"));
                }
            }
        }
    }

    private TargetListInfo queryTargetListInfo() {
        TargetListInfoView targetListInfoView = new TargetListInfoView();
        TargetListInfo targetListInfo = ((PatcherMainModel)this.getModel()).getTargetListInfo();
        targetListInfo.setVersion("2");
        targetListInfo.setNumberOfTargets(((PatcherMainModel)this.getModel()).getTargetInfos().size());
        targetListInfo.setDate(Application.singleton().getApplicationDateFormat().format(new Date()));
        targetListInfoView.setModel(targetListInfo);
        TargetListInfoDialog targetListInfoDialog = new TargetListInfoDialog(targetListInfoView, Application.singleton().getApplicationFrame(), "Enter the Target List Info", true);
        targetListInfoDialog.pack();
        UIUtilities.centerComponent(targetListInfoDialog);
        targetListInfoDialog.setEditable(true);
        targetListInfoDialog.show();
        if (targetListInfoDialog.getUserAction() == TargetListInfoDialog.USER_ACION_CANCEL) {
            return null;
        }
        targetListInfoView.fillTargetListInfo(targetListInfo);
        return targetListInfo;
    }

    protected void saveFile(File file) {
        try {
            TargetListInfo targetListInfo = this.queryTargetListInfo();
            if (targetListInfo != null) {
                ((PatcherMainModel)this.getModel()).setTargetListInfo(targetListInfo);
                String string = this.preferences.getString("encodingUsedForSave");
                ((PatcherMainModel)this.getModel()).saveToFile(file, string);
                ((TargetViewAndEditController)this.getChild("targetViewAndEditController")).resetChanges();
                String string2 = file.getParent();
                if (string2 != null) {
                    this.preferences.setValue("lastDirectoryOpenedToSaveTargetList", string2);
                }
                this.setStatusMessage("The file " + file.getAbsolutePath() + " has been saved successfully.");
            }
        }
        catch (IOException iOException) {
            Log.singleton().logNewMessage(new ErrorMessage("There was an error saving the file " + file.getAbsolutePath() + ". Details: " + iOException));
        }
        catch (SAXException sAXException) {
            Log.singleton().logNewMessage(new ErrorMessage("There was an error saving the file " + file.getAbsolutePath() + ". Details: " + sAXException));
        }
    }

    private void scanDirectory(File file) {
        PatcherMainModel patcherMainModel = new PatcherMainModel();
        this.setModel(patcherMainModel);
        class LoadAndParseAllInDirectoryThread
        extends Thread {
            private final /* synthetic */ File val$directory;
            private final /* synthetic */ PatcherController this$0;
            private File aDirectory;

            LoadAndParseAllInDirectoryThread(File file, PatcherController patcherController, File file2) {
                this.val$directory = file;
                this.this$0 = patcherController;
                this.aDirectory = file2;
            }

            public void run() {
                try {
                    try {
                        this.this$0.setStatusMessage("Scanning directory: " + this.aDirectory.getAbsolutePath());
                        ((PatcherMainModel)this.this$0.model).loadAndParse(this.val$directory, ((PatcherMainView)this.this$0.view).getProgressIndicator());
                        this.this$0.setStatusMessage("Finished scanning directory: " + this.aDirectory.getAbsolutePath());
                        this.this$0.fileLoaded = null;
                        this.this$0.saveFileAction.setEnabled(false);
                    }
                    catch (Throwable throwable) {
                        StringWriter stringWriter = new StringWriter();
                        throwable.printStackTrace(new PrintWriter(stringWriter));
                        this.this$0.setStatusMessage("There was a problem scanning the directory: " + this.aDirectory.getAbsolutePath());
                        Tracing.singleton().trace("There was a problem scanning the directory: " + this.aDirectory.getAbsolutePath(), Tracing.TRACE_SMALL_DETAIL);
                        Log.singleton().logNewMessage(new ErrorMessage("There was a problem scanning the directory: " + this.aDirectory.getAbsolutePath() + "\n" + throwable.getMessage() + "\n" + stringWriter.toString()));
                    }
                    Object var2_3 = null;
                }
                catch (Throwable throwable) {
                    Object var2_4 = null;
                    PatcherController.access$0(this.this$0, true);
                    this.this$0.fireEvent(new PatcherControllerEvent(this.this$0, 3, (PatcherMainModel)this.this$0.getModel()));
                    throw throwable;
                }
                PatcherController.access$0(this.this$0, true);
                this.this$0.fireEvent(new PatcherControllerEvent(this.this$0, 3, (PatcherMainModel)this.this$0.getModel()));
            }
        }
        this.loaderThread = new LoadAndParseAllInDirectoryThread(file, this, file);
        this.loaderThread.start();
    }

    public void searchForTargetInfoForFile(String string) {
        if (this.getModel() == null && this.loaderThread == null) {
            this.getLoadTargetListAction().actionPerformed(new ActionEvent(this, 2000, null));
        }
        if (this.loaderThread != null) {
            Tracing.singleton().trace("Waiting for loader to finish at " + System.currentTimeMillis(), Tracing.TRACE_MEDIUM_DETAIL);
            try {
                this.loaderThread.join();
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Interupted while waiting for for loader to finish at " + System.currentTimeMillis());
                Log.singleton().logNewMessage(new ErrorMessage("Could not search for the speciefied target because of the following exception: " + interruptedException));
            }
            Tracing.singleton().trace("Finished waiting for loader to finish at " + System.currentTimeMillis(), Tracing.TRACE_MEDIUM_DETAIL);
        }
        PWAction pWAction = ((TargetViewAndEditController)this.getChild("targetViewAndEditController")).getSmartSearchForTargetInfoAction();
        boolean bl = pWAction.isEnabled();
        pWAction.putProperty("filePath", string);
        pWAction.setEnabled(true);
        pWAction.invokeFromCode();
        pWAction.setEnabled(bl);
    }

    private void setActionsEnabled(boolean bl) {
        this.loadTargetListAction.setEnabled(bl);
        this.scanDirectoryAction.setEnabled(bl);
        this.saveAsFileAction.setEnabled(bl);
        this.newTargetListAction.setEnabled(bl);
        if (this.fileLoaded != null && bl) {
            this.saveFileAction.setEnabled(true);
        } else {
            this.saveFileAction.setEnabled(false);
        }
    }

    public void setModel(Model model) {
        super.setModel(model);
        this.fireEvent(new PatcherControllerEvent(this, 1, (PatcherMainModel)model));
    }

    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    public void setStatusMessage(String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            ((PatcherMainView)this.view).setStatusMessage(string);
        } else {
            class StatusMessageSetterRunnable
            implements Runnable {
                private final /* synthetic */ PatcherController this$0;
                String messageToSet;

                public StatusMessageSetterRunnable(PatcherController patcherController, String string) {
                    this.this$0 = patcherController;
                    this.messageToSet = string;
                }

                public void run() {
                    ((PatcherMainView)this.this$0.view).setStatusMessage(this.messageToSet);
                }
            }
            SwingUtilities.invokeLater(new StatusMessageSetterRunnable(this, string));
        }
    }

    private class NewTargetListAction
    extends PWAction {
        NewTargetListAction() {
            super(3, "File");
            this.putValue("Name", "New");
            this.putValue("ShortDescription", "New");
            this.putValue("LongDescription", "Start a new Target List");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/new.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            PatcherController.this.performNewTargetListAction();
        }
    }

    private class ScanDirectoryAction
    extends PWAction {
        ScanDirectoryAction() {
            super(3, "File");
            this.putValue("Name", "Scan Directory");
            this.putValue("ShortDescription", "Scan Directory");
            this.putValue("LongDescription", "Scan a directory containing palmpass files");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/scanDirectory.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            PatcherController.this.performScanDirectoryAction(this.invokedFromCode, (String)this.getProperty("filePath"));
        }
    }

    private class LoadTargetListFileAction
    extends PWAction {
        LoadTargetListFileAction() {
            super(3, "File");
            this.setKeyboardAccelerator(KeyStroke.getKeyStroke(76, 2));
            this.putValue("Name", "Load Target List");
            this.putValue("ShortDescription", "Load Target List");
            this.putValue("LongDescription", "Load a Target List");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/loadTargetList.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            String string = (String)this.getProperty("filePath");
            PatcherController.this.performLoadTargetListAction(this.invokedFromCode, string);
        }
    }

    private class SaveFileAction
    extends PWAction {
        SaveFileAction() {
            super(3, "File");
            this.setKeyboardAccelerator(KeyStroke.getKeyStroke(83, 2));
            this.putValue("Name", "Save");
            this.putValue("ShortDescription", "Save");
            this.putValue("LongDescription", "Save");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/saveFile.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            PatcherController.this.performSaveFileAction();
        }
    }

    private class SaveAsFileAction
    extends PWAction {
        SaveAsFileAction() {
            super(3, "File");
            this.putValue("Name", "Save As...");
            this.putValue("ShortDescription", "Save As...");
            this.putValue("LongDescription", "Save As...");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/saveAsFile.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            PatcherController.this.performSaveAsFileAction();
        }
    }

    private class AboutAction
    extends PWAction {
        AboutAction() {
            super(3, "Info");
            this.putValue("Name", "About");
            this.putValue("ShortDescription", "About");
            this.putValue("LongDescription", "Info about this application");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/about.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            PatcherController.this.performAboutAction();
        }
    }

    private class HelpAction
    extends PWAction {
        HelpAction() {
            super(3, "Info");
            this.putValue("Name", "Help");
            this.putValue("ShortDescription", "Help");
            this.putValue("LongDescription", "Display the help files");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/help.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            PatcherController.this.performHelpAction();
        }
    }

    private class PreferencesAction
    extends PWAction {
        PreferencesAction() {
            super(3, "File");
            this.setKeyboardAccelerator(KeyStroke.getKeyStroke(80, 2));
            this.putValue("Name", "Preferences...");
            this.putValue("ShortDescription", "Preferences...");
            this.putValue("LongDescription", "Open Preferences Dialog");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/preferences.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            PatcherController.this.performShowPreferencesDialogAction();
        }
    }

    private class ExitAction
    extends PWAction {
        ExitAction() {
            super(3, "File");
            this.setKeyboardAccelerator(KeyStroke.getKeyStroke(88, 2));
            this.putValue("Name", "Exit");
            this.putValue("ShortDescription", "Exit");
            this.putValue("LongDescription", "Exit PWCPP");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/exit.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            PatcherController.this.performExitAction();
        }
    }

    private class GCAction
    extends PWAction {
        GCAction() {
            super(3, "Info");
            this.putValue("Name", "Run GC");
            this.putValue("ShortDescription", "Run GC");
            this.putValue("LongDescription", "Run Garbage Collection");
        }

        public void perform(ActionEvent actionEvent) {
            PatcherController.this.performGC();
        }
    }

    private class DownloadPalmpassAction
    extends PWAction {
        DownloadPalmpassAction() {
            super(3, "File");
            this.setKeyboardAccelerator(KeyStroke.getKeyStroke(87, 2));
            this.putValue("Name", "Download");
            this.putValue("ShortDescription", "Download XML");
            this.putValue("LongDescription", "Download fresh palmpass XML file from palmWarez");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/download.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            PatcherController.this.performDownloadPalmpassAction();
        }
    }
}

