/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.controller;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import pw.palmpatch.Application;
import pw.palmpatch.Preferences;
import pw.palmpatch.controller.Controller;
import pw.palmpatch.controller.PWAction;
import pw.palmpatch.controller.PatcherController;
import pw.palmpatch.controller.StatisticsController;
import pw.palmpatch.controller.SubController;
import pw.palmpatch.controller.TargetViewAndEditController;
import pw.palmpatch.events.AttachmentChangedEvent;
import pw.palmpatch.events.ControllerEvent;
import pw.palmpatch.events.ControllerListener;
import pw.palmpatch.events.FileInfoChangedEvent;
import pw.palmpatch.events.ModelEvent;
import pw.palmpatch.events.ModelListener;
import pw.palmpatch.events.PatcherControllerEvent;
import pw.palmpatch.events.TargetInfoChangedEvent;
import pw.palmpatch.events.TargetViewAndEditControllerEvent;
import pw.palmpatch.exceptions.FileSizesDontMatchException;
import pw.palmpatch.io.GenericFile;
import pw.palmpatch.io.palmfiles.PDBDatabase;
import pw.palmpatch.io.palmfiles.PRCDatabase;
import pw.palmpatch.io.palmfiles.PalmDatabase;
import pw.palmpatch.io.palmfiles.RessourceType;
import pw.palmpatch.io.palmfiles.StringRessource;
import pw.palmpatch.models.Attachment;
import pw.palmpatch.models.ChangeInfo;
import pw.palmpatch.models.FileInfo;
import pw.palmpatch.models.Model;
import pw.palmpatch.models.PatcherMainModel;
import pw.palmpatch.models.TargetInfo;
import pw.palmpatch.models.TargetInfoDuplicatesRemoverModel;
import pw.palmpatch.models.TargetInfoToAttachmentsTableModelAdapter;
import pw.palmpatch.models.TargetInfoToFileInfosTableModelAdapter;
import pw.palmpatch.models.TargetInfosToListModelAdapter;
import pw.palmpatch.models.TargetViewAndEditModel;
import pw.palmpatch.patchengine.CRC16Support;
import pw.palmpatch.patchengine.FileNotCompatibleException;
import pw.palmpatch.patchengine.PatchEngine;
import pw.palmpatch.patchengine.PatchEngineException;
import pw.palmpatch.ui.views.DetachInfoDialog;
import pw.palmpatch.ui.views.ExportDialog;
import pw.palmpatch.ui.views.ExportImportView;
import pw.palmpatch.ui.views.ImportDialog;
import pw.palmpatch.ui.views.PWFileChooser;
import pw.palmpatch.ui.views.TargetInfoDuplicatesRemoverDialog;
import pw.palmpatch.ui.views.TargetListInfoDialog;
import pw.palmpatch.ui.views.TargetListInfoView;
import pw.palmpatch.ui.views.TargetViewAndEditView;
import pw.palmpatch.ui.widgets.ProgressIndicator;
import pw.palmpatch.util.ErrorMessage;
import pw.palmpatch.util.ImageCache;
import pw.palmpatch.util.InfoMessage;
import pw.palmpatch.util.Log;
import pw.palmpatch.util.Tracing;
import pw.palmpatch.util.UIUtilities;
import pw.palmpatch.util.UUEncoder1;
import pw.palmpatch.util.WarningMessage;

public class TargetViewAndEditController
extends SubController
implements ModelListener,
ControllerListener {
    protected JFileChooser fileChooser;
    protected PWAction chooseTargetFileAction;
    protected PWAction patchTargetFileAction;
    protected PWAction smartPatchTargetFileAction;
    protected PWAction smartSearchForTargetInfoAction;
    protected PWAction pwDataInfoAction;
    protected PWAction sortByTargetLongNameAscendingAction;
    protected PWAction sortByTargetLongNameDescendingAction;
    protected PWAction sortByTargetCreditsAscendingAction;
    protected PWAction sortByTargetCreditsDescendingAction;
    protected PWAction sortByUrlAscendingAction;
    protected PWAction sortByUrlDescendingAction;
    protected PWAction startEditingTargetInfoAction;
    protected PWAction stopEditingTargetInfoAction;
    protected PWAction saveChangesToTargetInfoAction;
    protected PWAction discardChangesToTargetInfoAction;
    protected PWAction deleteTargetInfoAction;
    protected PWAction newTargetInfoAction;
    protected PWAction deleteFileInfoAction;
    protected PWAction newFileInfoAction;
    protected PWAction getInfosFromFileAction;
    protected PWAction useInfosFromFileForTargetInfoAction;
    protected PWAction getChangesFromFilesAction;
    protected PWAction detachAttachmentAction;
    protected PWAction newAttachmentAction;
    protected PWAction removeAttachmentAction;
    protected PWAction exportTargetInfoAction;
    protected PWAction importTargetInfoAction;
    protected PWAction importTargetInfoFromTextAction;
    protected PWAction fileInfoSelectedAction;
    protected PWAction attachmentSelectedAction;
    protected PatchEngine myPatchEngine;
    protected ListSelectionListener targetInfoListSelectionListener;
    protected boolean isEditing;
    protected TargetInfo targetInfoBeforeEditing;
    protected ExportDialog myExportDialog;
    protected ImportDialog myImportDialog;
    protected boolean changesWereMade;
    protected CRC16Support aCRC16Support;
    protected MouseListener mouseListenerOnFileInfosTableView;
    protected MouseListener mouseListenerOnAttachmentTableView;
    protected PatcherMainModel patcherMainModel;
    public static int PATCHING_IMPOSSIBLE = 0;
    public static int NORMAL_PATCHING_POSSIBLE = 1;
    public static int SMARTPATCH_POSSIBLE = 2;

    public TargetViewAndEditController() {
        this.addListener(this);
    }

    static /* synthetic */ List access$0(TargetViewAndEditController targetViewAndEditController, File file, File file2) throws FileNotFoundException, FileSizesDontMatchException, IOException {
        return targetViewAndEditController.doCompareFiles(file, file2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void controllerEventOccurred(ControllerEvent controllerEvent) {
        if (controllerEvent instanceof PatcherControllerEvent) {
            switch (controllerEvent.getKind()) {
                case 2: {
                    this.enableActionsWhileLoading(false);
                    return;
                }
                case 3: {
                    this.getMyModel().getTargetInfosToListModelAdapter().triggerUpdate();
                    this.enableActionsWhileLoading(true);
                    if (this.getMyModel().getTargetInfosToListModelAdapter().getSize() <= 0) return;
                    this.getMyView().setSelectedTargetInfo(0);
                    return;
                }
                case 1: {
                    this.patcherMainModel = ((PatcherControllerEvent)controllerEvent).getNewModel();
                    this.patcherMainModel.addModelListener(this);
                    this.getMyModel().getTargetInfosToListModelAdapter().setModel(((PatcherControllerEvent)controllerEvent).getNewModel().getTargetInfos());
                    this.getMyModel().setCurrentTargetInfo(null);
                    this.getMyView().resetSelectionOfList();
                    return;
                }
                default: {
                    return;
                }
            }
        }
        if (!(controllerEvent instanceof TargetViewAndEditControllerEvent)) return;
        switch (controllerEvent.getKind()) {
            case 1: {
                this.enableActionsWhileComparingFiles(false);
                break;
            }
            case 2: {
                final List list = ((TargetViewAndEditControllerEvent)controllerEvent).getChangeInfos();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        this.getMyModel().getCurrentFileInfo().setChanges(list);
                        this.getMyModel().getTargetInfoToFileInfosTableModelAdapter().fireTableRowsUpdated(this.getMyView().getSelectedFileInfoIndex(), this.getMyView().getSelectedFileInfoIndex());
                        this.getMyView().updateChanges(this.getMyModel().getCurrentFileInfo());
                        this.getMyView().focusInfoTextInEditor();
                    }
                });
                this.enableActionsWhileComparingFiles(true);
                break;
            }
            case 3: {
                this.enableActionsWhileChoosingTarget(false);
                break;
            }
            case 4: {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                    }
                });
                this.enableActionsWhileChoosingTarget(true);
            }
        }
    }

    private int doChooseTargetFile(File file, boolean bl) {
        int n;
        GenericFile genericFile = null;
        if (file.getName().toLowerCase().endsWith(".prc")) {
            genericFile = new PRCDatabase(file);
            try {
                ((PalmDatabase)genericFile).readComplete();
            }
            catch (Throwable throwable) {
                Log.singleton().logNewMessage(new WarningMessage("An error occurred while reading the file " + genericFile.getName() + " : " + throwable, true));
            }
        } else if (file.getName().toLowerCase().endsWith(".pdb")) {
            genericFile = new PDBDatabase(file);
            try {
                ((PDBDatabase)genericFile).readComplete();
            }
            catch (Throwable throwable) {
                Log.singleton().logNewMessage(new WarningMessage("An error occurred while reading the file " + genericFile.getName() + " : " + throwable, true));
            }
        } else {
            genericFile = new GenericFile(file);
        }
        TargetInfo targetInfo = this.getMyModel().getCurrentTargetInfo();
        List list = targetInfo.getFilesInfos();
        FileInfo fileInfo = null;
        if (list.size() == 1) {
            ((FileInfo)list.get(0)).setAssociatedTargetFile(genericFile);
            ((TargetViewAndEditView)this.getView()).setSelectedFileInfo(0);
        } else {
            fileInfo = ((TargetViewAndEditView)this.getView()).getSelectedFileInfo();
            if (fileInfo != null) {
                fileInfo.setAssociatedTargetFile(genericFile);
                n = ((TargetViewAndEditView)this.getView()).getSelectedFileInfoIndex();
                ((TargetViewAndEditView)this.getView()).setSelectedFileInfo(n);
            } else {
                n = 0;
                int n2 = 0;
                while (n2 < list.size()) {
                    fileInfo = (FileInfo)list.get(n2);
                    if (fileInfo.getName().equalsIgnoreCase(genericFile.getName())) {
                        fileInfo.setAssociatedTargetFile(genericFile);
                        ((TargetViewAndEditView)this.getView()).setSelectedFileInfo(n2);
                        n = 1;
                    }
                    ++n2;
                }
                if (n != 0) {
                    this.getMyModel().getCurrentFileInfo().setPatchStatus(0);
                    this.getMyView().displayChosenTargetFile(this.getMyModel().getCurrentFileInfo().getAssociatedTargetFile());
                } else {
                    Log.singleton().logNewMessage(new WarningMessage(String.valueOf(genericFile.getName()) + " does not match one of the FileInfos of the selected TargetInfo", true));
                    return PATCHING_IMPOSSIBLE;
                }
            }
        }
        n = PATCHING_IMPOSSIBLE;
        FileInfo fileInfo2 = this.getMyModel().getCurrentFileInfo();
        try {
            this.myPatchEngine.checkIfNormalPatchingIsPossible(fileInfo2);
            n = NORMAL_PATCHING_POSSIBLE;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.singleton().logNewMessage(new ErrorMessage("Error while checking if normal patching is possible: " + fileNotFoundException));
        }
        catch (IOException iOException) {
            Log.singleton().logNewMessage(new ErrorMessage("Error while checking if normal patching is possible: " + iOException));
        }
        catch (PatchEngineException patchEngineException) {
            Log.singleton().logNewMessage(new ErrorMessage("Error while checking if normal patching is possible: " + patchEngineException));
        }
        catch (FileNotCompatibleException fileNotCompatibleException) {}
        if (n == PATCHING_IMPOSSIBLE) {
            try {
                this.myPatchEngine.checkIfSmartPatchIsPossible(this.getMyModel().getCurrentFileInfo());
                n = SMARTPATCH_POSSIBLE;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.singleton().logNewMessage(new WarningMessage(fileNotFoundException.getMessage(), true));
            }
            catch (IOException iOException) {
                Log.singleton().logNewMessage(new WarningMessage(iOException.getMessage(), true));
            }
            catch (PatchEngineException patchEngineException) {
                Log.singleton().logNewMessage(new InfoMessage(patchEngineException.getMessage(), true));
            }
            catch (FileNotCompatibleException fileNotCompatibleException) {
                Log.singleton().logNewMessage(new WarningMessage(fileNotCompatibleException.getMessage(), true));
            }
        }
        fileInfo2.setPossibleWayToPatch(n);
        boolean bl2 = n != PATCHING_IMPOSSIBLE;
        this.getPatchTargetFilesAction().setEnabled(bl2);
        if (!bl && !bl2) {
            this.getMyModel().getCurrentFileInfo().setAssociatedTargetFile(null);
        }
        this.getMyView().updatePatchableStatus(fileInfo2);
        this.getMyView().displayChosenTargetFile(this.getMyModel().getCurrentFileInfo().getAssociatedTargetFile());
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List doCompareFiles(File file, File file2) throws FileNotFoundException, FileSizesDontMatchException, IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("The file " + file + " cannot be found.");
        }
        if (!file2.exists()) {
            throw new FileNotFoundException("The file " + file2 + " cannot be found.");
        }
        if (file.length() != file2.length()) {
            throw new FileSizesDontMatchException("File sizes differ: " + file + "(" + file.length() + " KB) - " + file2 + "(" + file2.length() + " KB)");
        }
        long l = file.length();
        ProgressIndicator progressIndicator = ((PatcherController)this.getParentController()).getProgressIndicator();
        progressIndicator.use("Comparing files", 0, (int)l);
        this.doGetInfosFromFile(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        BufferedInputStream bufferedInputStream2 = new BufferedInputStream(new FileInputStream(file2));
        ArrayList arrayList = new ArrayList();
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        int n = 1;
        int n2 = 40;
        try {
            int n3 = -1;
            int n4 = -1;
            long l2 = 0L;
            boolean bl = false;
            boolean bl2 = false;
            HexValueArrayList hexValueArrayList = new HexValueArrayList();
            HexValueArrayList hexValueArrayList2 = new HexValueArrayList();
            long l3 = 0L;
            while (l3 < l) {
                progressIndicator.setProgress((int)l3);
                if (progressIndicator.hasBeenCanceled()) {
                    progressIndicator.reset();
                    break;
                }
                n3 = bufferedInputStream.read();
                if (n3 != (n4 = bufferedInputStream2.read())) {
                    if (!bl) {
                        l2 = l3;
                        bl = true;
                        bl2 = false;
                        Tracing.singleton().trace("Found start of byte sequence difference at: " + Long.toString(l2, 16), Tracing.TRACE_MEDIUM_DETAIL);
                    }
                    hexValueArrayList.add(new Integer(n3));
                    hexValueArrayList2.add(new Integer(n4));
                } else if (bl) {
                    Object object;
                    int n5;
                    boolean bl3;
                    int n6;
                    Tracing.singleton().trace("Found end of byte sequence difference at: " + Long.toString(l3, 16), Tracing.TRACE_MEDIUM_DETAIL);
                    bl = false;
                    int[] nArray = new int[hexValueArrayList.size()];
                    int[] nArray2 = new int[nArray.length];
                    int n7 = 0;
                    while (true) {
                        if (n7 >= nArray.length) {
                            Tracing.singleton().trace("Found old byte sequence (now titled current) is: " + ((Object)((Object)hexValueArrayList)).toString(), Tracing.TRACE_MEDIUM_DETAIL);
                            Tracing.singleton().trace("Found new byte sequence is: " + ((Object)((Object)hexValueArrayList2)).toString(), Tracing.TRACE_MEDIUM_DETAIL);
                            hexValueArrayList.clear();
                            hexValueArrayList2.clear();
                            n6 = n;
                            bl3 = false;
                            n5 = -1;
                            break;
                        }
                        nArray[n7] = (Integer)hexValueArrayList.get(n7);
                        nArray2[n7] = (Integer)hexValueArrayList2.get(n7);
                        ++n7;
                    }
                    while (!bl3 && n6 <= n2) {
                        Tracing.singleton().trace("Trying with preCRCCount = " + n6, Tracing.TRACE_MEDIUM_DETAIL);
                        randomAccessFile.seek(l2 - (long)n6);
                        object = new byte[n6];
                        randomAccessFile.read((byte[])object);
                        n5 = this.aCRC16Support.calculateCRC16For((byte[])object);
                        Tracing.singleton().trace("preCRC16Value for current byte sequence is: " + n5, Tracing.TRACE_MEDIUM_DETAIL);
                        boolean bl4 = false;
                        BufferedInputStream bufferedInputStream3 = new BufferedInputStream(new FileInputStream(file));
                        long l4 = -1L;
                        long l5 = 0L;
                        while (l5 < l) {
                            int n8;
                            if (bufferedInputStream3.read() == nArray[0] && l5 != l2) {
                                l4 = l5;
                                if (nArray.length == 1) {
                                    bl4 = true;
                                } else {
                                    int n9 = 1;
                                    while (n9 < nArray.length) {
                                        n8 = bufferedInputStream3.read();
                                        ++l5;
                                        if (n8 == -1) {
                                            bl4 = false;
                                            break;
                                        }
                                        if (n8 != nArray[n9]) {
                                            bl4 = false;
                                            break;
                                        }
                                        bl4 = true;
                                        ++n9;
                                    }
                                }
                            }
                            if (bl4) {
                                Tracing.singleton().trace("Found another matching byte sequence at: " + Long.toString(l4, 16), Tracing.TRACE_MEDIUM_DETAIL);
                                bl2 = true;
                                if (l4 > (long)n6) {
                                    randomAccessFile.seek(l4 - (long)n6);
                                    byte[] byArray = new byte[n6];
                                    randomAccessFile.read(byArray);
                                    n8 = this.aCRC16Support.calculateCRC16For(byArray);
                                    Tracing.singleton().trace("preCRC16 of other matching byte sequence is: " + n8, Tracing.TRACE_MEDIUM_DETAIL);
                                    if (n5 == n8) {
                                        ++n6;
                                        bl3 = false;
                                        Tracing.singleton().trace("Incrementing currentPreCRC16Count due to matching CRC (" + n8 + ") found at: " + Long.toString(l4, 16), Tracing.TRACE_MEDIUM_DETAIL);
                                        break;
                                    }
                                    bl3 = true;
                                    bl4 = false;
                                }
                            }
                            ++l5;
                        }
                        bufferedInputStream3.close();
                        if (bl2) continue;
                        Tracing.singleton().trace("Current byte sequence matches nowhere else in file", Tracing.TRACE_MEDIUM_DETAIL);
                        break;
                    }
                    if (n6 > n2) {
                        object = "Could not find unique preCRC due to preCRCCount: " + n6;
                        Tracing.singleton().trace((String)object, Tracing.TRACE_MEDIUM_DETAIL);
                        Log.singleton().logNewMessage(new WarningMessage((String)object));
                        arrayList.add((Object)new ChangeInfo(l2, nArray, nArray2, -1, -1));
                    } else if (!bl2) {
                        Tracing.singleton().trace("Found unique occurrence", Tracing.TRACE_MEDIUM_DETAIL);
                        arrayList.add((Object)new ChangeInfo(l2, nArray, nArray2, -1, -1));
                    } else {
                        Tracing.singleton().trace("Found unique preCRC: " + n5 + " with preCRCCount: " + n6, Tracing.TRACE_MEDIUM_DETAIL);
                        arrayList.add((Object)new ChangeInfo(l2, nArray, nArray2, n6, n5));
                    }
                }
                ++l3;
            }
        }
        catch (Throwable throwable) {
            Object var13_34 = null;
            bufferedInputStream.close();
            bufferedInputStream2.close();
            randomAccessFile.close();
            throw throwable;
        }
        Object var13_33 = null;
        bufferedInputStream.close();
        bufferedInputStream2.close();
        randomAccessFile.close();
        progressIndicator.reset();
        return arrayList;
    }

    private void doGetInfosFromFile(File file) {
        if (!file.exists()) {
            Log.singleton().logNewMessage(new ErrorMessage("The file " + file + " does not exist!"));
            return;
        }
        if (file.exists() && file.isDirectory()) {
            Log.singleton().logNewMessage(new ErrorMessage("The file " + file + " is a directory! Cannot get infos from a directory."));
            return;
        }
        String string = file.getName();
        final FileInfo fileInfo = this.getMyModel().getCurrentFileInfo();
        if (string.endsWith("prc")) {
            file = new PRCDatabase(file);
            fileInfo.setLongName("Palm Pilot Application");
        } else if (string.endsWith("pdb")) {
            file = new PDBDatabase(file);
            fileInfo.setLongName("Palm Pilot Database");
        } else {
            file = new GenericFile(file);
        }
        fileInfo.setSourceFile(file);
        if (file instanceof PalmDatabase) {
            PalmDatabase palmDatabase = (PalmDatabase)file;
            try {
                palmDatabase.readComplete();
                fileInfo.setId(palmDatabase.getDatabaseName());
                if (file instanceof PRCDatabase) {
                    fileInfo.setVersion(((PRCDatabase)palmDatabase).getVersion());
                }
            }
            catch (IOException iOException) {}
        }
        fileInfo.setCRC16(((GenericFile)file).getCRC16());
        fileInfo.setName(string);
        fileInfo.setSize(Long.toString(file.length()));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                this.getMyView().updateInformation(fileInfo);
            }
        });
    }

    private void doSmartSearchForTargetInfo(File file) {
        int n;
        if (this.patcherMainModel == null) {
            Log.singleton().logNewMessage(new WarningMessage("No Target Info List file is loaded. Smart Search cannot continue.", true));
            return;
        }
        Log.singleton().logNewMessage(new InfoMessage("Searching for TargetInformation for file " + file.getAbsolutePath(), true));
        CRC16Support cRC16Support = new CRC16Support();
        int n2 = -1;
        try {
            n2 = cRC16Support.calculateCRC16For(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.singleton().logNewMessage(new InfoMessage("The specified target file " + file.getAbsolutePath() + " does not exist.", true));
        }
        catch (IOException iOException) {
            Log.singleton().logNewMessage(new InfoMessage("There was an IO error reading the specified target file " + file.getAbsolutePath(), true));
        }
        List list = this.patcherMainModel.getTargetInfos();
        TargetInfo targetInfo = null;
        FileInfo fileInfo = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            targetInfo = (TargetInfo)iterator.next();
            fileInfo = targetInfo.getMatchingFileInfo(file.getName(), file.length());
            if (fileInfo == null) continue;
            this.setCurrentTargetInfo(targetInfo);
            this.chooseTargetFileAction.putProperty("associate", new Boolean(false));
            this.chooseTargetFileAction.putProperty("targetFile", file);
            this.chooseTargetFileAction.invokeFromCode();
            n = (Integer)this.chooseTargetFileAction.getProperty("possibleWayToPatch");
            if (n != PATCHING_IMPOSSIBLE) {
                Log.singleton().logNewMessage(new InfoMessage("Found matching " + targetInfo + " with matching " + fileInfo + " File name and size matches.", true));
                return;
            }
            Log.singleton().logNewMessage(new InfoMessage("Found candiate " + targetInfo + " with matching " + fileInfo + " File name and size matches but patch cannot be applied!.", true));
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            targetInfo = (TargetInfo)iterator.next();
            fileInfo = targetInfo.getMatchingFileInfo(file.getName());
            if (fileInfo == null) continue;
            this.setCurrentTargetInfo(targetInfo);
            this.chooseTargetFileAction.putProperty("associate", new Boolean(false));
            this.chooseTargetFileAction.putProperty("targetFile", file);
            this.chooseTargetFileAction.invokeFromCode();
            n = (Integer)this.chooseTargetFileAction.getProperty("possibleWayToPatch");
            if (n != PATCHING_IMPOSSIBLE) {
                Log.singleton().logNewMessage(new InfoMessage("Found matching " + targetInfo + " with matching " + fileInfo + " File name matches.", true));
                return;
            }
            Log.singleton().logNewMessage(new InfoMessage("Found candiate " + targetInfo + " with matching " + fileInfo + " File name matches but patch cannot be applied!.", true));
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            targetInfo = (TargetInfo)iterator.next();
            fileInfo = targetInfo.getMatchingFileInfo(n2);
            if (fileInfo == null) continue;
            this.setCurrentTargetInfo(targetInfo);
            this.chooseTargetFileAction.putProperty("associate", new Boolean(false));
            this.chooseTargetFileAction.putProperty("targetFile", file);
            this.chooseTargetFileAction.invokeFromCode();
            n = (Integer)this.chooseTargetFileAction.getProperty("possibleWayToPatch");
            if (n != PATCHING_IMPOSSIBLE) {
                Log.singleton().logNewMessage(new InfoMessage("Found matching " + targetInfo + " with matching " + fileInfo + " CRC matches.", true));
                return;
            }
            Log.singleton().logNewMessage(new InfoMessage("Found candiate " + targetInfo + " with matching " + fileInfo + " CRC matches but patch cannot be applied!.", true));
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            targetInfo = (TargetInfo)iterator.next();
            fileInfo = targetInfo.getMatchingFileInfo(file.length());
            if (fileInfo == null) continue;
            this.setCurrentTargetInfo(targetInfo);
            this.chooseTargetFileAction.putProperty("associate", new Boolean(false));
            this.chooseTargetFileAction.putProperty("targetFile", file);
            this.chooseTargetFileAction.invokeFromCode();
            n = (Integer)this.chooseTargetFileAction.getProperty("possibleWayToPatch");
            if (n != PATCHING_IMPOSSIBLE) {
                Log.singleton().logNewMessage(new InfoMessage("Found matching " + targetInfo + " with matching " + fileInfo + " File size matches.", true));
                return;
            }
            Log.singleton().logNewMessage(new InfoMessage("Found candiate " + targetInfo + " with matching " + fileInfo + " File size matches but patch cannot be applied!.", true));
        }
        Log.singleton().logNewMessage(new InfoMessage("No matching TargetInfos were found for file " + file.getAbsolutePath(), true));
    }

    protected void enableActionsWhileChoosingTarget(boolean bl) {
        Iterator iterator = this.getActions().iterator();
        while (iterator.hasNext()) {
            ((PWAction)iterator.next()).setEnabled(bl);
        }
        this.getNewFileInfoAction().setEnabled(false);
        this.getPatchTargetFilesAction().setEnabled(false);
        this.getDeleteFileInfoAction().setEnabled(false);
        this.getRemoveAttachmentAction().setEnabled(false);
        this.getNewAttachmentAction().setEnabled(false);
        this.getStopEditingTargetInfoAction().setEnabled(bl);
        this.getSaveChangesToTargetInfoAction().setEnabled(bl);
        this.getDiscardChangesToTargetInfoAction().setEnabled(bl);
        this.getGetInfosFromFileAction().setEnabled(bl);
        this.getGetChangesFromFilesAction().setEnabled(bl);
    }

    protected void enableActionsWhileComparingFiles(boolean bl) {
        Iterator iterator = this.getActions().iterator();
        while (iterator.hasNext()) {
            ((PWAction)iterator.next()).setEnabled(bl);
        }
        this.getPatchTargetFilesAction().setEnabled(false);
        this.getRemoveAttachmentAction().setEnabled(false);
        this.getChooseTargetFileAction().setEnabled(false);
        this.getStopEditingTargetInfoAction().setEnabled(bl);
        this.getSaveChangesToTargetInfoAction().setEnabled(bl);
        this.getDiscardChangesToTargetInfoAction().setEnabled(bl);
        this.getGetInfosFromFileAction().setEnabled(bl);
        this.getGetChangesFromFilesAction().setEnabled(bl);
        this.getUseInfosFromFileForTargetInfoAction().setEnabled(bl);
    }

    protected void enableActionsWhileLoading(boolean bl) {
        Iterator iterator = this.getActions().iterator();
        while (iterator.hasNext()) {
            ((PWAction)iterator.next()).setEnabled(bl);
        }
        this.getNewFileInfoAction().setEnabled(false);
        this.getPatchTargetFilesAction().setEnabled(false);
        this.getDeleteFileInfoAction().setEnabled(false);
        this.getRemoveAttachmentAction().setEnabled(false);
        this.getNewAttachmentAction().setEnabled(false);
        this.getDetachAttachmentAction().setEnabled(false);
        this.getSortByTargetCreditsAscendingAction().setEnabled(true);
        this.getSortByTargetCreditsDescendingAction().setEnabled(true);
        this.getSortByTargetLongNameAscendingAction().setEnabled(true);
        this.getSortByTargetLongNameDescendingAction().setEnabled(true);
    }

    public List getActions() {
        ArrayList arrayList = new ArrayList();
        arrayList.add((Object)this.getChooseTargetFileAction());
        arrayList.add((Object)this.getSmartSearchForTargetInfoAction());
        arrayList.add((Object)this.getPatchTargetFilesAction());
        arrayList.add((Object)this.getSortByTargetLongNameAscendingAction());
        arrayList.add((Object)this.getSortByTargetLongNameDescendingAction());
        arrayList.add((Object)this.getSortByTargetCreditsAscendingAction());
        arrayList.add((Object)this.getSortByTargetCreditsDescendingAction());
        arrayList.add((Object)this.getSortByUrlAscendingAction());
        arrayList.add((Object)this.getSortByUrlDescendingAction());
        arrayList.add((Object)this.getPWDataInfoAction());
        arrayList.add((Object)this.getNewTargetInfoAction());
        arrayList.add((Object)this.getStartEditingTargetInfoAction());
        arrayList.add((Object)this.getDeleteTargetInfoAction());
        arrayList.add((Object)this.getNewFileInfoAction());
        arrayList.add((Object)this.getDeleteFileInfoAction());
        arrayList.add((Object)this.getDetachAttachmentAction());
        arrayList.add((Object)this.getNewAttachmentAction());
        arrayList.add((Object)this.getRemoveAttachmentAction());
        arrayList.add((Object)this.getImportTargetInfoAction());
        arrayList.add((Object)this.getExportTargetInfoAction());
        return arrayList;
    }

    public PWAction getAttachmentSelectedAction() {
        return this.attachmentSelectedAction;
    }

    public PWAction getChooseTargetFileAction() {
        return this.chooseTargetFileAction;
    }

    public PWAction getDeleteFileInfoAction() {
        return this.deleteFileInfoAction;
    }

    public PWAction getDeleteTargetInfoAction() {
        return this.deleteTargetInfoAction;
    }

    public PWAction getDetachAttachmentAction() {
        return this.detachAttachmentAction;
    }

    public PWAction getDiscardChangesToTargetInfoAction() {
        return this.discardChangesToTargetInfoAction;
    }

    public PWAction getExportTargetInfoAction() {
        return this.exportTargetInfoAction;
    }

    public PWAction getFileInfoSelectedAction() {
        return this.fileInfoSelectedAction;
    }

    public PWAction getGetChangesFromFilesAction() {
        return this.getChangesFromFilesAction;
    }

    public PWAction getGetInfosFromFileAction() {
        return this.getInfosFromFileAction;
    }

    public PWAction getImportTargetInfoAction() {
        return this.importTargetInfoAction;
    }

    public PWAction getImportTargetInfoFromTextAction() {
        return this.importTargetInfoFromTextAction;
    }

    public MouseListener getMouseListenerOnAttachmentTableView() {
        return this.mouseListenerOnAttachmentTableView;
    }

    public MouseListener getMouseListenerOnFileInfosTableView() {
        return this.mouseListenerOnFileInfosTableView;
    }

    protected TargetViewAndEditModel getMyModel() {
        return (TargetViewAndEditModel)this.getModel();
    }

    protected TargetViewAndEditView getMyView() {
        return (TargetViewAndEditView)this.getView();
    }

    public PWAction getNewAttachmentAction() {
        return this.newAttachmentAction;
    }

    public PWAction getNewFileInfoAction() {
        return this.newFileInfoAction;
    }

    public PWAction getNewTargetInfoAction() {
        return this.newTargetInfoAction;
    }

    public PWAction getPWDataInfoAction() {
        return this.pwDataInfoAction;
    }

    public PWAction getPatchTargetFilesAction() {
        return this.patchTargetFileAction;
    }

    public PWAction getRemoveAttachmentAction() {
        return this.removeAttachmentAction;
    }

    public PWAction getSaveChangesToTargetInfoAction() {
        return this.saveChangesToTargetInfoAction;
    }

    public PWAction getSmartSearchForTargetInfoAction() {
        return this.smartSearchForTargetInfoAction;
    }

    public PWAction getSortByTargetCreditsAscendingAction() {
        return this.sortByTargetCreditsAscendingAction;
    }

    public PWAction getSortByTargetCreditsDescendingAction() {
        return this.sortByTargetCreditsDescendingAction;
    }

    public PWAction getSortByTargetLongNameAscendingAction() {
        return this.sortByTargetLongNameAscendingAction;
    }

    public PWAction getSortByTargetLongNameDescendingAction() {
        return this.sortByTargetLongNameDescendingAction;
    }

    public PWAction getSortByUrlAscendingAction() {
        return this.sortByUrlAscendingAction;
    }

    public PWAction getSortByUrlDescendingAction() {
        return this.sortByUrlDescendingAction;
    }

    public PWAction getStartEditingTargetInfoAction() {
        return this.startEditingTargetInfoAction;
    }

    public PWAction getStopEditingTargetInfoAction() {
        return this.stopEditingTargetInfoAction;
    }

    public TargetInfoToAttachmentsTableModelAdapter getTargetInfoToAttachmentsTableModelAdapter() {
        return this.getMyModel().getTargetInfoToAttachmentsTableModelAdapter();
    }

    public TargetInfoToFileInfosTableModelAdapter getTargetInfoToFileInfosTableModelAdapter() {
        return this.getMyModel().getTargetInfoToFileInfosTableModelAdapter();
    }

    public TargetInfosToListModelAdapter getTargetInfosToListModelAdapter() {
        return this.getMyModel().getTargetInfosToListModelAdapter();
    }

    public PWAction getUseInfosFromFileForTargetInfoAction() {
        return this.useInfosFromFileForTargetInfoAction;
    }

    protected void initialize() {
        super.initialize();
        this.chooseTargetFileAction = new ChooseTargetFileAction();
        this.chooseTargetFileAction.setEnabled(false);
        this.smartSearchForTargetInfoAction = new SmartSearchForTargetInfoAction();
        this.smartSearchForTargetInfoAction.setEnabled(false);
        this.patchTargetFileAction = new PatchTargetFileAction();
        this.patchTargetFileAction.setEnabled(false);
        this.pwDataInfoAction = new PWDataInfoAction();
        this.pwDataInfoAction.setEnabled(false);
        this.sortByTargetLongNameAscendingAction = new SortByTargetLongNameAscendingAction();
        this.sortByTargetLongNameDescendingAction = new SortByTargetLongNameDescendingAction();
        this.sortByTargetCreditsAscendingAction = new SortByTargetCreditsAscendingAction();
        this.sortByTargetCreditsDescendingAction = new SortByTargetCreditsDescendingAction();
        this.sortByUrlAscendingAction = new SortByUrlAscendingAction();
        this.sortByUrlDescendingAction = new SortByUrlDescendingAction();
        this.sortByTargetLongNameAscendingAction.setEnabled(false);
        this.sortByTargetLongNameDescendingAction.setEnabled(false);
        this.sortByTargetCreditsAscendingAction.setEnabled(false);
        this.sortByTargetCreditsDescendingAction.setEnabled(false);
        this.startEditingTargetInfoAction = new StartEditingTargetInfoAction();
        this.startEditingTargetInfoAction.setEnabled(false);
        this.stopEditingTargetInfoAction = new StopEditingTargetInfoAction();
        this.stopEditingTargetInfoAction.setEnabled(false);
        this.saveChangesToTargetInfoAction = new SaveChangesToTargetInfoAction();
        this.discardChangesToTargetInfoAction = new DiscardChangesToTargetInfoAction();
        this.newTargetInfoAction = new NewTargetInfoAction();
        this.deleteTargetInfoAction = new DeleteTargetInfoAction();
        this.deleteTargetInfoAction.setEnabled(false);
        this.newFileInfoAction = new NewFileInfoAction();
        this.newFileInfoAction.setEnabled(false);
        this.deleteFileInfoAction = new DeleteFileInfoAction();
        this.deleteFileInfoAction.setEnabled(false);
        this.getInfosFromFileAction = new GetInfosFromFileAction();
        this.getInfosFromFileAction.setEnabled(false);
        this.getChangesFromFilesAction = new GetChangesFromFilesAction();
        this.getChangesFromFilesAction.setEnabled(false);
        this.useInfosFromFileForTargetInfoAction = new UseInfosFromFileForTargetInfoAction();
        this.useInfosFromFileForTargetInfoAction.setEnabled(false);
        this.myPatchEngine = new PatchEngine();
        this.detachAttachmentAction = new DetachAttachmentAction();
        this.detachAttachmentAction.setEnabled(false);
        this.newAttachmentAction = new NewAttachmentAction();
        this.newAttachmentAction.setEnabled(false);
        this.removeAttachmentAction = new RemoveAttachmentAction();
        this.removeAttachmentAction.setEnabled(false);
        this.importTargetInfoAction = new ImportTargetInfoAction();
        this.importTargetInfoFromTextAction = new ImportTargetInfoFromTextAction();
        this.exportTargetInfoAction = new ExportTargetInfoAction();
        this.fileInfoSelectedAction = new FileInfoSelectedAction();
        this.attachmentSelectedAction = new AttachmentSelectedAction();
        this.fileChooser = PWFileChooser.createFileChooserForTargets();
        this.fileChooser.setFileFilter(null);
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setPreferredSize(new Dimension(this.fileChooser.getPreferredSize().width, 350));
        this.fileChooser.setDialogTitle("Choose the file to open");
        this.mouseListenerOnFileInfosTableView = new MouseListenerOnFileInfosTableView();
        this.mouseListenerOnAttachmentTableView = new MouseListenerOnAttachmentTableView();
        this.aCRC16Support = new CRC16Support();
    }

    public void modelEventOccurred(ModelEvent modelEvent) {
        if (modelEvent.getSource() instanceof PatcherMainModel) {
            if (this.isEditing) {
                this.isEditing = false;
                this.getMyModel().setCurrentTargetInfo(null);
                this.getMyView().switchToEditing(false);
                this.deleteFileInfoAction.setEnabled(false);
                this.removeAttachmentAction.setEnabled(false);
                this.newAttachmentAction.setEnabled(false);
                this.newFileInfoAction.setEnabled(false);
                this.targetInfoBeforeEditing = null;
            }
            this.getMyModel().setCurrentTargetInfo(null);
            this.getMyModel().getTargetInfosToListModelAdapter().triggerUpdate();
            this.getMyView().resetSelectionOfList();
            this.smartSearchForTargetInfoAction.setEnabled(true);
            this.sortByTargetLongNameAscendingAction.setEnabled(true);
            this.sortByTargetLongNameDescendingAction.setEnabled(true);
            this.sortByTargetCreditsAscendingAction.setEnabled(true);
            this.sortByTargetCreditsDescendingAction.setEnabled(true);
            this.pwDataInfoAction.setEnabled(true);
        } else if (modelEvent instanceof TargetInfoChangedEvent) {
            TargetInfo targetInfo = this.getMyModel().getCurrentTargetInfo();
            this.getMyView().setCurrentTargetInfo(targetInfo);
            if (targetInfo != null && !this.isEditing) {
                this.startEditingTargetInfoAction.setEnabled(true);
                this.deleteTargetInfoAction.setEnabled(true);
                if (targetInfo.getFilesInfos().size() == 0) {
                    this.chooseTargetFileAction.setEnabled(false);
                } else {
                    this.chooseTargetFileAction.setEnabled(true);
                }
            } else {
                this.chooseTargetFileAction.setEnabled(false);
                this.startEditingTargetInfoAction.setEnabled(false);
                this.deleteTargetInfoAction.setEnabled(false);
            }
        } else if (modelEvent instanceof FileInfoChangedEvent) {
            FileInfoChangedEvent fileInfoChangedEvent = (FileInfoChangedEvent)modelEvent;
            FileInfo fileInfo = fileInfoChangedEvent.getNewFileInfo();
            if (!this.isEditing) {
                if (fileInfo != null) {
                    this.getMyView().displayChosenTargetFile(fileInfo.getAssociatedTargetFile());
                    if (fileInfo.isPatchingPossible()) {
                        this.patchTargetFileAction.setEnabled(true);
                    } else {
                        this.patchTargetFileAction.setEnabled(false);
                    }
                } else {
                    this.getMyView().displayChosenTargetFile(null);
                    this.patchTargetFileAction.setEnabled(false);
                }
            } else {
                if (fileInfo != null) {
                    this.deleteFileInfoAction.setEnabled(true);
                    this.getInfosFromFileAction.setEnabled(true);
                    this.getChangesFromFilesAction.setEnabled(true);
                    if (fileInfo.getSourceFile() != null) {
                        this.useInfosFromFileForTargetInfoAction.setEnabled(true);
                    } else {
                        this.useInfosFromFileForTargetInfoAction.setEnabled(false);
                    }
                } else {
                    this.deleteFileInfoAction.setEnabled(false);
                    this.getInfosFromFileAction.setEnabled(false);
                    this.getChangesFromFilesAction.setEnabled(false);
                    this.useInfosFromFileForTargetInfoAction.setEnabled(false);
                }
                this.getMyView().displayEditorFor(fileInfo);
            }
            this.getMyView().setSelectedFileInfo(fileInfoChangedEvent.getIndexOfNewFileInfo());
        } else if (modelEvent instanceof AttachmentChangedEvent) {
            AttachmentChangedEvent attachmentChangedEvent = (AttachmentChangedEvent)modelEvent;
            Attachment attachment = attachmentChangedEvent.getNewAttachment();
            if (!this.isEditing) {
                if (attachment != null) {
                    this.detachAttachmentAction.setEnabled(true);
                } else {
                    this.detachAttachmentAction.setEnabled(false);
                }
            } else {
                this.detachAttachmentAction.setEnabled(false);
                if (attachment != null) {
                    this.removeAttachmentAction.setEnabled(true);
                } else {
                    this.removeAttachmentAction.setEnabled(false);
                }
                this.getMyView().displayEditorFor(attachment);
            }
            this.getMyView().setSelectedAttachment(attachmentChangedEvent.getIndexOfNewAttachment());
        }
    }

    protected int performChooseTargetFileAction(boolean bl, File file, boolean bl2) {
        if (bl) {
            return this.doChooseTargetFile(file, bl2);
        }
        String string = ((PatcherController)this.getParentController()).getPreferences().getString("lastDirectoryOpenedToChooseTarget");
        File file2 = new File(string);
        if (file2.exists()) {
            this.fileChooser.setCurrentDirectory(file2);
        }
        this.fileChooser.setDialogTitle("Please choose your target");
        if (this.getMyModel().getCurrentFileInfo() != null) {
            File file3 = new File(this.fileChooser.getCurrentDirectory(), this.getMyModel().getCurrentFileInfo().getName());
            if (file3.exists()) {
                this.fileChooser.setSelectedFile(file3);
            } else {
                this.fileChooser.setSelectedFile(null);
            }
        } else {
            this.fileChooser.setSelectedFile(null);
        }
        this.fileChooser.rescanCurrentDirectory();
        int n = this.fileChooser.showOpenDialog(Application.singleton().getApplicationFrame());
        if (n == 0) {
            file = this.fileChooser.getSelectedFile();
            if (file == null || !file.exists()) {
                return PATCHING_IMPOSSIBLE;
            }
            string = file.getParent();
            if (string != null) {
                ((PatcherController)this.getParentController()).getPreferences().put("lastDirectoryOpenedToChooseTarget", file.getParent());
            }
            return this.doChooseTargetFile(file, bl2);
        }
        return PATCHING_IMPOSSIBLE;
    }

    protected void performDeleteFileInfoAction() {
        if (((PatcherController)this.getParentController()).getPreferences().getBool("confirmDelete")) {
            int n = JOptionPane.showConfirmDialog(Application.singleton().getApplicationFrame(), "Do you really want to delete the selected item?", "Question", 0);
            if (n == 1) {
                return;
            }
            if (n == 0) {
                this.getMyModel().removeCurrentFileInfo();
            }
        } else {
            this.getMyModel().removeCurrentFileInfo();
        }
    }

    protected void performDeleteTargetInfoAction() {
        if (((PatcherController)this.getParentController()).getPreferences().getBool("confirmDelete")) {
            int n = JOptionPane.showConfirmDialog(Application.singleton().getApplicationFrame(), "Do you really want to delete the selected items?", "Question", 0);
            if (n == 1) {
                return;
            }
            if (n == 0) {
                this.patcherMainModel.removeTargetInfos(((TargetViewAndEditView)this.getView()).getSelectedTargetInfoIndices());
            }
        } else {
            this.patcherMainModel.removeTargetInfos(((TargetViewAndEditView)this.getView()).getSelectedTargetInfoIndices());
        }
    }

    protected void performDetachAttachmentAction() {
        Attachment[] attachmentArray = this.getMyView().getSelectedAttachments();
        if (attachmentArray != null) {
            int n;
            File file;
            String string;
            int n2 = this.fileChooser.getFileSelectionMode();
            this.fileChooser.setFileSelectionMode(1);
            this.fileChooser.setDialogTitle("Choose the directory to detach attachments to");
            this.fileChooser.setApproveButtonText("Choose");
            String string2 = ((PatcherController)this.getParentController()).getPreferences().getString("lastDirectoryOpenedToDetachAttachment");
            if (string2 == null || string2 != null && string2.equals("")) {
                string2 = System.getProperty("user.dir");
            }
            if ((string = (file = new File(string2)).getParent()) != null) {
                this.fileChooser.setCurrentDirectory(new File(string));
            } else {
                this.fileChooser.setCurrentDirectory(file);
            }
            this.fileChooser.setSelectedFile(null);
            this.fileChooser.rescanCurrentDirectory();
            if (Application.singleton().getPreferences().getBool("showDetachWarning")) {
                DetachInfoDialog detachInfoDialog = new DetachInfoDialog();
                detachInfoDialog.pack();
                UIUtilities.centerComponent(detachInfoDialog);
                detachInfoDialog.show();
            }
            if ((n = this.fileChooser.showOpenDialog(Application.singleton().getApplicationFrame())) == 0 && this.fileChooser.getSelectedFile() != null) {
                File file2 = this.fileChooser.getSelectedFile();
                ((PatcherController)this.getParentController()).getPreferences().put("lastDirectoryOpenedToDetachAttachment", file2.getAbsolutePath());
                int n3 = 0;
                while (n3 < attachmentArray.length) {
                    String string3 = attachmentArray[n3].getName();
                    if (new File(file2, string3).exists()) {
                        int n4;
                        if (((PatcherController)this.getParentController()).getPreferences().getBool("confirmExit") && (n4 = JOptionPane.showConfirmDialog(Application.singleton().getApplicationFrame(), "The file allready exists. Do you want to overwrite it?", "Question", 0)) != 1 && n4 == 0) {
                            this.writeAttachment(attachmentArray[n3], file2);
                            ((PatcherController)this.getParentController()).setStatusMessage("The attachment " + attachmentArray[n3].getName() + " has been successfully detached.");
                        }
                    } else {
                        this.writeAttachment(attachmentArray[n3], file2);
                        ((PatcherController)this.getParentController()).setStatusMessage("The attachment " + attachmentArray[n3].getName() + " has been successfully detached.");
                    }
                    ++n3;
                }
            }
            this.fileChooser.setFileSelectionMode(n2);
        }
    }

    protected void performDiscardChangesToTargetInfoAction() {
        this.getMyModel().setCurrentTargetInfo(this.targetInfoBeforeEditing.makeCopy());
    }

    protected void performExportTargetInfoAction() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int[] nArray = ((TargetViewAndEditView)this.getView()).getSelectedTargetInfoIndices();
            String string = ((PatcherController)this.getParentController()).getPreferences().getString("encodingUsedForExport");
            this.patcherMainModel.saveTo(byteArrayOutputStream, string, nArray, false);
            ExportImportView exportImportView = new ExportImportView();
            this.myExportDialog = new ExportDialog((Frame)Application.singleton().getApplicationFrame(), exportImportView, ((PatcherController)this.getParentController()).getPreferences());
            this.myExportDialog.setModal(true);
            if (string.equals("US-ASCII")) {
                string = "ASCII";
            } else if (string.equals("UTF-8")) {
                string = "UTF8";
            }
            exportImportView.setText(byteArrayOutputStream.toString(string));
            UIUtilities.centerComponent(this.myExportDialog);
            this.myExportDialog.show();
        }
        catch (IOException iOException) {
            Log.singleton().logNewMessage(new ErrorMessage("The selected entries could not be exported due to an exception:" + System.getProperty("line.separator") + iOException));
        }
        catch (SAXException sAXException) {
            Log.singleton().logNewMessage(new ErrorMessage("The selected entries could not be exported due to an exception:" + System.getProperty("line.separator") + sAXException));
        }
    }

    protected void performGetChangesFromFilesAction() {
        File file;
        File file2;
        String string = ((PatcherController)this.getParentController()).getPreferences().getString("lastDirectoryOpenedContainingOriginalFiles");
        this.fileChooser.setCurrentDirectory(new File(string));
        this.fileChooser.setSelectedFile(null);
        this.fileChooser.rescanCurrentDirectory();
        this.fileChooser.setDialogTitle("Choose the original file");
        int n = this.fileChooser.showOpenDialog(Application.singleton().getApplicationFrame());
        if (n == 0) {
            file2 = this.fileChooser.getSelectedFile();
            if (file2 == null || !file2.exists()) {
                return;
            }
            string = file2.getParent();
            if (string != null) {
                ((PatcherController)this.getParentController()).getPreferences().put("lastDirectoryOpenedContainingOriginalFiles", file2.getParent());
            }
        } else {
            return;
        }
        string = ((PatcherController)this.getParentController()).getPreferences().getString("lastDirectoryOpenedContainingOriginalFiles");
        if (string != null) {
            this.fileChooser.setCurrentDirectory(new File(string));
        } else {
            this.fileChooser.setCurrentDirectory(new File(""));
        }
        this.fileChooser.setDialogTitle("Choose the cracked file");
        String[] stringArray = GenericFile.chopOffFileExtension(file2.getAbsolutePath());
        String string2 = String.valueOf(stringArray[0]) + ".patched." + stringArray[1];
        File file3 = new File(string2);
        if (file3.exists()) {
            this.fileChooser.setSelectedFile(file3);
        }
        if ((n = this.fileChooser.showOpenDialog(Application.singleton().getApplicationFrame())) == 0) {
            file = this.fileChooser.getSelectedFile();
            if (file == null || !file.exists()) {
                return;
            }
            string = file.getParent();
            if (string != null) {
                ((PatcherController)this.getParentController()).getPreferences().put("lastDirectoryOpenedContainingCrackedFiles", file.getParent());
            }
        } else {
            return;
        }
        class CompareFilesThread
        extends Thread {
            private final /* synthetic */ TargetViewAndEditController this$0;
            private final /* synthetic */ File val$crackedFile;
            private final /* synthetic */ File val$originalFile;

            CompareFilesThread(File file, File file2, TargetViewAndEditController targetViewAndEditController) {
                this.val$crackedFile = file;
                this.val$originalFile = file2;
                this.this$0 = targetViewAndEditController;
            }

            public void run() {
                List list = null;
                try {
                    try {
                        list = TargetViewAndEditController.access$0(this.this$0, this.val$originalFile, this.val$crackedFile);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        Log.singleton().logNewMessage(new ErrorMessage(fileNotFoundException.getMessage()));
                    }
                    catch (FileSizesDontMatchException fileSizesDontMatchException) {
                        Log.singleton().logNewMessage(new ErrorMessage(fileSizesDontMatchException.getMessage()));
                    }
                    catch (IOException iOException) {
                        Log.singleton().logNewMessage(new ErrorMessage(iOException.getMessage()));
                    }
                    Object var3_5 = null;
                    this.this$0.fireEvent(new TargetViewAndEditControllerEvent(this.this$0, 2, list));
                }
                catch (Throwable throwable) {
                    Object var3_6 = null;
                    this.this$0.fireEvent(new TargetViewAndEditControllerEvent(this.this$0, 2, list));
                    throw throwable;
                }
            }
        }
        CompareFilesThread compareFilesThread = new CompareFilesThread(file, file2, this);
        this.fireEvent(new TargetViewAndEditControllerEvent(this, 1));
        compareFilesThread.setPriority(4);
        compareFilesThread.start();
    }

    protected void performGetInfosFromFileAction() {
        String string = ((PatcherController)this.getParentController()).getPreferences().getString("lastDirectoryOpenedContainingOriginalFiles");
        this.fileChooser.setCurrentDirectory(new File(string));
        this.fileChooser.setSelectedFile(null);
        this.fileChooser.rescanCurrentDirectory();
        this.fileChooser.setDialogTitle("Choose the file to get infos from");
        int n = this.fileChooser.showOpenDialog(Application.singleton().getApplicationFrame());
        if (n == 0) {
            File file = this.fileChooser.getSelectedFile();
            if (file == null || !file.exists()) {
                return;
            }
            string = file.getParent();
            this.doGetInfosFromFile(file);
            this.useInfosFromFileForTargetInfoAction.setEnabled(true);
        }
    }

    protected void performImportTargetInfoAction() {
        Preferences preferences = ((PatcherController)this.getParentController()).getPreferences();
        ExportImportView exportImportView = new ExportImportView();
        this.myImportDialog = new ImportDialog((Frame)Application.singleton().getApplicationFrame(), exportImportView, preferences, this);
        UIUtilities.centerComponent(this.myImportDialog);
        this.myImportDialog.show();
    }

    protected void performImportTargetInfoFromTextAction(String string) {
        Preferences preferences = ((PatcherController)this.getParentController()).getPreferences();
        try {
            try {
                Object object;
                Object object2;
                this.enableActionsWhileLoading(false);
                List list = this.patcherMainModel.loadAndParse(string.trim());
                if (preferences.getBool("checkForDuplicates")) {
                    object2 = this.patcherMainModel.findDuplicates(list, ((PatcherController)this.getParentController()).getProgressIndicator());
                    if (!((TargetInfoDuplicatesRemoverModel)object2).isEmpty()) {
                        object = new TargetInfoDuplicatesRemoverDialog(Application.singleton().getApplicationFrame());
                        ((TargetInfoDuplicatesRemoverDialog)object).setModel((TargetInfoDuplicatesRemoverModel)object2);
                        ((Component)object).setSize(650, 500);
                        UIUtilities.centerComponent((Component)object);
                        ((Dialog)object).show();
                        if (((TargetInfoDuplicatesRemoverDialog)object).wasCanceled()) {
                            Object var4_13 = null;
                            this.enableActionsWhileLoading(true);
                            return;
                        }
                    }
                    this.patcherMainModel.addTargetInfos((TargetInfoDuplicatesRemoverModel)object2, list);
                } else {
                    this.patcherMainModel.addTargetInfos(list);
                }
                if (preferences.getBool("sortOnImport")) {
                    if ("sortByNameAscending".equals(preferences.getString("sortOnImportMethod"))) {
                        this.getSortByTargetLongNameAscendingAction().invokeFromCode();
                    } else if ("sortByNameDescending".equals(preferences.getString("sortOnImportMethod"))) {
                        this.getSortByTargetLongNameDescendingAction().invokeFromCode();
                    } else if ("sortByCreditsAscending".equals(preferences.getString("sortOnImportMethod"))) {
                        this.getSortByTargetCreditsAscendingAction().invokeFromCode();
                    } else if ("sortByCreditsDescending".equals(preferences.getString("sortOnImportMethod"))) {
                        this.getSortByTargetCreditsDescendingAction().invokeFromCode();
                    }
                    this.getMyModel().getTargetInfosToListModelAdapter().triggerUpdate();
                    this.getMyView().selectLastEntryAndScrollThere();
                } else {
                    this.getMyModel().getTargetInfosToListModelAdapter().triggerUpdate();
                }
                object2 = (PatcherController)this.getParentController();
                object = (StatisticsController)((Controller)object2).getChild("statisticsController");
                ((StatisticsController)object).triggerUpdate();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                Log.singleton().logNewMessage(new ErrorMessage(parserConfigurationException.toString()));
                JOptionPane.showMessageDialog(Application.singleton().getApplicationFrame(), parserConfigurationException.toString(), "Problem", 0);
            }
            catch (IOException iOException) {
                Log.singleton().logNewMessage(new ErrorMessage(iOException.toString()));
                JOptionPane.showMessageDialog(Application.singleton().getApplicationFrame(), iOException.toString(), "Problem", 0);
            }
            catch (SAXParseException sAXParseException) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("A SAXParseException occurred!");
                stringBuffer.append(System.getProperty("line.separator"));
                stringBuffer.append("The error is located at ");
                stringBuffer.append("line: ");
                stringBuffer.append(sAXParseException.getLineNumber());
                int n = sAXParseException.getColumnNumber();
                if (n > 0) {
                    stringBuffer.append(" column: ");
                    stringBuffer.append(n);
                }
                stringBuffer.append(System.getProperty("line.separator"));
                stringBuffer.append("The error message is: ");
                stringBuffer.append(sAXParseException.getMessage());
                stringBuffer.append(System.getProperty("line.separator"));
                Log.singleton().logNewMessage(new ErrorMessage(stringBuffer.toString()));
                JOptionPane.showMessageDialog(Application.singleton().getApplicationFrame(), stringBuffer.toString(), "Problem", 0);
            }
            catch (SAXException sAXException) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("A SAXException occurred!");
                stringBuffer.append(System.getProperty("line.separator"));
                stringBuffer.append(sAXException);
                stringBuffer.append(sAXException.getException());
                sAXException.printStackTrace();
                stringBuffer.append(System.getProperty("line.separator"));
                Log.singleton().logNewMessage(new ErrorMessage(stringBuffer.toString()));
                JOptionPane.showMessageDialog(Application.singleton().getApplicationFrame(), stringBuffer.toString(), "Problem", 0);
            }
        }
        catch (Throwable throwable) {
            Object var4_15 = null;
            this.enableActionsWhileLoading(true);
            throw throwable;
        }
        Object var4_14 = null;
        this.enableActionsWhileLoading(true);
    }

    protected void performNewAttachmentAction() {
        int n;
        block13: {
            File file = null;
            n = this.fileChooser.getFileSelectionMode();
            this.fileChooser.setFileSelectionMode(0);
            this.fileChooser.setDialogTitle("Choose the file to add as attachment");
            this.fileChooser.setApproveButtonText("Choose");
            String string = ((PatcherController)this.getParentController()).getPreferences().getString("lastDirectoryOpenedToAddAttachment");
            this.fileChooser.setCurrentDirectory(new File(string));
            this.fileChooser.setSelectedFile(null);
            this.fileChooser.rescanCurrentDirectory();
            int n2 = this.fileChooser.showOpenDialog(Application.singleton().getApplicationFrame());
            if (n2 != 0) break block13;
            file = this.fileChooser.getSelectedFile();
            if (file == null || !file.exists()) {
                return;
            }
            string = file.getParent();
            if (string != null) {
                ((PatcherController)this.getParentController()).getPreferences().put("lastDirectoryOpenedToAddAttachment", file.getParent());
            }
            FilterInputStream filterInputStream = null;
            FilterOutputStream filterOutputStream = null;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                try {
                    filterInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                    UUEncoder1 uUEncoder1 = (UUEncoder1)UUEncoder1.singleton();
                    filterOutputStream = new DataOutputStream(byteArrayOutputStream);
                    uUEncoder1.encode(file.getName(), filterInputStream, filterOutputStream);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Log.singleton().logNewMessage(new ErrorMessage("The file " + file.getAbsolutePath() + " could not be encoded because it could not be found."));
                }
                catch (IOException iOException) {
                    Log.singleton().logNewMessage(new ErrorMessage("The file " + file.getAbsolutePath() + " could not be encoded because of an IOException."));
                }
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    filterInputStream.close();
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                filterInputStream.close();
                filterOutputStream.close();
            }
            catch (IOException iOException) {}
            Attachment attachment = new Attachment();
            attachment.setEncodedBytesAsString(byteArrayOutputStream.toString());
            attachment.setName(file.getName());
            attachment.setSizeAsString(Long.toString(file.length()));
            try {
                attachment.setCRC16(Integer.toString(this.aCRC16Support.calculateCRC16For(file)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.singleton().logNewMessage(new WarningMessage("CRC16 for file " + file.getAbsolutePath() + " could not be calculated because the file was not found anymore."));
            }
            catch (IOException iOException) {
                Log.singleton().logNewMessage(new WarningMessage("CRC16 for file " + file.getAbsolutePath() + " could not be calculated because the file could not be read anymore."));
            }
            int n3 = this.getMyModel().addNewAttachment(attachment);
            this.getMyView().setSelectedAttachment(n3);
        }
        this.fileChooser.setFileSelectionMode(n);
    }

    protected void performNewFileInfoAction() {
        int n = this.getMyModel().addNewFileInfo();
        this.getMyView().setSelectedFileInfo(n);
    }

    protected void performNewTargetInfoAction() {
        TargetInfo targetInfo = new TargetInfo();
        targetInfo.setIsNew(true);
        targetInfo.setLongName("New Entry");
        targetInfo.setCredits(((PatcherController)this.getParentController()).getPreferences().getString("defaultCredits"));
        this.patcherMainModel.addTargetInfo(targetInfo);
        this.getMyModel().setCurrentTargetInfo(targetInfo);
        this.getStartEditingTargetInfoAction().invokeFromCode();
    }

    protected void performPWDataInfoAction() {
        TargetListInfoView targetListInfoView = new TargetListInfoView();
        targetListInfoView.setModel(this.patcherMainModel.getTargetListInfo());
        targetListInfoView.setEnabled(false);
        TargetListInfoDialog targetListInfoDialog = new TargetListInfoDialog(targetListInfoView, Application.singleton().getApplicationFrame(), "Target List Info", true);
        targetListInfoDialog.setModal(true);
        targetListInfoDialog.pack();
        UIUtilities.centerComponent(targetListInfoDialog);
        targetListInfoDialog.show();
    }

    protected void performPatchTargetFileAction() {
        TargetViewAndEditModel targetViewAndEditModel = (TargetViewAndEditModel)this.getModel();
        try {
            this.myPatchEngine.patchNormal(targetViewAndEditModel.getCurrentFileInfo());
            ((PatcherController)this.getParentController()).setStatusMessage("Successfully patched file: " + targetViewAndEditModel.getCurrentFileInfo().getAssociatedTargetFile().getAbsolutePath());
            targetViewAndEditModel.getCurrentFileInfo().setPatchStatus(2);
            return;
        }
        catch (Throwable throwable) {
            Tracing.singleton().trace(throwable.toString(), Tracing.TRACE_MEDIUM_DETAIL);
            try {
                this.myPatchEngine.smartPatch(targetViewAndEditModel.getCurrentFileInfo());
                ((PatcherController)this.getParentController()).setStatusMessage("Successfully smartpatched file: " + targetViewAndEditModel.getCurrentFileInfo().getAssociatedTargetFile().getAbsolutePath());
                targetViewAndEditModel.getCurrentFileInfo().setPatchStatus(2);
            }
            catch (Throwable throwable2) {
                Log.singleton().logNewMessage(new ErrorMessage(throwable2.toString()));
                ((PatcherController)this.getParentController()).setStatusMessage("There were problems smart-patching. Look at the messages log for details.");
                targetViewAndEditModel.getCurrentFileInfo().setPatchStatus(1);
            }
            return;
        }
    }

    protected void performRemoveAttachmentAction() {
        if (((PatcherController)this.getParentController()).getPreferences().getBool("confirmDelete")) {
            int n = JOptionPane.showConfirmDialog(Application.singleton().getApplicationFrame(), "Do you really want to remove the selected attachemnt?", "Question", 0);
            if (n == 1) {
                return;
            }
            if (n == 0) {
                this.getMyModel().removeCurrentAttachment();
            }
        } else {
            this.getMyModel().removeCurrentAttachment();
        }
    }

    protected void performSaveChangesToTargetInfoAction(TargetInfo targetInfo) {
        Attachment attachment;
        TargetInfo targetInfo2 = this.getMyModel().getCurrentTargetInfo();
        ((TargetViewAndEditView)this.getView()).fillTargetInfo(targetInfo2);
        FileInfo fileInfo = this.getMyModel().getCurrentFileInfo();
        if (fileInfo != null) {
            this.getMyView().fillFileInfo(fileInfo);
        }
        if ((attachment = this.getMyModel().getCurrentAttachment()) != null) {
            this.getMyView().fillAttachment(attachment);
        }
        this.targetInfoBeforeEditing.setCredits(new String(targetInfo2.getCredits()));
        Iterator iterator = targetInfo2.getFilesInfos().iterator();
        FileInfo fileInfo2 = null;
        ArrayList arrayList = new ArrayList(targetInfo2.getFilesInfos().size());
        while (iterator.hasNext()) {
            fileInfo2 = ((FileInfo)iterator.next()).makeCopy();
            arrayList.add((Object)fileInfo2);
        }
        Iterator iterator2 = targetInfo2.getAttachments().iterator();
        Attachment attachment2 = null;
        ArrayList arrayList2 = new ArrayList(targetInfo2.getAttachments().size());
        while (iterator2.hasNext()) {
            attachment2 = ((Attachment)iterator2.next()).makeCopy();
            arrayList2.add((Object)attachment2);
        }
        this.targetInfoBeforeEditing.setFilesInfos((List)arrayList);
        this.targetInfoBeforeEditing.setAttachments((List)arrayList2);
        this.targetInfoBeforeEditing.setHasError(false);
        this.targetInfoBeforeEditing.setLongName(new String(targetInfo2.getLongName()));
        this.targetInfoBeforeEditing.setText(new String(targetInfo2.getText()));
        this.targetInfoBeforeEditing.setUrl(new String(targetInfo2.getUrl()));
        if (this.targetInfoBeforeEditing.isNew()) {
            this.patcherMainModel.getTargetListInfo().addEntryForNewTargetInfo(targetInfo2);
            this.targetInfoBeforeEditing.setIsNew(false);
        } else {
            this.patcherMainModel.getTargetListInfo().addEntryForChangedTargetInfo(targetInfo2);
        }
        this.stopEditingTargetInfoAction.putProperty("nextTargetInfo", targetInfo);
        this.stopEditingTargetInfoAction.invokeFromCode();
    }

    protected void performSmartSearchForTargetInfo(boolean bl, String string) {
        if (bl) {
            this.doSmartSearchForTargetInfo(new File(string));
        } else {
            this.fileChooser.setDialogTitle("Please choose your target");
            String string2 = ((PatcherController)this.getParentController()).getPreferences().getString("lastDirectoryOpenedToChooseTarget");
            this.fileChooser.setCurrentDirectory(new File(string2));
            this.fileChooser.rescanCurrentDirectory();
            this.fileChooser.setSelectedFile(null);
            int n = this.fileChooser.showOpenDialog(Application.singleton().getApplicationFrame());
            if (n == 0) {
                File file = this.fileChooser.getSelectedFile();
                if (file == null || !file.exists()) {
                    return;
                }
                string2 = file.getParent();
                if (string2 != null) {
                    ((PatcherController)this.getParentController()).getPreferences().put("lastDirectoryOpenedToChooseTarget", file.getParent());
                }
                this.doSmartSearchForTargetInfo(file);
            }
        }
    }

    protected void performSortAction(int n) {
        this.patcherMainModel.sort(n);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performStartEditingTargetInfoAction() {
        try {
            this.setCurrentFileInfo(null);
            this.setCurrentAttachment(null);
            this.getMyView().switchToEditing(true);
            this.targetInfoBeforeEditing = this.getMyModel().getCurrentTargetInfo();
            this.getMyModel().setCurrentTargetInfo(this.targetInfoBeforeEditing.makeCopy());
            this.chooseTargetFileAction.setEnabled(false);
            this.patchTargetFileAction.setEnabled(false);
            this.smartSearchForTargetInfoAction.setEnabled(false);
            this.sortByTargetCreditsAscendingAction.setEnabled(false);
            this.sortByTargetCreditsDescendingAction.setEnabled(false);
            this.sortByTargetLongNameAscendingAction.setEnabled(false);
            this.sortByTargetLongNameDescendingAction.setEnabled(false);
            this.startEditingTargetInfoAction.setEnabled(false);
            this.deleteTargetInfoAction.setEnabled(false);
            this.stopEditingTargetInfoAction.setEnabled(true);
            this.newTargetInfoAction.setEnabled(false);
            this.newFileInfoAction.setEnabled(true);
            this.newAttachmentAction.setEnabled(true);
        }
        finally {
            var2_1 = null;
            this.getExportTargetInfoAction().setEnabled(false);
            this.getImportTargetInfoAction().setEnabled(false);
            var3_3 = ((PatcherController)this.getParentController()).getActions();
            var4_5 = var3_3.iterator();
            ** while (var4_5.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            ((PWAction)var4_5.next()).setEnabled(false);
            continue;
        }
lbl30:
        // 1 sources

        this.isEditing = true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performStopEditingTargetInfoAction(TargetInfo var1_1) {
        try {
            this.isEditing = false;
            this.targetInfoBeforeEditing.removeAllSourceFiles();
            if (this.targetInfoBeforeEditing.isNew()) {
                this.patcherMainModel.getTargetListInfo().addEntryForNewTargetInfo(this.targetInfoBeforeEditing);
            }
            this.getMyView().switchToEditing(false);
            if (var1_1 == null) {
                this.getMyModel().setCurrentTargetInfo(this.targetInfoBeforeEditing);
            } else {
                this.getMyModel().setCurrentTargetInfo(var1_1);
                this.stopEditingTargetInfoAction.putProperty("nextTargetInfo", null);
                this.saveChangesToTargetInfoAction.putProperty("nextTargetInfo", null);
            }
            this.smartSearchForTargetInfoAction.setEnabled(true);
            this.sortByTargetCreditsAscendingAction.setEnabled(true);
            this.sortByTargetCreditsDescendingAction.setEnabled(true);
            this.sortByTargetLongNameAscendingAction.setEnabled(true);
            this.sortByTargetLongNameDescendingAction.setEnabled(true);
            this.stopEditingTargetInfoAction.setEnabled(false);
            this.startEditingTargetInfoAction.setEnabled(true);
            this.deleteTargetInfoAction.setEnabled(true);
            this.deleteFileInfoAction.setEnabled(false);
            this.newTargetInfoAction.setEnabled(true);
            this.newFileInfoAction.setEnabled(false);
            this.getInfosFromFileAction.setEnabled(false);
            this.getChangesFromFilesAction.setEnabled(false);
            this.useInfosFromFileForTargetInfoAction.setEnabled(false);
            this.newAttachmentAction.setEnabled(false);
            this.removeAttachmentAction.setEnabled(false);
            this.getMyView().focusTargetList();
        }
        finally {
            var3_2 = null;
            this.getExportTargetInfoAction().setEnabled(true);
            this.getImportTargetInfoAction().setEnabled(true);
            var4_4 = ((PatcherController)this.getParentController()).getActions();
            var5_6 = var4_4.iterator();
            ** while (var5_6.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            ((PWAction)var5_6.next()).setEnabled(true);
            continue;
        }
lbl40:
        // 1 sources

    }

    protected void performUseInfosFromFileForTargetInfoAction() {
        FileInfo fileInfo = ((TargetViewAndEditView)this.getView()).getSelectedFileInfo();
        File file = fileInfo.getSourceFile();
        if (file instanceof PRCDatabase) {
            Object object;
            List list;
            String string = null;
            String string2 = null;
            PRCDatabase pRCDatabase = (PRCDatabase)file;
            String string3 = pRCDatabase.getApplicationIconName();
            String string4 = pRCDatabase.getVersion();
            if (string4 != null && string4.length() > 0) {
                string = String.valueOf(string3) + " v" + string4;
            }
            if ((list = pRCDatabase.getRessources(RessourceType.STRING_RESSOURCE)) != null) {
                object = list.iterator();
                String string5 = null;
                LinkedList linkedList = new LinkedList();
                while (object.hasNext()) {
                    string5 = ((StringRessource)object.next()).getString();
                    StringTokenizer stringTokenizer = new StringTokenizer(string5);
                    while (stringTokenizer.hasMoreElements()) {
                        String string6 = stringTokenizer.nextToken();
                        if (!string6.startsWith("http://") && !string6.startsWith("www.")) continue;
                        linkedList.add((Object)string6);
                    }
                }
                string2 = "";
                if (linkedList.size() > 0) {
                    Iterator iterator = linkedList.iterator();
                    while (iterator.hasNext()) {
                        string2 = String.valueOf(string2) + (String)iterator.next() + " *** ";
                    }
                    string2 = string2.substring(0, string2.length() - 5);
                    if (linkedList.size() > 1) {
                        ((PatcherController)this.getParentController()).setStatusMessage("More than one URL was found in the file. Please remove all duplicates!");
                    }
                }
            }
            object = this.getMyModel().getCurrentTargetInfo();
            ((TargetViewAndEditView)this.getView()).fillTargetInfo((TargetInfo)object);
            if (string2 != null) {
                this.getMyModel().getCurrentTargetInfo().setUrl(string2);
            }
            this.getMyModel().getCurrentTargetInfo().setLongName(string);
            this.getMyView().setCurrentTargetInfo(this.getMyModel().getCurrentTargetInfo());
        }
    }

    public void resetChanges() {
        this.changesWereMade = false;
    }

    public void setCurrentAttachment(Attachment attachment) {
        Attachment attachment2;
        if (this.isEditing && (attachment2 = this.getMyModel().getCurrentAttachment()) != null) {
            this.getMyView().fillAttachment(attachment2);
        }
        this.getMyModel().setCurrentAttachment(attachment);
    }

    public void setCurrentFileInfo(FileInfo fileInfo) {
        FileInfo fileInfo2;
        if (this.isEditing && (fileInfo2 = this.getMyModel().getCurrentFileInfo()) != null) {
            this.getMyView().fillFileInfo(fileInfo2);
        }
        this.getMyModel().setCurrentFileInfo(fileInfo);
    }

    public boolean setCurrentTargetInfo(TargetInfo targetInfo) {
        if (this.isEditing) {
            int n = JOptionPane.showConfirmDialog(Application.singleton().getApplicationFrame(), "Do you want to save your changes before you continue?", "Question", 1);
            if (n == 1) {
                this.stopEditingTargetInfoAction.putProperty("nextTargetInfo", targetInfo);
                this.stopEditingTargetInfoAction.invokeFromCode();
                return true;
            }
            if (n == 0) {
                this.saveChangesToTargetInfoAction.putProperty("nextTargetInfo", targetInfo);
                this.saveChangesToTargetInfoAction.invokeFromCode();
                return true;
            }
            if (n == 2) {
                return false;
            }
        }
        this.getMyModel().setCurrentTargetInfo(targetInfo);
        return true;
    }

    public void setModel(Model model) {
        if (this.model != null) {
            this.model.removeModelListener(this);
        }
        super.setModel(model);
        this.model.addModelListener(this);
        this.fileChooser.setCurrentDirectory(new File(((PatcherController)this.getParentController()).getPreferences().getString("lastDirectoryOpenedToLoadTargetList")));
    }

    public boolean wereChangesMade() {
        return this.changesWereMade;
    }

    protected void writeAttachment(Attachment attachment, File file) {
        String string = attachment.getName();
        if (string == null) {
            Log.singleton().logNewMessage(new ErrorMessage("Attachment could not be saved due to missing file name."));
            return;
        }
        FilterOutputStream filterOutputStream = null;
        try {
            try {
                filterOutputStream = new BufferedOutputStream(new DataOutputStream(new FileOutputStream(new File(file, string))));
                attachment.writeTo(filterOutputStream);
                ((BufferedOutputStream)filterOutputStream).flush();
                File file2 = new File(file, string);
                try {
                    int n = this.aCRC16Support.calculateCRC16For(file2);
                    if (attachment.getCRC16() != null && !attachment.getCRC16().equals(Integer.toString(n))) {
                        Log.singleton().logNewMessage(new ErrorMessage("CRC16 for file " + file2.getAbsolutePath() + " (" + n + ")" + " does not match expected CRC16" + " (" + attachment.getCRC16() + "). It is propably corrupt."));
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Log.singleton().logNewMessage(new WarningMessage("CRC16 for file " + file2.getAbsolutePath() + " could not be checked because the file was not found anymore."));
                }
                catch (IOException iOException) {
                    Log.singleton().logNewMessage(new WarningMessage("CRC16 for file " + file2.getAbsolutePath() + " could not be checked because the file could not be read anymore."));
                }
            }
            catch (IOException iOException) {
                Log.singleton().logNewMessage(new ErrorMessage("Attachment could not be saved due to exception " + iOException));
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                filterOutputStream.close();
            }
            catch (IOException iOException) {
                Log.singleton().logNewMessage(new ErrorMessage("Could not close output stream for attachment " + attachment.getLongName()));
            }
            throw throwable;
        }
        try {
            filterOutputStream.close();
        }
        catch (IOException iOException) {
            Log.singleton().logNewMessage(new ErrorMessage("Could not close output stream for attachment " + attachment.getLongName()));
        }
    }

    private class MouseListenerOnFileInfosTableView
    extends MouseAdapter {
        MouseListenerOnFileInfosTableView() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (TargetViewAndEditController.this.isEditing && TargetViewAndEditController.this.getMyModel().getCurrentFileInfo() != null) {
                TargetViewAndEditController.this.getMyView().switchToEditorForFileInfo();
            }
        }
    }

    private class MouseListenerOnAttachmentTableView
    extends MouseAdapter {
        MouseListenerOnAttachmentTableView() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (TargetViewAndEditController.this.isEditing && TargetViewAndEditController.this.getMyModel().getCurrentAttachment() != null) {
                TargetViewAndEditController.this.getMyView().switchToEditorForAttachment();
            }
        }
    }

    private class ChooseTargetFileAction
    extends PWAction {
        static final String POSSIBLE_WAY_TO_PATCH_PROPERTY = "possibleWayToPatch";
        static final String TARGET_FILE_PROPERTY = "targetFile";
        static final String ASSOCIATE_TARGET_FILE_PROPERTY_IF_NOT_PATCHABLE = "associate";

        ChooseTargetFileAction() {
            super(3, "File Infos");
            this.putValue("Name", "Choose Target File");
            this.putValue("ShortDescription", "Choose Target File");
            this.putValue("LongDescription", "Choose Target File to patch");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/chooseTargetFile.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            int n;
            Boolean bl = (Boolean)this.getProperty(ASSOCIATE_TARGET_FILE_PROPERTY_IF_NOT_PATCHABLE);
            boolean bl2 = true;
            if (bl != null) {
                bl2 = bl;
            }
            if ((n = TargetViewAndEditController.this.performChooseTargetFileAction(this.invokedFromCode, (File)this.getProperty(TARGET_FILE_PROPERTY), bl2)) == NORMAL_PATCHING_POSSIBLE) {
                Log.singleton().logNewMessage(new InfoMessage("Target can be patched.", true));
            } else if (n == SMARTPATCH_POSSIBLE) {
                Log.singleton().logNewMessage(new InfoMessage("Target can be smartpatched.", true));
            } else {
                Log.singleton().logNewMessage(new InfoMessage("Target cannot be patched", true));
            }
            this.putProperty(POSSIBLE_WAY_TO_PATCH_PROPERTY, new Integer(n));
            this.putProperty(ASSOCIATE_TARGET_FILE_PROPERTY_IF_NOT_PATCHABLE, new Boolean(true));
        }
    }

    private class SmartSearchForTargetInfoAction
    extends PWAction {
        SmartSearchForTargetInfoAction() {
            super(3, "Target Infos");
            this.putValue("Name", "Smart Search");
            this.putValue("ShortDescription", "Smart Search");
            this.putValue("LongDescription", "Pick a target on let the patcher find a matching TargetInfo");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/smartSearch.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            TargetViewAndEditController.this.performSmartSearchForTargetInfo(this.invokedFromCode, (String)this.getProperty("filePath"));
        }
    }

    private class PatchTargetFileAction
    extends PWAction {
        PatchTargetFileAction() {
            super(3, "File Infos");
            this.putValue("Name", "Patch Target File");
            this.putValue("ShortDescription", "Patch Target File");
            this.putValue("LongDescription", "Patch Target File");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/smile small.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            TargetViewAndEditController.this.performPatchTargetFileAction();
        }
    }

    private class PWDataInfoAction
    extends PWAction {
        PWDataInfoAction() {
            super(3, "Target Infos");
            this.putValue("Name", "Show Info");
            this.putValue("ShortDescription", "Show Info");
            this.putValue("LongDescription", "Show Info about PW Data");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/info.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            TargetViewAndEditController.this.performPWDataInfoAction();
        }
    }

    private class SortByTargetLongNameAscendingAction
    extends PWAction {
        SortByTargetLongNameAscendingAction() {
            super(3, "Target Infos");
            this.putValue("Name", "Sort by Name");
            this.putValue("ShortDescription", "Sort by Name");
            this.putValue("LongDescription", "Sort by Long Name Ascending");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/sortByLongNameAscending.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            TargetViewAndEditController.this.performSortAction(1);
        }
    }

    private class SortByTargetLongNameDescendingAction
    extends PWAction {
        SortByTargetLongNameDescendingAction() {
            super(3, "Target Infos");
            this.putValue("Name", "Sort by Name");
            this.putValue("ShortDescription", "Sort by Name");
            this.putValue("LongDescription", "Sort by Long Name Descending");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/sortByLongNameDescending.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            TargetViewAndEditController.this.performSortAction(2);
        }
    }

    private class SortByTargetCreditsAscendingAction
    extends PWAction {
        SortByTargetCreditsAscendingAction() {
            super(3, "Target Infos");
            this.putValue("Name", "Sort by Credits");
            this.putValue("ShortDescription", "Sort by Credits");
            this.putValue("LongDescription", "Sort by Credits Ascending");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/sortByCreditsAscending.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            TargetViewAndEditController.this.performSortAction(3);
        }
    }

    private class SortByTargetCreditsDescendingAction
    extends PWAction {
        SortByTargetCreditsDescendingAction() {
            super(3, "Target Infos");
            this.putValue("Name", "Sort by Credits");
            this.putValue("ShortDescription", "Sort by Credits");
            this.putValue("LongDescription", "Sort by Credits Descending");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/sortByCreditsDescending.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            TargetViewAndEditController.this.performSortAction(4);
        }
    }

    private class SortByUrlAscendingAction
    extends PWAction {
        SortByUrlAscendingAction() {
            super(3, "Target Infos");
            this.putValue("Name", "Sort by Url");
            this.putValue("ShortDescription", "Sort by Url");
            this.putValue("LongDescription", "Sort by Url Ascending");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/sortByCreditsAscending.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            TargetViewAndEditController.this.performSortAction(5);
        }
    }

    private class SortByUrlDescendingAction
    extends PWAction {
        SortByUrlDescendingAction() {
            super(3, "Target Infos");
            this.putValue("Name", "Sort by Url");
            this.putValue("ShortDescription", "Sort by Url");
            this.putValue("LongDescription", "Sort by Url Descending");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/sortByCreditsDescending.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            TargetViewAndEditController.this.performSortAction(6);
        }
    }

    private class StartEditingTargetInfoAction
    extends PWAction {
        StartEditingTargetInfoAction() {
            super(3, "Target Infos");
            this.putValue("Name", "Edit");
            this.putValue("ShortDescription", "Edit");
            this.putValue("LongDescription", "Edit Target Info");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/edit.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            TargetViewAndEditController.this.performStartEditingTargetInfoAction();
        }
    }

    private class StopEditingTargetInfoAction
    extends PWAction {
        StopEditingTargetInfoAction() {
            super(3, "Target Infos");
            this.putValue("Name", "Cancel");
            this.putValue("ShortDescription", "Cancel Editing");
            this.putValue("LongDescription", "Cancel Editing of Target Info without Saving");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/stopediting.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            TargetViewAndEditController.this.performStopEditingTargetInfoAction((TargetInfo)this.getProperty("nextTargetInfo"));
        }
    }

    private class SaveChangesToTargetInfoAction
    extends PWAction {
        SaveChangesToTargetInfoAction() {
            super(3, "Target Infos");
            this.putValue("Name", "Save");
            this.putValue("ShortDescription", "Save Changes");
            this.putValue("LongDescription", "Save the changes made to the Target Info");
        }

        public void perform(ActionEvent actionEvent) {
            TargetViewAndEditController.this.performSaveChangesToTargetInfoAction((TargetInfo)this.getProperty("nextTargetInfo"));
            TargetViewAndEditController.this.changesWereMade = true;
        }
    }

    private class DiscardChangesToTargetInfoAction
    extends PWAction {
        DiscardChangesToTargetInfoAction() {
            super(3, "Target Infos");
            this.putValue("Name", "Discard");
            this.putValue("ShortDescription", "Discard changes made to current view");
            this.putValue("LongDescription", "Discard changes made to current view");
        }

        public void perform(ActionEvent actionEvent) {
            TargetViewAndEditController.this.performDiscardChangesToTargetInfoAction();
        }
    }

    private class DeleteTargetInfoAction
    extends PWAction {
        DeleteTargetInfoAction() {
            super(3, "Target Infos");
            this.putValue("Name", "Delete");
            this.putValue("ShortDescription", "Delete");
            this.putValue("LongDescription", "Delete Target Info");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/delete.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            TargetViewAndEditController.this.performDeleteTargetInfoAction();
            TargetViewAndEditController.this.changesWereMade = true;
        }
    }

    private class NewTargetInfoAction
    extends PWAction {
        NewTargetInfoAction() {
            super(3, "Target Infos");
            this.setKeyboardAccelerator(KeyStroke.getKeyStroke(78, 2));
            this.putValue("Name", "New");
            this.putValue("ShortDescription", "New");
            this.putValue("LongDescription", "New Target Info");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/new.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            TargetViewAndEditController.this.performNewTargetInfoAction();
            TargetViewAndEditController.this.changesWereMade = true;
        }
    }

    private class DeleteFileInfoAction
    extends PWAction {
        DeleteFileInfoAction() {
            super(3, "File Infos");
            this.putValue("Name", "Delete");
            this.putValue("ShortDescription", "Delete");
            this.putValue("LongDescription", "Delete File Info");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/delete.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            TargetViewAndEditController.this.performDeleteFileInfoAction();
            TargetViewAndEditController.this.changesWereMade = true;
        }
    }

    private class NewFileInfoAction
    extends PWAction {
        NewFileInfoAction() {
            super(3, "File Infos");
            this.putValue("Name", "New");
            this.putValue("ShortDescription", "New");
            this.putValue("LongDescription", "New File Info");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/new.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            TargetViewAndEditController.this.performNewFileInfoAction();
            TargetViewAndEditController.this.changesWereMade = true;
        }
    }

    private class GetInfosFromFileAction
    extends PWAction {
        GetInfosFromFileAction() {
            super(3, "File Infos");
            this.putValue("Name", "From File");
            this.putValue("ShortDescription", "Get Infos From a File");
            this.putValue("LongDescription", "Get Infos From a File");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/fromFile.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            TargetViewAndEditController.this.performGetInfosFromFileAction();
        }
    }

    private class UseInfosFromFileForTargetInfoAction
    extends PWAction {
        UseInfosFromFileForTargetInfoAction() {
            super(3, "->Target Info");
            this.putValue("Name", "->Target Info");
            this.putValue("ShortDescription", "Use the infos from the file for the Target Info");
            this.putValue("LongDescription", "Use the infos from the file for the Target Info");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/fromFile.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            TargetViewAndEditController.this.performUseInfosFromFileForTargetInfoAction();
        }
    }

    private class GetChangesFromFilesAction
    extends PWAction {
        GetChangesFromFilesAction() {
            super(3, "File Infos");
            this.putValue("Name", "Changes");
            this.putValue("ShortDescription", "Changes");
            this.putValue("LongDescription", "Get Changes between two Files");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/getChanges.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            TargetViewAndEditController.this.performGetChangesFromFilesAction();
            TargetViewAndEditController.this.changesWereMade = true;
        }
    }

    private class DetachAttachmentAction
    extends PWAction {
        DetachAttachmentAction() {
            super(3, "Attachments");
            this.putValue("Name", "Detach");
            this.putValue("ShortDescription", "Detach");
            this.putValue("LongDescription", "Detach the Selected Attachment and Save it to a File");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/detachAttachment.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            TargetViewAndEditController.this.performDetachAttachmentAction();
        }
    }

    private class NewAttachmentAction
    extends PWAction {
        NewAttachmentAction() {
            super(3, "Attachments");
            this.putValue("Name", "New");
            this.putValue("ShortDescription", "New");
            this.putValue("LongDescription", "Add a New Attachment");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/addAttachment.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            TargetViewAndEditController.this.performNewAttachmentAction();
            TargetViewAndEditController.this.changesWereMade = true;
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
        }
    }

    private class RemoveAttachmentAction
    extends PWAction {
        RemoveAttachmentAction() {
            super(3, "Attachments");
            this.putValue("Name", "Remove");
            this.putValue("ShortDescription", "Remove");
            this.putValue("LongDescription", "Remove the Selected Attachment");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/removeAttachment.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            TargetViewAndEditController.this.performRemoveAttachmentAction();
            TargetViewAndEditController.this.changesWereMade = true;
        }
    }

    private class ExportTargetInfoAction
    extends PWAction {
        ExportTargetInfoAction() {
            super(3, "Target Infos");
            this.setKeyboardAccelerator(KeyStroke.getKeyStroke(69, 2));
            this.putValue("Name", "Export");
            this.putValue("ShortDescription", "Export");
            this.putValue("LongDescription", "Export Target Info(s)");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/export.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            TargetViewAndEditController.this.performExportTargetInfoAction();
        }
    }

    private class ImportTargetInfoAction
    extends PWAction {
        ImportTargetInfoAction() {
            super(3, "Target Infos");
            this.setKeyboardAccelerator(KeyStroke.getKeyStroke(77, 2));
            this.putValue("Name", "Import");
            this.putValue("ShortDescription", "Import");
            this.putValue("LongDescription", "Import Target Info(s)");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/import.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            TargetViewAndEditController.this.performImportTargetInfoAction();
        }
    }

    private class ImportTargetInfoFromTextAction
    extends PWAction {
        ImportTargetInfoFromTextAction() {
            this.putValue("Name", "Import");
            this.putValue("ShortDescription", "Import");
            this.putValue("LongDescription", "Import to PWCPP");
        }

        public void perform(ActionEvent actionEvent) {
            TargetViewAndEditController.this.performImportTargetInfoFromTextAction((String)this.getProperty("textToImport"));
        }
    }

    private class FileInfoSelectedAction
    extends PWAction {
        FileInfoSelectedAction() {
            this.putValue("Name", "FileInfo selected");
            this.putValue("ShortDescription", "Internal FileInfo selected Action");
        }

        public void perform(ActionEvent actionEvent) {
            FileInfo fileInfo = TargetViewAndEditController.this.getMyView().getSelectedFileInfo();
            TargetViewAndEditController.this.setCurrentFileInfo(fileInfo);
        }
    }

    private class AttachmentSelectedAction
    extends PWAction {
        AttachmentSelectedAction() {
            this.putValue("Name", "Attachement selected");
            this.putValue("ShortDescription", "Internal Attachement selected Action");
        }

        public void perform(ActionEvent actionEvent) {
            Attachment attachment = TargetViewAndEditController.this.getMyView().getSelectedAttachment();
            TargetViewAndEditController.this.setCurrentAttachment(attachment);
        }
    }

    private class HexValueArrayList
    extends ArrayList {
        HexValueArrayList() {
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            stringBuffer.append("[");
            int n = this.size() - 1;
            Object object = null;
            int n2 = 0;
            while (n2 <= n) {
                object = iterator.next();
                if (object instanceof Integer) {
                    stringBuffer.append(Integer.toString((Integer)object, 16));
                } else {
                    stringBuffer.append(String.valueOf(object));
                }
                if (n2 < n) {
                    stringBuffer.append(", ");
                }
                ++n2;
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }
}

