/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.controller.preferences;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import pw.palmpatch.Application;
import pw.palmpatch.PreferenceNode;
import pw.palmpatch.Preferences;
import pw.palmpatch.ui.views.PWFileChooser;

public class StartupActionsPreferenceNode
extends PreferenceNode {
    protected PWFileChooser sharedFileChooser = PWFileChooser.createFileChooserForTargetLists();
    protected Preferences preferences;

    public StartupActionsPreferenceNode() {
        this.sharedFileChooser.setPreferredSize(new Dimension(this.sharedFileChooser.getPreferredSize().width, 350));
        this.setDescription("Startup Actions Preferences");
        this.setTitle("Startup");
        this.setOpenIcon(this.getIcon());
        this.setSystemNode(false);
    }

    public JComponent buildClient() {
        class Pw_palmpatch_controller_preferences_StartupActionsPreferenceNode$3 {
            /* synthetic */ Pw_palmpatch_controller_preferences_StartupActionsPreferenceNode$3() {
            }
        }
        return new StartupActionsPreferenceNodeClient();
    }

    public void display(Preferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("preferences must not be null");
        }
        ((StartupActionsPreferenceNodeClient)this.getClient()).startupFileTextField.setText(preferences.getString("fileToLoadOnStartup"));
        ((StartupActionsPreferenceNodeClient)this.getClient()).startupScanDirectoryTextField.setText(preferences.getString("directoryToScanOnStartup"));
        ((StartupActionsPreferenceNodeClient)this.getClient()).scanDirectoryOnStartupRadioButton.setSelected(preferences.getBool("scanDirectoryOnStartup"));
        ((StartupActionsPreferenceNodeClient)this.getClient()).loadFileOnStartupRadioButton.setSelected(preferences.getBool("loadFileOnStartup"));
        ((StartupActionsPreferenceNodeClient)this.getClient()).startupActionsEnabledCheckox.setSelected(preferences.getBool("startupActionsEnabled"));
        this.preferences = preferences;
    }

    public void save(Preferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("preferences must not be null");
        }
        if (this.getClient() != null) {
            preferences.setValue("directoryToScanOnStartup", ((StartupActionsPreferenceNodeClient)this.getClient()).startupScanDirectoryTextField.getText());
            preferences.setValue("fileToLoadOnStartup", ((StartupActionsPreferenceNodeClient)this.getClient()).startupFileTextField.getText());
            preferences.setValue("scanDirectoryOnStartup", new Boolean(((StartupActionsPreferenceNodeClient)this.getClient()).scanDirectoryOnStartupRadioButton.isSelected()).toString());
            preferences.setValue("loadFileOnStartup", new Boolean(((StartupActionsPreferenceNodeClient)this.getClient()).loadFileOnStartupRadioButton.isSelected()).toString());
            preferences.setValue("startupActionsEnabled", new Boolean(((StartupActionsPreferenceNodeClient)this.getClient()).startupActionsEnabledCheckox.isSelected()).toString());
        }
    }

    private class StartupActionsPreferenceNodeClient
    extends JPanel {
        protected JLabel startupScanDirectoryLabel = new JLabel("Directory to scan");
        protected JLabel startupFileLabel = new JLabel("File to load");
        protected JTextField startupScanDirectoryTextField = new JTextField();
        protected JTextField startupFileTextField = new JTextField();
        protected JButton startupFileButton = new JButton("Choose");
        protected JButton startupScanDirectoryButton;
        protected JPanel startupOptionsPanel;
        protected JRadioButton loadFileOnStartupRadioButton;
        protected JRadioButton scanDirectoryOnStartupRadioButton;
        protected JCheckBox startupActionsEnabledCheckox;
        protected ButtonGroup loadFileOrScanDirectoryButtonGroup;

        private StartupActionsPreferenceNodeClient() {
            this.startupFileButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ StartupActionsPreferenceNodeClient this$1;
                {
                    this.this$1 = startupActionsPreferenceNodeClient;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.performChooseStartupFileAction();
                }
            });
            this.startupScanDirectoryButton = new JButton("Choose");
            this.startupScanDirectoryButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ StartupActionsPreferenceNodeClient this$1;
                {
                    this.this$1 = startupActionsPreferenceNodeClient;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.performChooseStartupDirectoryAction();
                }
            });
            this.loadFileOnStartupRadioButton = new JRadioButton("Load file");
            this.scanDirectoryOnStartupRadioButton = new JRadioButton("Scan directory");
            this.loadFileOrScanDirectoryButtonGroup = new ButtonGroup();
            this.loadFileOrScanDirectoryButtonGroup.add(this.loadFileOnStartupRadioButton);
            this.loadFileOrScanDirectoryButtonGroup.add(this.scanDirectoryOnStartupRadioButton);
            this.startupActionsEnabledCheckox = new JCheckBox("Enable startup actions");
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagLayout.setConstraints(this.startupActionsEnabledCheckox, gridBagConstraints);
            this.add(this.startupActionsEnabledCheckox);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(this.scanDirectoryOnStartupRadioButton, gridBagConstraints);
            this.add(this.scanDirectoryOnStartupRadioButton);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.startupScanDirectoryLabel, gridBagConstraints);
            this.add(this.startupScanDirectoryLabel);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 12;
            gridBagConstraints.fill = 0;
            gridBagLayout.setConstraints(this.startupScanDirectoryButton, gridBagConstraints);
            this.add(this.startupScanDirectoryButton);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagLayout.setConstraints(this.startupScanDirectoryTextField, gridBagConstraints);
            this.add(this.startupScanDirectoryTextField);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.loadFileOnStartupRadioButton, gridBagConstraints);
            this.add(this.loadFileOnStartupRadioButton);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.startupFileLabel, gridBagConstraints);
            this.add(this.startupFileLabel);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.anchor = 12;
            gridBagConstraints.fill = 0;
            gridBagLayout.setConstraints(this.startupFileButton, gridBagConstraints);
            this.add(this.startupFileButton);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagLayout.setConstraints(this.startupFileTextField, gridBagConstraints);
            this.add(this.startupFileTextField);
        }

        public void performChooseStartupDirectoryAction() {
            File file;
            int n;
            StartupActionsPreferenceNode.this.sharedFileChooser.setDialogTitle("Choose the directory to scan at startup");
            StartupActionsPreferenceNode.this.sharedFileChooser.setApproveButtonText("Choose");
            StartupActionsPreferenceNode.this.sharedFileChooser.setFileSelectionMode(1);
            File file2 = new File(StartupActionsPreferenceNode.this.preferences.getString("lastDirectoryOpenedToLoadTargetList"));
            if (file2.exists() && file2.isDirectory()) {
                StartupActionsPreferenceNode.this.sharedFileChooser.setCurrentDirectory(file2);
            }
            if ((n = StartupActionsPreferenceNode.this.sharedFileChooser.showOpenDialog(Application.singleton().getApplicationFrame())) == 0 && (file = StartupActionsPreferenceNode.this.sharedFileChooser.getSelectedFile()) != null) {
                this.startupScanDirectoryTextField.setText(file.getAbsolutePath());
            }
        }

        public void performChooseStartupFileAction() {
            File file;
            int n;
            StartupActionsPreferenceNode.this.sharedFileChooser.setDialogTitle("Choose the file to load at startup");
            StartupActionsPreferenceNode.this.sharedFileChooser.setApproveButtonText("Choose");
            StartupActionsPreferenceNode.this.sharedFileChooser.setFileSelectionMode(0);
            File file2 = new File(StartupActionsPreferenceNode.this.preferences.getString("lastDirectoryOpenedToLoadTargetList"));
            if (file2.exists() && file2.isDirectory()) {
                StartupActionsPreferenceNode.this.sharedFileChooser.setCurrentDirectory(file2);
            }
            if ((n = StartupActionsPreferenceNode.this.sharedFileChooser.showOpenDialog(Application.singleton().getApplicationFrame())) == 0 && (file = StartupActionsPreferenceNode.this.sharedFileChooser.getSelectedFile()) != null) {
                this.startupFileTextField.setText(file.getAbsolutePath());
            }
        }
    }
}

