/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.controller.preferences;

import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pw.palmpatch.PreferenceNode;
import pw.palmpatch.Preferences;
import pw.palmpatch.util.ImageCache;

public class TargetInfoEditorPreferenceNode
extends PreferenceNode {
    public TargetInfoEditorPreferenceNode() {
        this.setDescription("Target Info Editing Preferences");
        this.setTitle("Editor");
        this.setIcon(ImageCache.singleton().getIcon("icons/targetInfoEditorPreferences.gif"));
        this.setOpenIcon(this.getIcon());
        this.setSystemNode(false);
    }

    public JComponent buildClient() {
        return new TargetInfoEditorPreferenceNodeClient();
    }

    public void display(Preferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("preferences must not be null");
        }
        ((TargetInfoEditorPreferenceNodeClient)this.getClient()).defaultCreditsTextField.setText(preferences.getString("defaultCredits"));
    }

    public void save(Preferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("preferences must not be null");
        }
        if (this.getClient() != null) {
            preferences.setValue("defaultCredits", ((TargetInfoEditorPreferenceNodeClient)this.getClient()).defaultCreditsTextField.getText());
        }
    }

    private class TargetInfoEditorPreferenceNodeClient
    extends JPanel {
        protected JPanel defaultCreditsPanel;
        protected JLabel defaultCreditsLabel;
        protected JTextField defaultCreditsTextField;

        TargetInfoEditorPreferenceNodeClient() {
            this.setLayout(new BoxLayout(this, 1));
            this.defaultCreditsLabel = new JLabel("Default text for the credits information");
            this.defaultCreditsTextField = new JTextField(10);
            this.defaultCreditsTextField.setMaximumSize(new Dimension(this.defaultCreditsTextField.getMaximumSize().width, this.defaultCreditsTextField.getMinimumSize().height));
            this.add(this.defaultCreditsLabel);
            this.add(Box.createVerticalStrut(15));
            this.add(this.defaultCreditsTextField);
        }
    }
}

