/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.io.palmfiles;

import com.sun.java.util.collections.Collection;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public abstract class RecordList {
    protected int nextRecordListID;
    protected short numberOfRecords;
    protected static int NEXT_RECORD_LIST_ID_OFFSET = 0;
    protected static int NUMBER_OF_RECORDS_OFFSET = 4;
    protected static int PLACEHOLDER_OFFSET = 6;

    public abstract Collection getAllRecordEntries();

    public int getNumberOfRecords() {
        return this.numberOfRecords;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void read(byte[] byArray) throws IOException {
        DataInputStream dataInputStream;
        block9: {
            block8: {
                dataInputStream = null;
                try {
                    dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                    long l = dataInputStream.skip(72L);
                    if (l != 72L) {
                        throw new IOException("Could not skip enough bytes!");
                    }
                    this.setNextRecordListID(dataInputStream.readInt());
                    this.setNumberOfRecords(dataInputStream.readShort());
                    if (this.getNumberOfRecords() <= 0) {
                        Object var4_4 = null;
                        if (dataInputStream == null) return;
                        break block8;
                    }
                    this.readRecordEntries(dataInputStream);
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    if (dataInputStream == null) throw throwable;
                    try {
                        dataInputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {}
            catch (IOException iOException) {}
            dataInputStream.close();
            return;
        }
        Object var4_5 = null;
        if (dataInputStream == null) return;
        try {}
        catch (IOException iOException) {
            return;
        }
        dataInputStream.close();
    }

    public abstract void readRecordEntries(DataInputStream var1) throws IOException;

    protected void setNextRecordListID(int n) {
        this.nextRecordListID = n;
    }

    protected void setNumberOfRecords(short s) {
        this.numberOfRecords = s;
    }
}

