/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.models;

import javax.swing.table.AbstractTableModel;
import pw.palmpatch.models.RankingInfo;

public class RankingsTableModelAdapter
extends AbstractTableModel {
    private RankingInfo[] rankings;
    private String[] columnNames = new String[]{"#", "Credits", "Targets cracked", "Targets cracked"};

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        if (n < 0 && n >= this.columnNames.length) {
            throw new IllegalArgumentException("column: " + n + " is out of range");
        }
        return this.columnNames[n];
    }

    public int getRowCount() {
        if (this.rankings != null) {
            return this.rankings.length;
        }
        return 0;
    }

    public Object getValueAt(int n, int n2) {
        if (this.rankings == null) {
            throw new IllegalStateException("model not set");
        }
        if (this.rankings.length < n - 1) {
            return null;
        }
        RankingInfo rankingInfo = this.rankings[n];
        if (rankingInfo != null) {
            switch (n2) {
                case 0: {
                    return new Integer(rankingInfo.getRanking());
                }
                case 1: {
                    return rankingInfo.getCracker();
                }
                case 2: {
                    return new Integer(rankingInfo.getCrackedTargets().size());
                }
                case 3: {
                    return rankingInfo.getCrackedTargets();
                }
            }
            throw new RuntimeException("Execution should never reach this point in doGetValueAt in: " + this.getClass());
        }
        return null;
    }

    public void setModel(RankingInfo[] rankingInfoArray) {
        if (rankingInfoArray == null) {
            throw new IllegalArgumentException("rankings must not be null");
        }
        this.rankings = rankingInfoArray;
        this.fireTableDataChanged();
    }
}

