/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.models;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.TreeMap;
import pw.palmpatch.models.Model;
import pw.palmpatch.models.RankingInfo;
import pw.palmpatch.models.RankingsTableModelAdapter;
import pw.palmpatch.models.StatisticsModel;
import pw.palmpatch.models.TargetInfo;
import pw.palmpatch.models.TargetInfosToStatisticsTableModelAdapter;

public class StatisticsModel
extends Model {
    protected TargetInfosToStatisticsTableModelAdapter singleTargetInfosToStatisticsTableModelAdapter = new TargetInfosToStatisticsTableModelAdapter();
    protected List targetInfosToBaseStatisticsOn;
    protected RankingInfo[] currentTopRankings;
    protected RankingsTableModelAdapter rankingsTableModelAdapter = new RankingsTableModelAdapter();
    protected int positions;

    public RankingsTableModelAdapter getRankingsTableModelAdapter() {
        return this.rankingsTableModelAdapter;
    }

    public TargetInfosToStatisticsTableModelAdapter getTargetInfosToStatisticsTableModelAdapter() {
        return this.singleTargetInfosToStatisticsTableModelAdapter;
    }

    protected RankingInfo[] getTopRankings(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("positions must greater than zero");
        }
        if (this.currentTopRankings == null || this.currentTopRankings.length != n) {
            this.recalculateTopRankings(n);
        }
        return this.currentTopRankings;
    }

    public void recalculateTopRankings(int n) {
        this.positions = n;
        this.currentTopRankings = new RankingInfo[n];
        HashMap hashMap = new HashMap();
        TargetInfo targetInfo = null;
        String string = null;
        Iterator iterator = this.targetInfosToBaseStatisticsOn.iterator();
        ArrayList arrayList = null;
        while (iterator.hasNext()) {
            targetInfo = (TargetInfo)iterator.next();
            string = targetInfo.getCredits();
            if (hashMap.containsKey((Object)string)) {
                arrayList = (List)hashMap.get((Object)string);
                arrayList.add((Object)targetInfo.getLongName());
                hashMap.put((Object)string, (Object)arrayList);
                continue;
            }
            arrayList = new ArrayList();
            arrayList.add((Object)targetInfo.getLongName());
            hashMap.put((Object)string, (Object)arrayList);
        }
        class MyComparator
        implements Comparator {
            Map myMap;
            int numberOfCracks1;
            int numberOfCracks2;

            MyComparator(Map map) {
                this.myMap = map;
            }

            public int compare(Object object, Object object2) {
                this.numberOfCracks1 = ((List)this.myMap.get(object)).size();
                this.numberOfCracks2 = ((List)this.myMap.get(object2)).size();
                if (this.numberOfCracks2 == this.numberOfCracks1) {
                    return -1;
                }
                return this.numberOfCracks2 - this.numberOfCracks1;
            }
        }
        TreeMap treeMap = new TreeMap((Comparator)new MyComparator((Map)hashMap));
        treeMap.putAll((Map)hashMap);
        Object[] objectArray = treeMap.keySet().toArray();
        String string2 = null;
        int n2 = 0;
        while (n2 < n) {
            if (objectArray.length <= n2) break;
            string2 = (String)objectArray[n2];
            this.currentTopRankings[n2] = new RankingInfo(string2, (List)hashMap.get((Object)string2), n2 + 1);
            ++n2;
        }
        this.rankingsTableModelAdapter.setModel(this.currentTopRankings);
    }

    public void setModelToBaseStatisticsOn(List list, int n) {
        this.targetInfosToBaseStatisticsOn = list;
        this.singleTargetInfosToStatisticsTableModelAdapter.setModel(list);
        this.recalculateTopRankings(n);
        this.rankingsTableModelAdapter.setModel(this.getTopRankings(n));
    }

    public void triggerUpdate() {
        this.singleTargetInfosToStatisticsTableModelAdapter.triggerUpdate();
        this.singleTargetInfosToStatisticsTableModelAdapter.sortByColumn(0);
        this.recalculateTopRankings(this.positions);
    }
}

