/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.models;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.StringTokenizer;
import javax.swing.event.EventListenerList;
import pw.palmpatch.events.PatchStatusChangedEvent;
import pw.palmpatch.events.PatchStatusChangedListener;
import pw.palmpatch.models.Attachment;
import pw.palmpatch.models.FileInfo;

public class TargetInfo {
    protected String longName;
    protected String url;
    protected String credits;
    protected String text;
    protected List fileInfos = new ArrayList();
    protected boolean hasError = false;
    protected EventListenerList anEventListenerList;
    protected List attachments = new ArrayList();
    protected boolean isNew;
    static /* synthetic */ Class class$pw$palmpatch$events$PatchStatusChangedListener;

    public TargetInfo() {
        this.anEventListenerList = new EventListenerList();
    }

    public void addAttachment(Attachment attachment) {
        this.attachments.add((Object)attachment);
    }

    public void addFileInfo(FileInfo fileInfo) {
        this.fileInfos.add((Object)fileInfo);
        fileInfo.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("patchStatus")) {
                    TargetInfo.this.firePatchStatusChangedEvent(new PatchStatusChangedEvent(propertyChangeEvent.getSource()));
                }
            }
        });
    }

    public void addPatchStatusChangedListener(PatchStatusChangedListener patchStatusChangedListener) {
        this.anEventListenerList.add(class$pw$palmpatch$events$PatchStatusChangedListener != null ? class$pw$palmpatch$events$PatchStatusChangedListener : (class$pw$palmpatch$events$PatchStatusChangedListener = TargetInfo.class$("pw.palmpatch.events.PatchStatusChangedListener")), patchStatusChangedListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private boolean compareLongName(TargetInfo targetInfo) {
        if (targetInfo.getLongName() != null && !targetInfo.getLongName().trim().startsWith(this.longName.trim().substring(0, 1))) {
            return false;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        StringTokenizer stringTokenizer = new StringTokenizer(targetInfo.getLongName());
        while (stringTokenizer.hasMoreElements()) {
            arrayList.add(stringTokenizer.nextElement());
        }
        stringTokenizer = new StringTokenizer(this.longName);
        while (stringTokenizer.hasMoreElements()) {
            arrayList2.add(stringTokenizer.nextElement());
        }
        if (arrayList.size() == 0 || arrayList2.size() == 0) {
            return false;
        }
        String string = (String)arrayList.get(arrayList.size() - 1);
        String string2 = (String)arrayList2.get(arrayList2.size() - 1);
        if (this.isSpecialWord(string) && this.isSpecialWord(string2)) {
            return this.compareTokensWhereTwoPhrasesContainSpecialWords((List)arrayList2, (List)arrayList);
        }
        if (this.isSpecialWord(string2)) {
            return this.compareTokensWhereOnePhraseContainsSpecialWords((List)arrayList2, (List)arrayList);
        }
        if (this.isSpecialWord(string)) {
            return this.compareTokensWhereOnePhraseContainsSpecialWords((List)arrayList, (List)arrayList2);
        }
        return this.compareTokens((List)arrayList2, (List)arrayList);
    }

    private boolean compareTokens(List list, List list2) {
        if (list.size() == 1) {
            return ((String)list.get(0)).equalsIgnoreCase((String)list2.get(0));
        }
        return this.doRemainingTokensMatch(list, list2, list.size());
    }

    private boolean compareTokensWhereOnePhraseContainsSpecialWords(List list, List list2) {
        String string = (String)list.get(list.size() - 1);
        if (string.equalsIgnoreCase("keygen")) {
            String string2;
            if (list.size() > 2 && (string2 = (String)list.get(list.size() - 2)).equalsIgnoreCase("PSNG")) {
                return this.doRemainingTokensMatch(list, list2, list.size() - 2);
            }
        } else {
            return this.doRemainingTokensMatch(list, list2, list.size() - 1);
        }
        return false;
    }

    private boolean compareTokensWhereTwoPhrasesContainSpecialWords(List list, List list2) {
        String string = (String)list.get(list.size() - 1);
        if (string.equalsIgnoreCase("keygen")) {
            String string2;
            if (list.size() > 2 && (string2 = (String)list.get(list.size() - 2)).equalsIgnoreCase("PSNG")) {
                return this.doRemainingTokensMatch(list, list2, list.size() - 2);
            }
        } else {
            return this.doRemainingTokensMatch(list, list2, list.size() - 1);
        }
        return false;
    }

    private boolean doRemainingTokensMatch(List list, List list2, int n) {
        if (n > list.size() && list.size() < list2.size()) {
            n = list.size();
        }
        if (n > list2.size() && list2.size() < list.size()) {
            n = list2.size();
        }
        if (this.isVersionIdentifier((String)list.get(n - 1))) {
            --n;
        } else if (this.isVersionIdentifier((String)list.get(n - 1))) {
            --n;
        }
        boolean bl = true;
        if (n == 0) {
            bl = false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (!((String)list.get(n2)).equalsIgnoreCase((String)list2.get(n2))) {
                bl = false;
            }
            ++n2;
        }
        return bl;
    }

    protected void firePatchStatusChangedEvent(PatchStatusChangedEvent patchStatusChangedEvent) {
        Object[] objectArray = this.anEventListenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$pw$palmpatch$events$PatchStatusChangedListener != null ? class$pw$palmpatch$events$PatchStatusChangedListener : TargetInfo.class$("pw.palmpatch.events.PatchStatusChangedListener"))) {
                ((PatchStatusChangedListener)objectArray[n + 1]).patchStatusChanged(patchStatusChangedEvent);
            }
            n -= 2;
        }
    }

    public Attachment getAttachmentAt(int n) {
        return (Attachment)this.attachments.get(n);
    }

    public List getAttachments() {
        return this.attachments;
    }

    public String getCredits() {
        return this.credits != null ? this.credits : "";
    }

    public FileInfo getFileInfoAt(int n) {
        return (FileInfo)this.fileInfos.get(n);
    }

    public List getFilesInfos() {
        return this.fileInfos;
    }

    public String getLongName() {
        return this.longName != null ? this.longName : "";
    }

    public FileInfo getMatchingFileInfo(int n) {
        FileInfo fileInfo = null;
        Iterator iterator = this.fileInfos.iterator();
        while (iterator.hasNext()) {
            fileInfo = (FileInfo)iterator.next();
            if (!fileInfo.getCRC16().equals(Integer.toString(n))) continue;
            return fileInfo;
        }
        return null;
    }

    public FileInfo getMatchingFileInfo(long l) {
        FileInfo fileInfo = null;
        Iterator iterator = this.fileInfos.iterator();
        while (iterator.hasNext()) {
            fileInfo = (FileInfo)iterator.next();
            if (!fileInfo.getSize().equals(Long.toString(l))) continue;
            return fileInfo;
        }
        return null;
    }

    public FileInfo getMatchingFileInfo(String string) {
        FileInfo fileInfo = null;
        Iterator iterator = this.fileInfos.iterator();
        while (iterator.hasNext()) {
            fileInfo = (FileInfo)iterator.next();
            if (!fileInfo.getName().equals(string)) continue;
            return fileInfo;
        }
        return null;
    }

    public FileInfo getMatchingFileInfo(String string, long l) {
        FileInfo fileInfo = null;
        Iterator iterator = this.fileInfos.iterator();
        while (iterator.hasNext()) {
            fileInfo = (FileInfo)iterator.next();
            if (!fileInfo.getName().equals(string) || !fileInfo.getSize().equals(Long.toString(l))) continue;
            return fileInfo;
        }
        return null;
    }

    public String getText() {
        return this.text != null ? this.text : "";
    }

    public String getUrl() {
        return this.url != null ? this.url : "";
    }

    public boolean hasError() {
        return this.hasError;
    }

    public boolean isAlike(TargetInfo targetInfo) {
        if (targetInfo == null) {
            throw new IllegalArgumentException("targetInfo must not be null");
        }
        return this.compareLongName(targetInfo);
    }

    public boolean isNew() {
        return this.isNew;
    }

    private boolean isSpecialWord(String string) {
        String[] stringArray = new String[]{"s/n", "[s/n]", "PSNG", "serial", "[serial]", "keygen"};
        int n = 0;
        while (n < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected boolean isVersionIdentifier(String string) {
        block7: {
            block6: {
                if (string == null) {
                    throw new IllegalArgumentException("Token must not be null");
                }
                if (string.length() == 0) {
                    throw new IllegalArgumentException("Token must have a size greater than 0");
                }
                if (!string.substring(0, 1).equalsIgnoreCase("v")) break block6;
                if (string.length() <= 1) break block7;
                String string2 = string.substring(1, 2);
                try {
                    new Integer(string2);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {}
                break block7;
            }
            String string3 = string.substring(0, 1);
            try {
                new Integer(string3);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return false;
    }

    public TargetInfo makeCopy() {
        TargetInfo targetInfo = new TargetInfo();
        targetInfo.setCredits(this.getCredits());
        Iterator iterator = this.getFilesInfos().iterator();
        ArrayList arrayList = new ArrayList(this.getFilesInfos().size());
        while (iterator.hasNext()) {
            arrayList.add((Object)((FileInfo)iterator.next()).makeCopy());
        }
        targetInfo.setFilesInfos((List)arrayList);
        Iterator iterator2 = this.getAttachments().iterator();
        ArrayList arrayList2 = new ArrayList(this.getAttachments().size());
        while (iterator2.hasNext()) {
            arrayList2.add((Object)((Attachment)iterator2.next()).makeCopy());
        }
        targetInfo.setAttachments((List)arrayList2);
        targetInfo.setHasError(this.hasError());
        targetInfo.setLongName(this.getLongName());
        targetInfo.setText(this.getText());
        targetInfo.setUrl(this.getUrl());
        targetInfo.setIsNew(this.isNew());
        return targetInfo;
    }

    public void removeAllSourceFiles() {
        FileInfo fileInfo = null;
        Iterator iterator = this.fileInfos.iterator();
        while (iterator.hasNext()) {
            fileInfo = (FileInfo)iterator.next();
            fileInfo.setSourceFile(null);
        }
    }

    public void removePatchStatusChangedListener(PatchStatusChangedListener patchStatusChangedListener) {
        this.anEventListenerList.remove(class$pw$palmpatch$events$PatchStatusChangedListener != null ? class$pw$palmpatch$events$PatchStatusChangedListener : (class$pw$palmpatch$events$PatchStatusChangedListener = TargetInfo.class$("pw.palmpatch.events.PatchStatusChangedListener")), patchStatusChangedListener);
    }

    public void setAttachments(List list) {
        this.attachments = list;
    }

    public void setCredits(String string) {
        this.credits = string;
    }

    public void setFilesInfos(List list) {
        this.fileInfos = list;
    }

    public void setHasError(boolean bl) {
        this.hasError = bl;
    }

    public void setIsNew(boolean bl) {
        this.isNew = bl;
    }

    public void setLongName(String string) {
        this.longName = string;
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String toString() {
        return "TargetInfo for target: " + this.longName;
    }
}

