/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.models;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import pw.palmpatch.models.Model;
import pw.palmpatch.models.TargetInfo;
import pw.palmpatch.models.TargetInfoDuplicatesRemoverViewTableModel;

public class TargetInfoDuplicatesRemoverModel
extends Model {
    protected TargetInfoDuplicatesRemoverViewTableModel tableModelForExistingTargetInfos;
    protected TargetInfoDuplicatesRemoverViewTableModel tableModelForNewTargetInfos;
    protected DuplicatesList duplicatesList = new DuplicatesList();
    protected Map deletionIndicatorsForNewTargetInfos = new HashMap();
    protected Map deletionIndicatorsForExistingTargetInfos = new HashMap();

    public TargetInfoDuplicatesRemoverModel() {
        this.tableModelForNewTargetInfos = new TargetInfoDuplicatesRemoverViewTableModel(this.deletionIndicatorsForNewTargetInfos);
        this.tableModelForExistingTargetInfos = new TargetInfoDuplicatesRemoverViewTableModel(this.deletionIndicatorsForExistingTargetInfos);
    }

    public void addDuplicates(TargetInfo targetInfo, List list) {
        if (!this.deletionIndicatorsForNewTargetInfos.containsKey((Object)targetInfo)) {
            this.deletionIndicatorsForNewTargetInfos.put((Object)targetInfo, (Object)Boolean.FALSE);
        }
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.deletionIndicatorsForExistingTargetInfos.put(iterator.next(), (Object)Boolean.FALSE);
            }
        }
        this.duplicatesList.addDuplicates(targetInfo, list);
        this.tableModelForNewTargetInfos.setTargetInfos(this.duplicatesList.getNewTargetInfos());
        this.tableModelForNewTargetInfos.fireTableDataChanged();
    }

    public void clearDuplicates() {
        this.duplicatesList.clearDuplicates();
        this.tableModelForExistingTargetInfos.fireTableDataChanged();
    }

    public List getExistingTargetInfosToDelete() {
        return this.getTargetInfosToDelete(this.deletionIndicatorsForExistingTargetInfos);
    }

    public List getNewTargetInfosToDelete() {
        return this.getTargetInfosToDelete(this.deletionIndicatorsForNewTargetInfos);
    }

    public TargetInfoDuplicatesRemoverViewTableModel getTableModelForExistingTaregetInfos() {
        return this.tableModelForExistingTargetInfos;
    }

    public TargetInfoDuplicatesRemoverViewTableModel getTableModelForNewTaregetInfos() {
        return this.tableModelForNewTargetInfos;
    }

    protected List getTargetInfosToDelete(Map map) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (!entry.getValue().equals(Boolean.TRUE)) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }

    public boolean isEmpty() {
        return this.duplicatesList.getNewTargetInfos().isEmpty();
    }

    public void selectNewTargetInfo(int n) {
        this.tableModelForExistingTargetInfos.setTargetInfos(this.duplicatesList.getDuplicatesOfNewTargetInfo(n));
        this.tableModelForExistingTargetInfos.fireTableDataChanged();
    }

    private class DuplicatesList {
        private List newTargetInfos = new ArrayList();
        private List duplicatesOfNewTargetInfos = new ArrayList();

        DuplicatesList() {
        }

        void addDuplicates(TargetInfo targetInfo, List list) {
            this.newTargetInfos.add((Object)targetInfo);
            this.duplicatesOfNewTargetInfos.add((Object)list);
        }

        void clearDuplicates() {
            this.newTargetInfos.clear();
            this.duplicatesOfNewTargetInfos.clear();
        }

        List getDuplicatesOfNewTargetInfo(int n) {
            if (n < 0 || n >= this.duplicatesOfNewTargetInfos.size()) {
                return null;
            }
            return (List)this.duplicatesOfNewTargetInfos.get(n);
        }

        List getDuplicatesOfNewTargetInfos() {
            return this.duplicatesOfNewTargetInfos;
        }

        List getNewTargetInfos() {
            return this.newTargetInfos;
        }

        TargetInfo getTargetInfo(int n) {
            return (TargetInfo)this.newTargetInfos.get(n);
        }
    }
}

