/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.models;

import com.sun.java.util.collections.List;
import javax.swing.table.AbstractTableModel;
import pw.palmpatch.events.PatchStatusChangedEvent;
import pw.palmpatch.events.PatchStatusChangedListener;
import pw.palmpatch.models.FileInfo;
import pw.palmpatch.models.TargetInfo;
import pw.palmpatch.models.ValueWithFileInfo;
import pw.palmpatch.util.Tracing;

public class TargetInfoToFileInfosTableModelAdapter
extends AbstractTableModel {
    protected TargetInfo myTargetInfo;
    protected List cachedFileInfos;
    protected String[] columnNames = new String[]{"ID", "Filename", "Long Name", "Size", " Version", "CRC16", "Info", "Changes"};
    MyPatchStatusChangedListener myPatchStatusChangedListener = new MyPatchStatusChangedListener();

    TargetInfoToFileInfosTableModelAdapter() {
    }

    public TargetInfoToFileInfosTableModelAdapter(TargetInfo targetInfo) {
        this.setTargetInfo(targetInfo);
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        if (n < 0 && n > this.columnNames.length) {
            throw new IllegalArgumentException("column: " + n + " is out of range");
        }
        return this.columnNames[n];
    }

    public FileInfo getFileInfoAt(int n) {
        if (this.myTargetInfo != null && n >= 0 && n < this.myTargetInfo.getFilesInfos().size()) {
            return this.myTargetInfo.getFileInfoAt(n);
        }
        return null;
    }

    public int getRowCount() {
        if (this.cachedFileInfos != null) {
            return this.cachedFileInfos.size();
        }
        return 0;
    }

    public TargetInfo getTargetInfo() {
        return this.myTargetInfo;
    }

    public Object getValueAt(int n, int n2) {
        if (n2 < 0 && n2 > this.columnNames.length) {
            throw new IllegalArgumentException("columnIndex: " + n2 + " is out of range");
        }
        if (n < 0 && n > this.getRowCount()) {
            throw new IllegalArgumentException("rowIndex: " + n + " is out of range");
        }
        FileInfo fileInfo = (FileInfo)this.cachedFileInfos.get(n);
        switch (n2) {
            case 0: {
                return new ValueWithFileInfo(fileInfo.getId(), fileInfo, fileInfo.doesIDMatch());
            }
            case 1: {
                return new ValueWithFileInfo(fileInfo.getName(), fileInfo, fileInfo.doesNameMatch());
            }
            case 2: {
                return fileInfo.getLongName();
            }
            case 3: {
                return new ValueWithFileInfo(fileInfo.getSize(), fileInfo, fileInfo.doesSizeMatch());
            }
            case 4: {
                return new ValueWithFileInfo(fileInfo.getVersion(), fileInfo, fileInfo.doesVersionMatch());
            }
            case 5: {
                return new ValueWithFileInfo(fileInfo.getCRC16(), fileInfo, fileInfo.doesCRC16Match());
            }
            case 6: {
                return fileInfo.getInfoText();
            }
            case 7: {
                List list = fileInfo.getChanges();
                if (list != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n3 = 0;
                    while (n3 < list.size()) {
                        if (list.get(n3) == null) {
                            Tracing.singleton().trace("changes contains null", Tracing.TRACE_GREAT_DETAIL);
                        } else if (n3 != 0) {
                            stringBuffer.append("  /  ");
                            stringBuffer.append(list.get(n3).toString());
                        } else {
                            stringBuffer.append(list.get(n3).toString());
                        }
                        ++n3;
                    }
                    return stringBuffer.toString();
                }
                return "";
            }
        }
        return new RuntimeException("Execution should never reach this point in getValueAt in: " + this.getClass());
    }

    public void setTargetInfo(TargetInfo targetInfo) {
        this.myTargetInfo = targetInfo;
        if (this.myTargetInfo != null) {
            this.cachedFileInfos = targetInfo.getFilesInfos();
            this.myTargetInfo.addPatchStatusChangedListener(this.myPatchStatusChangedListener);
        } else {
            this.cachedFileInfos = null;
        }
        this.fireTableDataChanged();
    }

    private class MyPatchStatusChangedListener
    implements PatchStatusChangedListener {
        MyPatchStatusChangedListener() {
        }

        public void patchStatusChanged(PatchStatusChangedEvent patchStatusChangedEvent) {
            FileInfo fileInfo = (FileInfo)patchStatusChangedEvent.getSource();
            int n = TargetInfoToFileInfosTableModelAdapter.this.cachedFileInfos.indexOf((Object)fileInfo);
            TargetInfoToFileInfosTableModelAdapter.this.fireTableRowsUpdated(n, n);
        }
    }
}

