/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.models;

import java.util.Date;
import pw.palmpatch.Application;
import pw.palmpatch.models.TargetInfo;

public class TargetListInfo
implements Cloneable {
    protected String version = "";
    protected String date = "";
    protected String credits = "";
    protected String infoText = "";
    protected int numberOfTargets = 0;
    protected String updatesText = "";

    public void addEntryForChangedTargetInfo(TargetInfo targetInfo) {
        if (targetInfo == null) {
            throw new IllegalArgumentException("changedTargetInfo must not be null");
        }
        String string = Application.singleton().getApplicationDateFormat().format(new Date());
        this.updatesText = String.valueOf(string) + " Changed\t" + targetInfo.getLongName() + " (" + targetInfo.getCredits() + ")" + "\n" + this.updatesText;
    }

    public void addEntryForNewTargetInfo(TargetInfo targetInfo) {
        if (targetInfo == null) {
            throw new IllegalArgumentException("newTargetInfo must not be null");
        }
        String string = Application.singleton().getApplicationDateFormat().format(new Date());
        this.updatesText = this.updatesText == null ? String.valueOf(string) + " Added\t " + targetInfo.getLongName() : String.valueOf(string) + " Added\t " + targetInfo.getLongName() + " (" + targetInfo.getCredits() + ")" + "\n" + this.updatesText;
    }

    public void addEntryForRemovedTargetInfo(TargetInfo targetInfo) {
        if (targetInfo == null) {
            throw new IllegalArgumentException("removedTargetInfo must not be null");
        }
        String string = Application.singleton().getApplicationDateFormat().format(new Date());
        this.updatesText = String.valueOf(string) + " Removed\t " + targetInfo.getLongName() + " (" + targetInfo.getCredits() + ")" + "\n" + this.updatesText;
    }

    public String getCredits() {
        return this.credits;
    }

    public String getDate() {
        return this.date;
    }

    public String getInfoText() {
        return this.infoText;
    }

    public int getNumberOfTargets() {
        return this.numberOfTargets;
    }

    public String getUpdatesText() {
        return this.updatesText;
    }

    public String getVersion() {
        return this.version;
    }

    public TargetListInfo makeCopy() {
        try {
            return (TargetListInfo)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void setCredits(String string) {
        this.credits = string;
    }

    public void setDate(String string) {
        this.date = string;
    }

    public void setInfoText(String string) {
        this.infoText = string;
    }

    public void setNumberOfTargets(int n) {
        this.numberOfTargets = n;
    }

    public void setUpdatesText(String string) {
        this.updatesText = string;
    }

    public void setVersion(String string) {
        this.version = string;
    }
}

