/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.models;

import java.io.File;
import pw.palmpatch.events.AttachmentChangedEvent;
import pw.palmpatch.events.FileInfoChangedEvent;
import pw.palmpatch.events.TargetInfoChangedEvent;
import pw.palmpatch.models.Attachment;
import pw.palmpatch.models.FileInfo;
import pw.palmpatch.models.Model;
import pw.palmpatch.models.TargetInfo;
import pw.palmpatch.models.TargetInfoToAttachmentsTableModelAdapter;
import pw.palmpatch.models.TargetInfoToFileInfosTableModelAdapter;
import pw.palmpatch.models.TargetInfosToListModelAdapter;

public class TargetViewAndEditModel
extends Model {
    protected TargetInfo currentTargetInfo;
    protected FileInfo currentFileInfo;
    protected Attachment currentAttachment;
    protected File currentTargetFile;
    protected TargetInfosToListModelAdapter singleTargetInfosToListModelAdapter = new TargetInfosToListModelAdapter();
    protected TargetInfoToFileInfosTableModelAdapter singleTargetInfoToFileInfosTableModelAdapter = new TargetInfoToFileInfosTableModelAdapter();
    protected TargetInfoToAttachmentsTableModelAdapter singleTargetInfoToAttachmentsTableModelAdapter = new TargetInfoToAttachmentsTableModelAdapter();

    public int addNewAttachment(Attachment attachment) {
        if (attachment == null) {
            throw new IllegalArgumentException("newAttachment must not be null");
        }
        if (this.currentTargetInfo == null) {
            throw new IllegalStateException("must set a currentTargetInfo first");
        }
        attachment.setLongName("New Attachment");
        this.currentTargetInfo.getAttachments().add((Object)attachment);
        this.singleTargetInfoToAttachmentsTableModelAdapter.fireTableDataChanged();
        return this.currentTargetInfo.getAttachments().indexOf((Object)attachment);
    }

    public int addNewFileInfo() {
        if (this.currentTargetInfo == null) {
            throw new IllegalStateException("must set a currentTargetInfo first");
        }
        FileInfo fileInfo = new FileInfo();
        fileInfo.setLongName("New FileInfo");
        this.currentTargetInfo.getFilesInfos().add((Object)fileInfo);
        this.singleTargetInfoToFileInfosTableModelAdapter.fireTableDataChanged();
        return this.currentTargetInfo.getFilesInfos().indexOf((Object)fileInfo);
    }

    public Attachment getCurrentAttachment() {
        return this.currentAttachment;
    }

    public FileInfo getCurrentFileInfo() {
        return this.currentFileInfo;
    }

    public File getCurrentTargetFile() {
        return this.currentTargetFile;
    }

    public TargetInfo getCurrentTargetInfo() {
        return this.currentTargetInfo;
    }

    public TargetInfoToAttachmentsTableModelAdapter getTargetInfoToAttachmentsTableModelAdapter() {
        return this.singleTargetInfoToAttachmentsTableModelAdapter;
    }

    public TargetInfoToFileInfosTableModelAdapter getTargetInfoToFileInfosTableModelAdapter() {
        return this.singleTargetInfoToFileInfosTableModelAdapter;
    }

    public TargetInfosToListModelAdapter getTargetInfosToListModelAdapter() {
        return this.singleTargetInfosToListModelAdapter;
    }

    public void removeCurrentAttachment() {
        if (this.currentTargetInfo == null) {
            throw new IllegalStateException("must set a currentTargetInfo first");
        }
        int n = this.currentTargetInfo.getAttachments().indexOf((Object)this.currentAttachment);
        this.currentTargetInfo.getAttachments().remove(n);
        if (this.currentTargetInfo.getAttachments().size() == 0) {
            this.setCurrentAttachment(null);
        } else if (n == 0) {
            this.setCurrentAttachment((Attachment)this.currentTargetInfo.getAttachments().get(n));
        } else {
            this.setCurrentAttachment((Attachment)this.currentTargetInfo.getAttachments().get(n - 1));
        }
        this.singleTargetInfoToAttachmentsTableModelAdapter.fireTableDataChanged();
    }

    public void removeCurrentFileInfo() {
        if (this.currentTargetInfo == null) {
            throw new IllegalStateException("must set a currentTargetInfo first");
        }
        int n = this.currentTargetInfo.getFilesInfos().indexOf((Object)this.currentFileInfo);
        this.currentTargetInfo.getFilesInfos().remove(n);
        if (this.currentTargetInfo.getFilesInfos().size() == 0) {
            this.setCurrentFileInfo(null);
        } else if (n == 0) {
            this.setCurrentFileInfo((FileInfo)this.currentTargetInfo.getFilesInfos().get(n));
        } else {
            this.setCurrentFileInfo((FileInfo)this.currentTargetInfo.getFilesInfos().get(n - 1));
        }
        this.singleTargetInfoToFileInfosTableModelAdapter.fireTableDataChanged();
    }

    public void setCurrentAttachment(Attachment attachment) {
        AttachmentChangedEvent attachmentChangedEvent;
        int n = -1;
        int n2 = -1;
        if (this.currentTargetInfo != null) {
            if (this.currentAttachment != null) {
                n = this.currentTargetInfo.getAttachments().indexOf((Object)this.currentAttachment);
            }
            if (attachment != null) {
                n2 = this.currentTargetInfo.getAttachments().indexOf((Object)attachment);
            }
            attachmentChangedEvent = new AttachmentChangedEvent(this, this.currentAttachment, attachment, n, n2);
        } else {
            attachmentChangedEvent = new AttachmentChangedEvent(this, this.currentAttachment, attachment, n, n2);
        }
        this.currentAttachment = attachment;
        this.fireModelEvent(attachmentChangedEvent);
    }

    public void setCurrentFileInfo(FileInfo fileInfo) {
        FileInfoChangedEvent fileInfoChangedEvent;
        int n = -1;
        int n2 = -1;
        if (this.currentTargetInfo != null) {
            if (this.currentFileInfo != null) {
                n = this.currentTargetInfo.getFilesInfos().indexOf((Object)this.currentFileInfo);
            }
            if (fileInfo != null) {
                n2 = this.currentTargetInfo.getFilesInfos().indexOf((Object)fileInfo);
            }
            fileInfoChangedEvent = new FileInfoChangedEvent(this, this.currentFileInfo, fileInfo, n, n2);
        } else {
            fileInfoChangedEvent = new FileInfoChangedEvent(this, this.currentFileInfo, fileInfo, n, n2);
        }
        this.currentFileInfo = fileInfo;
        this.fireModelEvent(fileInfoChangedEvent);
    }

    public void setCurrentTargetInfo(TargetInfo targetInfo) {
        this.currentTargetInfo = targetInfo;
        this.fireModelEvent(new TargetInfoChangedEvent(this));
    }
}

