/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.parser;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import pw.palmpatch.exceptions.InvalidChangeInfoFormatException;
import pw.palmpatch.models.Attachment;
import pw.palmpatch.models.ChangeInfo;
import pw.palmpatch.models.FileInfo;
import pw.palmpatch.models.TargetInfo;
import pw.palmpatch.models.TargetListInfo;
import pw.palmpatch.util.Log;
import pw.palmpatch.util.WarningMessage;

public class PWCPPContentHandler
implements ContentHandler {
    protected TargetInfo currentTargetInfo;
    protected FileInfo currentFileInfo;
    protected ChangeInfo currentChangeInfo;
    protected Attachment currentAttachment;
    protected List currentChangeInfos;
    protected boolean charactersForChangesEnabled;
    protected boolean charactersForAttachmentEnabled;
    protected boolean charactersForInfoTextEnabled;
    protected boolean charactersForUpdatesEnabled;
    protected InputSource inputSource;
    protected int numberOfTargetEntries;
    protected StringBuffer changeInfoStringBuffer;
    protected StringBuffer attachmentStringBuffer;
    protected StringBuffer infoTextStringBuffer;
    protected StringBuffer updatesStringBuffer;
    protected TargetListInfo parsedTargetListInfo;
    protected List parsedTargetInfos;

    public PWCPPContentHandler(InputSource inputSource) {
        if (inputSource == null) {
            throw new IllegalArgumentException("inputSource must not be null");
        }
        this.inputSource = inputSource;
        this.parsedTargetInfos = new LinkedList();
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.charactersForChangesEnabled) {
            this.changeInfoStringBuffer.append(new String(cArray, n, n2));
        } else if (this.charactersForAttachmentEnabled) {
            String string = new String(cArray, n, n2);
            this.attachmentStringBuffer.append(string);
        } else if (this.charactersForInfoTextEnabled) {
            String string = new String(cArray, n, n2);
            this.infoTextStringBuffer.append(string);
        } else if (this.charactersForUpdatesEnabled) {
            String string = new String(cArray, n, n2);
            this.updatesStringBuffer.append(string);
        }
    }

    protected void enableCharactersForAttachment(boolean bl) {
        this.charactersForAttachmentEnabled = bl;
    }

    protected void enableCharactersForChanges(boolean bl) {
        this.charactersForChangesEnabled = bl;
    }

    protected void enableCharactersForInfoText(boolean bl) {
        this.charactersForInfoTextEnabled = bl;
    }

    protected void enableCharactersForUpdates(boolean bl) {
        this.charactersForUpdatesEnabled = bl;
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("FILE")) {
            this.currentFileInfo.setChanges(this.currentChangeInfos);
            this.currentChangeInfos = null;
            this.enableCharactersForChanges(false);
            this.currentTargetInfo.addFileInfo(this.currentFileInfo);
        } else {
            if (string3.equals("CHANGE")) {
                try {
                    try {
                        this.currentChangeInfos.add((Object)ChangeInfo.parse(this.changeInfoStringBuffer.toString(), this.currentChangeInfo));
                    }
                    catch (InvalidChangeInfoFormatException invalidChangeInfoFormatException) {
                        this.currentChangeInfo.setErrorText(invalidChangeInfoFormatException.getMessage());
                        this.currentChangeInfos.add((Object)this.currentChangeInfo);
                        this.currentChangeInfo.setHasError(true);
                        this.currentFileInfo.setHasError(true);
                        this.currentTargetInfo.setHasError(true);
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(invalidChangeInfoFormatException.getMessage());
                        stringBuffer.append(" while processing: ");
                        stringBuffer.append(this.currentFileInfo);
                        stringBuffer.append(" belonging to: ");
                        stringBuffer.append(this.currentTargetInfo);
                        stringBuffer.append(" in InputSource: ");
                        stringBuffer.append(this.inputSource.getSystemId());
                        Log.singleton().logNewMessage(new WarningMessage(stringBuffer.toString()));
                    }
                    Object var5_6 = null;
                    this.currentChangeInfo.setChangeInfoAsReadFromFile(this.changeInfoStringBuffer.toString());
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    this.currentChangeInfo.setChangeInfoAsReadFromFile(this.changeInfoStringBuffer.toString());
                    throw throwable;
                }
            }
            if (string3.equals("ATTACH")) {
                this.enableCharactersForAttachment(false);
                this.currentAttachment.setEncodedBytesAsString(this.attachmentStringBuffer.toString().trim());
                this.currentTargetInfo.addAttachment(this.currentAttachment);
                this.currentAttachment = null;
            } else if (string3.equals("INFOTEXT")) {
                this.parsedTargetListInfo.setInfoText(this.infoTextStringBuffer.toString());
                this.enableCharactersForInfoText(false);
            } else if (string3.equals("UPDATES")) {
                this.parsedTargetListInfo.setUpdatesText(this.updatesStringBuffer.toString());
                this.enableCharactersForUpdates(false);
            } else if (string3.equals("PW_DATA")) {
                this.parsedTargetListInfo.setNumberOfTargets(this.numberOfTargetEntries);
            }
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public List getParsedTargetInfos() {
        return this.parsedTargetInfos;
    }

    public TargetListInfo getParsedTargetListInfo() {
        return this.parsedTargetListInfo;
    }

    protected void handleAttachment(Attributes attributes) {
        this.currentAttachment = new Attachment();
        this.currentAttachment.setLongName(attributes.getValue("LONGNAME"));
        this.currentAttachment.setName(attributes.getValue("NAME"));
        this.currentAttachment.setSizeAsString(attributes.getValue("SIZE"));
        this.currentAttachment.setCRC16(attributes.getValue("CRC16"));
        this.currentAttachment.setInfoText(attributes.getValue("TEXT"));
        this.attachmentStringBuffer = new StringBuffer();
        this.enableCharactersForAttachment(true);
    }

    protected void handleChanges(Attributes attributes) {
        this.currentChangeInfo = new ChangeInfo();
        try {
            this.currentChangeInfo.setCrc(Integer.parseInt(attributes.getValue("PRECRC")));
        }
        catch (NumberFormatException numberFormatException) {
            this.currentChangeInfo.setCrc(-1);
        }
        try {
            this.currentChangeInfo.setCrcCount(Integer.parseInt(attributes.getValue("UCNT")));
        }
        catch (NumberFormatException numberFormatException) {
            this.currentChangeInfo.setCrcCount(-1);
        }
        String string = attributes.getValue("START");
        if (string != null) {
            try {
                this.currentChangeInfo.setStartOfCrc(Integer.parseInt(attributes.getValue("START")));
            }
            catch (NumberFormatException numberFormatException) {
                this.currentChangeInfo.setCrcCount(-1);
            }
        }
        this.changeInfoStringBuffer = new StringBuffer();
        this.enableCharactersForChanges(true);
    }

    protected void handleFileInfo(Attributes attributes) {
        this.currentChangeInfos = new ArrayList();
        this.currentFileInfo = new FileInfo();
        this.currentFileInfo.setCRC16(attributes.getValue("CRC16"));
        this.currentFileInfo.setId(attributes.getValue("ID"));
        this.currentFileInfo.setInfoText(attributes.getValue("TEXT"));
        this.currentFileInfo.setLongName(attributes.getValue("LONGNAME"));
        this.currentFileInfo.setName(attributes.getValue("NAME"));
        this.currentFileInfo.setSize(attributes.getValue("SIZE"));
        this.currentFileInfo.setVersion(attributes.getValue("VER"));
    }

    protected void handleInfoText(Attributes attributes) {
        this.infoTextStringBuffer = new StringBuffer();
        this.enableCharactersForInfoText(true);
    }

    protected void handlePatchInfoList(Attributes attributes) {
        this.numberOfTargetEntries = 0;
        this.parsedTargetListInfo = new TargetListInfo();
        this.parsedTargetListInfo.setCredits(attributes.getValue("CREDITS"));
        this.parsedTargetListInfo.setDate(attributes.getValue("DATE"));
        this.parsedTargetListInfo.setVersion(attributes.getValue("VERSION"));
    }

    protected void handleTargetInfo(Attributes attributes) {
        ++this.numberOfTargetEntries;
        this.currentTargetInfo = new TargetInfo();
        this.currentTargetInfo.setCredits(attributes.getValue("CREDITS"));
        this.currentTargetInfo.setLongName(attributes.getValue("LONGNAME"));
        this.currentTargetInfo.setText(attributes.getValue("TEXT"));
        this.currentTargetInfo.setUrl(attributes.getValue("URL"));
        this.parsedTargetInfos.add((Object)this.currentTargetInfo);
    }

    protected void handleUpdates(Attributes attributes) {
        this.updatesStringBuffer = new StringBuffer();
        this.enableCharactersForUpdates(true);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals("FILE")) {
            this.handleFileInfo(attributes);
        }
        if (string3.equals("ATTACH")) {
            this.handleAttachment(attributes);
        } else if (string3.equals("TARGET")) {
            this.handleTargetInfo(attributes);
        } else if (string3.equals("PW_DATA")) {
            this.handlePatchInfoList(attributes);
        } else if (string3.equals("INFOTEXT")) {
            this.handleInfoText(attributes);
        } else if (string3.equals("UPDATES")) {
            this.handleUpdates(attributes);
        } else if (string3.equals("CHANGE")) {
            this.handleChanges(attributes);
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }
}

