/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.patchengine;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.List;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import pw.palmpatch.io.GenericFile;
import pw.palmpatch.models.ChangeInfo;
import pw.palmpatch.models.FileInfo;
import pw.palmpatch.patchengine.CRC16Support;
import pw.palmpatch.patchengine.FileNotCompatibleException;
import pw.palmpatch.patchengine.PatchEngineException;
import pw.palmpatch.util.Tracing;

public class PatchEngine {
    protected CRC16Support aCRC16Support = new CRC16Support();

    private void applySmartPatch(FileInfo fileInfo, List list) throws IOException, FileNotFoundException, FileNotCompatibleException, SecurityException, PatchEngineException {
        Tracing.singleton().trace("SmartPatch can patch", Tracing.TRACE_MEDIUM_DETAIL);
        FileInfo fileInfo2 = fileInfo.makeCopy();
        fileInfo2.setChanges(list);
        this.patchNormal(fileInfo2);
    }

    public void checkIfNormalPatchingIsPossible(FileInfo fileInfo) throws IOException, FileNotFoundException, PatchEngineException, FileNotCompatibleException {
        RandomAccessFile randomAccessFile = null;
        if (fileInfo.getAssociatedTargetFile() == null) {
            throw new IllegalArgumentException("the FileInfo must have a non null associated target file");
        }
        try {
            randomAccessFile = new RandomAccessFile(fileInfo.getAssociatedTargetFile(), "r");
            List list = fileInfo.getChanges();
            ChangeInfo changeInfo = null;
            int[] nArray = null;
            int n = 0;
            int n2 = 0;
            while (n2 < list.size()) {
                changeInfo = (ChangeInfo)list.get(n2);
                if (changeInfo.hasError()) {
                    throw new PatchEngineException("A ChangeInfo for file " + fileInfo.getAssociatedTargetFile().getAbsolutePath() + " is corrupt. The patch can not be applied.");
                }
                nArray = changeInfo.getOldValues();
                int n3 = 0;
                while (n3 < nArray.length) {
                    randomAccessFile.seek(changeInfo.getOffsetInFile() + (long)n3);
                    n = randomAccessFile.readByte();
                    if (n < 0) {
                        n = n + 255 + 1;
                    }
                    if (nArray[n3] != n) {
                        throw new FileNotCompatibleException(nArray[n3], n, changeInfo.getOffsetInFile(), fileInfo.getAssociatedTargetFile());
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        finally {
            Object var4_9 = null;
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
    }

    public List checkIfSmartPatchIsPossible(FileInfo fileInfo) throws IOException, FileNotFoundException, FileNotCompatibleException, PatchEngineException {
        if (!this.doesFileInfoContainEnoughInformationForSmartPatchToWork(fileInfo)) {
            throw new PatchEngineException("Not enough information available to apply SmartPatch feature!");
        }
        BufferedInputStream bufferedInputStream = null;
        ArrayList arrayList = new ArrayList();
        List list = fileInfo.getChanges();
        ChangeInfo changeInfo = null;
        boolean bl = true;
        String string = null;
        int n = 0;
        while (n < list.size()) {
            block27: {
                int n2;
                int n3;
                ArrayList arrayList2;
                block26: {
                    changeInfo = (ChangeInfo)list.get(n);
                    Tracing.singleton().trace("SmartPatch working on: " + changeInfo, Tracing.TRACE_MEDIUM_DETAIL);
                    arrayList2 = new ArrayList();
                    try {
                        bufferedInputStream = new BufferedInputStream(new FileInputStream(fileInfo.getAssociatedTargetFile()));
                        n3 = bufferedInputStream.read();
                        n2 = changeInfo.getOldValues()[0];
                        long l = 0L;
                        long l2 = 0L;
                        while (n3 != -1) {
                            if (n3 == n2) {
                                boolean bl2 = true;
                                int n4 = 0;
                                n4 = 1;
                                while (n4 < changeInfo.getOldValues().length) {
                                    n3 = bufferedInputStream.read();
                                    ++l2;
                                    if (n3 != changeInfo.getOldValues()[n4]) {
                                        bl2 = false;
                                        break;
                                    }
                                    ++n4;
                                }
                                if (!bl2) continue;
                                l = l2 - (long)n4 + 1L;
                                arrayList2.add((Object)new Long(l));
                                n3 = bufferedInputStream.read();
                                ++l2;
                                Tracing.singleton().trace("SmartPatch found complete match for: " + changeInfo + " at: " + Long.toHexString(l), Tracing.TRACE_MEDIUM_DETAIL);
                                continue;
                            }
                            n3 = bufferedInputStream.read();
                            ++l2;
                        }
                    }
                    finally {
                        Object var11_13 = null;
                        bufferedInputStream.close();
                    }
                    if (arrayList2.size() == 0) {
                        Tracing.singleton().trace("SmartPatch cannot patch", Tracing.TRACE_MEDIUM_DETAIL);
                        throw new PatchEngineException("Unable to apply smart patch because matching byte sequence for ChangeInfo " + changeInfo + " was not found");
                    }
                    if (arrayList2.size() != 1) break block26;
                    ChangeInfo changeInfo2 = new ChangeInfo();
                    changeInfo2.setOffsetInFile((Long)arrayList2.get(0));
                    changeInfo2.setOldValues(changeInfo.getOldValues());
                    changeInfo2.setNewValues(changeInfo.getNewValues());
                    arrayList.add((Object)changeInfo2);
                    Tracing.singleton().trace("SmartPatch found unique byte sequence: " + changeInfo2 + "at: " + Long.toHexString((Long)arrayList2.get(0)), Tracing.TRACE_MEDIUM_DETAIL);
                    break block27;
                }
                if (arrayList2.size() > 1) {
                    Object var20_26;
                    RandomAccessFile randomAccessFile;
                    block25: {
                        long l = -1L;
                        n3 = -1;
                        n2 = -1;
                        int n5 = -1;
                        int n6 = 0;
                        byte[] byArray = null;
                        int n7 = -1;
                        randomAccessFile = null;
                        if (changeInfo.getCrcCount() < 0 || changeInfo.getCrc() < 0) {
                            throw new PatchEngineException("Not enough information available to apply SmartPatch feature! The sequence to patch is not unique and not enough additional info is included in the FileInfo: " + fileInfo);
                        }
                        try {
                            randomAccessFile = new RandomAccessFile(fileInfo.getAssociatedTargetFile(), "rw");
                            n2 = changeInfo.getCrcCount();
                            n6 = changeInfo.getStartOfCrc();
                            n3 = changeInfo.getCrc();
                            int n8 = 0;
                            while (n8 < arrayList2.size()) {
                                l = (Long)arrayList2.get(n8);
                                if (n6 == 0) {
                                    n6 = -n2;
                                }
                                if (n6 < 0 && l < (long)(n2 - 1)) {
                                    Tracing.singleton().trace("SmartPatch skipping CRC check of sequence at: " + Long.toHexString(l) + " because offset is too small for CRC count.", Tracing.TRACE_MEDIUM_DETAIL);
                                } else if (n6 > 0 && (long)n2 > randomAccessFile.length() - l - 1L) {
                                    Tracing.singleton().trace("SmartPatch skipping CRC check of sequence at: " + Long.toHexString(l) + " because offset is too big for CRC count.", Tracing.TRACE_MEDIUM_DETAIL);
                                } else {
                                    randomAccessFile.seek(l + (long)n6);
                                    Tracing.singleton().trace("SmartPatch checking CRC of sequence at offset: " + Long.toHexString(l) + ". Start of CRC check is at: " + l + n6, Tracing.TRACE_MEDIUM_DETAIL);
                                    byArray = new byte[n2];
                                    int n9 = 0;
                                    while (n9 < n2) {
                                        byArray[n9] = (byte)randomAccessFile.read();
                                        ++n9;
                                    }
                                    n5 = this.aCRC16Support.calculateCRC16For(byArray);
                                    Tracing.singleton().trace("SmartPatch comparing currentCrc to expectedCrc: " + n5 + ":" + n3, Tracing.TRACE_MEDIUM_DETAIL);
                                    if (n5 == n3) {
                                        Tracing.singleton().trace("SmartPatch found matching CRC: " + n5 + ":" + n3, Tracing.TRACE_MEDIUM_DETAIL);
                                        ++n7;
                                        ChangeInfo changeInfo3 = null;
                                        changeInfo3 = new ChangeInfo();
                                        changeInfo3.setOffsetInFile(l);
                                        changeInfo3.setOldValues(changeInfo.getOldValues());
                                        changeInfo3.setNewValues(changeInfo.getNewValues());
                                        arrayList.add((Object)changeInfo3);
                                    }
                                }
                                ++n8;
                            }
                            if (n7 == -1) {
                                string = "SmartPatch found no matching byte sequence for: " + changeInfo;
                                Tracing.singleton().trace(string, Tracing.TRACE_MEDIUM_DETAIL);
                                bl = false;
                            }
                            if (n7 <= 1) break block25;
                            string = "SmartPatch found more than one matching byte sequence for: " + changeInfo + ": " + n7;
                            Tracing.singleton().trace(string, Tracing.TRACE_MEDIUM_DETAIL);
                            bl = false;
                        }
                        catch (Throwable throwable) {
                            var20_26 = null;
                            randomAccessFile.close();
                            throw throwable;
                        }
                    }
                    var20_26 = null;
                    randomAccessFile.close();
                }
            }
            ++n;
        }
        if (!bl) {
            Tracing.singleton().trace("SmartPatch cannot patch", Tracing.TRACE_MEDIUM_DETAIL);
            throw new PatchEngineException("Unable to apply SmartPatch because of ambigous informations" + System.getProperty("line.separator") + string);
        }
        return arrayList;
    }

    protected boolean doesFileInfoContainEnoughInformationForSmartPatchToWork(FileInfo fileInfo) {
        if (fileInfo == null) {
            throw new IllegalArgumentException("aFileInfo must not be null");
        }
        List list = fileInfo.getChanges();
        ChangeInfo changeInfo = null;
        int n = 0;
        while (n < list.size()) {
            changeInfo = (ChangeInfo)list.get(n);
            if (changeInfo.getCrcCount() <= 0 && changeInfo.getCrc() > 0 || changeInfo.getCrcCount() > 0 && changeInfo.getCrc() <= 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void patchNormal(FileInfo fileInfo) throws IOException, FileNotFoundException, FileNotCompatibleException, SecurityException, PatchEngineException {
        if (fileInfo.getAssociatedTargetFile() == null) {
            throw new IllegalArgumentException("the FileInfo must have a non null associated target file");
        }
        RandomAccessFile randomAccessFile = null;
        try {
            this.checkIfNormalPatchingIsPossible(fileInfo);
            GenericFile genericFile = new GenericFile(fileInfo.getAssociatedTargetFile());
            String[] stringArray = GenericFile.chopOffFileExtension(fileInfo.getAssociatedTargetFile().getAbsolutePath());
            String string = String.valueOf(stringArray[0]) + ".patched." + stringArray[1];
            File file = new File(string);
            if (file.exists()) {
                file.delete();
            }
            genericFile.copy(new File(string));
            randomAccessFile = new RandomAccessFile(string, "rw");
            List list = fileInfo.getChanges();
            ChangeInfo changeInfo = null;
            int[] nArray = null;
            int n = 0;
            while (n < list.size()) {
                changeInfo = (ChangeInfo)list.get(n);
                nArray = changeInfo.getNewValues();
                int n2 = 0;
                while (n2 < nArray.length) {
                    randomAccessFile.seek(changeInfo.getOffsetInFile() + (long)n2);
                    randomAccessFile.writeByte(nArray[n2]);
                    ++n2;
                }
                ++n;
            }
        }
        finally {
            Object var4_12 = null;
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
    }

    public void smartPatch(FileInfo fileInfo) throws IOException, FileNotFoundException, FileNotCompatibleException, SecurityException, PatchEngineException {
        List list = this.checkIfSmartPatchIsPossible(fileInfo);
        this.applySmartPatch(fileInfo, list);
    }

    public void smartPatch(FileInfo fileInfo, List list) throws IOException, FileNotFoundException, FileNotCompatibleException, SecurityException, PatchEngineException {
        this.applySmartPatch(fileInfo, list);
    }
}

