/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.ui.views;

import edu.stanford.cs.ejalbert.BrowserLauncher;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import pw.palmpatch.Application;
import pw.palmpatch.ApplicationInfo;
import pw.palmpatch.ui.views.View;
import pw.palmpatch.util.ImageCache;

public class AboutView
extends View {
    private ApplicationInfo myApplicationInfo;
    private JLabel versionLabel;
    private JLabel nameLabel;
    private JLabel dateLabel;
    private JLabel iconLabel;
    private JLabel feedbackLabel;
    private JEditorPane htmlPane;
    static /* synthetic */ Class class$pw$palmpatch$util$ResourceAnchor;

    public AboutView(ApplicationInfo applicationInfo) {
        if (applicationInfo == null) {
            throw new IllegalArgumentException("anApplicationInfo must not be null");
        }
        this.myApplicationInfo = applicationInfo;
        this.initialize();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        gridBagConstraints.anchor = 17;
        String string = this.myApplicationInfo.getIconName();
        this.iconLabel = string != null ? new JLabel(ImageCache.singleton().getIcon(this.myApplicationInfo.getIconName())) : new JLabel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagLayout.setConstraints(this.iconLabel, gridBagConstraints);
        this.add(this.iconLabel);
        this.nameLabel = new JLabel(this.myApplicationInfo.getName());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.nameLabel, gridBagConstraints);
        this.add(this.nameLabel);
        this.versionLabel = new JLabel("version " + this.myApplicationInfo.getVersionNumber());
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.versionLabel, gridBagConstraints);
        this.add(this.versionLabel);
        String string2 = Application.singleton().getApplicationDateFormat().format(this.myApplicationInfo.getDate().getTime());
        this.dateLabel = new JLabel(string2);
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.dateLabel, gridBagConstraints);
        this.add(this.dateLabel);
        this.feedbackLabel = new JLabel("http://www.pilotwarez.com/pwcpp/feedback/feedback.html");
        this.feedbackLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                block2: {
                    if (AboutView.this.feedbackLabel.getText() == null || AboutView.this.feedbackLabel.getText().trim().equals("")) break block2;
                    try {
                        BrowserLauncher.openURL(AboutView.this.feedbackLabel.getText().trim());
                    }
                    catch (IOException iOException) {}
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                if (AboutView.this.feedbackLabel.getText() != null && !AboutView.this.feedbackLabel.getText().trim().equals("")) {
                    AboutView.this.feedbackLabel.setCursor(Cursor.getPredefinedCursor(12));
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (AboutView.this.feedbackLabel.getText() != null && !AboutView.this.feedbackLabel.getText().trim().equals("")) {
                    AboutView.this.feedbackLabel.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.feedbackLabel, gridBagConstraints);
        this.add(this.feedbackLabel);
        this.htmlPane = new JEditorPane();
        this.htmlPane.setEditable(false);
        try {
            this.htmlPane.setPage((class$pw$palmpatch$util$ResourceAnchor != null ? class$pw$palmpatch$util$ResourceAnchor : (class$pw$palmpatch$util$ResourceAnchor = AboutView.class$("pw.palmpatch.util.ResourceAnchor"))).getResource("docs/releaseInfo.htm"));
        }
        catch (IOException iOException) {
            this.htmlPane.setText(iOException.toString());
        }
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.htmlPane);
        jScrollPane.setPreferredSize(new Dimension(400, 200));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.add(jScrollPane);
    }
}

