/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.ui.views;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import pw.palmpatch.models.Attachment;
import pw.palmpatch.ui.views.View;
import pw.palmpatch.ui.widgets.ReadOnlySupportedTextField;

public class AttachmentEditorView
extends View {
    JLabel longNameLabel;
    JLabel nameLabel;
    JLabel sizeLabel;
    JLabel crc16Label;
    JLabel infoTextLabel;
    JTextField longNameTextField;
    JTextField nameTextField;
    JTextField sizeTextField;
    JTextField crc16TextField;
    JTextArea infoTextArea;

    public AttachmentEditorView() {
        this.initialize();
    }

    public void fillAttachment(Attachment attachment) {
        attachment.setLongName(this.longNameTextField.getText());
        attachment.setName(this.nameTextField.getText());
        attachment.setSizeAsString(this.sizeTextField.getText());
        attachment.setCRC16(this.crc16TextField.getText());
        attachment.setInfoText(this.infoTextArea.getText());
    }

    public void initialize() {
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, 300));
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Target Infos");
        titledBorder.setTitleFont(new Font("Dialog", 0, 10));
        this.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(0, 3, 3, 3)));
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        gridBagConstraints.anchor = 11;
        this.longNameLabel = new JLabel("Longname:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.longNameLabel, gridBagConstraints);
        this.add(this.longNameLabel);
        this.longNameTextField = new JTextField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.longNameTextField, gridBagConstraints);
        this.add(this.longNameTextField);
        this.nameLabel = new JLabel("Name:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.nameLabel, gridBagConstraints);
        this.add(this.nameLabel);
        this.nameTextField = new ReadOnlySupportedTextField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.nameTextField, gridBagConstraints);
        this.add(this.nameTextField);
        this.sizeLabel = new JLabel("Size:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.sizeLabel, gridBagConstraints);
        this.add(this.sizeLabel);
        this.sizeTextField = new ReadOnlySupportedTextField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.sizeTextField, gridBagConstraints);
        this.add(this.sizeTextField);
        this.crc16Label = new JLabel("CRC16:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.crc16Label, gridBagConstraints);
        this.add(this.crc16Label);
        this.crc16TextField = new ReadOnlySupportedTextField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.crc16TextField, gridBagConstraints);
        this.add(this.crc16TextField);
        this.infoTextLabel = new JLabel("Info:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.infoTextLabel, gridBagConstraints);
        this.add(this.infoTextLabel);
        this.infoTextArea = new JTextArea(3, 10);
        this.infoTextArea.setLineWrap(true);
        this.infoTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(this.infoTextArea);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setBorder((Border)UIManager.get("TextField.border"));
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.add(jScrollPane);
    }

    public void setAttachment(Attachment attachment) {
        this.updateInformation(attachment);
        this.longNameTextField.select(0, 0);
        this.nameTextField.select(0, 0);
        this.sizeTextField.select(0, 0);
        this.crc16TextField.select(0, 0);
        this.longNameTextField.requestFocus();
    }

    public void updateInformation(Attachment attachment) {
        this.longNameTextField.setText(attachment.getLongName());
        this.nameTextField.setText(attachment.getName());
        this.sizeTextField.setText(attachment.getSizeAsString());
        this.crc16TextField.setText(attachment.getCRC16());
        this.infoTextArea.setText(attachment.getInfoText());
    }
}

