/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.ui.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import pw.palmpatch.Preferences;
import pw.palmpatch.controller.PWAction;
import pw.palmpatch.ui.views.ExportImportView;
import pw.palmpatch.ui.views.PWDialog;
import pw.palmpatch.ui.views.PWFileChooser;
import pw.palmpatch.ui.widgets.PWButton;
import pw.palmpatch.util.ErrorMessage;
import pw.palmpatch.util.Log;

public class ExportDialog
extends PWDialog {
    protected ExportImportView myExportView;
    protected PWButton copyToClipboardButton;
    protected PWButton copyToClipboardForUBBButton;
    protected PWButton saveAsFileButton;
    protected PWButton cancelButton;
    protected PWAction copyToClipboardAction;
    protected PWAction copyToClipboardForUBBAction;
    protected PWAction saveAsFileAction;
    protected PWAction unindentAction;
    protected PWAction cancelAction;
    protected Preferences preferences;
    protected PWFileChooser fileChooser;

    public ExportDialog(Frame frame, ExportImportView exportImportView, Preferences preferences) {
        super(frame);
        this.myExportView = exportImportView;
        this.preferences = preferences;
        this.initialize();
    }

    public void initialize() {
        this.cancelAction = new CancelAction();
        this.copyToClipboardButton = new PWButton();
        this.copyToClipboardForUBBButton = new PWButton();
        this.saveAsFileButton = new PWButton();
        this.cancelButton = new PWButton();
        this.cancelButton.setMnemonic('C');
        this.copyToClipboardAction = new CopyTargetInfosToClipboardAction();
        this.copyToClipboardForUBBAction = new CopyTargetInfosToClipboardForUBBAction();
        this.saveAsFileAction = new SaveTargetInfosAsFileAction();
        this.copyToClipboardButton.addActionListener(this.copyToClipboardAction);
        this.copyToClipboardButton.setMnemonic('p');
        this.copyToClipboardForUBBButton.addActionListener(this.copyToClipboardForUBBAction);
        this.copyToClipboardForUBBButton.setMnemonic('y');
        this.saveAsFileButton.addActionListener(this.saveAsFileAction);
        this.saveAsFileButton.setMnemonic('S');
        this.cancelButton.addActionListener(this.cancelAction);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.myExportView, "Center");
        JPanel jPanel = new JPanel();
        jPanel.add(this.copyToClipboardButton);
        jPanel.add(this.copyToClipboardForUBBButton);
        jPanel.add(this.saveAsFileButton);
        jPanel.add(this.cancelButton);
        this.getContentPane().add((Component)jPanel, "South");
        this.setTitle("Export");
        this.pack();
        this.addWindowListener(new WindowAdapter(){
            boolean gotFocus = false;

            public void windowActivated(WindowEvent windowEvent) {
                if (this.gotFocus) {
                    ExportDialog.this.copyToClipboardButton.requestFocus();
                    this.gotFocus = true;
                }
            }

            public void windowOpened(WindowEvent windowEvent) {
                ExportDialog.this.copyToClipboardButton.requestFocus();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    ExportDialog.this.cancelAction.invokeFromCode();
                }
            }
        });
    }

    protected void performCopyToClipboardAction() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(this.myExportView.getText());
        clipboard.setContents(stringSelection, null);
    }

    protected void performCopyToClipboardForUBBAction() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.myExportView.getText(), "&", false);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
            stringBuffer.append("&amp;");
        }
        String string = stringBuffer.toString();
        string = string.substring(0, string.length() - 5);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(string.toString());
        clipboard.setContents(stringSelection, null);
    }

    protected void performSaveAsFileAction() {
        block15: {
            block13: {
                block14: {
                    File file;
                    if (this.fileChooser == null) {
                        this.fileChooser = PWFileChooser.createFileChooserForTargetLists();
                    }
                    this.fileChooser.setPreferredSize(new Dimension(this.fileChooser.getPreferredSize().width, 350));
                    this.fileChooser.setFileSelectionMode(0);
                    this.fileChooser.setDialogTitle("Export to file");
                    String string = this.preferences.getString("lastDirectoryOpenedToExportTargetInfos");
                    if (string == null || string != null && string.equals("")) {
                        string = System.getProperty("user.dir");
                    }
                    if ((file = new File(string)).exists()) {
                        this.fileChooser.setCurrentDirectory(file);
                    }
                    this.fileChooser.rescanCurrentDirectory();
                    this.fileChooser.setSelectedFile(null);
                    int n = this.fileChooser.showSaveDialog(null);
                    if (n != 0) break block13;
                    File file2 = this.fileChooser.getSelectedFile();
                    if (file2 == null) break block14;
                    if (file2.exists()) {
                        int n2 = JOptionPane.showConfirmDialog(null, "The filename you have chosen allready exists. Do you want to continue?", "Question", 0);
                        if (n2 == 1) {
                            return;
                        }
                        String string2 = file2.getParent();
                        if (string2 != null) {
                            this.preferences.setValue("lastDirectoryOpenedToExportTargetInfos", string2);
                        }
                    }
                    BufferedWriter bufferedWriter = null;
                    try {
                        try {
                            String string3 = this.myExportView.getText();
                            bufferedWriter = new BufferedWriter(new FileWriter(file2));
                            bufferedWriter.write(string3);
                        }
                        catch (IOException iOException) {
                            Log.singleton().logNewMessage(new ErrorMessage("There was an error saving the file " + file2.getAbsolutePath() + ". Details: " + iOException));
                        }
                        Object var7_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        try {
                            bufferedWriter.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {}
                    break block15;
                }
                return;
            }
            return;
        }
    }

    protected void performUnindentAction() {
        String string = this.myExportView.getText();
        if (string == null) {
            return;
        }
    }

    private class CopyTargetInfosToClipboardAction
    extends PWAction {
        CopyTargetInfosToClipboardAction() {
            this.putValue("Name", "Copy");
            this.putValue("ShortDescription", "Copy");
            this.putValue("LongDescription", "Copy to clipboard");
        }

        public void perform(ActionEvent actionEvent) {
            ExportDialog.this.performCopyToClipboardAction();
        }
    }

    private class CopyTargetInfosToClipboardForUBBAction
    extends PWAction {
        CopyTargetInfosToClipboardForUBBAction() {
            this.putValue("Name", "Copy for UBB");
            this.putValue("ShortDescription", "Copy for UBB");
            this.putValue("LongDescription", "Copy to clipboard so that you can post to UBB");
        }

        public void perform(ActionEvent actionEvent) {
            ExportDialog.this.performCopyToClipboardForUBBAction();
        }
    }

    private class SaveTargetInfosAsFileAction
    extends PWAction {
        SaveTargetInfosAsFileAction() {
            this.putValue("Name", "Save");
            this.putValue("ShortDescription", "Save");
            this.putValue("LongDescription", "Save exported Target Infos to file");
        }

        public void perform(ActionEvent actionEvent) {
            ExportDialog.this.performSaveAsFileAction();
        }
    }

    private class UnindentAction
    extends PWAction {
        UnindentAction() {
            this.putValue("Name", "Unindent");
            this.putValue("ShortDescription", "Unindent");
            this.putValue("LongDescription", "Remove the indention");
        }

        public void perform(ActionEvent actionEvent) {
            ExportDialog.this.performUnindentAction();
        }
    }

    private class CancelAction
    extends PWAction {
        CancelAction() {
            this.putValue("Name", "Cancel");
            this.putValue("ShortDescription", "Cancel");
            this.putValue("LongDescription", "Close the export dialog");
        }

        public void perform(ActionEvent actionEvent) {
            ExportDialog.this.dispose();
        }
    }
}

