/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.ui.views;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import pw.palmpatch.exceptions.InvalidChangeInfoFormatException;
import pw.palmpatch.models.ChangeInfo;
import pw.palmpatch.models.FileInfo;
import pw.palmpatch.ui.views.View;
import pw.palmpatch.ui.widgets.ReadOnlySupportedTextField;
import pw.palmpatch.util.ErrorMessage;
import pw.palmpatch.util.Log;

public class FileInfoEditorView
extends View {
    protected JLabel idLabel;
    protected JLabel fileNameLabel;
    protected JLabel longNameLabel;
    protected JLabel sizeLabel;
    protected JLabel versionLabel;
    protected JLabel crc16Label;
    protected JLabel infoLabel;
    protected JLabel changesLabel;
    protected JTextField idTextField;
    protected JTextField fileNameTextField;
    protected JTextField longNameTextField;
    protected JTextField sizeTextField;
    protected JTextField versionTextField;
    protected JTextField crc16TextField;
    protected JTextArea infoTextArea;
    protected JTextArea changesTextArea;

    public FileInfoEditorView() {
        this.initialize();
    }

    public void fillFileInfo(FileInfo fileInfo) {
        fileInfo.setId(this.idTextField.getText());
        fileInfo.setName(this.fileNameTextField.getText());
        fileInfo.setLongName(this.longNameTextField.getText());
        fileInfo.setSize(this.sizeTextField.getText());
        fileInfo.setVersion(this.versionTextField.getText());
        fileInfo.setCRC16(this.crc16TextField.getText());
        fileInfo.setInfoText(this.infoTextArea.getText());
        StringTokenizer stringTokenizer = new StringTokenizer(this.changesTextArea.getText().trim(), "\n");
        ArrayList arrayList = new ArrayList();
        while (stringTokenizer.hasMoreTokens()) {
            try {
                ChangeInfo changeInfo = ChangeInfo.parseComplete(stringTokenizer.nextToken());
                arrayList.add((Object)changeInfo);
            }
            catch (InvalidChangeInfoFormatException invalidChangeInfoFormatException) {
                Log.singleton().logNewMessage(new ErrorMessage("A ChangeInfo was entered incorrect: " + invalidChangeInfoFormatException.getMessage()));
            }
        }
        fileInfo.setChanges((List)arrayList);
    }

    public void initialize() {
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, 260));
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Edit File Info");
        titledBorder.setTitleFont(new Font("Dialog", 0, 10));
        this.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(0, 3, 3, 3)));
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        gridBagConstraints.anchor = 11;
        this.idLabel = new JLabel("ID:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.idLabel, gridBagConstraints);
        this.add(this.idLabel);
        this.idTextField = new JTextField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.idTextField, gridBagConstraints);
        this.add(this.idTextField);
        this.fileNameLabel = new JLabel("Filename:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.fileNameLabel, gridBagConstraints);
        this.add(this.fileNameLabel);
        this.fileNameTextField = new ReadOnlySupportedTextField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.fileNameTextField, gridBagConstraints);
        this.add(this.fileNameTextField);
        this.longNameLabel = new JLabel("Longname:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.longNameLabel, gridBagConstraints);
        this.add(this.longNameLabel);
        this.longNameTextField = new JTextField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.longNameTextField, gridBagConstraints);
        this.add(this.longNameTextField);
        this.sizeLabel = new JLabel("Size:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.sizeLabel, gridBagConstraints);
        this.add(this.sizeLabel);
        this.sizeTextField = new ReadOnlySupportedTextField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.sizeTextField, gridBagConstraints);
        this.add(this.sizeTextField);
        this.versionLabel = new JLabel("Version:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.versionLabel, gridBagConstraints);
        this.add(this.versionLabel);
        this.versionTextField = new JTextField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.versionTextField, gridBagConstraints);
        this.add(this.versionTextField);
        this.crc16Label = new JLabel("CRC16:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.crc16Label, gridBagConstraints);
        this.add(this.crc16Label);
        this.crc16TextField = new ReadOnlySupportedTextField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.crc16TextField, gridBagConstraints);
        this.add(this.crc16TextField);
        this.infoLabel = new JLabel("Info:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.infoLabel, gridBagConstraints);
        this.add(this.infoLabel);
        this.infoTextArea = new JTextArea(3, 10);
        this.infoTextArea.setLineWrap(true);
        this.infoTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(this.infoTextArea);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setBorder((Border)UIManager.get("TextField.border"));
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.add(jScrollPane);
        this.changesLabel = new JLabel("Changes:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.changesLabel, gridBagConstraints);
        this.add(this.changesLabel);
        this.changesTextArea = new JTextArea(3, 10);
        this.changesTextArea.setLineWrap(true);
        this.changesTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane2 = new JScrollPane(this.changesTextArea);
        jScrollPane2.setHorizontalScrollBarPolicy(30);
        jScrollPane2.setVerticalScrollBarPolicy(20);
        jScrollPane2.setBorder((Border)UIManager.get("TextField.border"));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jScrollPane2, gridBagConstraints);
        this.add(jScrollPane2);
    }

    public void setFileInfo(FileInfo fileInfo) {
        this.updateInformation(fileInfo);
        this.idTextField.select(0, 0);
        this.fileNameTextField.select(0, 0);
        this.longNameTextField.select(0, 0);
        this.sizeTextField.select(0, 0);
        this.versionTextField.select(0, 0);
        this.crc16TextField.select(0, 0);
        this.updateChanges(fileInfo);
        this.idTextField.requestFocus();
    }

    public void setFocusToInfo() {
        this.infoTextArea.requestFocus();
    }

    public void updateChanges(FileInfo fileInfo) {
        ChangeInfo changeInfo = null;
        List list = fileInfo.getChanges();
        if (list != null) {
            Iterator iterator = fileInfo.getChanges().iterator();
            StringBuffer stringBuffer = new StringBuffer();
            while (iterator.hasNext()) {
                changeInfo = (ChangeInfo)iterator.next();
                stringBuffer.append(changeInfo.toString());
                stringBuffer.append("\n");
            }
            this.changesTextArea.setText(stringBuffer.toString());
        } else {
            this.changesTextArea.setText("");
        }
    }

    public void updateInformation(FileInfo fileInfo) {
        this.idTextField.setText(fileInfo.getId());
        this.fileNameTextField.setText(fileInfo.getName());
        this.longNameTextField.setText(fileInfo.getLongName());
        this.sizeTextField.setText(fileInfo.getSize());
        this.versionTextField.setText(fileInfo.getVersion());
        this.crc16TextField.setText(fileInfo.getCRC16());
        this.infoTextArea.setText(fileInfo.getInfoText());
    }
}

