/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.ui.views;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pw.palmpatch.Preferences;
import pw.palmpatch.controller.PWAction;
import pw.palmpatch.controller.TargetViewAndEditController;
import pw.palmpatch.ui.views.ExportImportView;
import pw.palmpatch.ui.views.PWDialog;
import pw.palmpatch.ui.views.PWFileChooser;
import pw.palmpatch.ui.widgets.PWButton;
import pw.palmpatch.util.ErrorMessage;
import pw.palmpatch.util.ImageCache;
import pw.palmpatch.util.Log;

public class ImportDialog
extends PWDialog {
    protected ExportImportView myImportView;
    protected PWButton pasteFromClipboardButton;
    protected PWButton loadFromFileButton;
    protected PWButton importButton;
    protected PWButton cancelButton;
    protected PWAction pasteFromClipboardAction;
    protected PWAction loadFromFileAction;
    protected PWAction cancelAction;
    protected PWAction importAction;
    protected Preferences preferences;
    protected PWFileChooser fileChooser;
    protected JCheckBox sortOnImportCheckBox;
    protected JCheckBox checkForDuplicatesCheckBox;
    protected JRadioButton sortByNameAscending;
    protected JRadioButton sortByNameDescending;
    protected JRadioButton sortByCreditsAscending;
    protected JRadioButton sortByCreditsDescending;
    protected TargetViewAndEditController theTargetViewAndEditController;

    public ImportDialog(Frame frame, ExportImportView exportImportView, Preferences preferences, TargetViewAndEditController targetViewAndEditController) {
        super(frame);
        this.myImportView = exportImportView;
        this.theTargetViewAndEditController = targetViewAndEditController;
        this.preferences = preferences;
        this.initialize();
    }

    protected void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 1, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 5;
        gridBagLayout.setConstraints(this.myImportView, gridBagConstraints);
        this.getContentPane().add(this.myImportView);
        this.sortOnImportCheckBox = new JCheckBox("Sort on import");
        ButtonGroup buttonGroup = new ButtonGroup();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.sortOnImportCheckBox, gridBagConstraints);
        this.getContentPane().add(this.sortOnImportCheckBox);
        this.sortByNameAscending = new JRadioButton("By name asc.");
        buttonGroup.add(this.sortByNameAscending);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.sortByNameAscending, gridBagConstraints);
        this.getContentPane().add(this.sortByNameAscending);
        this.sortByNameDescending = new JRadioButton("By name desc.");
        buttonGroup.add(this.sortByNameDescending);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.sortByNameDescending, gridBagConstraints);
        this.getContentPane().add(this.sortByNameDescending);
        this.sortByCreditsAscending = new JRadioButton("By credits asc.");
        buttonGroup.add(this.sortByCreditsAscending);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.sortByCreditsAscending, gridBagConstraints);
        this.getContentPane().add(this.sortByCreditsAscending);
        this.sortByCreditsDescending = new JRadioButton("By credits desc.");
        buttonGroup.add(this.sortByCreditsDescending);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.sortByCreditsDescending, gridBagConstraints);
        this.getContentPane().add(this.sortByCreditsDescending);
        this.pasteFromClipboardButton = new PWButton();
        this.pasteFromClipboardButton.setMnemonic('P');
        this.pasteFromClipboardAction = new PasteTargetInfosFromClipboardAction();
        this.pasteFromClipboardButton.addActionListener(this.pasteFromClipboardAction);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.pasteFromClipboardButton, gridBagConstraints);
        this.getContentPane().add(this.pasteFromClipboardButton);
        this.loadFromFileButton = new PWButton();
        this.loadFromFileButton.setMnemonic('L');
        this.loadFromFileAction = new LoadTargetInfosFromFileAction();
        this.loadFromFileButton.addActionListener(this.loadFromFileAction);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.loadFromFileButton, gridBagConstraints);
        this.getContentPane().add(this.loadFromFileButton);
        this.importButton = new PWButton();
        this.importButton.setMnemonic('I');
        this.importAction = new ImportAction();
        this.importButton.addActionListener(this.importAction);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.importButton, gridBagConstraints);
        this.getContentPane().add(this.importButton);
        this.cancelButton = new PWButton();
        this.cancelButton.setMnemonic('C');
        this.cancelAction = new CancelAction();
        this.cancelButton.addActionListener(this.cancelAction);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        this.getContentPane().add(this.cancelButton);
        this.checkForDuplicatesCheckBox = new JCheckBox("Check For Duplicates");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.checkForDuplicatesCheckBox, gridBagConstraints);
        this.getContentPane().add(this.checkForDuplicatesCheckBox);
        this.checkForDuplicatesCheckBox.setSelected(this.preferences.getBool("checkForDuplicates"));
        this.sortOnImportCheckBox.setSelected(this.preferences.getBool("sortOnImport"));
        if (this.sortOnImportCheckBox.isSelected()) {
            this.sortByNameAscending.setEnabled(true);
            this.sortByNameDescending.setEnabled(true);
            this.sortByCreditsAscending.setEnabled(true);
            this.sortByCreditsDescending.setEnabled(true);
        } else {
            this.sortByNameAscending.setEnabled(false);
            this.sortByNameDescending.setEnabled(false);
            this.sortByCreditsAscending.setEnabled(false);
            this.sortByCreditsDescending.setEnabled(false);
        }
        this.sortOnImportCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (ImportDialog.this.sortOnImportCheckBox.isSelected()) {
                    ImportDialog.this.sortByNameAscending.setEnabled(true);
                    ImportDialog.this.sortByNameDescending.setEnabled(true);
                    ImportDialog.this.sortByCreditsAscending.setEnabled(true);
                    ImportDialog.this.sortByCreditsDescending.setEnabled(true);
                } else {
                    ImportDialog.this.sortByNameAscending.setEnabled(false);
                    ImportDialog.this.sortByNameDescending.setEnabled(false);
                    ImportDialog.this.sortByCreditsAscending.setEnabled(false);
                    ImportDialog.this.sortByCreditsDescending.setEnabled(false);
                }
            }
        });
        String string = this.preferences.getString("sortOnImportMethod");
        if ("sortByNameAscending".equals(string)) {
            this.sortByNameAscending.setSelected(true);
        } else if ("sortByNameDescending".equals(string)) {
            this.sortByNameDescending.setSelected(true);
        } else if ("sortByCreditsAscending".equals(string)) {
            this.sortByCreditsAscending.setSelected(true);
        } else if ("sortByCreditsDescending".equals(string)) {
            this.sortByCreditsDescending.setSelected(true);
        }
        this.setTitle("Import");
        this.setModal(true);
        this.pack();
        this.addWindowListener(new WindowAdapter(){
            boolean gotFocus = false;

            public void windowActivated(WindowEvent windowEvent) {
                if (this.gotFocus) {
                    ImportDialog.this.pasteFromClipboardButton.requestFocus();
                    this.gotFocus = true;
                }
            }

            public void windowOpened(WindowEvent windowEvent) {
                ImportDialog.this.pasteFromClipboardButton.requestFocus();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    ImportDialog.this.cancelAction.invokeFromCode();
                }
            }
        });
    }

    protected void performImportFromFileAction() {
        block14: {
            block12: {
                block13: {
                    File file;
                    if (this.fileChooser == null) {
                        this.fileChooser = PWFileChooser.createFileChooserForTargetLists();
                    }
                    this.fileChooser.setPreferredSize(new Dimension(this.fileChooser.getPreferredSize().width, 350));
                    this.fileChooser.setFileSelectionMode(0);
                    this.fileChooser.setDialogTitle("Import from file");
                    String string = this.preferences.getString("lastDirectoryOpenedToImportTargetInfos");
                    if (string == null || string != null && string.equals("")) {
                        string = System.getProperty("user.dir");
                    }
                    if ((file = new File(string)).exists()) {
                        this.fileChooser.setCurrentDirectory(file);
                    }
                    this.fileChooser.rescanCurrentDirectory();
                    this.fileChooser.setSelectedFile(null);
                    int n = this.fileChooser.showOpenDialog(null);
                    if (n != 0) break block12;
                    File file2 = this.fileChooser.getSelectedFile();
                    if (file2 == null) break block13;
                    String string2 = file2.getParent();
                    if (string2 != null) {
                        this.preferences.setValue("lastDirectoryOpenedToImportTargetInfos", string2);
                    }
                    BufferedReader bufferedReader = null;
                    try {
                        try {
                            bufferedReader = new BufferedReader(new FileReader(file2));
                            StringBuffer stringBuffer = new StringBuffer();
                            String string3 = null;
                            string3 = bufferedReader.readLine();
                            while (string3 != null) {
                                stringBuffer.append(string3);
                                stringBuffer.append(System.getProperty("line.separator"));
                                string3 = bufferedReader.readLine();
                            }
                            this.myImportView.setText(stringBuffer.toString());
                        }
                        catch (IOException iOException) {
                            Log.singleton().logNewMessage(new ErrorMessage("There was an error reading the file " + file2.getAbsolutePath() + ". Details: " + iOException));
                        }
                        Object var8_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_11 = null;
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                    break block14;
                }
                return;
            }
            return;
        }
    }

    protected void performPasteFromClipboardAction() {
        this.myImportView.pasteFromClipboard();
    }

    protected void saveNewPreferences() {
        this.preferences.setValue("sortOnImport", this.sortOnImportCheckBox.isSelected());
        this.preferences.setValue("checkForDuplicates", this.checkForDuplicatesCheckBox.isSelected());
        if (this.sortByNameAscending.isSelected()) {
            this.preferences.setValue("sortOnImportMethod", "sortByNameAscending");
        } else if (this.sortByNameDescending.isSelected()) {
            this.preferences.setValue("sortOnImportMethod", "sortByNameDescending");
        } else if (this.sortByCreditsAscending.isSelected()) {
            this.preferences.setValue("sortOnImportMethod", "sortByCreditsAscending");
        } else if (this.sortByCreditsDescending.isSelected()) {
            this.preferences.setValue("sortOnImportMethod", "sortByCreditsDescending");
        }
    }

    private class PasteTargetInfosFromClipboardAction
    extends PWAction {
        PasteTargetInfosFromClipboardAction() {
            this.putValue("Name", "Paste");
            this.putValue("ShortDescription", "Paste");
            this.putValue("LongDescription", "Paste from clipboard");
            this.putValue("SmallIcon", ImageCache.singleton().getIcon("icons/paste.gif"));
        }

        public void perform(ActionEvent actionEvent) {
            ImportDialog.this.performPasteFromClipboardAction();
        }
    }

    private class LoadTargetInfosFromFileAction
    extends PWAction {
        LoadTargetInfosFromFileAction() {
            this.putValue("Name", "Load");
            this.putValue("ShortDescription", "Load");
            this.putValue("LongDescription", "Import Target Infos from file");
        }

        public void perform(ActionEvent actionEvent) {
            ImportDialog.this.performImportFromFileAction();
        }
    }

    private class ImportAction
    extends PWAction {
        ImportAction() {
            this.putValue("Name", "Import");
            this.putValue("ShortDescription", "Import");
            this.putValue("LongDescription", "Import to PWCPP");
        }

        public void perform(ActionEvent actionEvent) {
            ImportDialog.this.saveNewPreferences();
            ImportDialog.this.dispose();
            PWAction pWAction = ImportDialog.this.theTargetViewAndEditController.getImportTargetInfoFromTextAction();
            pWAction.putProperty("textToImport", ImportDialog.this.myImportView.getText().trim());
            pWAction.invokeFromCode();
        }
    }

    private class CancelAction
    extends PWAction {
        CancelAction() {
            this.putValue("Name", "Cancel");
            this.putValue("ShortDescription", "Cancel");
            this.putValue("LongDescription", "Cancel Import and close dialog");
        }

        public void perform(ActionEvent actionEvent) {
            ImportDialog.this.saveNewPreferences();
            ImportDialog.this.dispose();
        }
    }
}

