/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.ui.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import pw.palmpatch.ui.views.View;
import pw.palmpatch.util.ErrorMessage;
import pw.palmpatch.util.IMessage;
import pw.palmpatch.util.LogListener;
import pw.palmpatch.util.WarningMessage;

public class MessagesView
extends View
implements LogListener {
    JScrollPane textAreaScroller;
    JTextArea messageDisplay;

    public MessagesView() {
        this.initialize();
    }

    public void clearLog() {
        this.messageDisplay.setText("");
    }

    public String getText() {
        return this.messageDisplay.getText();
    }

    protected void initialize() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.textAreaScroller = new JScrollPane();
        this.messageDisplay = new JTextArea();
        this.messageDisplay.setEnabled(false);
        this.messageDisplay.setDisabledTextColor(Color.black);
        this.messageDisplay.setLineWrap(true);
        this.messageDisplay.setWrapStyleWord(true);
        this.messageDisplay.setBorder(BorderFactory.createEmptyBorder(3, 4, 3, 4));
        this.textAreaScroller.setViewportView(this.messageDisplay);
        this.textAreaScroller.setBorder((Border)UIManager.get("TextField.border"));
        this.add((Component)this.textAreaScroller, "Center");
    }

    public void logNewMessage(IMessage iMessage) {
        String string = System.getProperty("line.separator");
        if (iMessage instanceof WarningMessage) {
            this.messageDisplay.append("Warning!" + string);
        } else if (iMessage instanceof ErrorMessage) {
            this.messageDisplay.append("Error!" + string);
        }
        this.messageDisplay.append(iMessage.getText());
        this.messageDisplay.append(String.valueOf(string) + string);
    }

    public void updateUI() {
        super.updateUI();
        if (this.textAreaScroller != null) {
            this.textAreaScroller.setBorder((Border)UIManager.get("TextField.border"));
        }
    }
}

