/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.ui.views;

import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import pw.palmpatch.controller.PWAction;

public class PWDialog
extends JDialog {
    protected PWAction actionToBeInvokedOnEsc;
    protected JComponent componentToReceiveFocusOnOpening;

    public PWDialog() {
        this.initListeners();
    }

    public PWDialog(Frame frame) {
        super(frame);
        this.initListeners();
    }

    public PWDialog(Frame frame, String string) {
        super(frame, string);
        this.initListeners();
    }

    public PWDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.initListeners();
    }

    public PWDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initListeners();
    }

    protected PWAction getActionToBeInvokedOnEsc() {
        return this.actionToBeInvokedOnEsc;
    }

    protected JComponent getComponentToReceiveFocusOnOpening() {
        return this.componentToReceiveFocusOnOpening;
    }

    protected void initListeners() {
        this.installListenerForUIManagerChanges();
        this.addWindowListener(new WindowAdapter(){
            boolean gotFocus = false;

            public void windowActivated(WindowEvent windowEvent) {
                if (this.gotFocus) {
                    if (PWDialog.this.getComponentToReceiveFocusOnOpening() != null) {
                        PWDialog.this.getComponentToReceiveFocusOnOpening().requestFocus();
                    }
                    this.gotFocus = true;
                }
            }

            public void windowOpened(WindowEvent windowEvent) {
                if (PWDialog.this.getComponentToReceiveFocusOnOpening() != null) {
                    PWDialog.this.getComponentToReceiveFocusOnOpening().requestFocus();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27 && PWDialog.this.getActionToBeInvokedOnEsc() != null) {
                    PWDialog.this.getActionToBeInvokedOnEsc().invokeFromCode();
                }
            }
        });
    }

    protected void installListenerForUIManagerChanges() {
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() != null && propertyChangeEvent.getPropertyName().equals("lookAndFeel")) {
                    PWDialog.this.updateUI();
                }
            }
        });
    }

    public void setActionToBeInvokedOnEsc(PWAction pWAction) {
        this.actionToBeInvokedOnEsc = pWAction;
    }

    public void setComponentToReceiveFocusOnOpening(JComponent jComponent) {
        this.componentToReceiveFocusOnOpening = jComponent;
    }

    protected void updateUI() {
        SwingUtilities.updateComponentTreeUI(this);
    }
}

