/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.ui.views;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import pw.palmpatch.ui.FileFilter;
import pw.palmpatch.ui.FileView;
import pw.palmpatch.util.ImageCache;

public class PWFileChooser
extends JFileChooser {
    public PWFileChooser() {
        this.installListenerForUIManagerChanges();
    }

    public PWFileChooser(File file) {
        super(file, null);
        this.installListenerForUIManagerChanges();
    }

    public PWFileChooser(File file, FileSystemView fileSystemView) {
        super(file, fileSystemView);
        this.installListenerForUIManagerChanges();
    }

    public PWFileChooser(String string) {
        super(string, null);
        this.installListenerForUIManagerChanges();
    }

    public PWFileChooser(String string, FileSystemView fileSystemView) {
        super(string, fileSystemView);
        this.installListenerForUIManagerChanges();
    }

    public PWFileChooser(FileSystemView fileSystemView) {
        super((File)null, fileSystemView);
        this.installListenerForUIManagerChanges();
    }

    public static PWFileChooser createFileChooserForTargetLists() {
        PWFileChooser pWFileChooser = new PWFileChooser();
        FileFilter fileFilter = new FileFilter(new String[]{"xml", "zip"}, "Target Info Lists");
        pWFileChooser.setFileFilter(fileFilter);
        FileView fileView = new FileView();
        fileView.addTypeDescription("xml", "Target Info List");
        fileView.addTypeDescription("zip", "Packed Target Info List");
        fileView.addTypeDescription("prc", "Palm Pilot Executable");
        fileView.addTypeDescription("pdb", "Palm Pilot Database");
        fileView.addIconFor("xml", ImageCache.singleton().getIcon("icons/xmlFileType.gif"));
        fileView.addIconFor("zip", ImageCache.singleton().getIcon("icons/zipFileType.gif"));
        fileView.addIconFor("prc", ImageCache.singleton().getIcon("icons/prcFileType.gif"));
        fileView.addIconFor("pdb", ImageCache.singleton().getIcon("icons/pdbFileType.gif"));
        pWFileChooser.setFileView(fileView);
        return pWFileChooser;
    }

    public static PWFileChooser createFileChooserForTargets() {
        PWFileChooser pWFileChooser = new PWFileChooser();
        FileFilter fileFilter = new FileFilter(new String[]{"prc", "pdb", "exe", "dll"}, "Targets");
        pWFileChooser.setFileFilter(fileFilter);
        FileView fileView = new FileView();
        fileView.addTypeDescription("xml", "Target Info List");
        fileView.addTypeDescription("zip", "Packed Target Info List");
        fileView.addTypeDescription("prc", "Palm Pilot Executable");
        fileView.addTypeDescription("pdb", "Palm Pilot Database");
        fileView.addTypeDescription("exe", "Executable");
        fileView.addTypeDescription("dll", "Dynamic Link Library");
        fileView.addIconFor("xml", ImageCache.singleton().getIcon("icons/xmlFileType.gif"));
        fileView.addIconFor("zip", ImageCache.singleton().getIcon("icons/zipFileType.gif"));
        fileView.addIconFor("prc", ImageCache.singleton().getIcon("icons/prcFileType.gif"));
        fileView.addIconFor("pdb", ImageCache.singleton().getIcon("icons/pdbFileType.gif"));
        fileView.addIconFor("exe", ImageCache.singleton().getIcon("icons/pdbFileType.gif"));
        fileView.addIconFor("dll", ImageCache.singleton().getIcon("icons/pdbFileType.gif"));
        pWFileChooser.setFileView(fileView);
        return pWFileChooser;
    }

    protected void installListenerForUIManagerChanges() {
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() != null && propertyChangeEvent.getPropertyName().equals("lookAndFeel")) {
                    PWFileChooser.this.updateUI();
                }
            }
        });
    }

    public void setCurrentDirectory(File file) {
        if (file == null || !file.exists()) {
            super.setCurrentDirectory(new File(System.getProperty("user.home")));
            return;
        }
        super.setCurrentDirectory(file);
    }
}

