/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.ui.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import pw.palmpatch.PreferenceNode;
import pw.palmpatch.controller.Controller;
import pw.palmpatch.controller.PreferenceNodeBasedPreferencesController;
import pw.palmpatch.events.ModelEvent;
import pw.palmpatch.events.ModelListener;
import pw.palmpatch.models.PreferencesControllerModel;
import pw.palmpatch.ui.views.View;
import pw.palmpatch.ui.widgets.PreferenceNodeTreeCellRenderer;

public class PreferenceNodeBasedPreferencesView
extends View
implements ModelListener {
    protected JSplitPane aSplitPane;
    protected JScrollPane scrollPaneForTree;
    protected JScrollPane scrollPaneForPreferenceNodeClient;
    protected JTree preferenceNodeClientTree;
    protected JPanel clientContainer;

    public PreferenceNodeBasedPreferencesView(PreferencesControllerModel preferencesControllerModel) {
        this.initialize(preferencesControllerModel);
    }

    public PreferenceNode getSelectedPreferenceNode() {
        TreePath treePath = this.preferenceNodeClientTree.getSelectionPath();
        if (treePath != null) {
            return (PreferenceNode)((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
        }
        return null;
    }

    protected void initialize(PreferencesControllerModel preferencesControllerModel) {
        this.preferenceNodeClientTree = new JTree(preferencesControllerModel.getModelForPreferenceNodeTree());
        this.preferenceNodeClientTree.setCellRenderer(new PreferenceNodeTreeCellRenderer());
        this.preferenceNodeClientTree.setRootVisible(false);
        this.preferenceNodeClientTree.setShowsRootHandles(true);
        this.preferenceNodeClientTree.getSelectionModel().setSelectionMode(1);
        this.preferenceNodeClientTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (treeSelectionEvent.getNewLeadSelectionPath() == null) {
                    PreferenceNodeBasedPreferencesView.this.preferenceNodeClientTree.getSelectionModel().addSelectionPath(treeSelectionEvent.getOldLeadSelectionPath());
                }
            }
        });
        this.aSplitPane = new JSplitPane();
        this.scrollPaneForTree = new JScrollPane(this.preferenceNodeClientTree);
        this.scrollPaneForPreferenceNodeClient = new JScrollPane();
        this.aSplitPane.setLeftComponent(this.scrollPaneForTree);
        this.aSplitPane.setRightComponent(this.scrollPaneForPreferenceNodeClient);
        this.setLayout(new BorderLayout());
        this.add((Component)this.aSplitPane, "Center");
        this.clientContainer = new JPanel();
        this.clientContainer.setLayout(new BorderLayout());
        this.scrollPaneForPreferenceNodeClient.setViewportView(this.clientContainer);
    }

    public void modelEventOccurred(ModelEvent modelEvent) {
        this.preferenceNodeClientTree.setModel(((PreferencesControllerModel)modelEvent.getSource()).getModelForPreferenceNodeTree());
    }

    public void setController(Controller controller) {
        super.setController(controller);
        this.preferenceNodeClientTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                PreferenceNode preferenceNode = PreferenceNodeBasedPreferencesView.this.getSelectedPreferenceNode();
                if (preferenceNode != null) {
                    ((PreferenceNodeBasedPreferencesController)PreferenceNodeBasedPreferencesView.this.getController()).preferenceNodeWasSelected(preferenceNode);
                }
            }
        });
        this.preferenceNodeClientTree.setSelectionRow(0);
    }

    public void setPreferenceNodeClient(JComponent jComponent) {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(this.getSelectedPreferenceNode().getDescription());
        titledBorder.setTitleFont(new Font("Dialog", 0, 10));
        this.clientContainer.setBorder(titledBorder);
        this.clientContainer.removeAll();
        if (jComponent != null) {
            this.clientContainer.add((Component)jComponent, "Center");
        }
        this.clientContainer.revalidate();
        this.clientContainer.repaint();
    }

    public void updateUI() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        TreeModel treeModel;
        TreePath treePath = null;
        if (this.preferenceNodeClientTree != null) {
            this.preferenceNodeClientTree.setCellRenderer(new PreferenceNodeTreeCellRenderer());
            treePath = this.preferenceNodeClientTree.getSelectionPath();
        }
        super.updateUI();
        if (this.preferenceNodeClientTree != null && (treeModel = this.preferenceNodeClientTree.getModel()) != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)treeModel.getRoot()) != null) {
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
            JComponent jComponent = null;
            PreferenceNode preferenceNode = null;
            while (enumeration.hasMoreElements()) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                preferenceNode = (PreferenceNode)defaultMutableTreeNode.getUserObject();
                if (preferenceNode == null || (jComponent = preferenceNode.getClient()) == null) continue;
                SwingUtilities.updateComponentTreeUI(jComponent);
            }
        }
        if (treePath != null) {
            this.preferenceNodeClientTree.setSelectionPath(treePath);
        }
    }
}

