/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.ui.views;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import pw.palmpatch.Application;
import pw.palmpatch.controller.Controller;
import pw.palmpatch.controller.StatisticsController;
import pw.palmpatch.models.SortableAbstractTableModel;
import pw.palmpatch.ui.views.View;
import pw.palmpatch.ui.widgets.NoFocusBorderTableCellRenderer;
import pw.palmpatch.ui.widgets.StripedTableCellRenderer;
import pw.palmpatch.ui.widgets.Table;
import pw.palmpatch.util.Tracing;

public class StatisticsView
extends View {
    private Table targetInfoTable;
    private Table rankingsTable;
    private JComboBox topCombo;
    static /* synthetic */ Class class$java$lang$Object;

    public StatisticsView() {
        this.initialize();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public int getNumberOfTopPositionsToShow() {
        return (Integer)this.topCombo.getSelectedItem();
    }

    protected void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 1, 2, 2);
        gridBagConstraints.anchor = 17;
        this.targetInfoTable = new Table();
        this.targetInfoTable.setEnabled(false);
        this.targetInfoTable.setRowSelectionAllowed(false);
        this.targetInfoTable.setAutoResizeMode(0);
        this.targetInfoTable.sizeColumnsToContents();
        this.targetInfoTable.setDefaultRenderer(class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = StatisticsView.class$("java.lang.Object")), new NoFocusBorderTableCellRenderer());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.targetInfoTable);
        jScrollPane.setPreferredSize(new Dimension(200, 150));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.add(jScrollPane);
        this.targetInfoTable.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = StatisticsView.this.targetInfoTable.getColumnModel().getColumnIndexAtX(mouseEvent.getX());
                int n2 = StatisticsView.this.targetInfoTable.convertColumnIndexToModel(n);
                if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                    Tracing.singleton().trace("Start sorting");
                    Application.singleton().getApplicationFrame().setCursor(Cursor.getPredefinedCursor(3));
                    int n3 = mouseEvent.getModifiers() & 1;
                    boolean bl = n3 == 0;
                    ((SortableAbstractTableModel)StatisticsView.this.targetInfoTable.getModel()).sortByColumn(n2, bl);
                    Application.singleton().getApplicationFrame().setCursor(Cursor.getPredefinedCursor(0));
                    Tracing.singleton().trace("Finished sorting");
                }
            }
        });
        this.targetInfoTable.getTableHeader().setToolTipText("Click to sort. Use Shift+Click to sort the other way");
        JLabel jLabel = new JLabel("Show Top:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        Object[] objectArray = new Object[]{new Integer(5), new Integer(10), new Integer(15), new Integer(25), new Integer(50), new Integer(100)};
        this.topCombo = new JComboBox<Object>(objectArray);
        this.topCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((StatisticsController)StatisticsView.this.getController()).updateRankings(StatisticsView.this.getNumberOfTopPositionsToShow());
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.topCombo, gridBagConstraints);
        this.add(this.topCombo);
        this.rankingsTable = new Table();
        this.rankingsTable.setEnabled(false);
        this.rankingsTable.setRowSelectionAllowed(false);
        this.rankingsTable.setAutoResizeMode(0);
        this.rankingsTable.sizeColumnsToContents();
        this.rankingsTable.setDefaultRenderer(class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = StatisticsView.class$("java.lang.Object")), new NoFocusBorderTableCellRenderer());
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setViewportView(this.rankingsTable);
        jScrollPane2.setPreferredSize(new Dimension(200, 150));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jScrollPane2, gridBagConstraints);
        this.add(jScrollPane2);
    }

    public void setController(Controller controller) {
        super.setController(controller);
        this.targetInfoTable.setModel(((StatisticsController)controller).getTargetInfosToStatisticsTableModelAdapter());
        StripedTableCellRenderer.installInTable(this.targetInfoTable, StripedTableCellRenderer.DEFAULT_EVEN_BACK_COLOR, null, StripedTableCellRenderer.DEFAULT_ODD_BACK_COLOR, null);
        this.rankingsTable.setModel(((StatisticsController)controller).getRankingsTableModelAdapter());
        StripedTableCellRenderer.installInTable(this.rankingsTable, StripedTableCellRenderer.DEFAULT_EVEN_BACK_COLOR, null, StripedTableCellRenderer.DEFAULT_ODD_BACK_COLOR, null);
    }
}

