/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.ui.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JPanel;
import pw.palmpatch.controller.PWAction;
import pw.palmpatch.models.TargetInfoDuplicatesRemoverModel;
import pw.palmpatch.ui.views.ExportImportView;
import pw.palmpatch.ui.views.PWDialog;
import pw.palmpatch.ui.views.TargetInfoDuplicatesRemoverView;
import pw.palmpatch.ui.widgets.PWButton;

public class TargetInfoDuplicatesRemoverDialog
extends PWDialog {
    private TargetInfoDuplicatesRemoverView duplicatesView;
    protected ExportImportView myExportView;
    protected PWButton cancelButton;
    protected PWButton continueButton;
    protected PWAction cancelAction;
    protected PWAction continueAction;
    protected boolean wasCanceled;

    public TargetInfoDuplicatesRemoverDialog(Frame frame) {
        super(frame);
        this.initialize();
    }

    public void initialize() {
        this.setModal(true);
        this.duplicatesView = new TargetInfoDuplicatesRemoverView();
        this.cancelAction = new CancelAction();
        this.cancelButton = new PWButton();
        this.cancelButton.addActionListener(this.cancelAction);
        this.cancelButton.setMnemonic('a');
        this.continueAction = new ContinueAction();
        this.continueButton = new PWButton();
        this.continueButton.addActionListener(this.continueAction);
        this.continueButton.setMnemonic('o');
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.duplicatesView, "Center");
        JPanel jPanel = new JPanel();
        jPanel.add(this.cancelButton);
        jPanel.add(this.continueButton);
        this.getContentPane().add((Component)jPanel, "South");
        this.setTitle("Duplicates Handling");
        this.addWindowListener(new WindowAdapter(){
            boolean gotFocus = false;

            public void windowActivated(WindowEvent windowEvent) {
                if (this.gotFocus) {
                    TargetInfoDuplicatesRemoverDialog.this.continueButton.requestFocus();
                    this.gotFocus = true;
                }
            }

            public void windowOpened(WindowEvent windowEvent) {
                TargetInfoDuplicatesRemoverDialog.this.continueButton.requestFocus();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    TargetInfoDuplicatesRemoverDialog.this.cancelAction.invokeFromCode();
                }
            }
        });
    }

    protected void performCancelAction() {
        this.wasCanceled = true;
        this.dispose();
    }

    protected void performContinueAction() {
        this.dispose();
    }

    public void setModel(TargetInfoDuplicatesRemoverModel targetInfoDuplicatesRemoverModel) {
        this.duplicatesView.setModel(targetInfoDuplicatesRemoverModel);
    }

    public boolean wasCanceled() {
        return this.wasCanceled;
    }

    private class CancelAction
    extends PWAction {
        CancelAction() {
            this.putValue("Name", "Cancel");
            this.putValue("ShortDescription", "Cancel");
            this.putValue("LongDescription", "Cancel Import");
        }

        public void perform(ActionEvent actionEvent) {
            TargetInfoDuplicatesRemoverDialog.this.performCancelAction();
        }
    }

    private class ContinueAction
    extends PWAction {
        ContinueAction() {
            this.putValue("Name", "Continue");
            this.putValue("ShortDescription", "Continue");
            this.putValue("LongDescription", "Continue Import");
        }

        public void perform(ActionEvent actionEvent) {
            TargetInfoDuplicatesRemoverDialog.this.performContinueAction();
        }
    }
}

