/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.ui.views;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.List;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pw.palmpatch.controller.Controller;
import pw.palmpatch.controller.TargetViewAndEditController;
import pw.palmpatch.io.palmfiles.PalmDatabase;
import pw.palmpatch.models.Attachment;
import pw.palmpatch.models.FileInfo;
import pw.palmpatch.models.TargetInfo;
import pw.palmpatch.ui.ISearchStringConsumer;
import pw.palmpatch.ui.SearchStringProvider;
import pw.palmpatch.ui.views.AttachmentEditorView;
import pw.palmpatch.ui.views.AttachmentsTableView;
import pw.palmpatch.ui.views.FileInfoEditorView;
import pw.palmpatch.ui.views.FileInfosTableView;
import pw.palmpatch.ui.views.FileView;
import pw.palmpatch.ui.views.GenericFileView;
import pw.palmpatch.ui.views.PalmPilotFileView;
import pw.palmpatch.ui.views.TargetEditCommandBar;
import pw.palmpatch.ui.views.TargetInfoView;
import pw.palmpatch.ui.views.View;
import pw.palmpatch.ui.widgets.TargetInfoListCellRenderer;

public class TargetViewAndEditView
extends View {
    private JScrollPane targetsListScrollPane;
    private JList targetsList;
    private JPanel rightHandPanel;
    private JPopupMenu popupMenu;
    private TargetInfoView myTargetInfoView;
    private FileView currentFileView;
    private FileInfosTableView myFileInfosTableView;
    private AttachmentsTableView myAttachmentsTableView;
    private HashMap fileViews;
    private FileInfoEditorView myFileInfoEditor;
    private AttachmentEditorView myAttachmentEditor;
    private boolean fileInfoEditorIsShown;
    private boolean attachmentEditorIsShown;
    private boolean targetInfoViewIsShown;
    private TargetEditCommandBar myTargetEditCommandBar;
    private GridBagConstraints gbcForFileInfosTableView;
    private GridBagConstraints gbcForAttachmentsTableView;
    private GridBagConstraints gbcForTargetFileView;
    private GridBagConstraints gbcForTargetInfoViewWhenTargetEditCommandBarShowing;
    private GridBagConstraints gbcForTargetInfoViewWhenTargetEditCommandBarNotShowing;
    private GridBagConstraints gbcForTargetEditCommandBar;
    private GridBagLayout rightHandPanelLayout;

    public TargetViewAndEditView() {
        this.initialize();
    }

    public void displayChosenTargetFile(File file) {
        if (file == null) {
            if (this.currentFileView != null) {
                this.rightHandPanel.remove(this.currentFileView);
                this.currentFileView = null;
                this.rightHandPanel.revalidate();
                this.rightHandPanel.repaint();
            }
        } else {
            FileView fileView = (FileView)this.fileViews.get(file.getClass());
            if (fileView == null) {
                fileView = file instanceof PalmDatabase ? new PalmPilotFileView() : new GenericFileView();
            }
            this.fileViews.put(file.getClass(), (Object)fileView);
            if (this.currentFileView != fileView) {
                if (this.currentFileView != null) {
                    this.rightHandPanel.remove(this.currentFileView);
                }
                this.currentFileView = fileView;
                this.rightHandPanel.add(this.currentFileView);
                ((GridBagLayout)this.rightHandPanel.getLayout()).setConstraints(this.currentFileView, this.gbcForTargetFileView);
                this.rightHandPanel.revalidate();
                this.rightHandPanel.repaint();
            }
            this.currentFileView.setFile(file);
        }
    }

    public void displayEditorFor(Attachment attachment) {
        if (attachment == null) {
            this.displayTargetInfo();
        } else {
            if (!this.attachmentEditorIsShown) {
                if (this.fileInfoEditorIsShown) {
                    this.rightHandPanel.remove(this.myFileInfoEditor);
                } else {
                    this.rightHandPanel.remove(this.myTargetInfoView);
                    this.targetInfoViewIsShown = false;
                }
                this.rightHandPanelLayout.setConstraints(this.myAttachmentEditor, this.gbcForTargetInfoViewWhenTargetEditCommandBarShowing);
                this.rightHandPanel.add(this.myAttachmentEditor);
                this.rightHandPanel.revalidate();
                this.rightHandPanel.repaint();
                this.attachmentEditorIsShown = true;
                this.fileInfoEditorIsShown = false;
            }
            this.myAttachmentEditor.setAttachment(attachment);
        }
    }

    public void displayEditorFor(FileInfo fileInfo) {
        if (fileInfo == null) {
            this.displayTargetInfo();
        } else {
            if (!this.fileInfoEditorIsShown) {
                if (this.attachmentEditorIsShown) {
                    this.rightHandPanel.remove(this.myAttachmentEditor);
                } else {
                    this.rightHandPanel.remove(this.myTargetInfoView);
                    this.targetInfoViewIsShown = false;
                }
                this.rightHandPanelLayout.setConstraints(this.myFileInfoEditor, this.gbcForTargetInfoViewWhenTargetEditCommandBarShowing);
                this.rightHandPanel.add(this.myFileInfoEditor);
                this.rightHandPanel.revalidate();
                this.rightHandPanel.repaint();
                this.fileInfoEditorIsShown = true;
                this.attachmentEditorIsShown = false;
            }
            this.myFileInfoEditor.setFileInfo(fileInfo);
        }
    }

    public void displayTargetInfo() {
        if (!this.targetInfoViewIsShown) {
            if (this.fileInfoEditorIsShown) {
                this.rightHandPanel.remove(this.myFileInfoEditor);
            }
            if (this.attachmentEditorIsShown) {
                this.rightHandPanel.remove(this.myAttachmentEditor);
            }
            this.rightHandPanelLayout.setConstraints(this.myTargetInfoView, this.gbcForTargetInfoViewWhenTargetEditCommandBarShowing);
            this.rightHandPanel.add(this.myTargetInfoView);
            this.rightHandPanel.revalidate();
            this.rightHandPanel.repaint();
            this.myTargetInfoView.requestDefaultFocus();
        }
        this.fileInfoEditorIsShown = false;
        this.attachmentEditorIsShown = false;
        this.targetInfoViewIsShown = true;
    }

    public void fillAttachment(Attachment attachment) {
        this.myAttachmentEditor.fillAttachment(attachment);
    }

    public void fillAttachment(FileInfo fileInfo) {
        this.myFileInfoEditor.fillFileInfo(fileInfo);
    }

    public void fillFileInfo(FileInfo fileInfo) {
        this.myFileInfoEditor.fillFileInfo(fileInfo);
    }

    public void fillTargetInfo(TargetInfo targetInfo) {
        this.myTargetInfoView.fillTargetInfo(targetInfo);
    }

    public void focusInfoTextInEditor() {
        this.myFileInfoEditor.setFocusToInfo();
    }

    public void focusTargetList() {
        this.targetsList.requestFocus();
    }

    public Attachment getSelectedAttachment() {
        return this.myAttachmentsTableView.getSelectedAttachment();
    }

    public Attachment[] getSelectedAttachments() {
        int[] nArray = this.myAttachmentsTableView.getSelectedIndices();
        Attachment[] attachmentArray = null;
        if (nArray.length != 0) {
            attachmentArray = new Attachment[nArray.length];
            int n = 0;
            while (n < nArray.length) {
                attachmentArray[n] = this.myAttachmentsTableView.getAttachmentAt(nArray[n]);
                ++n;
            }
        }
        return attachmentArray;
    }

    public FileInfo getSelectedFileInfo() {
        return this.myFileInfosTableView.getSelectedFileInfo();
    }

    public int getSelectedFileInfoIndex() {
        return this.myFileInfosTableView.getSelectedIndex();
    }

    public TargetInfo getSelectedTargetInfo() {
        return (TargetInfo)this.targetsList.getSelectedValue();
    }

    public int[] getSelectedTargetInfoIndices() {
        return this.targetsList.getSelectedIndices();
    }

    public void initialize() {
        this.setLayout(new BorderLayout());
        this.rightHandPanel = new JPanel();
        this.rightHandPanelLayout = new GridBagLayout();
        this.rightHandPanel.setLayout(this.rightHandPanelLayout);
        this.targetsListScrollPane = new JScrollPane();
        this.targetsList = new JList();
        this.targetsList.setCellRenderer(new TargetInfoListCellRenderer());
        this.targetsList.addListSelectionListener(new ListSelectionListener(){
            int lastSelectedIndex = -1;

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n;
                if (!listSelectionEvent.getValueIsAdjusting() && (n = TargetViewAndEditView.this.targetsList.getSelectedIndex()) != this.lastSelectedIndex) {
                    TargetInfo targetInfo = (TargetInfo)TargetViewAndEditView.this.targetsList.getSelectedValue();
                    boolean bl = ((TargetViewAndEditController)TargetViewAndEditView.this.getController()).setCurrentTargetInfo(targetInfo);
                    if (!bl) {
                        TargetViewAndEditView.this.targetsList.setSelectedIndex(this.lastSelectedIndex);
                    } else {
                        this.lastSelectedIndex = n;
                    }
                }
            }
        });
        this.popupMenu = new JPopupMenu();
        this.targetsList.add(this.popupMenu);
        this.targetsList.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            protected void showPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    boolean bl = false;
                    boolean bl2 = false;
                    int n = mouseEvent.getX();
                    int n2 = mouseEvent.getY();
                    int n3 = TargetViewAndEditView.this.targetsListScrollPane.getWidth();
                    int n4 = TargetViewAndEditView.this.targetsListScrollPane.getHeight();
                    Point point = TargetViewAndEditView.this.targetsListScrollPane.getViewport().getViewPosition();
                    if (mouseEvent.getY() - point.y + TargetViewAndEditView.this.popupMenu.getHeight() > n4) {
                        n2 = n4 - TargetViewAndEditView.this.popupMenu.getHeight();
                        bl2 = true;
                    }
                    if (mouseEvent.getX() - point.x + TargetViewAndEditView.this.popupMenu.getWidth() > n3) {
                        n = n3 - TargetViewAndEditView.this.popupMenu.getWidth();
                        bl = true;
                    }
                    if (bl && bl2) {
                        TargetViewAndEditView.this.popupMenu.show(TargetViewAndEditView.this.targetsListScrollPane, n, n2);
                    } else if (bl) {
                        TargetViewAndEditView.this.popupMenu.show(TargetViewAndEditView.this.targetsListScrollPane, n, mouseEvent.getPoint().y - point.y);
                    } else if (bl2) {
                        TargetViewAndEditView.this.popupMenu.show(TargetViewAndEditView.this.targetsListScrollPane, mouseEvent.getPoint().x - point.x, n2);
                    } else {
                        TargetViewAndEditView.this.popupMenu.show(TargetViewAndEditView.this.targetsList, n, n2);
                    }
                }
            }
        });
        final JPanel jPanel = new JPanel();
        final JLabel jLabel = new JLabel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)this.targetsListScrollPane, "Center");
        ISearchStringConsumer iSearchStringConsumer = new ISearchStringConsumer(){
            private boolean searchLabelAdded = false;
            private ListModel theListModel = null;
            private TargetInfo aTargetInfo = null;

            public void searchFor(String string) {
                if (string.length() == 0) {
                    if (this.searchLabelAdded) {
                        jPanel.remove(jLabel);
                        jPanel.repaint();
                        jPanel.revalidate();
                        this.searchLabelAdded = false;
                    }
                } else {
                    jLabel.setText("Search for: " + string);
                    if (!this.searchLabelAdded) {
                        jPanel.add((Component)jLabel, "North");
                        jPanel.repaint();
                        jPanel.revalidate();
                        this.searchLabelAdded = true;
                    }
                    this.theListModel = targetsList.getModel();
                    int n = targetsList.getSelectedIndex();
                    if (n == -1) {
                        if (this.theListModel.getSize() > 0) {
                            n = 0;
                        } else {
                            return;
                        }
                    }
                    this.aTargetInfo = (TargetInfo)this.theListModel.getElementAt(n);
                    if (this.aTargetInfo.getLongName().toUpperCase().startsWith(string.toUpperCase())) {
                        return;
                    }
                    this.searchForNextOccurrence(string);
                }
            }

            private void searchForNextOccurrence(String string) {
                if (this.theListModel == null) {
                    throw new IllegalStateException("theListModel is null in searchForNextOccurrence");
                }
                boolean bl = false;
                int n = targetsList.getSelectedIndex();
                int n2 = n + 1;
                while (n2 < this.theListModel.getSize()) {
                    this.aTargetInfo = (TargetInfo)this.theListModel.getElementAt(n2);
                    if (this.aTargetInfo.getLongName().toUpperCase().startsWith(string.toUpperCase())) {
                        targetsList.setSelectedIndex(n2);
                        if (n2 < targetsList.getModel().getSize() - 1) {
                            targetsList.ensureIndexIsVisible(n2 + 1);
                        } else {
                            targetsList.ensureIndexIsVisible(n2);
                        }
                        n = n2;
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    int n3 = 0;
                    while (n3 < n) {
                        this.aTargetInfo = (TargetInfo)this.theListModel.getElementAt(n3);
                        if (this.aTargetInfo.getLongName().toUpperCase().startsWith(string.toUpperCase())) {
                            targetsList.setSelectedIndex(n3);
                            targetsList.ensureIndexIsVisible(n3);
                            n = n3;
                            bl = true;
                            break;
                        }
                        ++n3;
                    }
                }
            }

            public void searchNext(String string) {
                if (this.theListModel != null) {
                    this.searchForNextOccurrence(string);
                }
            }
        };
        SearchStringProvider searchStringProvider = new SearchStringProvider(iSearchStringConsumer);
        this.targetsList.addKeyListener(searchStringProvider);
        this.targetsList.addMouseListener(searchStringProvider);
        this.targetsList.setToolTipText("Click on the right mouse button to bring up a menu");
        this.targetsListScrollPane.setViewportView(this.targetsList);
        this.targetsListScrollPane.setPreferredSize(new Dimension(200, 100));
        this.targetsListScrollPane.setMinimumSize(new Dimension(200, 100));
        this.myTargetEditCommandBar = new TargetEditCommandBar();
        this.gbcForTargetEditCommandBar = new GridBagConstraints();
        this.gbcForTargetEditCommandBar.ipadx = 2;
        this.gbcForTargetEditCommandBar.ipady = 2;
        this.gbcForTargetEditCommandBar.fill = 0;
        this.gbcForTargetEditCommandBar.insets = new Insets(2, 0, 2, 0);
        this.gbcForTargetEditCommandBar.anchor = 11;
        this.gbcForTargetEditCommandBar.weightx = 0.0;
        this.gbcForTargetEditCommandBar.weighty = 0.0;
        this.gbcForTargetEditCommandBar.gridx = 1;
        this.gbcForTargetEditCommandBar.gridy = 0;
        this.gbcForTargetEditCommandBar.gridwidth = 1;
        this.myTargetInfoView = new TargetInfoView();
        Dimension dimension = new Dimension(this.myTargetInfoView.getPreferredSize().width - this.myTargetEditCommandBar.getPreferredSize().width - 20, this.myTargetInfoView.getPreferredSize().height);
        this.myTargetInfoView.setMinimumSize(dimension);
        this.myTargetInfoView.setEnabled(false);
        this.gbcForTargetInfoViewWhenTargetEditCommandBarNotShowing = new GridBagConstraints();
        this.gbcForTargetInfoViewWhenTargetEditCommandBarNotShowing.ipadx = 2;
        this.gbcForTargetInfoViewWhenTargetEditCommandBarNotShowing.ipady = 2;
        this.gbcForTargetInfoViewWhenTargetEditCommandBarNotShowing.fill = 2;
        this.gbcForTargetInfoViewWhenTargetEditCommandBarNotShowing.insets = new Insets(2, 0, 2, 0);
        this.gbcForTargetInfoViewWhenTargetEditCommandBarNotShowing.anchor = 11;
        this.gbcForTargetInfoViewWhenTargetEditCommandBarNotShowing.weightx = 1.0;
        this.gbcForTargetInfoViewWhenTargetEditCommandBarNotShowing.weighty = 0.0;
        this.gbcForTargetInfoViewWhenTargetEditCommandBarNotShowing.gridx = 0;
        this.gbcForTargetInfoViewWhenTargetEditCommandBarNotShowing.gridy = 0;
        this.gbcForTargetInfoViewWhenTargetEditCommandBarNotShowing.gridwidth = 2;
        this.gbcForTargetInfoViewWhenTargetEditCommandBarShowing = new GridBagConstraints();
        this.gbcForTargetInfoViewWhenTargetEditCommandBarShowing.ipadx = 2;
        this.gbcForTargetInfoViewWhenTargetEditCommandBarShowing.ipady = 2;
        this.gbcForTargetInfoViewWhenTargetEditCommandBarShowing.fill = 2;
        this.gbcForTargetInfoViewWhenTargetEditCommandBarShowing.insets = new Insets(2, 0, 2, 0);
        this.gbcForTargetInfoViewWhenTargetEditCommandBarShowing.anchor = 11;
        this.gbcForTargetInfoViewWhenTargetEditCommandBarShowing.weightx = 1.0;
        this.gbcForTargetInfoViewWhenTargetEditCommandBarShowing.weighty = 0.0;
        this.gbcForTargetInfoViewWhenTargetEditCommandBarShowing.gridx = 0;
        this.gbcForTargetInfoViewWhenTargetEditCommandBarShowing.gridy = 0;
        this.gbcForTargetInfoViewWhenTargetEditCommandBarShowing.gridwidth = 1;
        this.rightHandPanelLayout.setConstraints(this.myTargetInfoView, this.gbcForTargetInfoViewWhenTargetEditCommandBarNotShowing);
        this.rightHandPanel.add(this.myTargetInfoView);
        this.myFileInfoEditor = new FileInfoEditorView();
        Dimension dimension2 = new Dimension(this.myFileInfoEditor.getPreferredSize().width - this.myTargetEditCommandBar.getPreferredSize().width - 20, this.myFileInfoEditor.getPreferredSize().height);
        this.myFileInfoEditor.setMinimumSize(dimension2);
        ((GridBagLayout)this.rightHandPanel.getLayout()).setConstraints(this.myFileInfoEditor, this.gbcForTargetInfoViewWhenTargetEditCommandBarShowing);
        this.fileInfoEditorIsShown = false;
        this.myAttachmentEditor = new AttachmentEditorView();
        Dimension dimension3 = new Dimension(this.myAttachmentEditor.getPreferredSize().width - this.myTargetEditCommandBar.getPreferredSize().width - 20, this.myAttachmentEditor.getPreferredSize().height - 100);
        this.myAttachmentEditor.setMinimumSize(dimension3);
        this.attachmentEditorIsShown = false;
        this.myFileInfosTableView = new FileInfosTableView();
        this.gbcForFileInfosTableView = new GridBagConstraints();
        this.gbcForFileInfosTableView.ipadx = 2;
        this.gbcForFileInfosTableView.ipady = 2;
        this.gbcForFileInfosTableView.fill = 1;
        this.gbcForFileInfosTableView.insets = new Insets(2, 0, 2, 0);
        this.gbcForFileInfosTableView.anchor = 11;
        this.gbcForFileInfosTableView.weightx = 1.0;
        this.gbcForFileInfosTableView.weighty = 1.0;
        this.gbcForFileInfosTableView.gridx = 0;
        this.gbcForFileInfosTableView.gridy = 1;
        this.gbcForFileInfosTableView.gridwidth = 2;
        this.rightHandPanelLayout.setConstraints(this.myFileInfosTableView, this.gbcForFileInfosTableView);
        this.myFileInfosTableView.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ((TargetViewAndEditController)TargetViewAndEditView.this.getController()).getFileInfoSelectedAction().invokeFromCode();
                }
            }
        });
        this.myFileInfosTableView.setPreferredSize(new Dimension(160, 110));
        this.myFileInfosTableView.setMinimumSize(new Dimension(160, 90));
        this.rightHandPanel.add(this.myFileInfosTableView);
        this.myAttachmentsTableView = new AttachmentsTableView();
        this.gbcForAttachmentsTableView = new GridBagConstraints();
        this.gbcForAttachmentsTableView.ipadx = 2;
        this.gbcForAttachmentsTableView.ipady = 2;
        this.gbcForAttachmentsTableView.fill = 1;
        this.gbcForAttachmentsTableView.insets = new Insets(2, 0, 2, 0);
        this.gbcForAttachmentsTableView.anchor = 11;
        this.gbcForAttachmentsTableView.weightx = 1.0;
        this.gbcForAttachmentsTableView.weighty = 1.0;
        this.gbcForAttachmentsTableView.gridx = 0;
        this.gbcForAttachmentsTableView.gridy = 3;
        this.gbcForAttachmentsTableView.gridwidth = 2;
        this.rightHandPanelLayout.setConstraints(this.myAttachmentsTableView, this.gbcForAttachmentsTableView);
        this.myAttachmentsTableView.setPreferredSize(new Dimension(160, 90));
        this.myAttachmentsTableView.setMinimumSize(new Dimension(160, 80));
        this.myAttachmentsTableView.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ((TargetViewAndEditController)TargetViewAndEditView.this.getController()).getAttachmentSelectedAction().invokeFromCode();
                }
            }
        });
        this.rightHandPanel.add(this.myAttachmentsTableView);
        JSplitPane jSplitPane = new JSplitPane(1, true, jPanel, this.rightHandPanel);
        this.add("Center", jSplitPane);
        this.fileViews = new HashMap(11);
        this.gbcForTargetFileView = new GridBagConstraints();
        this.gbcForTargetFileView.ipadx = 2;
        this.gbcForTargetFileView.ipady = 2;
        this.gbcForTargetFileView.fill = 1;
        this.gbcForTargetFileView.insets = new Insets(2, 0, 2, 0);
        this.gbcForTargetFileView.weightx = 1.0;
        this.gbcForTargetFileView.weighty = 0.0;
        this.gbcForTargetFileView.gridheight = 1;
        this.gbcForTargetFileView.gridwidth = 2;
        this.gbcForTargetFileView.gridx = 0;
        this.gbcForTargetFileView.gridy = 2;
    }

    public void resetSelectionOfList() {
        this.targetsList.clearSelection();
    }

    public void selectLastEntryAndScrollThere() {
        int n = this.targetsList.getModel().getSize() - 1;
        this.targetsList.setSelectedIndex(n);
        if (n >= 0) {
            this.targetsList.scrollRectToVisible(this.targetsList.getCellBounds(n, n));
        }
    }

    public void setController(Controller controller) {
        super.setController(controller);
        ArrayList arrayList = new ArrayList();
        arrayList.add((Object)((TargetViewAndEditController)this.getController()).getChooseTargetFileAction());
        arrayList.add((Object)((TargetViewAndEditController)this.getController()).getPatchTargetFilesAction());
        arrayList.add((Object)((TargetViewAndEditController)this.getController()).getNewFileInfoAction());
        arrayList.add((Object)((TargetViewAndEditController)this.getController()).getDeleteFileInfoAction());
        this.myFileInfosTableView.setActions((List)arrayList);
        ArrayList arrayList2 = new ArrayList();
        arrayList2.add((Object)((TargetViewAndEditController)this.getController()).getDetachAttachmentAction());
        arrayList2.add((Object)((TargetViewAndEditController)this.getController()).getNewAttachmentAction());
        arrayList2.add((Object)((TargetViewAndEditController)this.getController()).getRemoveAttachmentAction());
        this.myAttachmentsTableView.setActions((List)arrayList2);
        this.popupMenu.add(((TargetViewAndEditController)this.getController()).getPWDataInfoAction());
        JMenu jMenu = new JMenu("Sort");
        this.popupMenu.add(jMenu);
        jMenu.add(((TargetViewAndEditController)this.getController()).getSortByTargetLongNameAscendingAction());
        jMenu.add(((TargetViewAndEditController)this.getController()).getSortByTargetLongNameDescendingAction());
        jMenu.add(((TargetViewAndEditController)this.getController()).getSortByTargetCreditsAscendingAction());
        jMenu.add(((TargetViewAndEditController)this.getController()).getSortByTargetCreditsDescendingAction());
        jMenu.add(((TargetViewAndEditController)this.getController()).getSortByUrlAscendingAction());
        jMenu.add(((TargetViewAndEditController)this.getController()).getSortByUrlDescendingAction());
        this.targetsList.setModel(((TargetViewAndEditController)this.getController()).getTargetInfosToListModelAdapter());
        this.popupMenu.add(((TargetViewAndEditController)this.getController()).getNewTargetInfoAction());
        this.popupMenu.add(((TargetViewAndEditController)this.getController()).getStartEditingTargetInfoAction());
        this.popupMenu.add(((TargetViewAndEditController)this.getController()).getDeleteTargetInfoAction());
        this.popupMenu.add(((TargetViewAndEditController)this.getController()).getImportTargetInfoAction());
        this.popupMenu.add(((TargetViewAndEditController)this.getController()).getExportTargetInfoAction());
        this.targetsList.registerKeyboardAction(((TargetViewAndEditController)this.getController()).getDeleteTargetInfoAction(), KeyStroke.getKeyStroke(127, 0), 2);
        this.myTargetEditCommandBar.getSaveButton().addActionListener(((TargetViewAndEditController)controller).getSaveChangesToTargetInfoAction());
        this.myTargetEditCommandBar.getDiscardChangesButton().addActionListener(((TargetViewAndEditController)controller).getDiscardChangesToTargetInfoAction());
        this.myTargetEditCommandBar.getCancelButton().addActionListener(((TargetViewAndEditController)controller).getStopEditingTargetInfoAction());
        this.myTargetEditCommandBar.getGetInfoFromFileButton().addActionListener(((TargetViewAndEditController)controller).getGetInfosFromFileAction());
        this.myTargetEditCommandBar.getGetChangesFromFilesButton().addActionListener(((TargetViewAndEditController)controller).getGetChangesFromFilesAction());
        this.myTargetEditCommandBar.getUseInfosFromFileForTargetInfoButton().addActionListener(((TargetViewAndEditController)controller).getUseInfosFromFileForTargetInfoAction());
        this.myFileInfosTableView.setController(controller);
        this.myAttachmentsTableView.setController(controller);
        this.myFileInfosTableView.addMouseListenerToTable(((TargetViewAndEditController)this.getController()).getMouseListenerOnFileInfosTableView());
        this.myAttachmentsTableView.addMouseListenerToTable(((TargetViewAndEditController)this.getController()).getMouseListenerOnAttachmentTableView());
    }

    public void setCurrentTargetInfo(TargetInfo targetInfo) {
        this.targetsList.setSelectedValue(targetInfo, true);
        this.myTargetInfoView.setModel(targetInfo);
        this.myFileInfosTableView.setModel(targetInfo);
        this.myAttachmentsTableView.setModel(targetInfo);
    }

    public void setSelectedAttachment(int n) {
        this.myAttachmentsTableView.setSelectedAttachment(n);
    }

    public void setSelectedFileInfo(int n) {
        this.myFileInfosTableView.setSelectedFileInfo(n);
    }

    public void setSelectedTargetInfo(int n) {
        this.targetsList.setSelectedIndex(n);
        this.targetsList.requestFocus();
    }

    public void switchToEditing(boolean bl) {
        this.displayTargetInfo();
        this.myTargetInfoView.setEnabled(bl);
        this.myFileInfosTableView.setSelectedFileInfo(-1);
        this.myAttachmentsTableView.setSelectedAttachment(-1);
        if (bl) {
            this.rightHandPanelLayout.setConstraints(this.myTargetEditCommandBar, this.gbcForTargetEditCommandBar);
            this.rightHandPanelLayout.setConstraints(this.myTargetInfoView, this.gbcForTargetInfoViewWhenTargetEditCommandBarShowing);
            this.rightHandPanel.add(this.myTargetEditCommandBar);
            this.rightHandPanel.revalidate();
            this.rightHandPanel.repaint();
        } else {
            this.rightHandPanel.remove(this.myTargetEditCommandBar);
            this.rightHandPanelLayout.setConstraints(this.myTargetInfoView, this.gbcForTargetInfoViewWhenTargetEditCommandBarNotShowing);
            this.rightHandPanel.revalidate();
            this.rightHandPanel.repaint();
        }
    }

    public void switchToEditorForAttachment() {
        if (!this.attachmentEditorIsShown) {
            if (this.fileInfoEditorIsShown) {
                this.rightHandPanel.remove(this.myFileInfoEditor);
            } else {
                this.rightHandPanel.remove(this.myTargetInfoView);
                this.targetInfoViewIsShown = false;
            }
            this.rightHandPanelLayout.setConstraints(this.myAttachmentEditor, this.gbcForTargetInfoViewWhenTargetEditCommandBarShowing);
            this.rightHandPanel.add(this.myAttachmentEditor);
            this.rightHandPanel.revalidate();
            this.rightHandPanel.repaint();
            this.attachmentEditorIsShown = true;
            this.fileInfoEditorIsShown = false;
        }
    }

    public void switchToEditorForFileInfo() {
        if (!this.fileInfoEditorIsShown) {
            if (this.attachmentEditorIsShown) {
                this.rightHandPanel.remove(this.myAttachmentEditor);
            } else {
                this.rightHandPanel.remove(this.myTargetInfoView);
                this.targetInfoViewIsShown = false;
            }
            this.rightHandPanelLayout.setConstraints(this.myFileInfoEditor, this.gbcForTargetInfoViewWhenTargetEditCommandBarShowing);
            this.rightHandPanel.add(this.myFileInfoEditor);
            this.rightHandPanel.revalidate();
            this.rightHandPanel.repaint();
            this.fileInfoEditorIsShown = true;
            this.attachmentEditorIsShown = false;
        }
    }

    public void updateChanges(FileInfo fileInfo) {
        this.myFileInfoEditor.updateChanges(fileInfo);
        this.myFileInfosTableView.sizeColumnsToContents();
    }

    public void updateInformation(FileInfo fileInfo) {
        this.myFileInfoEditor.updateInformation(fileInfo);
        this.myFileInfosTableView.sizeColumnsToContents();
    }

    public void updatePatchableStatus(FileInfo fileInfo) {
        this.myFileInfosTableView.updatePatchableStatus(fileInfo);
    }

    public void updateUI() {
        super.updateUI();
        if (this.myTargetEditCommandBar != null) {
            SwingUtilities.updateComponentTreeUI(this.myTargetEditCommandBar);
        }
        if (this.popupMenu != null) {
            SwingUtilities.updateComponentTreeUI(this.popupMenu);
        }
        if (this.currentFileView != null) {
            SwingUtilities.updateComponentTreeUI(this.currentFileView);
        }
        if (this.myTargetInfoView != null) {
            SwingUtilities.updateComponentTreeUI(this.myTargetInfoView);
        }
        if (this.myFileInfoEditor != null) {
            SwingUtilities.updateComponentTreeUI(this.myFileInfoEditor);
        }
    }
}

