/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.ui.widgets;

import java.awt.Color;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.text.Document;

public class ReadOnlySupportedTextArea
extends JTextArea {
    protected Border oldBorder;
    protected Color oldBackground;

    public ReadOnlySupportedTextArea() {
        this.initialize();
    }

    public ReadOnlySupportedTextArea(int n, int n2) {
        super(n, n2);
        this.initialize();
    }

    public ReadOnlySupportedTextArea(String string) {
        super(string);
        this.initialize();
    }

    public ReadOnlySupportedTextArea(String string, int n, int n2) {
        super(string, n, n2);
        this.initialize();
    }

    public ReadOnlySupportedTextArea(Document document) {
        super(document);
        this.initialize();
    }

    public ReadOnlySupportedTextArea(Document document, String string, int n, int n2) {
        super(document, string, n, n2);
        this.initialize();
    }

    public void initialize() {
        this.setDisabledTextColor((Color)UIManager.get("TextField.foreground"));
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (!bl) {
            this.oldBorder = this.getBorder();
            Insets insets = this.oldBorder.getBorderInsets(this);
            this.setBorder(new BorderUIResource(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right)));
            this.oldBackground = this.getBackground();
            this.setBackground((Color)UIManager.get("Label.background"));
        } else {
            if (this.oldBorder == null) {
                this.oldBorder = this.getBorder();
            }
            if (this.oldBackground == null) {
                this.oldBackground = this.getBackground();
            }
            this.setBorder(this.oldBorder);
            this.setBackground(this.oldBackground);
        }
    }

    public void updateUI() {
        super.updateUI();
        this.oldBorder = null;
        this.oldBackground = null;
        this.setDisabledTextColor((Color)UIManager.get("TextField.foreground"));
        this.setEnabled(this.isEnabled());
    }
}

