/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.ui.widgets;

import java.awt.Color;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.text.Document;

public class ReadOnlySupportedTextField
extends JTextField {
    protected Border oldBorder;
    protected Color oldBackground;

    public ReadOnlySupportedTextField() {
        this.initialize();
    }

    public ReadOnlySupportedTextField(int n) {
        super(n);
        this.initialize();
    }

    public ReadOnlySupportedTextField(String string) {
        super(string);
        this.initialize();
    }

    public ReadOnlySupportedTextField(String string, int n) {
        super(string, n);
        this.initialize();
    }

    public ReadOnlySupportedTextField(Document document, String string, int n) {
        super(document, string, n);
        this.initialize();
    }

    public void initialize() {
        this.setDisabledTextColor((Color)UIManager.get("TextField.foreground"));
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (!bl) {
            this.oldBorder = this.getBorder();
            Insets insets = this.oldBorder.getBorderInsets(this);
            this.setBorder(new BorderUIResource(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right)));
            this.oldBackground = this.getBackground();
            this.setBackground((Color)UIManager.get("Label.background"));
        } else {
            if (this.oldBorder == null) {
                this.oldBorder = this.getBorder();
            }
            if (this.oldBackground == null) {
                this.oldBackground = this.getBackground();
            }
            this.setBorder(this.oldBorder);
            this.setBackground(this.oldBackground);
        }
    }

    public void updateUI() {
        super.updateUI();
        this.setDisabledTextColor((Color)UIManager.get("TextField.foreground"));
        this.oldBorder = null;
        this.oldBackground = null;
        this.setEnabled(this.isEnabled());
    }
}

