/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.util;

import edu.stanford.cs.ejalbert.BrowserLauncher;
import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import pw.palmpatch.Application;
import pw.palmpatch.io.ProgressIndicatorInputStream;
import pw.palmpatch.ui.views.HTMLFrame;
import pw.palmpatch.ui.widgets.ProgressIndicator;
import pw.palmpatch.util.ErrorMessage;
import pw.palmpatch.util.InfoMessage;
import pw.palmpatch.util.Log;
import pw.palmpatch.util.WarningMessage;

public class FileDownloader {
    private URL constructAutoDownloadInfoUrl(URL uRL) throws MalformedURLException {
        String string = uRL.toExternalForm();
        URL uRL2 = null;
        int n = string.lastIndexOf(47);
        if (n != -1) {
            String string2 = string.substring(0, n + 1);
            uRL2 = new URL(String.valueOf(string2) + "autoDownloadInfo.xml");
            System.out.println(uRL2);
        } else {
            uRL2 = new URL(String.valueOf(string) + "/autoDownloadInfo.xml");
        }
        return uRL2;
    }

    private void displayTeasers(Element element) {
        NodeList nodeList = element.getElementsByTagName("Teaser");
        Element element2 = null;
        Attr attr = null;
        String string = null;
        int n = 400;
        int n2 = 400;
        boolean bl = false;
        int n3 = 0;
        while (n3 < nodeList.getLength()) {
            bl = false;
            element2 = (Element)nodeList.item(n3);
            attr = (Attr)element2.getAttributes().getNamedItem("Url");
            String string2 = attr.getValue();
            attr = (Attr)element2.getAttributes().getNamedItem("Width");
            if (attr != null) {
                try {
                    n = Integer.parseInt(attr.getValue());
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if ((attr = (Attr)element2.getAttributes().getNamedItem("Height")) != null) {
                try {
                    n2 = Integer.parseInt(attr.getValue());
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if ((attr = (Attr)element2.getAttributes().getNamedItem("Display")) != null) {
                string = attr.getValue();
                if (string != null && string.equalsIgnoreCase("Browser")) {
                    bl = true;
                } else if (string != null && string.equalsIgnoreCase("Application")) {
                    bl = false;
                }
            }
            if (bl = true) {
                try {
                    BrowserLauncher.openURL(string2);
                }
                catch (IOException iOException) {
                    Log.singleton().logNewMessage(new InfoMessage("Could not launch browser due to: " + iOException.toString()));
                }
            } else {
                try {
                    new HTMLFrame(new URL(string2), new Dimension(n, n2));
                }
                catch (MalformedURLException malformedURLException) {}
            }
            ++n3;
        }
        Application.singleton().getApplicationFrame().toFront();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean downloadFile(URL uRL, File file, ProgressIndicator progressIndicator, boolean bl) throws IOException {
        boolean bl2;
        if (!this.isAllowedToDownload(uRL)) {
            return false;
        }
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.connect();
        Log.singleton().logNewMessage(new InfoMessage(String.valueOf(uRL.getFile()) + " was last modified on: " + new Date(uRLConnection.getLastModified()), true));
        if (file.lastModified() > uRLConnection.getLastModified() && bl) {
            Log.singleton().logNewMessage(new InfoMessage("Not downloading. Local file is newer than remote file.", true));
            return false;
        }
        InputStream inputStream = uRLConnection.getInputStream();
        ProgressIndicatorInputStream progressIndicatorInputStream = new ProgressIndicatorInputStream(new BufferedInputStream(new BufferedInputStream(inputStream)), progressIndicator);
        progressIndicator.use("Downloading " + file.getName(), 0, uRLConnection.getContentLength());
        try {
            this.writeURLStreamToFile(progressIndicatorInputStream, file);
            Log.singleton().logNewMessage(new InfoMessage("Finished downloading.", true));
            bl2 = true;
            Object var10_9 = null;
            if (progressIndicatorInputStream == null) return bl2;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (progressIndicatorInputStream == null) throw throwable;
            progressIndicatorInputStream.close();
            throw throwable;
        }
        progressIndicatorInputStream.close();
        return bl2;
    }

    private Element findMatchingItem(NodeList nodeList, URL uRL) {
        Node node = null;
        Attr attr = null;
        String string = null;
        int n = 0;
        while (n < nodeList.getLength()) {
            node = nodeList.item(n);
            attr = (Attr)node.getAttributes().getNamedItem("Uri");
            string = attr.getValue();
            if (string != null && string.equals(uRL.getPath())) {
                return (Element)node;
            }
            ++n;
        }
        return null;
    }

    private boolean isAllowedToDownload(URL uRL) {
        try {
            Document document = this.parseDocument(this.constructAutoDownloadInfoUrl(uRL));
            if (document == null) {
                return false;
            }
            if (this.isGloballyDisabledForMe(document)) {
                return false;
            }
            return this.processDownloadInfos(document, uRL);
        }
        catch (MalformedURLException malformedURLException) {
            Log.singleton().logNewMessage(new ErrorMessage("There was an error downloading: " + uRL.toExternalForm(), true));
            return false;
        }
    }

    private boolean isGloballyDisabledForMe(Document document) {
        NodeList nodeList = document.getDocumentElement().getElementsByTagName("GloballyDisabled");
        Node node = null;
        Attr attr = null;
        String string = null;
        int n = 0;
        while (n < nodeList.getLength()) {
            node = nodeList.item(n);
            attr = (Attr)node.getAttributes().getNamedItem("Application");
            string = attr.getValue();
            if (string != null && string.equalsIgnoreCase("PWCPP") && (string = (attr = (Attr)node.getAttributes().getNamedItem("Version")).getValue()) != null && string.equalsIgnoreCase(Application.singleton().getApplicationInfo().getVersionNumber())) {
                Log.singleton().logNewMessage(new WarningMessage("Auto download is disabled for the version of PWCPP you are using.", true));
                attr = (Attr)node.getAttributes().getNamedItem("Hint");
                if (attr != null && (string = attr.getValue()) != null) {
                    Log.singleton().logNewMessage(new InfoMessage(string, true));
                }
                return true;
            }
            ++n;
        }
        return false;
    }

    private Document parseDocument(URL uRL) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(false);
            documentBuilderFactory.setValidating(true);
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return documentBuilder.parse(uRL.toExternalForm());
        }
        catch (SAXException sAXException) {
            Log.singleton().logNewMessage(new ErrorMessage("Cannot parse download infos due to: " + sAXException.toString(), true));
        }
        catch (IOException iOException) {
            Log.singleton().logNewMessage(new ErrorMessage("Cannot parse download infos due to: " + iOException.toString(), true));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Log.singleton().logNewMessage(new ErrorMessage("Cannot parse download infos due to: " + parserConfigurationException.toString(), true));
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            Log.singleton().logNewMessage(new ErrorMessage("Cannot parse download infos due to: " + factoryConfigurationError.toString(), true));
        }
        return null;
    }

    private boolean processDownloadInfos(Document document, URL uRL) {
        NodeList nodeList = document.getDocumentElement().getElementsByTagName("Item");
        Element element = this.findMatchingItem(nodeList, uRL);
        if (element == null) {
            return true;
        }
        try {
            this.displayTeasers(element);
        }
        catch (Throwable throwable) {
            Log.singleton().logNewMessage(new ErrorMessage("Cannot display teasers due to: " + throwable.toString()));
            return false;
        }
        Attr attr = (Attr)element.getAttributes().getNamedItem("AutoDownloadAllowed");
        String string = attr.getValue();
        if (string != null && !string.equalsIgnoreCase("No")) {
            return true;
        }
        Log.singleton().logNewMessage(new InfoMessage("Download of URL " + uRL + " is disabled", true));
        return false;
    }

    private void writeURLStreamToFile(InputStream inputStream, File file) throws IOException, FileNotFoundException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        int n = -1;
        try {
            while ((n = inputStream.read()) != -1) {
                bufferedOutputStream.write(n);
            }
        }
        finally {
            Object var6_5 = null;
            if (bufferedOutputStream != null) {
                bufferedOutputStream.close();
            }
        }
    }
}

