/*
 * Decompiled with CFR 0.152.
 */
package pw.palmpatch.util;

import com.holub.tools.Singleton_registry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;

public class Tracing {
    public static int TRACE_ENTRY_EXIT = 1;
    public static int TRACE_GREAT_DETAIL = 2;
    public static int TRACE_MEDIUM_DETAIL = 4;
    public static int TRACE_SMALL_DETAIL = 8;
    private static Tracing singelton;
    protected int level;
    protected DateFormat aDateFormat = DateFormat.getTimeInstance();
    protected boolean enabled;
    protected String separator = "    ";
    protected PrintStream out = System.out;
    public static final String destinationFile = "destinationFile";
    public static final String destinationConsole = "destinationConsole";
    static /* synthetic */ Class class$pw$palmpatch$util$Tracing;

    static {
        Singleton_registry.register(class$pw$palmpatch$util$Tracing != null ? class$pw$palmpatch$util$Tracing : (class$pw$palmpatch$util$Tracing = Tracing.class$("pw.palmpatch.util.Tracing")));
    }

    private Tracing() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void cleanUp() {
        this.out.close();
    }

    public void enable(boolean bl) {
        this.enabled = bl;
        if (this.enabled) {
            System.out.println("Tracing has been enabled.");
        } else {
            System.out.println("Tracing has been disabled.");
        }
    }

    public int getLevel() {
        return this.level;
    }

    public void setDestination(String string) {
        if (destinationFile.equals(string)) {
            try {
                File file = new File(System.getProperty("user.home"));
                File file2 = new File(file, ".pwcpp");
                if (!file2.exists()) {
                    file2.mkdir();
                }
                File file3 = new File(file2, "trace.txt");
                this.out = new PrintStream(new FileOutputStream(file3));
            }
            catch (FileNotFoundException fileNotFoundException) {}
        } else {
            this.out = destinationConsole.equals(string) ? System.out : System.out;
        }
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public static Tracing singleton() {
        if (singelton == null) {
            Class clazz = class$pw$palmpatch$util$Tracing != null ? class$pw$palmpatch$util$Tracing : (class$pw$palmpatch$util$Tracing = Tracing.class$("pw.palmpatch.util.Tracing"));
            synchronized (clazz) {
                if (singelton == null) {
                    singelton = new Tracing();
                }
            }
        }
        return singelton;
    }

    public void trace(String string) {
        this.trace(string, TRACE_GREAT_DETAIL);
    }

    public void trace(String string, int n) {
        if (this.enabled && (this.level & n) > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.aDateFormat.format(new Date()));
            stringBuffer.append(this.separator);
            stringBuffer.append(string);
            stringBuffer.append(this.separator);
            stringBuffer.append(n);
            this.out.println(stringBuffer.toString());
            this.out.flush();
        }
    }

    public void traceEntry(Object object, String string, String string2) {
        if (this.enabled && (this.level & TRACE_ENTRY_EXIT) > 0) {
            this.traceEntryOrExit(object, string, string2, "Entry:");
        }
    }

    protected void traceEntryOrExit(Object object, String string, String string2, String string3) {
        String string4 = object.getClass().getName();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.aDateFormat.format(new Date()));
        stringBuffer.append(this.separator);
        stringBuffer.append(string3);
        stringBuffer.append(this.separator);
        stringBuffer.append("Source: ");
        stringBuffer.append(string4.substring(string4.lastIndexOf(".") + 1));
        stringBuffer.append(this.separator);
        stringBuffer.append("Method: ");
        stringBuffer.append(string);
        stringBuffer.append(this.separator);
        stringBuffer.append("Info: ");
        stringBuffer.append(string2);
        this.out.println(stringBuffer.toString());
        this.out.flush();
    }

    public void traceExit(Object object, String string, String string2) {
        if (this.enabled && (this.level & TRACE_ENTRY_EXIT) > 0) {
            this.traceEntryOrExit(object, string, string2, "Exit:");
        }
    }
}

