/*******************************************************************
 *
 *	Copyright (c) 1998, EVSoft co., Ltd., All Rights Reserved
 *
 *------------------------------------------------------------------
 * FileName:
 *		PlugBase.h
 *
 * Description:
 *		Include file used by PlugBase plugins for PalmOS
 *
 *      Email:  gzevsoft@public.guangzhou.gd.cn
 *
 *      This file may be freely distributed.
 *
 * History:
 *   	9/20/98  - Created by Winter Du
 *
 *******************************************************************/

#ifndef __PLUG_BASE_H__
#define __PLUG_BASE_H__

#include <Common.h>				// PalmPilot common definitions
#include <SystemMgr.rh>			// Needed to create PlugBase Version Number
#include <FeatureMgr.h>			// Needed to get the PlugBase API Pointer

#define	SupportHackMaster

/********************************************************************
 * Type and creator of PlugBase database
 ********************************************************************/
#define	ApplResType				'appl'	//same as sysFileTApplication
#define	CodeResType				'code'

#define	PlugBasePluginType		'PLUG'	// PlugBase plugin PRC type
#define	PlugBaseCreator   		'evPB'	// PlugBase app's creator
#define	PlugBaseBigIconID		1000	// PlugBase big icon ID
#define	PlugBaseSmallIconID		1001	// PlugBase small icon ID

#ifdef	SupportHackMaster
#define	HackPluginType			'HACK'
#define	HackPluginInfoFormID	3000
#define	HackPluginIconStrID		3000
#define	HackPluginConfigFormID	2000
#define	HackPluginConfigCodeID	2000
#define	HackMainFormID			9000
#define	HackPluginTrapIDBegin	1000

#define	FormResType				'tFRM'
#define	TRAPResType				'TRAP'
#endif


/********************************************************************
 * Feature Number of PlugBase
 ********************************************************************/
#define	PBFtrNum_APIPtr		100


// PlugBase VERSION
//
// The PlugBase version scheme follows the system versioning scheme.
// See sysMakeROMVersion and friends in SystemMgr.h.
//
// For reference:
//
// 0xMMmfsbbb, where MM is major version, m is minor version
// f is bug fix, s is stage: 3-release,2-beta,1-alpha,0-development,
// bbb is build number for non-releases
// V1.12b3   would be: 0x01122003
// V2.00a2   would be: 0x02001002
// V1.01     would be: 0x01013000

// V1.0b1
#define PlugBaseVersion		sysMakeROMVersion(1, 0, 0, sysROMStageBeta, 1)

#define PlugBaseAPIVersion	1

/********************************************************************
 * Public Structures
 ********************************************************************/

enum ScreenAreaChoices {
	applButton,
	menuButton,
	calcButton,
	findButton,
	screenArea,
	graffitiArea,
	graffitiLetterUpArea,
	graffitiLetterDownArea,
	graffitiNumberUpArea,
	graffitiNumberDownArea,
	disableSoftPenStroke,

	NumToAreaChoices,
	NumFromAreaChoices = (findButton+1),
	NumAreaChoices = NumToAreaChoices
};
typedef enum ScreenAreaChoices ScreenAreaType;

typedef enum {areaFrom, areaTo} AreaMode;

typedef struct tagSoftPenStrokeType {
ULong			type;		// Type of application which install the SoftPenStroke
ULong			creator;	// Creator of application which install the SoftPenStroke
UInt			id;			// An application can install several SoftPenStroke,
							// each SoftPenStroke identified by this ID,
							// maybe 0..MAX UInt
ScreenAreaType  penFrom;	// From Area
ScreenAreaType  penTo;		// To Area
} SoftPenStrokeType, *SoftPenStrokePtr;


typedef struct tagHookTrapType {
ULong			type;			// Type of application
ULong			creator;		// Creator of application
UInt			trapNum;		// Trap Number
VoidPtr			newTrapAddr;	// New Trap address
VoidPtr			oldTrapAddr;	// Return SysTrap address before hooked
} HookTrapType, *HookTrapPtr;


/********************************************************************
 * API Prototypes
 ********************************************************************/
#ifdef __cplusplus
extern "C" {
#endif

typedef DWord    (*PBGetVersionPtr)    (void);
typedef DWord    (*PBGetAPIVersionPtr) (void);

typedef Err      (*PBPluginEnablePtr)  (ULong type, ULong creator, Boolean enableIt);
typedef Boolean  (*PBPluginEnabledPtr) (ULong type, ULong creator);

typedef Err      (*PBHookSysTrapPtr)   (HookTrapPtr trapP);
typedef Err      (*PBUnhookSysTrapPtr) (HookTrapPtr trapP);
typedef Boolean  (*PBSysTrapHookedPtr) (HookTrapPtr trapP);

typedef Err      (*PBInstallSoftPenStrokePtr)   (SoftPenStrokePtr psP);
typedef Err      (*PBUninstallSoftPenStrokePtr) (SoftPenStrokePtr psP);
typedef Err      (*PBGetSoftPenStrokePtr)       (SoftPenStrokePtr psP);
typedef Boolean  (*PBCheckSoftPenStrokePtr)     (SoftPenStrokePtr psP, SoftPenStrokePtr psOccupiedByP);
typedef CharPtr* (*PBGetSoftPenStrokeChoicesPtr)     (UIntPtr numItemsP, AreaMode areaMode, Boolean longDesc);
typedef void     (*PBSetSoftPenStrokeListChoicesPtr) (ListPtr list,      AreaMode areaMode, Boolean longDesc);

#ifdef __cplusplus
}
#endif


typedef struct {
	PBGetVersionPtr						getVersion;
	PBGetAPIVersionPtr					getAPIVersion;

	PBPluginEnablePtr					pluginEnable;
	PBPluginEnabledPtr					pluginEnabled;
	
	PBHookSysTrapPtr					hookSysTrap;
	PBUnhookSysTrapPtr					unhookSysTrap;
	PBSysTrapHookedPtr					sysTrapHooked;

	PBInstallSoftPenStrokePtr			installSoftPenStroke;
	PBUninstallSoftPenStrokePtr			uninstallSoftPenStroke;
	PBGetSoftPenStrokePtr				getSoftPenStroke;
	PBCheckSoftPenStrokePtr				checkSoftPenStroke;
	PBGetSoftPenStrokeChoicesPtr		getSoftPenStrokeChoices;
	PBSetSoftPenStrokeListChoicesPtr	setSoftPenStrokeListChoices;
} PlugBaseAPIType, *PlugBaseAPIPtr;

/************************************************************
 * PlugBase result codes
 *************************************************************/
#define pbErrorClass				(appErrorClass+0x2000)
#define pbErrInvalidParam			(pbErrorClass | 1)
#define pbErrNotEnoughSpace			(pbErrorClass | 2)
#define pbErrNotFound				(pbErrorClass | 3)
#define pbErrNotValidPlugin			(pbErrorClass | 4)
#define pbErrSoftPenStrokeUsed		(pbErrorClass | 5)

//------------------------------------------------------------------------
// PlugBase Launch Command
//------------------------------------------------------------------------
//
typedef enum {
	PBLaunchCmd_GetInformation = sysAppLaunchCmdCustomBase+'PB',
	PBLaunchCmd_PluginAttach,
	PBLaunchCmd_PluginDetach,
	PBLaunchCmd_ActivePluginInfoPanel,
	PBLaunchCmd_ActivePluginControlPanel,
	PBLaunchCmd_SoftPenStroke
} PlugBaseLaunchCmds;


//------------------------------------------------------------------------
// Parameter blocks for Launch Command
//------------------------------------------------------------------------

typedef struct {
	ULong			id;				// Launch command identifier for PlugBase,
									// seted to PlugBaseCreator['evPB']
									// by PlugBase before launch
	ULong			pluginType;		// Type of plugin PRC
	ULong			pluginCreator;	// Creator of plugin PRC
	PlugBaseAPIPtr	apiP;			// PlugBase API pointer
	Err				err;			// error code, plugin must set this value after process
									// 0 no error
	union param {
		struct allParam {
			Word data[8];
		} allParam;

		// For PBLaunchCmd_GetInformation
		struct {
			Boolean		supportInfoPanel;
			Boolean		supportConfigPanel;
		} getInformation;

		// For PBLaunchCmd_SoftPenStroke
		struct {
			UInt		id;
		} softPenStroke;

	} data;

} PBLaunchParameterType, *PBLaunchParameterPtr;


/********************************************************************
 * Public Macros
 ********************************************************************/

// Get PlugBase API pointer
#define	PBGetAPIPtr(ptr)											\
{																	\
	DWord	ftrRet;													\
																	\
	ptr = 0;														\
	if (FtrGet (PlugBaseCreator, PBFtrNum_APIPtr, &ftrRet) == 0)	\
		ptr = (PlugBaseAPIPtr) ftrRet;								\
}

#endif	// __PLUG_BASE_H__

