#include "SkinDefs.r"


/* HandEra skin */
resource 'Skin' (1) {
	1,							/* Skin version - must be 1 for this skin structure */
	"Basique",				/* Skin name - can be 23 chars + zero at the end */
	HANDERA,					/* High resolution mode */
	4,							/* Minimal supported color depth */
	
	24,						/* Title height */
	YES,						/* Standard Palm OS title with time */
	0,							/* Title bar bitmap ID */
	{0, 0, 0, 0},			/* Title bar rectangle */

	9002,						/* Refresh button bitmap ID */
	9042,						/* Refresh button selected bitmap ID */
	{60, 3, 15, 15},		/* Refresh button rectangle */

	9003,						/* Memory bitmap ID */
	{80, 1, 47, 18},		/* Memory - the full size rectangle */
	{81, 4, 42, 11},		/* Memory - bar display rectangle */
	0,							/* Memory - delimiting vertical line color color */
	12,						/* Memory - delimiting vertical line color gray */

	9004,						/* Battery bitmap ID */
	9025,						/* Battery charging bitmap ID */
	{128, 1, 47, 18},		/* Battery - the full size rectangle */
	{130, 4, 38, 11},		/* Battery - bar display rectangle */
	0,							/* Battery - delimiting vertical line color color */
	11,						/* Battery - delimiting vertical line color gray */
	
	9014,						/* Homer bitmap ID */
	9054,						/* Homer selected bitmap ID */
	{0, 225, 15, 15},		/* Homer bitmap rectangle */
	{0, 225, 15, 15},		/* Homer hot-spot rectangle */

	9013,						/* Gadget toggle bitmap ID */
	9053,						/* Gadget toggle selected bitmap ID */
	{225, 225, 15, 15},	/* Gadget toggle bitmap rectangle */
	{225, 225, 15, 15},	/* Gadget toggle hot-spot rectangle */

	9012,						/* Gadget bar background bitmap ID */
	{0, 202, 240, 38},	/* Gadget bar background rectangle */

	7,							/* Number of visible gadgets (max is 16) */
	NO,						/* Gadgets vertical */
	{22, 205},				/* starting point for drawing gadgets */
	0,							/* gadget horizontal padding */
	28,						/* gadget width */
	32,						/* gadget height */
	
	13,						/* Number of gadgets */
	9100,						/* First gadget bitmap ID */
	9200,						/* First gadget selected bitmap ID */
	
	9151,						/* GadgetLockUnlock bitmapID */
	9152,						/* GadgetLockUnlock selected bitmapID */
	
	{2, 24, 227, 201},	/* App area - gadgets hidden*/
	{2, 24, 227, 178},	/* App area - gadgets drawn*/
	
	DEFAULT,					/* Scrollbar position */
	11,						/* Scrollbar width */
	0,							/* Scrollbar background color color */
	0,							/* Scrollbar background color gray */
	0,							/* Scrollbar foreground color color */
	15,						/* Scrollbar foreground color gray */
	0,							/* Scrollbar vertical size correction */

	14,						/* Number of category icons */
	4300,						/* First category icon bitmap ID */
	16,						/* Category icon width */
	15,						/* Category icon height */

	NONE,						/* Tabs position */
	NO,						/* Two rows of tabs */
	0,							/* Bitmap ID of the slice: left */
	0,							/* Bitmap ID of the slice: selected left */
	0,							/* Bitmap ID of the slice: selected right */
	0,							/* Bitmap ID of the slice: right */	
	0,							/* Bitmap ID of the slice: left after selected */
	0,							/* Bitmap ID of the slice: right - non-last tab */
	0,							/* Slice height */
	0,							/* Left slice width */
	0,							/* Upper line thickness */
	0,							/* Non-selected real height */
	
	0,							/* Bitmap ID of the "Previous tab" scroll arrow */
	0,							/* Bitmap ID of the "Next tab" scroll arrow */
	0,							/* Tab scroll arrow height */
	0,							/* Tab scroll arrow width */

	0,							/* horizontal offset from the left side of the left slice */
	0,							/* horizontal offset from the left side of the "afer selected" slice */
	0,							/* horizontal offset from the right side of the right slice */
	0,							/* horizontal offset from the right side of the "before selected" slice */
	0,							/* vertical offset from the top of the slice */
	0,							/* vertical offset from the top of the selected slice */

	{0, 23, 240, 217}		/* App area to be painted with the background color */
	};

resource 'Skin' (2) {
	1,							/* Skin version - must be 1 for this skin structure */
	"Classique-Top",		/* Skin name - can be 23 chars + zero at the end */
	HANDERA,					/* High resolution mode */
	4,							/* Minimal supported color depth */
	
	18,						/* Title height */
	NO,						/* Standard Palm OS title with time */
	9001,						/* Title bar bitmap ID */
	{0, 0, 117, 18},		/* Title bar rectangle */

	9002,						/* Refresh button bitmap ID */
	9042,						/* Refresh button selected bitmap ID */
	{120, 3, 15, 15},		/* Refresh button rectangle */

	9003,						/* Memory bitmap ID */
	{140, 1, 47, 18},		/* Memory - the full size rectangle */
	{141, 4, 42, 11},		/* Memory - bar display rectangle */
	0,							/* Memory - delimiting vertical line color color */
	12,						/* Memory - delimiting vertical line color gray */

	9004,						/* Battery bitmap ID */
	9025,						/* Battery charging bitmap ID */
	{188, 1, 47, 18},		/* Battery - the full size rectangle */
	{190, 4, 38, 11},		/* Battery - bar display rectangle */
	0,							/* Battery - delimiting vertical line color color */
	11,						/* Battery - delimiting vertical line color gray */
	
	9014,						/* Homer bitmap ID */
	9054,						/* Homer selected bitmap ID */
	{0, 225, 15, 15},		/* Homer bitmap rectangle */
	{0, 225, 15, 15},		/* Homer hot-spot rectangle */

	9013,						/* Gadget toggle bitmap ID */
	9053,						/* Gadget toggle selected bitmap ID */
	{225, 225, 15, 15},	/* Gadget toggle bitmap rectangle */
	{225, 225, 15, 15},	/* Gadget toggle hot-spot rectangle */

	9012,						/* Gadget bar background bitmap ID */
	{0, 202, 240, 38},	/* Gadget bar background rectangle */

	7,							/* Number of visible gadgets (max is 16) */
	NO,						/* Gadgets vertical */
	{22, 205},				/* starting point for drawing gadgets */
	0,							/* gadget horizontal padding */
	28,						/* gadget width */
	32,						/* gadget height */
	
	13,						/* Number of gadgets */
	9100,						/* First gadget bitmap ID */
	9200,						/* First gadget selected bitmap ID */
	
	9151,						/* GadgetLockUnlock bitmapID */
	9152,						/* GadgetLockUnlock selected bitmapID */
	
	{2, 45, 227, 180},	/* App area - gadgets hidden*/
	{2, 45, 227, 157},	/* App area - gadgets drawn*/
	
	DEFAULT,					/* Scrollbar position */
	11,						/* Scrollbar width */
	0,							/* Scrollbar background color color */
	0,							/* Scrollbar background color gray */
	0,							/* Scrollbar foreground color color */
	15,						/* Scrollbar foreground color gray */
	0,							/* Scrollbar vertical size correction */

	14,						/* Number of category icons */
	4300,						/* First category icon bitmap ID */
	16,						/* Category icon width */
	15,							/* Category icon height */
/***********/
	UP,						/* Tabs position */
	NO,						/* Two rows of tabs */
	4200,						/* Bitmap ID of the slice: left */
	4201,						/* Bitmap ID of the slice: selected left */
	4202,						/* Bitmap ID of the slice: selected right */
	4203,						/* Bitmap ID of the slice: right */	
	4214,						/* Bitmap ID of the slice: left after selected */
	4214,						/* Bitmap ID of the slice: right - non-last tab */
	24,						/* Slice height */
	8,							/* Slice width */
	1,							/* Upper line thickness */
	21,						/* Non-selected real height */
	
	4204,						/* Bitmap ID of the "Previous tab" scroll arrow */
	4205,						/* Bitmap ID of the "Next tab" scroll arrow */
	15,						/* Tab scroll arrow height */
	10,						/* Tab scroll arrow width */

	6,							/* horizontal offset from the left side of the left slice */
	2,							/* horizontal offset from the left side of the "afer selected" slice */
	3,							/* horizontal offset from the right side of the right slice */
	2,							/* horizontal offset from the right side of the "before selected" slice */
	3,							/* vertical offset from the top of the slice */
	5,							/* vertical offset from the top of the selected slice */

	{0, 44, 240, 196}		/* App area to be painted with the background color */
	};

resource 'Skin' (3) {
	1,							/* Skin version - must be 1 for this skin structure */
	"Classique-Left",		/* Skin name - can be 23 chars + zero at the end */
	HANDERA,					/* High resolution mode */
	4,							/* Minimal supported color depth */
	
	18,						/* Title height */
	NO,						/* Standard Palm OS title with time */
	9001,						/* Title bar bitmap ID */
	{0, 0, 117, 18},		/* Title bar rectangle */

	9002,						/* Refresh button bitmap ID */
	9042,						/* Refresh button selected bitmap ID */
	{120, 2, 15, 15},		/* Refresh button rectangle */

	9003,						/* Memory bitmap ID */
	{140, 1, 47, 18},		/* Memory - the full size rectangle */
	{141, 4, 42, 11},		/* Memory - bar display rectangle */
	0,							/* Memory - delimiting vertical line color color */
	12,						/* Memory - delimiting vertical line color gray */

	9004,						/* Battery bitmap ID */
	9025,						/* Battery charging bitmap ID */
	{188, 1, 47, 18},		/* Battery - the full size rectangle */
	{190, 4, 38, 11},		/* Battery - bar display rectangle */
	0,							/* Battery - delimiting vertical line color color */
	11,						/* Battery - delimiting vertical line color gray */
	
	9014,						/* Homer bitmap ID */
	9054,						/* Homer selected bitmap ID */
	{0, 225, 15, 15},		/* Homer bitmap rectangle */
	{0, 225, 15, 15},		/* Homer hot-spot rectangle */

	9013,						/* Gadget toggle bitmap ID */
	9053,						/* Gadget toggle selected bitmap ID */
	{225, 225, 15, 15},	/* Gadget toggle bitmap rectangle */
	{225, 225, 15, 15},	/* Gadget toggle hot-spot rectangle */

	9012,						/* Gadget bar background bitmap ID */
	{0, 202, 240, 38},	/* Gadget bar background rectangle */

	7,							/* Number of visible gadgets (max is 16) */
	NO,						/* Gadgets vertical */
	{22, 205},				/* starting point for drawing gadgets */
	0,							/* gadget horizontal padding */
	28,						/* gadget width */
	32,						/* gadget height */
	
	13,						/* Number of gadgets */
	9100,						/* First gadget bitmap ID */
	9200,						/* First gadget selected bitmap ID */
	
	9151,						/* GadgetLockUnlock bitmapID */
	9152,						/* GadgetLockUnlock selected bitmapID */
	
	{61, 22, 167, 203},	/* App area - gadgets hidden*/
	{61, 22, 167, 180},	/* App area - gadgets drawn*/
	
	DEFAULT,					/* Scrollbar position */
	11,						/* Scrollbar width */
	0,							/* Scrollbar background color color */
	0,							/* Scrollbar background color gray */
	0,							/* Scrollbar foreground color color */
	15,						/* Scrollbar foreground color gray */
	0,							/* Scrollbar vertical size correction */

	14,						/* Number of category icons */
	4300,						/* First category icon bitmap ID */
	16,						/* Category icon width */
	15,							/* Category icon height */
/***********/
	LEFT,						/* Tabs position */
	NO,						/* Two rows of tabs */
	4206,						/* Bitmap ID of the slice: left */ /* unselected */
	4207,						/* Bitmap ID of the slice: selected left */ /* selected */
	4208,						/* Bitmap ID of the slice: selected right */ /* unselected last */
	9,							/* Bitmap ID of the slice: right */ /* max number of tabs */
	0,							/* Bitmap ID of the slice: left after selected */
	0,							/* Bitmap ID of the slice: right - non-last tab */
	20,						/* Slice height */ /* unselected height */
	60,						/* Left slice width */ /* total width */
	54,						/* Right slice width */ /* unselected width */
	23,						/* Non-selected real height *//* last & selected height */
	
	4209,						/* Bitmap ID of the "Previous tab" scroll arrow */
	4210,						/* Bitmap ID of the "Next tab" scroll arrow */
	10,							/* Tab scroll arrow height */
	15,							/* Tab scroll arrow width */

	0,							/* horizontal offset from the left side of the left slice */
	0,							/* horizontal offset from the left side of the "afer selected" slice */
	0,							/* horizontal offset from the right side of the right slice */
	0,							/* horizontal offset from the right side of the "before selected" slice */
	0,							/* vertical offset from the top of the slice */
	0,							/* vertical offset from the top of the selected slice */

	{60, 21, 180, 219}	/* App area to be painted with the background color */
	};

resource 'Skin' (4) {
	1,							/* Skin version - must be 1 for this skin structure */
	"Classique-Right",	/* Skin name - can be 23 chars + zero at the end */
	HANDERA,					/* High resolution mode */
	4,							/* Minimal supported color depth */
	
	18,						/* Title height */
	NO,						/* Standard Palm OS title with time */
	9001,						/* Title bar bitmap ID */
	{0, 0, 117, 18},		/* Title bar rectangle */

	9002,						/* Refresh button bitmap ID */
	9042,						/* Refresh button selected bitmap ID */
	{120, 2, 15, 15},		/* Refresh button rectangle */

	9003,						/* Memory bitmap ID */
	{140, 1, 47, 18},		/* Memory - the full size rectangle */
	{141, 4, 42, 11},		/* Memory - bar display rectangle */
	0,							/* Memory - delimiting vertical line color color */
	12,						/* Memory - delimiting vertical line color gray */

	9004,						/* Battery bitmap ID */
	9025,						/* Battery charging bitmap ID */
	{188, 1, 47, 18},		/* Battery - the full size rectangle */
	{190, 4, 38, 11},		/* Battery - bar display rectangle */
	0,							/* Battery - delimiting vertical line color color */
	11,						/* Battery - delimiting vertical line color gray */
	
	9014,						/* Homer bitmap ID */
	9054,						/* Homer selected bitmap ID */
	{0, 225, 15, 15},		/* Homer bitmap rectangle */
	{0, 225, 15, 15},		/* Homer hot-spot rectangle */

	9013,						/* Gadget toggle bitmap ID */
	9053,						/* Gadget toggle selected bitmap ID */
	{225, 225, 15, 15},	/* Gadget toggle bitmap rectangle */
	{225, 225, 15, 15},	/* Gadget toggle hot-spot rectangle */

	9012,						/* Gadget bar background bitmap ID */
	{0, 202, 240, 38},	/* Gadget bar background rectangle */

	7,							/* Number of visible gadgets (max is 16) */
	NO,						/* Gadgets vertical */
	{22, 205},				/* starting point for drawing gadgets */
	0,							/* gadget horizontal padding */
	28,						/* gadget width */
	32,						/* gadget height */
	
	13,						/* Number of gadgets */
	9100,						/* First gadget bitmap ID */
	9200,						/* First gadget selected bitmap ID */
	
	9151,						/* GadgetLockUnlock bitmapID */
	9152,						/* GadgetLockUnlock selected bitmapID */
	
	{1, 22, 167, 203},	/* App area - gadgets hidden*/
	{1, 22, 167, 180},	/* App area - gadgets drawn*/
	
	DEFAULT,					/* Scrollbar position */
	11,						/* Scrollbar width */
	0,							/* Scrollbar background color color */
	0,							/* Scrollbar background color gray */
	0,							/* Scrollbar foreground color color */
	15,						/* Scrollbar foreground color gray */
	0,							/* Scrollbar vertical size correction */

	14,						/* Number of category icons */
	4300,						/* First category icon bitmap ID */
	16,						/* Category icon width */
	15,							/* Category icon height */
/***********/
	RIGHT,					/* Tabs position */
	NO,						/* Two rows of tabs */
	4211,						/* Bitmap ID of the slice: left */ /* unselected */
	4212,						/* Bitmap ID of the slice: selected left */ /* selected */
	4213,						/* Bitmap ID of the slice: selected right */ /* unselected last */
	9,							/* Bitmap ID of the slice: right */ /* max number of tabs */
	0,							/* Bitmap ID of the slice: left after selected */
	0,							/* Bitmap ID of the slice: right - non-last tab */
	20,						/* Slice height */ /* unselected height */
	60,						/* Left slice width */ /* total width */
	54,						/* Right slice width */ /* unselected width */
	23,						/* Non-selected real height *//* last & selected height */
	
	4209,						/* Bitmap ID of the "Previous tab" scroll arrow */
	4210,						/* Bitmap ID of the "Next tab" scroll arrow */
	10,						/* Tab scroll arrow height */
	15,						/* Tab scroll arrow width */

	0,							/* horizontal offset from the left side of the left slice */
	0,							/* horizontal offset from the left side of the "afer selected" slice */
	0,							/* horizontal offset from the right side of the right slice */
	0,							/* horizontal offset from the right side of the "before selected" slice */
	0,							/* vertical offset from the top of the slice */
	0,							/* vertical offset from the top of the selected slice */

	{0, 21, 180, 219}	/* App area to be painted with the background color */
	};
