\ table68k.fr - Instructions to build the m68k disassembler.
\ 
\ 0 : literal 0
\ 1 : literal 1
\ c : condition code
\ C : condition codes, except F
\ d : mode, except immediate and pc-relative
\ D : reg, except immediate and pc-relative
\ f : direction
\ i : immediate
\ I : immediate, except 0
\ j : immediate 8, 1..7
\ J : immediate 0..15
\ r : reg
\ R : reg
\ s : mode
\ S : reg
\ z : size
\
\ Arp: --> -(Ar)
\ ArP: --> (Ar)+
\
\ definst bitpattern : processor level priviledge level : instruction

definst 0000 0000 0011 1100:00: ORSR.B  #1
definst 0000 0000 0111 1100:02: ORSR.W  #1
definst 0000 0000 zzdd dDDD:00: OR.z    #z,d[!Areg]
definst 0000 0010 0011 1100:00: ANDSR.B #1
definst 0000 0010 0111 1100:02: ANDSR.W #1
definst 0000 0010 zzdd dDDD:00: AND.z   #z,d[!Areg]
definst 0000 0100 zzdd dDDD:00: SUB.z   #z,d[!Areg]
definst 0000 0110 zzdd dDDD:00: ADD.z   #z,d[!Areg]
definst 0000 1000 00ss sSSS:00: BTST    #1,s[!Areg]
definst 0000 1000 01ss sSSS:00: BCHG    #1,s[!Areg,Immd]
definst 0000 1000 10ss sSSS:00: BCLR    #1,s[!Areg,Immd]
definst 0000 1000 11ss sSSS:00: BSET    #1,s[!Areg,Immd]
definst 0000 1010 0011 1100:00: EORSR.B #1
definst 0000 1010 0111 1100:02: EORSR.W #1
definst 0000 1010 zzdd dDDD:00: EOR.z   #z,d[!Areg]
definst 0000 1100 zzdd dDDD:00: CMP.z   #z,d[!Areg]
definst 0000 1010 11ss sSSS:20: CAS.L   #1,s[!Immd]
definst 0000 rrr1 00dd dDDD:00: MVPMR.W d[Areg-Ad16],Dr
definst 0000 rrr1 01dd dDDD:00: MVPMR.L d[Areg-Ad16],Dr
definst 0000 rrr1 10dd dDDD:00: MVPRM.W Dr,d[Areg-Ad16]
definst 0000 rrr1 11dd dDDD:00: MVPRM.L Dr,d[Areg-Ad16]
definst 0000 rrr1 00ss sSSS:00: BTST    Dr,s[!Areg]
definst 0000 rrr1 01ss sSSS:00: BCHG    Dr,s[!Areg,Immd]
definst 0000 rrr1 10ss sSSS:00: BCLR    Dr,s[!Areg,Immd]
definst 0000 rrr1 11ss sSSS:00: BSET    Dr,s[!Areg,Immd]
definst 0001 DDDd ddss sSSS:00: MOVE.B  s,d[!Areg]
definst 0010 DDDd ddss sSSS:00: MOVEA.L s,d[Areg]
definst 0010 DDDd ddss sSSS:00: MOVE.L  s,d[!Areg]
definst 0011 DDDd ddss sSSS:00: MOVEA.W s,d[Areg]
definst 0011 DDDd ddss sSSS:00: MOVE.W  s,d[!Areg]
definst 0100 0000 zzdd dDDD:00: NEGX.z  d[!Areg]
definst 0100 0000 11dd dDDD:01: MVSR2.W d[!Areg]
definst 0100 0010 zzdd dDDD:00: CLR.z   d[!Areg]
definst 0100 0010 11dd dDDD:10: MVSR2.B d[!Areg]
definst 0100 0100 zzdd dDDD:00: NEG.z   d[!Areg]
definst 0100 0100 11ss sSSS:00: MV2SR.B s[!Areg]
definst 0100 0110 zzdd dDDD:00: NOT.z   d[!Areg]
definst 0100 0110 11ss sSSS:02: MV2SR.W s[!Areg]
definst 0100 1000 00dd dDDD:00: NBCD.B  d[!Areg]
definst 0100 1000 01ss sSSS:00: SWAP.L  s[Dreg]
definst 0100 1000 01ss sSSS:00: PEA.L   s[!Dreg,Areg,Immd]
definst 0100 1000 10dd dDDD:00: EXT.W   d[Dreg]   
definst 0100 1000 10dd dDDD:00: MVMLE.W d[!Dreg,Areg]
definst 0100 1000 11dd dDDD:00: EXT.L   d[Dreg]
definst 0100 1000 11dd dDDD:00: MVMLE.L #1,d[!Dreg,Areg]
definst 0100 1010 zzdd dDDD:00: TST.z   d
definst 0100 1100 00ss sSSS:20: MULL.L  #1,s
definst 0100 1100 01ss sSSS:20: DIVL.L  #1,s
definst 0100 1100 10ss sSSS:00: MVMEL.W s[!Dreg,Areg,Immd]
definst 0100 1100 11ss sSSS:00: MVMEL.L s[!Dreg,Areg,Immd]
definst 0100 1110 0100 JJJJ:00: TRAP    #J
definst 0100 1110 0101 0rrr:00: LINK.L  Ar,#1
definst 0100 1110 0101 1rrr:00: UNLK.L  Ar
definst 0100 1110 0110 0rrr:02: MVR2USP.L Ar
definst 0100 1110 0110 1rrr:02: MVUSP2R.L Ar
definst 0100 1110 0111 0000:02: RESET
definst 0100 1110 0111 0001:00: NOP
definst 0100 1110 0111 0010:02: STOP    #1
definst 0100 1110 0111 0011:02: RTE
definst 0100 1110 0111 0100:00: RTD     #1
definst 0100 1110 0111 0101:00: RTS
definst 0100 1110 0111 0110:00: TRAPV
definst 0100 1110 0111 0111:00: RTR
definst 0100 1110 0111 1010:12: MOVEC2  #1
definst 0100 1110 0111 1011:12: MOVE2C  #1
definst 0100 1110 10ss sSSS:00: JSR.L   s[!Dreg,Areg,Immd]
definst 0100 rrr1 10ss sSSS:00: CHK.W   s,Dr
definst 0100 1110 11ss sSSS:00: JMP.L   s[!Dreg,Areg,Immd]
definst 0100 rrr1 11ss sSSS:00: LEA.L   s[!Dreg,Areg,Immd],Ar
definst 0101 jjj0 zzdd dDDD:00: ADDA.z  #j,d[Areg]     
definst 0101 jjj0 zzdd dDDD:00: ADD.z   #j,d[!Areg]
definst 0101 jjj1 zzdd dDDD:00: SUBA.z  #j,d[Areg]     
definst 0101 jjj1 zzdd dDDD:00: SUB.z   #j,d[!Areg]
definst 0101 cccc 1100 1rrr:00: DBcc.W  Dr,#1
definst 0101 cccc 11dd dDDD:00: Scc.B   d[!Areg]
definst 0110 0001 0000 0000:00: BSR.W   #1
definst 0110 0001 IIII IIII:00: BSR.B   #I
definst 0110 CCCC 0000 0000:00: Bcc.W   #1
definst 0110 CCCC IIII IIII:00: Bcc.B   #I
definst 0111 rrr0 iiii iiii:00: MOVE.L  #i,Dr
definst 1000 rrr0 zzss sSSS:00: OR.z    s[!Areg],Dr
definst 1000 rrr0 11ss sSSS:00: DIVU.W  s[!Areg],Dr
definst 1000 rrr1 00dd dDDD:00: SBCD.B  d[Dreg],Dr
definst 1000 rrr1 00dd dDDD:00: SBCD.B  d[Areg-Apdi],Arp      
definst 1000 rrr1 00dd dDDD:00: OR.B    Dr,d[!Areg,Dreg]
definst 1000 rrr1 01dd dDDD:00: OR.W    Dr,d[!Areg,Dreg]
definst 1000 rrr1 10dd dDDD:00: OR.L    Dr,d[!Areg,Dreg]
definst 1000 rrr1 11ss sSSS:00: DIVS.W  s[!Areg],Dr
definst 1001 rrr0 zzss sSSS:00: SUB.z   s,Dr
definst 1001 rrr0 11ss sSSS:00: SUBA.W  s,Ar
definst 1001 rrr1 zzdd dDDD:00: SUBX.z  d[Dreg],Dr
definst 1001 rrr1 zzdd dDDD:00: SUBX.z  d[Areg-Apdi],Arp      
definst 1001 rrr1 zzdd dDDD:00: SUB.z   Dr,d[!Areg,Dreg]
definst 1001 rrr1 11ss sSSS:00: SUBA.L  s,Ar
definst 1011 rrr0 zzss sSSS:00: CMP.z   s,Dr
definst 1011 rrr0 11ss sSSS:00: CMPA.W  s,Ar
definst 1011 rrr1 11ss sSSS:00: CMPA.L  s,Ar
definst 1011 rrr1 zzdd dDDD:00: CMPM.z  d[Areg-Aipi],ArP
definst 1011 rrr1 zzdd dDDD:00: EOR.z   Dr,d[!Areg]
definst 1100 rrr0 zzss sSSS:00: AND.z   s[!Areg],Dr
definst 1100 rrr0 11ss sSSS:00: MULU.W  s[!Areg],Dr
definst 1100 rrr1 00dd dDDD:00: ABCD.B  d[Dreg],Dr
definst 1100 rrr1 00dd dDDD:00: ABCD.B  d[Areg-Apdi],Arp
definst 1100 rrr1 00dd dDDD:00: AND.B   Dr,d[!Areg,Dreg]
definst 1100 rrr1 01dd dDDD:00: EXG.L   Dr,d[Dreg]
definst 1100 rrr1 01dd dDDD:00: EXG.L   Ar,d[Areg]      
definst 1100 rrr1 01dd dDDD:00: AND.W   Dr,d[!Areg,Dreg]
definst 1100 rrr1 10dd dDDD:00: EXG.L   Dr,d[Areg]
definst 1100 rrr1 10dd dDDD:00: AND.L   Dr,d[!Areg,Dreg]
definst 1100 rrr1 11ss sSSS:00: MULS.W  s[!Areg],Dr
definst 1101 rrr0 zzss sSSS:00: ADD.z   s,Dr
definst 1101 rrr0 11ss sSSS:00: ADDA.W  s,Ar
definst 1101 rrr1 zzdd dDDD:00: ADDX.z  d[Dreg],Dr
definst 1101 rrr1 zzdd dDDD:00: ADDX.z  d[Areg-Apdi],Arp
definst 1101 rrr1 zzdd dDDD:00: ADD.z   Dr,d[!Areg,Dreg]
definst 1101 rrr1 11ss sSSS:00: ADDA.L  s,Ar
definst 1110 jjjf zz00 0RRR:00: ASf.z   #j,DR
definst 1110 jjjf zz00 1RRR:00: LSf.z   #j,DR
definst 1110 jjjf zz01 0RRR:00: ROXf.z  #j,DR
definst 1110 jjjf zz01 1RRR:00: ROf.z   #j,DR
definst 1110 rrrf zz10 0RRR:00: ASf.z   Dr,DR
definst 1110 rrrf zz10 1RRR:00: LSf.z   Dr,DR
definst 1110 rrrf zz11 0RRR:00: ROXf.z  Dr,DR
definst 1110 rrrf zz11 1RRR:00: ROf.z   Dr,DR
definst 1110 000f 11dd dDDD:00: ASfW.W  d[!Dreg,Areg,PC8r,PC16]
definst 1110 001f 11dd dDDD:00: LSfW.W  d[!Dreg,Areg,PC8r,PC16]
definst 1110 010f 11dd dDDD:00: ROXfW.W d[!Dreg,Areg,PC8r,PC16]
definst 1110 011f 11dd dDDD:00: ROfW.W  d[!Dreg,Areg,PC8r,PC16]
