/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Color;
import waba.fx.Graphics;
import waba.fx.Rect;
import waba.sys.Settings;
import waba.ui.Button;
import waba.ui.Container;
import waba.ui.Control;
import waba.ui.ControlEvent;
import waba.ui.Event;
import waba.ui.ListBox;
import waba.ui.PenEvent;
import waba.ui.PopList;

public class ComboBox
extends Container {
    private PopList f1;
    private Button f2;
    private boolean f3;
    private boolean f4;
    private int f5;
    private Graphics f6;
    private Color f7;
    private Color f8;
    private Color[] f9 = new Color[4];
    private boolean f10 = true;
    public boolean fullHeight;

    public ComboBox() {
        this((Object[])null);
    }

    public ComboBox(ListBox listBox) {
        this(new PopList(listBox));
    }

    public ComboBox(PopList popList) {
        this.f1 = popList;
        this.f2 = Button.createArrowButton((byte)2, this.fmH * 3 / 11, Color.BLACK);
        if (Settings.uiStyle == 1) {
            this.f2.setBorder((byte)0);
        }
        ComboBox comboBox = this;
        super.add(comboBox.f2);
        this.started = true;
    }

    public ComboBox(Object[] objectArray) {
        this(new ListBox(objectArray));
    }

    public void add(Object object) {
        this.f1.lb.add(object);
        this.f10 = true;
        this.repaint();
    }

    public void add(Control control) {
    }

    public void add(Object[] objectArray) {
        this.f1.lb.add(objectArray);
        this.f10 = true;
        this.repaint();
    }

    public Object getItemAt(int n) {
        return this.f1.lb.getItemAt(n);
    }

    public Object[] getItems() {
        return this.f1.lb.getItems();
    }

    public int getPreferredHeight() {
        return this.fmH + (Settings.uiStyle == 1 ? 1 : 4);
    }

    public int getPreferredWidth() {
        return this.f1.getPreferredWidth() + 1;
    }

    public int getSelectedIndex() {
        return this.f1.lb.selectedIndex;
    }

    public Object getSelectedItem() {
        return this.f1.lb.getSelectedItem();
    }

    public int indexOf(Object object) {
        return this.f1.lb.indexOf(object);
    }

    public void insert(Object object, int n) {
        this.f1.lb.insert(object, n);
        this.f10 = true;
        this.repaint();
    }

    protected void onBoundsChanged() {
        Rect rect = this.getAbsoluteRect();
        this.f1.setRect(rect.x, rect.y, this.width, this.height);
        this.f5 = this.f2.getPreferredWidth();
        if (Settings.uiStyle == 1) {
            this.f2.setRect(0, 0, this.f5, this.height);
        } else {
            this.f2.setRect(this.width - this.f5 - 2, 2, this.f5, this.height - 4);
        }
        this.f10 = true;
    }

    protected void onColorsChanged(boolean bl) {
        if (bl) {
            this.f2.setBackForeColors(this.backColor, this.foreColor);
            this.f1.lb.setBackForeColors(this.backColor, this.foreColor);
        }
        this.f7 = this.getBackColor().brighter();
        this.f8 = this.getForeColor();
        Graphics.compute3dColors(this.enabled, this.backColor, this.foreColor, this.f9);
    }

    public void onEvent(Event event) {
        if (!this.f4 || event.type == 499) {
            switch (event.type) {
                case 498: {
                    if (event.target == this.getParentWindow()) {
                        this.onBoundsChanged();
                    }
                    this.repaint();
                    if (this.f6 != null) {
                        this.f6.free();
                    }
                    this.f6 = this.createGraphics();
                    return;
                }
                case 203: {
                    PenEvent penEvent = (PenEvent)event;
                    ComboBox comboBox = this;
                    boolean bl = comboBox.contains(comboBox.x + penEvent.x, this.y + penEvent.y);
                    if (event.target != this || bl == this.f3 || this.f1.lb.itemCount <= 0) break;
                    this.f3 = bl;
                    if (Settings.uiStyle == 1) {
                        this.f6.drawCursor(0, 0, this.width, this.height);
                        return;
                    }
                    this.f2.press(this.f3);
                    return;
                }
                case 200: {
                    if (event.target != this || this.f3 || this.f1.lb.itemCount <= 0) break;
                    if (Settings.uiStyle == 1) {
                        this.f6.drawCursor(0, 0, this.width, this.height);
                    } else {
                        this.f2.press(true);
                    }
                    this.f3 = true;
                    return;
                }
                case 202: {
                    PenEvent penEvent = (PenEvent)event;
                    ComboBox comboBox = this;
                    boolean bl = comboBox.contains(comboBox.x + penEvent.x, this.y + penEvent.y);
                    if (event.target != this || !bl || !this.f3) break;
                    if (Settings.uiStyle == 1) {
                        this.f6.drawCursor(0, 0, this.width, this.height);
                    } else {
                        this.f2.press(false);
                    }
                    this.f3 = false;
                    this.f4 = true;
                    this.m1();
                    return;
                }
                case 499: {
                    if (event.target != this.f1) break;
                    this.f4 = false;
                    this.repaintNow();
                    this.postEvent(new ControlEvent(300, this));
                    return;
                }
                case 300: {
                    if (event.target != this.f2 || this.f1.lb.itemCount <= 0) break;
                    this.requestFocus();
                    this.m1();
                    return;
                }
                case 301: 
                case 302: {
                    if (event.target != this.f2) break;
                    event.target = this;
                }
            }
        }
    }

    protected void onFontChanged() {
        if (this.f1 != null) {
            this.f1.setFont(this.font);
        }
    }

    public void onPaint(Graphics graphics) {
        if (this.f6 == null) {
            this.f6 = this.createGraphics();
        }
        graphics.setBackColor(this.f7);
        graphics.fillRect(0, 0, this.width, this.height);
        if (Settings.uiStyle == 1) {
            graphics.setClip(this.f5, 0, this.width - this.f5 - 1, this.height - 1);
        } else {
            graphics.draw3dRect(0, 0, this.width, this.height, (byte)4, false, false, this.f9);
            graphics.setClip(2, 2, this.width - this.f5 - 3, this.height - 4);
        }
        if (this.f1.lb.itemCount > 0) {
            graphics.setForeColor(this.f8);
            this.f1.lb.drawItem(graphics, this.f1.lb.selectedIndex, Settings.uiStyle == 1 ? this.f5 + 3 : 3, this.height - this.fmH >> 1);
        }
    }

    private void m1() {
        if (this.f10) {
            this.f10 = false;
            Rect rect = this.getAbsoluteRect();
            this.f1.fullHeight = this.fullHeight;
            this.f1.setRect(rect.x, rect.y, this.width, this.height);
            int n = this.f1.lb.selectedIndex;
            this.f1.lb.selectedIndex = -2;
            this.f1.lb.select(n);
        }
        this.getParentWindow().popupModal(this.f1);
        this.f1.lb.requestFocus();
    }

    public void qsort() {
        this.f1.lb.qsort();
        this.select(-1);
    }

    public void remove(int n) {
        this.f1.lb.remove(n);
        this.f10 = true;
        this.repaint();
    }

    public void remove(Object object) {
        this.f1.lb.remove(object);
        this.f10 = true;
        this.repaint();
    }

    public void remove(Control control) {
    }

    public void removeAll() {
        this.f1.lb.removeAll();
        this.f10 = true;
        this.repaint();
    }

    public void select(int n) {
        this.f1.lb.select(n);
        this.repaint();
    }

    public void setCursorColor(Color color) {
        this.f1.lb.setCursorColor(color);
    }

    public void setItemAt(int n, Object object) {
        this.f1.lb.setItemAt(n, object);
        this.f10 = true;
        this.repaint();
    }

    public int size() {
        return this.f1.lb.itemCount;
    }
}

