/*
 * Decompiled with CFR 0.152.
 */
package waba.fx;

import waba.fx.Coord;

public final class Rect {
    public int x;
    public int y;
    public int width;
    public int height;
    public static final int SAME = 0;

    public Rect() {
    }

    public Rect(int n, int n2, int n3, int n4) {
        this.set(n, n2, n3, n4);
    }

    public Rect(Coord coord, Coord coord2) {
        this.set(coord.x, coord.y, coord2.x - coord.x + 1, coord2.y - coord.y + 1);
    }

    public boolean contains(int n, int n2) {
        return this.x <= n && n < this.x + this.width && this.y <= n2 && n2 < this.y + this.height;
    }

    public boolean equals(Object object) {
        if (object instanceof Rect) {
            Rect rect = (Rect)object;
            return rect.x == this.x && rect.y == this.y && rect.width == this.width && rect.height == this.height;
        }
        return false;
    }

    public Rect intersectWith(Rect rect) {
        int n = Math.max(this.x, rect.x);
        int n2 = Math.min(this.x + this.width, rect.x + rect.width);
        int n3 = Math.max(this.y, rect.y);
        int n4 = Math.min(this.y + this.height, rect.y + rect.height);
        this.x = n;
        this.y = n3;
        this.width = n2 - n;
        this.height = n4 - n3;
        return this;
    }

    public boolean intersects(Rect rect) {
        return (rect.x + rect.width <= this.x || rect.y + rect.height <= this.y || rect.x >= this.x + this.width || rect.y >= this.y + this.height) ^ true;
    }

    public Rect modifiedBy(int n, int n2, int n3, int n4) {
        return new Rect(n == 0 ? this.x : this.x + n, n2 == 0 ? this.y : this.y + n2, n3 == 0 ? this.width : this.width + n3, n4 == 0 ? this.height : this.height + n4);
    }

    public void modify(int n, int n2, int n3, int n4) {
        this.x += n;
        this.y += n2;
        this.width += n3;
        this.height += n4;
    }

    public void set(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public void set(Rect rect) {
        this.x = rect.x;
        this.y = rect.y;
        this.width = rect.width;
        this.height = rect.height;
    }

    public String toString() {
        return "" + this.x + ',' + this.y + ',' + this.width + ',' + this.height;
    }

    public void translate(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    public Rect unionWith(Rect rect) {
        int n = Math.min(this.x, rect.x);
        int n2 = Math.max(this.x + this.width, rect.x + rect.width);
        int n3 = Math.min(this.y, rect.y);
        int n4 = Math.max(this.y + this.height, rect.y + rect.height);
        this.x = n;
        this.y = n3;
        this.width = n2 - n;
        this.height = n4 - n3;
        return this;
    }

    public int x2() {
        return this.x + this.width - 1;
    }

    public int y2() {
        return this.y + this.height - 1;
    }
}

