#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>
#include "resource.h"
#include "PCalcMain.h"
#include "EditProgForm.h"
#include "DataBase.h"
#include "Misc.h"
#include "CommonEditMenu.h"


/* globals. */
static Int     gEditProgRecord;
static Boolean gAddRecord;
static SWord   gCursorPos;


/* prototypes. */
static Boolean CheckProgData(CharPtr*, CharPtr*);


/* define functions. */

Boolean EditProgFormHandleEvent(EventPtr event)
{
  Boolean handled = false;
  FormPtr form = FrmGetActiveForm();

  switch (event->eType) {
  case frmOpenEvent:
    if (!gAddRecord) {
      Char title[32];

      ReadProgramTitle(gEditProgRecord, title);
      ReadProgramCode(gEditProgRecord,  gProgramStr);
      SetFieldText(fieldEditProgTitleID, title);
      SetFieldText(fieldEditProgCodeID,  gProgramStr);
      // 'gProgramStr' is just used as a temporary buffer.

      if (gCursorPos >= 0) {
	FrmSetFocus(form, FrmGetObjectIndex(form, fieldEditProgCodeID));
	FldSetInsPtPosition(GetObjectPtr(fieldEditProgCodeID), gCursorPos);
	InsPtEnable(true);
      }

    } else {
      SetFieldText(fieldEditProgTitleID, "");
      SetFieldText(fieldEditProgCodeID,  "");
    }
    UpdateScrollBar(fieldEditProgCodeID, scrollbarEditProgCodeID);
    FrmDrawForm(form);
    handled = true;
    break;

  case fldChangedEvent:
    UpdateScrollBar(fieldEditProgCodeID, scrollbarEditProgCodeID);
    handled = true;
    break;

  case sclRepeatEvent:
    ScrollLines(event->data.sclRepeat.newValue
		- event->data.sclRepeat.value, fieldEditProgCodeID);
    UpdateScrollBar(fieldEditProgCodeID, scrollbarEditProgCodeID);
    break;

  case ctlSelectEvent:
    switch(event->data.ctlSelect.controlID) {
    case buttonEditProgOkID:
      {
	CharPtr title = FldGetTextPtr(GetObjectPtr(fieldEditProgTitleID));
	CharPtr code  = FldGetTextPtr(GetObjectPtr(fieldEditProgCodeID));

	if (CheckProgData(&title, &code)) {
	  if (gAddRecord) {
	    AddProgramRecord(gEditProgRecord, title, code);
	  } else {
	    ModifyProgramRecord(gEditProgRecord, title, code);
	  }
	  gLastExecProgRec = -1;
	  FrmUpdateForm(NULL, 0); // NULL means a dummy form pointer.
	  FrmReturnToForm(0);     // '0'  means the last form.
	}
      }
      handled = true;
      break;

    case buttonEditProgCancelID:
      FrmUpdateForm(NULL, 0); // NULL means a dummy form pointer.
      FrmReturnToForm(0);     // '0'  means the last form.

      handled = true;
      break;
    }
    break;

  case menuEvent:
    switch (event->data.menu.itemID) {
    case menuitemEditProgInsInpexprID:
      FldInsert(GetObjectPtr(fieldEditProgCodeID), "@INPEXPR", 8);
      handled = true;
    break;
    case menuitemEditProgInsDispID:
      FldInsert(GetObjectPtr(fieldEditProgCodeID), "@DISP \"\"", 8);
      handled = true;
    break;
    case menuitemEditProgInsSetexprID:
      FldInsert(GetObjectPtr(fieldEditProgCodeID), "@SETEXPR \"\"", 11);
      handled = true;
    break;
    case menuitemEditProgInsEvalID:
      FldInsert(GetObjectPtr(fieldEditProgCodeID), "@EVAL", 5);
      handled = true;
    break;
    case menuitemEditProgInsStmemID:
      FldInsert(GetObjectPtr(fieldEditProgCodeID), "@STMEM ", 7);
      handled = true;
    break;
    case menuitemEditProgHelpID:
      FrmHelp(helpEditProgID);
      handled = true;
    default:
      handled = HandleCommonEditMenu(event->data.menu.itemID);
    }

  case nilEvent:
    handled = true;
    break;
  }

  return handled;
}


void PresetEditProgFormParam(Int i, Boolean add, SWord cur)
{
  gEditProgRecord = i;
  gAddRecord = add;
  gCursorPos = cur;
}


static Boolean CheckProgData(CharPtr* title, CharPtr* code)
{
  if (StrLen(*title) == 0) {
    FrmCustomAlert(alertInformID, "TITLE :", "No data.", "");
    return false;
  }
  if (StrLen(*code) == 0) {
    if (FrmCustomAlert(alertConfirmID, "CODE :",  "No data.",
		       "Are you sure?") == 0) return false;
  }

  return true;
}
