
/* define constants. */
#define kPcalcAppID     'PCal'
#define kConstantDBType 'SciC'
#define kConstantDBName "Constant-PCal"
#define kProgramDBType  'Prog'
#define kProgramDBName  "Program-PCal"
#define kNumMemory    9
#define kNumHistory   5
#define kNumExprChars 128 /* must be consistent with 'resource.h' */


/* define structures. */
typedef struct {
  Char Notation;
  Char AngleUnit;
  Char DisplayDigit;
  Char InsertDigit;
  Char NotatBound;
  Boolean LastAnsValid;
  Boolean FirstInput;
  Char HistPosition;
  Char HistoryStr[kNumHistory][kNumExprChars];
  UInt DispAddFormat;
  double Memory[kNumMemory + 1];
} AppPrefType;


/* define globals. */
AppPrefType g;
Boolean     gProgramMode;
Char*       gProgCurrPos;
Char        gProgramStr[512];
Int         gLastExecProgRec;
Char        gLastAnsStr[32];
DmOpenRef   gConstantDB;
DmOpenRef   gProgramDB;
