/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Vector;

public class Model {
    private static String applcreator4 = "GkyrGtkr";
    private static String applcreator5 = "GkyrGtkr";
    public static final boolean DEBUG = false;
    private static String csvFilename = "keyring.csv";
    private static char csvSeparator = (char)59;
    private byte[] pdbHeader = new byte[78];
    private byte[] pdbCategories = new byte[276];
    private String pdbName;
    private int pdbFlags;
    protected int pdbVersion;
    private long pdbModNumber;
    private int pdbSortInfoOffset;
    private String pdbType;
    private String pdbCreator;
    private int pdbAppInfoOffset;
    private int pdbNumRecords;
    private int recordZeroAttribute;
    private int recordZeroUniqueId;
    private int recordZeroLength;
    private Vector entries = new Vector();
    private Vector categories = new Vector();
    protected Crypto crypto;

    public static void writeNewDatabase(String string) {
        int[] nArray = new int[]{75, 101, 121, 115, 45, 71, 116, 107, 114, 0, 107, 114, 95, 97, 112, 112, 108, 95, 97, 54, 56, 107, 0, 0, 115, 121, 115, 112, 4, 0, 115, 112, 0, 8, 0, 4, 189, 219, 101, 6, 189, 219, 101, 13, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 96, 0, 0, 0, 0, 71, 107, 121, 114, 71, 116, 107, 114, 0, 183, 48, 2, 0, 0, 0, 0, 0, 2, 0, 0, 1, 116, 80, 183, 48, 1, 0, 0, 1, 136, 64, 183, 48, 2, 0, 0, 31, 31};
        int[] nArray2 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 15, 0, 176, 218, 67, 74, 145, 85, 18, 236, 213, 150, 205, 33, 154, 252, 45, 1, 156, 47, 199, 19, 97, 0, 240, 59, 22, 204, 37, 207, 73, 192};
        byte[] byArray = new byte[256];
        byte[] byArray2 = new String("no category").getBytes();
        try {
            int n;
            File file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            for (n = 0; n < nArray.length; ++n) {
                fileOutputStream.write((byte)nArray[n]);
            }
            Arrays.fill(byArray, (byte)0);
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            fileOutputStream.write(byArray, 0, 256);
            for (n = 0; n < nArray2.length; ++n) {
                fileOutputStream.write((byte)nArray2[n]);
            }
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Caught Exception: " + exception.getMessage());
        }
    }

    public void addEntry(Object object) {
        this.entries.add((Entry)object);
    }

    public void removeEntry(Object object) {
        this.entries.removeElement(object);
    }

    public int getEntriesSize() {
        return this.entries.size();
    }

    public Vector getEntries() {
        return this.entries;
    }

    public Enumeration getElements() {
        return this.entries.elements();
    }

    public String getCategoryName(int n) throws ArrayIndexOutOfBoundsException {
        return (String)this.categories.get(n);
    }

    public void setCategories(Vector vector) {
        this.categories = vector;
    }

    public Vector getCategories() {
        return this.categories;
    }

    public void loadData(String string) throws Exception {
        int n;
        byte[] byArray = null;
        int n2 = 102400;
        int n3 = 0;
        int n4 = 0;
        byte[] byArray2 = null;
        String string2 = null;
        this.entries.clear();
        this.categories.clear();
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray3 = new byte[n2];
        int n5 = fileInputStream.read(byArray3);
        if (n5 == n2) {
            throw new Exception("File too large.");
        }
        fileInputStream.close();
        this.pdbHeader = Model.sliceBytes(byArray3, 0, 78);
        this.pdbName = Model.sliceString(byArray3, 0, 32);
        this.pdbFlags = (int)Model.sliceNumber(byArray3, 32, 2);
        this.pdbVersion = (int)Model.sliceNumber(byArray3, 34, 2);
        this.pdbModNumber = Model.sliceNumber(byArray3, 48, 4);
        this.pdbAppInfoOffset = (int)Model.sliceNumber(byArray3, 52, 4);
        this.pdbSortInfoOffset = (int)Model.sliceNumber(byArray3, 56, 4);
        this.pdbType = Model.sliceString(byArray3, 60, 4);
        this.pdbCreator = new String(byArray3, 64, 4);
        this.pdbNumRecords = (int)Model.sliceNumber(byArray3, 76, 2);
        if (this.pdbVersion != 4 && this.pdbVersion != 5) {
            throw new Exception("Wrong Keyring database format.");
        }
        int[] nArray = new int[this.pdbNumRecords];
        int[] nArray2 = new int[this.pdbNumRecords];
        int[] nArray3 = new int[this.pdbNumRecords];
        for (n = 0; n < this.pdbNumRecords; ++n) {
            nArray[n] = (int)Model.sliceNumber(byArray3, 78 + n * 8, 4);
            nArray2[n] = (int)Model.sliceNumber(byArray3, 82 + n * 8, 1);
            nArray3[n] = (int)Model.sliceNumber(byArray3, 83 + n * 8, 3);
        }
        this.pdbCategories = Model.sliceBytes(byArray3, this.pdbAppInfoOffset, 276);
        for (n = 0; n < 16; ++n) {
            String string3 = Model.sliceString(byArray3, this.pdbAppInfoOffset + 2 + 16 * n, 16);
            if (string3.equals("")) continue;
            this.categories.add(string3);
        }
        if (this.pdbVersion == 5) {
            if (this.pdbNumRecords <= 0) {
                throw new Exception("No real data.");
            }
            byte[] byArray4 = Model.sliceBytes(byArray3, this.pdbAppInfoOffset + 276, 8);
            int n6 = (int)Model.sliceNumber(byArray3, this.pdbAppInfoOffset + 276 + 8, 2);
            int n7 = (int)Model.sliceNumber(byArray3, this.pdbAppInfoOffset + 276 + 8 + 2, 2);
            byte[] byArray5 = Model.sliceBytes(byArray3, this.pdbAppInfoOffset + 276 + 8 + 2 + 2, 8);
            this.crypto = new Crypto(null, 5, byArray4, byArray5, n6, n7);
            n4 = 0;
            switch (n7) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new Exception("No cipher not supported.");
                }
            }
        }
        if (this.pdbVersion == 4) {
            if (this.pdbNumRecords <= 1) {
                throw new Exception("No real data.");
            }
            this.recordZeroAttribute = nArray2[0];
            this.recordZeroUniqueId = nArray3[0];
            this.recordZeroLength = nArray[1] - nArray[0];
            this.crypto = new Crypto(Model.sliceBytes(byArray3, nArray[0], nArray[1] - nArray[0]), 4);
            n4 = 1;
        }
        for (int i = n4; i < this.pdbNumRecords; ++i) {
            if ((nArray2[i] & 0xF0) != 64) continue;
            int n8 = i == this.pdbNumRecords - 1 ? n5 - nArray[i] : nArray[i + 1] - nArray[i];
            if (this.pdbVersion == 4) {
                string2 = Model.sliceString(byArray3, nArray[i], -1);
                byArray2 = null;
                byArray = Model.sliceBytes(byArray3, nArray[i] + string2.length() + 1, n8 - string2.length() - 1);
            }
            if (this.pdbVersion == 5) {
                int n9 = (int)Model.sliceNumber(byArray3, nArray[i], 2);
                int n10 = n9 + 1 & 0xFFFFFFFE;
                string2 = Model.sliceString(byArray3, nArray[i] + 4, n9);
                int n11 = 8;
                if (this.crypto.type == 2 || this.crypto.type == 3) {
                    n11 = 16;
                }
                byArray2 = Model.sliceBytes(byArray3, nArray[i] + n10 + 4, n11);
                byArray = Model.sliceBytes(byArray3, nArray[i] + n10 + 4 + n11, n8 - (n10 + 4 + n11));
            }
            if (string2.equals("")) {
                string2 = "#" + n3++;
            }
            Entry entry = new Entry(i, string2, nArray2[i] & 0xF, byArray, this.crypto, nArray2[i], nArray3[i], n8, byArray2);
            this.entries.add(entry);
        }
    }

    public void saveData(String string) throws Exception {
        switch (this.pdbVersion) {
            case 4: {
                this.saveData_4(string);
                break;
            }
            case 5: {
                this.saveData_5(string);
            }
        }
    }

    public void saveData_4(String string) throws Exception {
        Entry entry;
        int n = 0;
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.pdbAppInfoOffset = 78 + 8 * this.entries.size() + 2 + 8;
        this.pdbNumRecords = this.entries.size() + 1;
        n = this.pdbAppInfoOffset + 276;
        fileOutputStream.write(this.pdbHeader, 0, 52);
        fileOutputStream.write(Model.numberToByte(this.pdbAppInfoOffset, 4), 0, 4);
        fileOutputStream.write(this.pdbHeader, 56, 20);
        fileOutputStream.write(Model.numberToByte(this.pdbNumRecords, 2), 0, 2);
        fileOutputStream.write(Model.numberToByte(n, 4), 0, 4);
        fileOutputStream.write(Model.numberToByte(this.recordZeroAttribute, 1), 0, 1);
        fileOutputStream.write(Model.numberToByte(this.recordZeroUniqueId, 3), 0, 3);
        n += this.recordZeroLength;
        Enumeration enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            entry = (Entry)enumeration.nextElement();
            fileOutputStream.write(Model.numberToByte(n, 4), 0, 4);
            fileOutputStream.write(Model.numberToByte(entry.attribute, 1), 0, 1);
            fileOutputStream.write(Model.numberToByte(entry.uniqueId, 3), 0, 3);
            n += entry.recordLength;
        }
        fileOutputStream.write(0);
        fileOutputStream.write(0);
        this.updateCategories();
        fileOutputStream.write(this.pdbCategories, 0, 276);
        fileOutputStream.write(this.crypto.recordZero);
        enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            entry = (Entry)enumeration.nextElement();
            fileOutputStream.write(entry.getTitle().getBytes());
            fileOutputStream.write(0);
            fileOutputStream.write(entry.encrypted);
        }
        fileOutputStream.close();
    }

    public void saveData_5(String string) throws Exception {
        Entry entry;
        int n = 0;
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.pdbAppInfoOffset = 78 + 8 * this.entries.size() + 2;
        this.pdbNumRecords = this.entries.size();
        n = this.pdbAppInfoOffset + 276 + 20;
        fileOutputStream.write(this.pdbHeader, 0, 52);
        fileOutputStream.write(Model.numberToByte(this.pdbAppInfoOffset, 4), 0, 4);
        fileOutputStream.write(this.pdbHeader, 56, 20);
        fileOutputStream.write(Model.numberToByte(this.pdbNumRecords, 2), 0, 2);
        Enumeration enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            entry = (Entry)enumeration.nextElement();
            fileOutputStream.write(Model.numberToByte(n, 4), 0, 4);
            fileOutputStream.write(Model.numberToByte(entry.attribute, 1), 0, 1);
            fileOutputStream.write(Model.numberToByte(entry.uniqueId, 3), 0, 3);
            n += entry.recordLength;
        }
        fileOutputStream.write(0);
        fileOutputStream.write(0);
        this.updateCategories();
        fileOutputStream.write(this.pdbCategories, 0, 276);
        fileOutputStream.write(this.crypto.salt);
        fileOutputStream.write(Model.numberToByte(this.crypto.iter, 2));
        fileOutputStream.write(Model.numberToByte(this.crypto.type, 2));
        fileOutputStream.write(this.crypto.hash);
        enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            entry = (Entry)enumeration.nextElement();
            fileOutputStream.write(Model.convertStringToField(entry.getTitle(), 0));
            fileOutputStream.write(entry.iv);
            fileOutputStream.write(entry.encrypted);
        }
        fileOutputStream.close();
    }

    public void convertDatabase(int n, int n2, String string, char[] cArray, int n3, int n4) throws Exception {
        switch (n2) {
            case 4: {
                this.convertTo_4(n, string, cArray);
                break;
            }
            case 5: {
                this.convertTo_5(n, string, cArray, n3, n4);
                break;
            }
            default: {
                return;
            }
        }
    }

    public void convertTo_4(int n, String string, char[] cArray) throws Exception {
        Entry entry;
        int n2;
        int n3 = 0;
        byte[] byArray = new byte[20];
        byte[] byArray2 = new byte[cArray.length];
        byte[] byArray3 = new byte[4];
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        Crypto crypto = null;
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.pdbAppInfoOffset = 78 + 8 * this.entries.size() + 2 + 8;
        this.pdbNumRecords = this.entries.size() + 1;
        n3 = this.pdbAppInfoOffset + 276;
        Arrays.fill(byArray, (byte)0);
        if (cArray.length > 40) {
            throw new Exception("Password too long.");
        }
        for (n2 = 0; n2 < cArray.length; ++n2) {
            byArray2[n2] = (byte)(0xFF & cArray[n2]);
        }
        switch (n) {
            case 4: {
                for (n2 = 0; n2 < 4; ++n2) {
                    byArray3[n2] = this.crypto.recordZero[n2];
                    byArray[n2] = this.crypto.recordZero[n2];
                }
                break;
            }
            case 5: {
                for (n2 = 0; n2 < 4; ++n2) {
                    byArray3[n2] = this.crypto.salt[n2];
                    byArray[n2] = this.crypto.salt[n2];
                }
                break;
            }
        }
        byte[] byArray6 = this.crypto.checkPasswordHash_4(byArray3, byArray2);
        for (n2 = 0; n2 < 16; ++n2) {
            byArray[n2 + 4] = byArray6[n2];
        }
        crypto = new Crypto(byArray, 4);
        crypto.setPassword(cArray);
        Arrays.fill(cArray, '\u0000');
        Arrays.fill(byArray2, (byte)0);
        fileOutputStream.write(this.pdbHeader, 0, 34);
        fileOutputStream.write(Model.numberToByte(4L, 2), 0, 2);
        fileOutputStream.write(this.pdbHeader, 36, 16);
        fileOutputStream.write(Model.numberToByte(this.pdbAppInfoOffset, 4), 0, 4);
        fileOutputStream.write(this.pdbHeader, 56, 4);
        fileOutputStream.write(applcreator4.getBytes());
        fileOutputStream.write(this.pdbHeader, 68, 8);
        fileOutputStream.write(Model.numberToByte(this.pdbNumRecords, 2), 0, 2);
        fileOutputStream.write(Model.numberToByte(n3, 4), 0, 4);
        fileOutputStream.write(Model.numberToByte(80L, 1), 0, 1);
        fileOutputStream.write(Model.numberToByte(0L, 3), 0, 3);
        n3 += 20;
        Enumeration enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            entry = (Entry)enumeration.nextElement();
            fileOutputStream.write(Model.numberToByte(n3, 4), 0, 4);
            fileOutputStream.write(Model.numberToByte(entry.attribute, 1), 0, 1);
            fileOutputStream.write(Model.numberToByte(entry.uniqueId, 3), 0, 3);
            byArray4 = Model.toRecordFormat4(entry.getAccount() + "\u0000" + entry.getPassword() + "\u0000" + entry.getNotes() + "\u0000");
            byArray5 = crypto.encrypt(byArray4);
            entry.encrypted = Model.sliceBytes(byArray5, 16, byArray5.length - 16);
            n3 += entry.getTitle().length() + 1 + entry.encrypted.length;
        }
        fileOutputStream.write(0);
        fileOutputStream.write(0);
        this.updateCategories();
        fileOutputStream.write(this.pdbCategories, 0, 276);
        fileOutputStream.write(byArray);
        enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            entry = (Entry)enumeration.nextElement();
            fileOutputStream.write(entry.getTitle().getBytes());
            fileOutputStream.write(0);
            fileOutputStream.write(entry.encrypted);
        }
        crypto = null;
        fileOutputStream.close();
    }

    public void convertTo_5(int n, String string, char[] cArray, int n2, int n3) throws Exception {
        Entry entry;
        int n4;
        int n5 = 0;
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = new byte[20];
        Crypto crypto = null;
        int[] nArray = new int[]{0, 24, 16, 32};
        byte[] byArray4 = new byte[cArray.length];
        byte[] byArray5 = new byte[8];
        for (n4 = 0; n4 < cArray.length; ++n4) {
            byArray4[n4] = (byte)(0xFF & cArray[n4]);
        }
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.pdbAppInfoOffset = 78 + 8 * this.entries.size() + 2;
        this.pdbNumRecords = this.entries.size();
        n5 = this.pdbAppInfoOffset + 276 + 20;
        switch (n) {
            case 4: {
                for (n4 = 0; n4 < 4; ++n4) {
                    byArray5[n4] = this.crypto.recordZero[n4];
                    byArray5[n4 + 4] = this.crypto.recordZero[n4];
                }
                break;
            }
            case 5: {
                for (n4 = 0; n4 < 8; ++n4) {
                    byArray5[n4] = this.crypto.salt[n4];
                }
                break;
            }
        }
        byte[] byArray6 = this.crypto.pbkdf2(byArray4, byArray5, n3, nArray[n2]);
        if (n2 == 1) {
            for (n4 = 0; n4 < 24; ++n4) {
                int n6 = 0xFF & byArray6[n4];
                byArray6[n4] = (byte)Crypto.odd_parity[n6];
            }
        }
        byte[] byArray7 = this.crypto.getMessageDigest(byArray6, byArray5);
        byte[] byArray8 = Model.sliceBytes(byArray7, 0, 8);
        crypto = new Crypto(null, 5, byArray5, byArray8, n3, n2);
        crypto.setPassword(cArray);
        Arrays.fill(cArray, '\u0000');
        Arrays.fill(byArray4, (byte)0);
        fileOutputStream.write(this.pdbHeader, 0, 34);
        fileOutputStream.write(Model.numberToByte(5L, 2), 0, 2);
        fileOutputStream.write(this.pdbHeader, 36, 16);
        fileOutputStream.write(Model.numberToByte(this.pdbAppInfoOffset, 4), 0, 4);
        fileOutputStream.write(this.pdbHeader, 56, 4);
        fileOutputStream.write(applcreator5.getBytes());
        fileOutputStream.write(this.pdbHeader, 68, 8);
        fileOutputStream.write(Model.numberToByte(this.pdbNumRecords, 2), 0, 2);
        Enumeration enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            entry = (Entry)enumeration.nextElement();
            fileOutputStream.write(Model.numberToByte(n5, 4), 0, 4);
            fileOutputStream.write(Model.numberToByte(entry.attribute, 1), 0, 1);
            fileOutputStream.write(Model.numberToByte(entry.uniqueId, 3), 0, 3);
            byArray = Model.toRecordFormat5(entry.getAccount(), entry.getPassword(), entry.getNotes());
            byArray2 = crypto.encrypt(byArray);
            int n7 = 8;
            if (n2 != 1) {
                n7 = 16;
            }
            entry.iv = Model.sliceBytes(byArray2, 0, n7);
            entry.encrypted = Model.sliceBytes(byArray2, 16, byArray2.length - 16);
            n5 += Model.convertStringToField(entry.getTitle(), 0).length + n7 + entry.encrypted.length;
        }
        fileOutputStream.write(0);
        fileOutputStream.write(0);
        this.updateCategories();
        fileOutputStream.write(this.pdbCategories, 0, 276);
        fileOutputStream.write(byArray5);
        fileOutputStream.write(Model.numberToByte(n3, 2));
        fileOutputStream.write(Model.numberToByte(n2, 2));
        fileOutputStream.write(byArray8);
        enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            entry = (Entry)enumeration.nextElement();
            fileOutputStream.write(Model.convertStringToField(entry.getTitle(), 0));
            fileOutputStream.write(entry.iv);
            fileOutputStream.write(entry.encrypted);
        }
        crypto = null;
        fileOutputStream.close();
    }

    public static byte[] toRecordFormat4(String string) {
        byte[] byArray = Model.getDateType();
        byte[] byArray2 = string.getBytes();
        byte[] byArray3 = new byte[byArray2.length + 2];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        byArray3[byArray2.length] = byArray[1];
        byArray3[byArray2.length + 1] = byArray[0];
        return byArray3;
    }

    public static byte[] toRecordFormat5(String string, String string2, String string3) {
        byte[] byArray = new byte[]{0, 2, 3, 0, 0, 0};
        byte[] byArray2 = string.getBytes();
        byte[] byArray3 = string2.getBytes();
        byte[] byArray4 = string3.getBytes();
        int n = byArray2.length;
        int n2 = byArray3.length;
        int n3 = byArray4.length;
        if (n != 0) {
            byArray2 = Model.convertStringToField(string, 1);
            n = byArray2.length;
        }
        if (n2 != 0) {
            byArray3 = Model.convertStringToField(string2, 2);
            n2 = byArray3.length;
        }
        if (n3 != 0) {
            byArray4 = Model.convertStringToField(string3, 255);
            n3 = byArray4.length;
        }
        byte[] byArray5 = Model.getDateType();
        byArray[4] = byArray5[1];
        byArray[5] = byArray5[0];
        int n4 = (n + n2 + n3 + 6 + 2) % 8;
        byte[] byArray6 = new byte[n + n2 + n3 + 6 + 2 + n4];
        Arrays.fill(byArray6, (byte)-1);
        if (n != 0) {
            System.arraycopy(byArray2, 0, byArray6, 0, n);
        }
        if (n2 != 0) {
            System.arraycopy(byArray3, 0, byArray6, n, n2);
        }
        if (n3 != 0) {
            System.arraycopy(byArray4, 0, byArray6, n + n2, n3);
        }
        System.arraycopy(byArray, 0, byArray6, n + n2 + n3, 6);
        return byArray6;
    }

    public static byte[] convertStringToField(String string, int n) {
        byte[] byArray = string.getBytes();
        int n2 = 0;
        int n3 = byArray.length;
        if (n3 % 2 == 1) {
            n2 = 1;
        }
        byte[] byArray2 = new byte[4 + n3 + n2];
        Arrays.fill(byArray2, (byte)0);
        System.arraycopy(Model.numberToByte(n3, 2), 0, byArray2, 0, 2);
        System.arraycopy(Model.numberToByte(n, 1), 0, byArray2, 2, 1);
        byArray2[3] = 0;
        System.arraycopy(byArray, 0, byArray2, 4, n3);
        return byArray2;
    }

    public int getNewUniqueId() {
        int n = 0;
        Enumeration enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            Entry entry = (Entry)enumeration.nextElement();
            if (entry.getUniqueId() <= n) continue;
            n = entry.getUniqueId();
        }
        return ++n;
    }

    public void saveEntriesToFile(String string) throws Exception {
        csvFilename = string;
        File file = new File(csvFilename);
        FileWriter fileWriter = new FileWriter(file);
        Enumeration enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            Entry entry = (Entry)enumeration.nextElement();
            String string2 = "\"" + entry.getEntryId() + '\"' + csvSeparator + '\"' + this.categories.elementAt(entry.getCategory()) + '\"' + csvSeparator + '\"' + entry.getTitle() + '\"' + csvSeparator + '\"' + entry.getAccount() + '\"' + csvSeparator + '\"' + entry.getPassword() + '\"' + csvSeparator + '\"' + entry.getDate() + '\"' + "\n";
            fileWriter.write(string2.toCharArray());
        }
        fileWriter.close();
    }

    public void setCsvSeparator(char c) {
        csvSeparator = c;
    }

    public void setCsvFilename(String string) {
        csvFilename = string;
    }

    public String getCsvFilename() {
        return csvFilename;
    }

    public static byte[] numberToByte(long l, int n) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = (n - 1) * 8;
        while (n2 < n) {
            byArray[n2] = (byte)(0xFFL & l >> n3);
            ++n2;
            n3 -= 8;
        }
        return byArray;
    }

    public static int unsignedByteToInt(byte by) {
        return by & 0xFF;
    }

    public static byte[] sliceBytes(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray2[i] = byArray[n + i];
        }
        return byArray2;
    }

    public static long sliceNumber(byte[] byArray, int n, int n2) {
        long l = 0L;
        long l2 = 1L;
        for (int i = 0; i < n2; ++i) {
            l += (long)Model.unsignedByteToInt(byArray[n + n2 - (i + 1)]) * l2;
            l2 *= 256L;
        }
        return l;
    }

    public static String sliceString(byte[] byArray, int n, int n2) {
        int n3 = 0;
        if (n2 == -1) {
            n2 = byArray.length - n;
        }
        while (n3 < n2 && byArray[n + n3] != 0) {
            ++n3;
        }
        return new String(byArray, n, n3);
    }

    public static void printByteArray(String string, byte[] byArray) {
        System.out.print("printByteArray " + string + " (" + byArray.length + "): ");
        for (int i = 0; i < byArray.length; ++i) {
            System.out.print((byArray[i] & 0xFF) + " ");
        }
        System.out.println();
    }

    public static void printHexByteArray(String string, byte[] byArray) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        System.out.println("printHexByteArray " + string + " (" + byArray.length + "): ");
        for (int i = 0; i < byArray.length; ++i) {
            int n = (byArray[i] & 0xFF) / 16;
            int n2 = (byArray[i] & 0xFF) % 16;
            System.out.print("" + cArray[n] + "" + cArray[n2] + " ");
        }
        System.out.println();
    }

    private void printPDBHeader() {
        System.out.println("PDB Name: " + this.pdbName);
        System.out.println("PDB Flags: " + this.pdbFlags);
        System.out.println("PDB Version: " + this.pdbVersion);
        System.out.println("PDB Modification Number: " + this.pdbModNumber);
        System.out.println("PDB AppInfoOffset: " + this.pdbAppInfoOffset);
        System.out.println("PDB SortInfoOffset: " + this.pdbSortInfoOffset);
        System.out.println("PDB Type: " + this.pdbType);
        System.out.println("PDB Creator: " + this.pdbCreator);
        System.out.println("PDB NumberOfRecords: " + this.pdbNumRecords + "\n");
    }

    private void printEntries() {
        Object object;
        int n = 0;
        Enumeration enumeration = this.categories.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            System.out.println("Category " + n++ + ": " + (String)object);
        }
        System.out.println();
        enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            object = (Entry)enumeration.nextElement();
            System.out.println(((Entry)object).getInfo());
        }
        System.out.println();
    }

    private static byte[] getDateType() {
        int[] nArray = new int[2];
        byte[] byArray = new byte[2];
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n = gregorianCalendar.get(5);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(1) - 1904;
        nArray[0] = (n &= 0x1F) | ((n2 &= 0xF) & 7) << 5;
        nArray[1] = (n3 &= 0x7F) << 1 | (n2 & 8) >> 3;
        byArray[0] = (byte)nArray[0];
        byArray[1] = (byte)nArray[1];
        return byArray;
    }

    private void updateCategories() {
        byte[] byArray = new byte[16];
        int n = 0;
        Enumeration enumeration = this.categories.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            byte[] byArray2 = string.getBytes();
            for (int i = 0; i < 16; ++i) {
                byArray[i] = i < byArray2.length ? byArray2[i] : (byte)0;
            }
            System.arraycopy(byArray, 0, this.pdbCategories, 2 + n * 16, 16);
            ++n;
        }
    }
}

