echo off
rem **************************************************************************
rem KeePass2KeyRing.Complex.cmd by David White (whitedavidp@fastmail.us). This
rem Windows command script is used to demonstrate the use of KeePass2KeyRing.
rem This script requires that Java Standard Edition (http://java.sun.com/javase/)
rem is installed and assumes that the java command is found on the executable
rem search path.
rem **************************************************************************

:checkAssumptions
if not exist c:\Keepass\KeePass2KeyRing goto badLocation
if not exist Keys-Gtkr.PDB.orig goto noKeyRingDb
if not exist ..\KPScript.exe goto KPScriptMissing
if not exist d:\KeePass\Database.kdbx goto KeePassMissing
if not exist KeePass2KeyRing.jar goto JarMissing
if not exist F:\Palm\QuickInstall.exe goto PalmMissing

:validateInput
if "%1%"=="" goto missingPassword

:prepare
rem **************************************************************************
rem To prepare, I change to the folder where KeePass2KeyRing is installed. I
rem have mine installed directly under my KeePass installation folder. Your
rem location may vary but the changes required are minimal. I then clean up
rem any old files which may have been left over from previous, failed attempts
rem to run this script. In my KeePass2KeyRing installation folder, I keep
rem an old but valid KeyRing database (copied from my Palm data directory in
rem a folder called Backup) for use in this process. KeyRing calls this file
rem Keys-Gtkr.PDB. This process will output a file by that name. So I call the
rem old KeyRing database Keys-Gtkr.PDB.orig just to be clear. Each time, I make
rem a new copy of Keys-Gtkr.PDB that will be emptied and re-populated.
rem **************************************************************************
pushd c:\Keepass\KeePass2KeyRing
if exist Keys-Gtkr.PDB del Keys-Gtkr.PDB
copy Keys-Gtkr.PDB.orig Keys-Gtkr.PDB

:runKeePass2KeyRing
rem ********************************************************************************
rem KeePass2KeyRing can accept its input from the standard input file. I prefer this
rem method as no potentially sensitive information (your keepass entries) is placed
rem in an unencrypted file on disk.
rem ********************************************************************************
..\KPScript.exe -c:ListEntries d:\KeePass\Database.kdbx -guikeyprompt | java -jar KeePass2KeyRing.jar -stdin Keys-Gtkr.PDB %1%
if errorlevel 1 goto ProcessingError

:setupPalmInstall
rem ******************************************************************************
rem On my system, I then invoke the Palm Quick Install program telling it to place
rem the newly created KeyRing database on my handheld during the next hotsync. You
rem may not wish to do this (but I am not sure why not).
rem ******************************************************************************
F:\Palm\QuickInstall.exe Keys-Gtkr.PDB

echo Processing completed.
pause

:cleanup
rem ****************************************************
rem Here I just get rid of any left-over work files, etc
rem ****************************************************
if exist KeePass2KeyRing.txt del KeePass2KeyRing.txt
if exist Keys-Gtkr.PDB del Keys-Gtkr.PDB
popd
goto exit

:PalmMissing
echo Palm quick install not found in expected location
pause
goto cleanup

:JarMissing
echo KeePass2KeyRing.jar not found in the expected location
pause
goto cleanup

:KeePassMissing
echo KeePass database not found in the expected location
pause
goto cleanup

:KPScriptMissing
echo KPScript.exe not found in the expected location
pause
goto cleanup

:noKeyRingDb
echo KeyRing database file not found in the expected location
pause
goto cleanup

:badLocation
echo KeePass2KeyRing is not in the expected location
pause
goto cleanup

:missingPassword
echo You must supply a password for your KeyRing database.
pause
goto cleanup

:KPScriptError
echo KPScript processing failed.
pause
goto cleanup

:ProcessingError
echo Processing failed.
pause
goto cleanup

rem *****************
rem Common exit point
rem *****************
:exit
