/*
 * Decompiled with CFR 0.152.
 */
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Crypto {
    protected static final int[] odd_parity = new int[]{1, 1, 2, 2, 4, 4, 7, 7, 8, 8, 11, 11, 13, 13, 14, 14, 16, 16, 19, 19, 21, 21, 22, 22, 25, 25, 26, 26, 28, 28, 31, 31, 32, 32, 35, 35, 37, 37, 38, 38, 41, 41, 42, 42, 44, 44, 47, 47, 49, 49, 50, 50, 52, 52, 55, 55, 56, 56, 59, 59, 61, 61, 62, 62, 64, 64, 67, 67, 69, 69, 70, 70, 73, 73, 74, 74, 76, 76, 79, 79, 81, 81, 82, 82, 84, 84, 87, 87, 88, 88, 91, 91, 93, 93, 94, 94, 97, 97, 98, 98, 100, 100, 103, 103, 104, 104, 107, 107, 109, 109, 110, 110, 112, 112, 115, 115, 117, 117, 118, 118, 121, 121, 122, 122, 124, 124, 127, 127, 128, 128, 131, 131, 133, 133, 134, 134, 137, 137, 138, 138, 140, 140, 143, 143, 145, 145, 146, 146, 148, 148, 151, 151, 152, 152, 155, 155, 157, 157, 158, 158, 161, 161, 162, 162, 164, 164, 167, 167, 168, 168, 171, 171, 173, 173, 174, 174, 176, 176, 179, 179, 181, 181, 182, 182, 185, 185, 186, 186, 188, 188, 191, 191, 193, 193, 194, 194, 196, 196, 199, 199, 200, 200, 203, 203, 205, 205, 206, 206, 208, 208, 211, 211, 213, 213, 214, 214, 217, 217, 218, 218, 220, 220, 223, 223, 224, 224, 227, 227, 229, 229, 230, 230, 233, 233, 234, 234, 236, 236, 239, 239, 241, 241, 242, 242, 244, 244, 247, 247, 248, 248, 251, 251, 253, 253, 254, 254};
    protected static final int SALT_SIZE = 4;
    protected static final int MD5_CBLOCK = 64;
    protected static final int MD5_DIGEST_LENGTH = 16;
    protected static final int KDESBLOCKSIZE = 8;
    protected byte[] recordZero;
    private int version;
    protected byte[] salt = new byte[8];
    protected byte[] hash = new byte[8];
    protected int iter;
    protected int type;
    protected SecretKey key = null;
    protected Cipher cipher = null;

    public Crypto(byte[] byArray, int n) {
        this.recordZero = byArray;
        this.version = n;
    }

    public Crypto(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        this.recordZero = byArray;
        this.version = n;
        this.salt = byArray2;
        this.hash = byArray3;
        this.iter = n2;
        this.type = n3;
    }

    public void setPassword(char[] cArray) throws Exception {
        switch (this.version) {
            case 4: {
                this.setPassword_4(cArray);
                break;
            }
            case 5: {
                this.setPassword_5(cArray);
            }
        }
    }

    public void setPassword_5(char[] cArray) throws Exception {
        byte[] byArray;
        byte[] byArray2;
        int[] nArray = new int[]{0, 24, 16, 32};
        byte[] byArray3 = new byte[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            byArray3[i] = (byte)(0xFF & cArray[i]);
        }
        byte[] byArray4 = this.pbkdf2(byArray3, this.salt, this.iter, nArray[this.type]);
        if (this.type == 1) {
            for (int i = 0; i < 24; ++i) {
                int n = 0xFF & byArray4[i];
                byArray4[i] = (byte)odd_parity[n];
            }
        }
        if (!Arrays.equals(this.hash, byArray2 = Model.sliceBytes(byArray = this.getMessageDigest(byArray4, this.salt), 0, this.hash.length))) {
            throw new Exception("Password incorrect.");
        }
        for (int i = 0; i < byArray3.length; ++i) {
            byArray3[i] = 0;
        }
        switch (this.type) {
            case 1: {
                this.key = SecretKeyFactory.getInstance("DESede").generateSecret(new DESedeKeySpec(byArray4));
                this.cipher = Cipher.getInstance("TripleDES/CBC/NoPadding");
                break;
            }
            case 2: {
                this.key = new SecretKeySpec(Model.sliceBytes(byArray4, 0, 16), "AES");
                this.cipher = Cipher.getInstance("AES/CBC/NoPadding");
                break;
            }
            case 3: {
                this.key = new SecretKeySpec(Model.sliceBytes(byArray4, 0, 32), "AES");
                this.cipher = Cipher.getInstance("AES/CBC/NoPadding");
                break;
            }
            default: {
                throw new Exception("Cipher " + this.type + " not supported.");
            }
        }
    }

    public byte[] getMessageDigest(byte[] byArray, byte[] byArray2) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
        messageDigest.update(byArray);
        messageDigest.update(byArray2);
        return messageDigest.digest();
    }

    public byte[] pbkdf2(byte[] byArray, byte[] byArray2, int n, int n2) throws Exception {
        int n3 = 20;
        int n4 = 1;
        byte[] byArray3 = new byte[4];
        int n5 = 0;
        byte[] byArray4 = new byte[n3];
        byte[] byArray5 = new byte[n2];
        Mac mac = Mac.getInstance("HmacSHA1");
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HmacSHA1");
        mac.init(secretKeySpec);
        while (n2 > 0) {
            int n6 = n2 > n3 ? n3 : n2;
            byArray3[0] = (byte)(0xFF & n4 >> 24);
            byArray3[1] = (byte)(0xFF & n4 >> 16);
            byArray3[2] = (byte)(0xFF & n4 >> 8);
            byArray3[3] = (byte)(0xFF & n4);
            mac.reset();
            mac.update(byArray2);
            byArray4 = mac.doFinal(byArray3);
            System.arraycopy(byArray4, 0, byArray5, n5, n6);
            for (int i = 1; i < n; ++i) {
                mac.reset();
                byArray4 = mac.doFinal(byArray4);
                for (int j = 0; j < n6; ++j) {
                    int n7 = n5 + j;
                    byArray5[n7] = (byte)(byArray5[n7] ^ byArray4[j]);
                }
            }
            n2 -= n6;
            n5 += n6;
            ++n4;
        }
        return byArray5;
    }

    public byte[] hmac(byte[] byArray, byte[] byArray2, String string) throws Exception {
        int n = 64;
        byte[] byArray3 = new byte[n];
        byte[] byArray4 = new byte[n];
        Arrays.fill(byArray3, (byte)0);
        Arrays.fill(byArray4, (byte)0);
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
        for (int i = 0; i < n; ++i) {
            byArray3[i] = (byte)(0x36 ^ byArray3[i]);
            byArray4[i] = (byte)(0x5C ^ byArray4[i]);
        }
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        messageDigest.update(byArray3);
        messageDigest.update(byArray);
        byte[] byArray5 = messageDigest.digest();
        messageDigest.reset();
        messageDigest.update(byArray4);
        messageDigest.update(byArray5);
        byArray5 = messageDigest.digest();
        return byArray5;
    }

    public void setPassword_4(char[] cArray) throws Exception {
        int n;
        byte[] byArray = new byte[24];
        byte[] byArray2 = new byte[cArray.length];
        for (n = 0; n < cArray.length; ++n) {
            byArray2[n] = (byte)(0xFF & cArray[n]);
        }
        for (n = 0; n < cArray.length; ++n) {
            cArray[n] = '\u0000';
        }
        if (byArray2.length > 40) {
            throw new Exception("Password too long.");
        }
        byte[] byArray3 = this.checkPasswordHash_4(this.recordZero, byArray2);
        if (!Arrays.equals(byArray3, Model.sliceBytes(this.recordZero, 4, 16))) {
            throw new Exception("Password incorrect.");
        }
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(byArray2);
        byte[] byArray4 = messageDigest.digest();
        for (n = 0; n < 16; ++n) {
            byArray[n] = byArray4[n];
            if (n >= 8) continue;
            byArray[n + 16] = byArray4[n];
        }
        this.key = SecretKeyFactory.getInstance("DESede").generateSecret(new DESedeKeySpec(byArray));
        this.cipher = Cipher.getInstance("TripleDES/ECB/NoPadding");
        for (n = 0; n < byArray2.length; ++n) {
            byArray2[n] = 0;
        }
    }

    protected byte[] checkPasswordHash_4(byte[] byArray, byte[] byArray2) throws Exception {
        int n;
        byte[] byArray3 = new byte[16];
        byte[] byArray4 = new byte[64];
        Arrays.fill(byArray4, (byte)0);
        for (n = 0; n < 4; ++n) {
            byArray4[n] = byArray[n];
        }
        for (n = 0; n < byArray2.length; ++n) {
            byArray4[n + 4] = byArray2[n];
        }
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(byArray4);
        byArray3 = messageDigest.digest();
        return byArray3;
    }

    public Object decrypt(byte[] byArray, String string, byte[] byArray2) {
        Object object = null;
        switch (this.version) {
            case 4: {
                object = this.decrypt_4(byArray, string);
                break;
            }
            case 5: {
                object = this.decrypt_5(byArray, string, byArray2);
            }
        }
        return object;
    }

    public Object decrypt_5(byte[] byArray, String string, byte[] byArray2) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        int n = 0;
        AlgorithmParameters algorithmParameters = null;
        try {
            switch (this.type) {
                case 1: {
                    algorithmParameters = AlgorithmParameters.getInstance("DES");
                    algorithmParameters.init(new IvParameterSpec(byArray2));
                    this.cipher.init(2, (Key)this.key, algorithmParameters);
                    byArray4 = this.cipher.update(byArray);
                    break;
                }
                case 2: 
                case 3: {
                    algorithmParameters = AlgorithmParameters.getInstance("AES");
                    algorithmParameters.init(new IvParameterSpec(byArray2));
                    this.cipher.init(2, (Key)this.key, algorithmParameters);
                    byArray4 = this.cipher.doFinal(byArray);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return "Could not decrypt data.";
        }
        int n2 = (int)Model.sliceNumber(byArray4, n, 2);
        while (n2 != 65535) {
            int n3 = n2 + 1 & 0xFFFFFFFE;
            int n4 = (int)Model.sliceNumber(byArray4, n + 2, 1);
            switch (n4) {
                case 1: {
                    string2 = Model.sliceString(byArray4, n + 4, n2);
                    break;
                }
                case 2: {
                    string3 = Model.sliceString(byArray4, n + 4, n2);
                    break;
                }
                case 3: {
                    byArray3 = Model.sliceBytes(byArray4, n + 4, 2);
                    break;
                }
                case 255: {
                    string4 = Model.sliceString(byArray4, n + 4, n2);
                }
            }
            n = n + n3 + 4;
            if (n < byArray4.length - 2) {
                n2 = (int)Model.sliceNumber(byArray4, n, 2);
                continue;
            }
            n2 = 65535;
        }
        if (string.equals("account")) {
            return string2;
        }
        if (string.equals("password")) {
            return string3;
        }
        if (string.equals("notes")) {
            return string4;
        }
        if (string.equals("datetype")) {
            return byArray3;
        }
        return null;
    }

    public Object decrypt_4(byte[] byArray, String string) {
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length;
        byte[] byArray2 = new byte[n3];
        try {
            int n4;
            byte[] byArray3;
            int n5;
            this.cipher.init(2, this.key);
            for (n5 = 0; n5 < n3 / 8; ++n5) {
                byArray3 = this.cipher.update(byArray, n5 * 8, 8);
                for (n4 = 0; n4 < byArray3.length; ++n4) {
                    byArray2[n++] = byArray3[n4];
                }
            }
            int n6 = n3 % 8;
            byArray3 = new byte[8];
            for (n5 = 0; n5 < 8; ++n5) {
                byArray3[n5] = n5 < n6 ? byArray[n3 - n6 + n5] : (byte)0;
            }
            byte[] byArray4 = this.cipher.doFinal(byArray3);
            for (n4 = 0; n4 < n6; ++n4) {
                byArray2[n++] = byArray4[n4];
            }
        }
        catch (Exception exception) {
            return "Could not decrypt data.";
        }
        String string2 = Model.sliceString(byArray2, n2, -1);
        String string3 = Model.sliceString(byArray2, n2 += string2.length() + 1, -1);
        String string4 = Model.sliceString(byArray2, n2 += string3.length() + 1, -1);
        byte[] byArray5 = Model.sliceBytes(byArray2, n2 += string4.length() + 1, 2);
        if (string.equals("account")) {
            return string2;
        }
        if (string.equals("password")) {
            return string3;
        }
        if (string.equals("notes")) {
            return string4;
        }
        if (string.equals("datetype")) {
            return byArray5;
        }
        return byArray2;
    }

    public byte[] encrypt(byte[] byArray) throws Exception {
        byte[] byArray2 = null;
        block0 : switch (this.version) {
            case 4: {
                byArray2 = this.encrypt_des_aes(byArray, 8);
                break;
            }
            case 5: {
                switch (this.type) {
                    case 1: {
                        byArray2 = this.encrypt_des_aes(byArray, 8);
                        break block0;
                    }
                    case 2: {
                        byArray2 = this.encrypt_des_aes(byArray, 16);
                        break block0;
                    }
                    case 3: {
                        byArray2 = this.encrypt_des_aes(byArray, 16);
                    }
                }
            }
        }
        return byArray2;
    }

    public byte[] encrypt_des_aes(byte[] byArray, int n) throws Exception {
        int n2;
        byte[] byArray2;
        int n3;
        int n4 = 0;
        int n5 = byArray.length;
        int n6 = n5 % n != 0 ? n5 + (n - n5 % n) : n5;
        byte[] byArray3 = new byte[n6];
        this.cipher.init(1, this.key);
        byte[] byArray4 = this.cipher.getIV();
        for (n3 = 0; n3 < n5 / n; ++n3) {
            byArray2 = this.cipher.update(byArray, n3 * n, n);
            for (n2 = 0; n2 < byArray2.length; ++n2) {
                byArray3[n4++] = byArray2[n2];
            }
        }
        int n7 = n5 % n;
        if (n7 != 0) {
            byArray2 = new byte[n];
            for (n3 = 0; n3 < n; ++n3) {
                byArray2[n3] = n3 < n7 ? byArray[n5 - n7 + n3] : (byte)0;
            }
            byte[] byArray5 = this.cipher.doFinal(byArray2);
            for (n2 = 0; n2 < n; ++n2) {
                byArray3[n4] = byArray5[n2];
                ++n4;
            }
        }
        byte[] byArray6 = new byte[16 + byArray3.length];
        Arrays.fill(byArray6, (byte)0);
        if (byArray4 != null) {
            System.arraycopy(byArray4, 0, byArray6, 0, byArray4.length);
        }
        System.arraycopy(byArray3, 0, byArray6, 16, byArray3.length);
        return byArray6;
    }
}

