/*
 * garux.c
 *
 * Linux Loader for the Palm OS.
 *
 * Copyright (C) 2004 Vinayak R. Borkar
 * Author: Vinayak R. Borkar [vinayakb@users.sourceforge.net]
 *
 * Original version by Romain Goyet [r.goyet@gmail.com]
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <PalmOS.h>
#include <PceNativeCall.h>
#include <MemGlue.h>
#include <MemoryMgr.h>
#include <string.h>
#include <stdio.h>

#include "garux.h"


UInt32 PilotMain (UInt16 cmd, void *params, UInt16 flags) {
  int i = 0;
  EventType e;
  char deviceID[4];
  MemPtr kernel;
  void *kernelPointer;
  MemHandle asmloaderHandle;
  void *asmloader;
  MemHandle pageHandle;
  void *page;

  if (cmd == sysAppLaunchCmdNormalLaunch) {
    // Let's get the device ID in order to check wether we're on a T|E
    FtrGet(sysFtrCreator, sysFtrNumOEMDeviceID, (UInt32 *)&deviceID);

    if (deviceID[0] == 'C' && deviceID[1] == 'c' && deviceID[2] == 't' && deviceID[3] == '1') {
      // Garux is being run on a Tungsten E
      FrmGotoForm(MainForm);
      while (1) {
	EvtGetEvent(&e, 100);
	SysHandleEvent(&e);
	if (e.eType == ctlSelectEvent) {
	  if (e.data.ctlSelect.controlID == PalmOSButton) {
	    FrmCloseAllForms();
	    return 0;
	  }
	  else if (e.data.ctlSelect.controlID == LinuxButton) {
	    // User choosed to load Linux
	    
	    // Let's clean the screen first
	    FrmCloseAllForms();
	    
	    // Reserve a chumk of memory for the kernel
	    // We allocate 1Mb.
	    kernel = MemGluePtrNew(0x00100000);
	    kernelPointer = kernel;
	    asmloaderHandle = DmGetResource('armc', 0);
	    asmloader = MemHandleLock(asmloaderHandle);
	    
	    printf("Loading kernel... at 0x%lx\n",(unsigned long)kernel);
	    
	    // Copy the kernel pages into the contiguous memory we allocated.
	    printf("Joining kernel chunks");
	    for (i = 0; i < NUM_KERNEL_PAGES; i++) {
	      pageHandle = DmGetResource('page', i);
	      page = MemHandleLock(pageHandle);
	      memcpy(kernelPointer, page, PAGE_SIZE);
	      kernelPointer += PAGE_SIZE;
	      MemHandleUnlock(pageHandle);
	      printf(".");
	    }
	    printf("OK\n");
	    
	    printf("Running assembly loader...\n");
	    PceNativeCall(asmloader, kernel);
	    
	    // The following code shall not be executed
	    MemPtrFree(kernel);
	    MemHandleUnlock (asmloaderHandle);
	    return 0;
	  }
	}
	if (e.eType == frmLoadEvent) {
	  FrmSetActiveForm(FrmInitForm(e.data.frmLoad.formID));
	  continue;
	}
	if (e.eType == frmOpenEvent) {
	  FrmDrawForm(FrmGetActiveForm());
	  continue;
	}
	if (e.eType == appStopEvent) {
	  FrmCloseAllForms();
	  return 0;	
	}
	if (FrmGetActiveForm())
	  FrmHandleEvent(FrmGetActiveForm(), &e);
      }
    }
    else {
      // Garux is not being run on a Tungsten E. We'll warn, and exit.
      FrmGotoForm(AltForm);
      
      while (1) {
	EvtGetEvent(&e, 100);
	SysHandleEvent(&e);
	if (e.eType == ctlSelectEvent)
	  if (e.data.ctlSelect.controlID == PalmOSButton) {
	    FrmCloseAllForms();
	    return 0;
	  }
	if (e.eType == frmLoadEvent) {
	  FrmSetActiveForm(FrmInitForm(e.data.frmLoad.formID));
	  continue;
	}
	if (e.eType == frmOpenEvent) {
	  FrmDrawForm(FrmGetActiveForm());
	  continue;
	}
	if (e.eType == appStopEvent) {
	  FrmCloseAllForms();
	  return 0;	
	}
	if (FrmGetActiveForm())
	FrmHandleEvent(FrmGetActiveForm(), &e); 
      }
    }
    return 0;
  }
}
