#!/usr/bin/perl

#
# split.pl
#
# A tool to split an input file in 32kb chunks. Those chunks are named
# page???.bin
#
# Copyright (C) 2004 Romain Goyet
# Author: Romain Goyet [r.goyet@gmail.com]
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation.

use strict;

open(INP, '<', $ARGV[0]) or die "Can't open input file $ARGV[0]: $!\n";

my $i = 0;
while(1)
{
	my $nread = sysread(INP, my $page, 32768);

	if($nread == 0)
	{
		last;
	}

	if($nread < 32768)
	{
		$page .= "\000" x (32768 - length($page));
	}

	my $file = 'page' . sprintf("%04x", $i) . '.bin';
	open(PAGE, '>', $file) or die "Can't create output file $file: $!\n";
	print PAGE $page;
	close(PAGE);

	$i++;
}

close(INP);
