/*******************************************************************
 *
 *	Copyright (c) 1998, EVSoft co., Ltd., All Rights Reserved
 *
 *------------------------------------------------------------------
 * FileName:
 *		Example1.c
 *
 * Description:
 *		This is a PlugBase sample, which shows how to create a plugin for PalmOS.
 *
 *      Email:  gzevsoft@public.guangzhou.gd.cn
 *
 * History:
 *   	9/20/98  - Created by Winter Du
 *
 *******************************************************************/

#include <Pilot.h>						// all the system toolbox headers

#include "..\..\..\Src\PlugBase.h"		// PlugBase defines
#include "Example1Rsc.h"				// application resource defines


/***********************************************************************
 * Structures for this module
 **********************************************************************/

/***********************************************************************
 * Global defines for this module
 **********************************************************************/
#define version20      	 	0x02000000	// ROM Version
#define appCreator			'pbE1'		// app's creator

#define SoftPenStroke1ID	0
#define SoftPenStroke2ID	1

#define PenStroke1From		findButton
#define PenStroke1To		graffitiLetterUpArea
#define PenStroke2From		findButton
#define PenStroke2To		graffitiNumberDownArea

/***********************************************************************
 * Global variables for this module
 **********************************************************************/

/***********************************************************************
 * Prototypes for internal functions
 **********************************************************************/
static void  msgBox (CharPtr msg, ULong delay);
static PlugBaseAPIPtr getAPIPtr ();

static void uninstallSoftPenStrokeOfExample (PlugBaseAPIPtr apiP);
static void installSoftPenStrokeOfExample (
	PlugBaseAPIPtr apiP,
	ScreenAreaType from1, ScreenAreaType to1,
	ScreenAreaType from2, ScreenAreaType to2);

typedef void (*SysKeyboardDialogV10Ptr) (void);
typedef void (*SysKeyboardDialogPtr) (KeyboardType kbd);

/***********************************************************************
 *
 * FUNCTION:    getAPIPtr
 *
 * DESCRIPTION: Get PlugBase API pointer
 *
 * PARAMETERS:  nothing
 *
 * RETURNED:    PlugBase API pointer
 *              0 - PlugBase doesn't exist or doesn't activated
 *
 * REVISION HISTORY:
 *			Name	Date		Description
 *			----	----		-----------
 *			Winter	9/20/98		Initial Revision
 *
 ***********************************************************************/
static PlugBaseAPIPtr
getAPIPtr ()
{
	PlugBaseAPIPtr	apiP;

	PBGetAPIPtr (apiP);

	ErrNonFatalDisplayIf (apiP == 0, "You must install EVPlugBase and active it first!");

	return apiP;
}

static VoidPtr
getObjectPtrByID (FormPtr frmP, Word objID)
{
	return FrmGetObjectPtr (frmP, FrmGetObjectIndex (frmP, objID));
}

inline static ListPtr
getListPtrByID (FormPtr frmP, Word objID)
{
  return (ListPtr) getObjectPtrByID(frmP, objID);
}

inline static ControlPtr
getControlPtrByID (FormPtr frmP, Word objID)
{
  return (ControlPtr) getObjectPtrByID(frmP, objID);
}

static void
setPopListByID (FormPtr frmP, Word popTriggerID, Word listID, Word newValue)
{
	ListPtr		lstP;
	ControlPtr	ctlP;
	
	lstP = getListPtrByID (frmP, listID);
	LstSetSelection (lstP, newValue);
	ctlP = getControlPtrByID (frmP, popTriggerID);
	CtlSetLabel (ctlP, LstGetSelectionText (lstP, newValue));
}

static Word
getListSelectionByID (FormPtr frmP, Word objID)
{
	return LstGetSelection (getListPtrByID (frmP, objID));
}

static void
msgBox (CharPtr msg, ULong delay)
{
	Int				msgLen;
	Word			error;
	RectangleType	rect;
	RectangleType	rectFrame;
	WinHandle		saveWin;

	if (msg == 0)
		msg = "No message...";
		
	if (delay < 10)
		delay = 10;

	msgLen = StrLen (msg);

	rectFrame.extent.x  = FntCharsWidth (msg, msgLen) + 8;
	rectFrame.extent.y  = FntCharHeight () + 6;
	rectFrame.topLeft.x = (160-(SWord)rectFrame.extent.x)/2;
	rectFrame.topLeft.y = (160-(SWord)rectFrame.extent.y)/2;

	saveWin = WinSaveBits (&rectFrame, &error);

	RctSetRectangle (&rect, rectFrame.topLeft.x+2, rectFrame.topLeft.y+2,
							rectFrame.extent.x-4, rectFrame.extent.y-4);

	WinEraseRectangle (&rect, 0);
	WinDrawRectangleFrame (dialogFrame, &rect);

	WinDrawChars (msg, msgLen, rectFrame.topLeft.x+4, rectFrame.topLeft.y+3);

	SysTaskDelay (delay);
	
	if (saveWin)
		WinRestoreBits (saveWin, rectFrame.topLeft.x, rectFrame.topLeft.y);
}


static void
doDialog (Word frmID)
{
	DmOpenRef		pluginDB;
	FormPtr			frm;

	pluginDB = DmOpenDatabaseByTypeCreator (PlugBasePluginType, appCreator, dmModeReadOnly);

	frm = FrmInitForm (frmID);
	FrmDoDialog (frm);
	FrmDeleteForm (frm);

	DmCloseDatabase (pluginDB);
}

/***********************************************************************
 *
 * FUNCTION:    mySysKeyboardDialogV10
 *
 * DESCRIPTION: SysKeyboardDialog patch code for PalmOS 1.0
 *
 * PARAMETERS:  nothing
 *
 * RETURNED:    nothing
 *
 * REVISION HISTORY:
 *			Name	Date		Description
 *			----	----		-----------
 *			Winter	9/20/98		Initial Revision
 *
 ***********************************************************************/
static void
mySysKeyboardDialogV10 (void)
{
	SysKeyboardDialogV10Ptr	pSysKeyboardDialogV10;

	// Do something here
	// .....
	msgBox ("Waiting for Keyboard", 200);

	// Call old Trap address of SysKeyboardDialog
	FtrGet (appCreator, sysTrapSysKeyboardDialogV10, (DWordPtr)(&pSysKeyboardDialogV10));
	(*pSysKeyboardDialogV10) ();
}

/***********************************************************************
 *
 * FUNCTION:    mySysKeyboardDialog
 *
 * DESCRIPTION: SysKeyboardDialog patch code for PalmOS 2.0 or later
 *
 * PARAMETERS:  kbd
 *
 * RETURNED:    nothing
 *
 * REVISION HISTORY:
 *			Name	Date		Description
 *			----	----		-----------
 *			Winter	9/20/98		Initial Revision
 *
 ***********************************************************************/
static void
mySysKeyboardDialog (KeyboardType kbd)
{
	SysKeyboardDialogPtr	pSysKeyboardDialog;

	// Do something here
	// .....
	msgBox ("Waiting for Keyboard", 200);

	// Call old Trap address of SysKeyboardDialog
	FtrGet (appCreator, sysTrapSysKeyboardDialog, (DWordPtr)(&pSysKeyboardDialog));
	(*pSysKeyboardDialog) (kbd);
}


static void
installSoftPenStrokeOfExample (
	PlugBaseAPIPtr apiP,
	ScreenAreaType from1, ScreenAreaType to1,
	ScreenAreaType from2, ScreenAreaType to2)
{
	SoftPenStrokeType	softPenStroke;

	if (!apiP) return;

	softPenStroke.type    = PlugBasePluginType;
	softPenStroke.creator = appCreator;

	softPenStroke.id      = SoftPenStroke1ID;
	softPenStroke.penFrom = from1;
	softPenStroke.penTo   = to1;
	(*(apiP->installSoftPenStroke)) (&softPenStroke);

	softPenStroke.id      = SoftPenStroke2ID;
	softPenStroke.penFrom = from2;
	softPenStroke.penTo   = to2;
	(*(apiP->installSoftPenStroke)) (&softPenStroke);
}

static void
uninstallSoftPenStrokeOfExample (PlugBaseAPIPtr apiP)
{
	SoftPenStrokeType	softPenStroke;

	if (!apiP) return;

	softPenStroke.type    = PlugBasePluginType;
	softPenStroke.creator = appCreator;

	softPenStroke.id      = SoftPenStroke1ID;
	(*(apiP->uninstallSoftPenStroke)) (&softPenStroke);

	softPenStroke.id      = SoftPenStroke2ID;
	(*(apiP->uninstallSoftPenStroke)) (&softPenStroke);
}

static void
configFormInit (FormPtr frm)
{
	PlugBaseAPIPtr apiP   = getAPIPtr ();

	if (apiP)
	{
		(*(apiP->setSoftPenStrokeListChoices)) (getListPtrByID (frm, ConfigFrom1List), areaFrom, true);
		(*(apiP->setSoftPenStrokeListChoices)) (getListPtrByID (frm, ConfigTo1List),   areaTo,   true);

		(*(apiP->setSoftPenStrokeListChoices)) (getListPtrByID (frm, ConfigFrom2List), areaFrom, true);
		(*(apiP->setSoftPenStrokeListChoices)) (getListPtrByID (frm, ConfigTo2List),   areaTo,   true);
	}

	setPopListByID (frm, ConfigFrom1PopTrigger,   ConfigFrom1List,   PenStroke1From);
	setPopListByID (frm, ConfigTo1PopTrigger,     ConfigTo1List,     PenStroke1To);

	setPopListByID (frm, ConfigFrom2PopTrigger,   ConfigFrom2List,   PenStroke2From);
	setPopListByID (frm, ConfigTo2PopTrigger,     ConfigTo2List,     PenStroke2To);
}

static void
configFromSave (FormPtr frm)
{
	ScreenAreaType	from1, to1;
	ScreenAreaType	from2, to2;
	PlugBaseAPIPtr	apiP;

	from1 = (ScreenAreaType) getListSelectionByID (frm, ConfigFrom1List);
	to1   = (ScreenAreaType) getListSelectionByID (frm, ConfigTo1List);

	from2 = (ScreenAreaType) getListSelectionByID (frm, ConfigFrom2List);
	to2   = (ScreenAreaType) getListSelectionByID (frm, ConfigTo2List);

	apiP = getAPIPtr ();
	if (apiP && (*(apiP->pluginEnabled)) (PlugBasePluginType, appCreator))
		installSoftPenStrokeOfExample (apiP, from1, to1, from2, to2);
}

static void
doConfig ()
{
	DmOpenRef		pluginDB;
	FormPtr			frm;

	pluginDB = DmOpenDatabaseByTypeCreator (PlugBasePluginType, appCreator, dmModeReadOnly);

	frm = FrmInitForm (ConfigForm);

	configFormInit (frm);

	if (FrmDoDialog (frm) == ConfigOKButton)
		configFromSave (frm);

	FrmDeleteForm (frm);

	DmCloseDatabase (pluginDB);
}

/***********************************************************************
 *
 * FUNCTION:    PilotMain
 *
 * DESCRIPTION: This is the main entry point for the Example1 application.
 *
 * PARAMETERS:  cmd
 *              cmdPBP
 *              launchFlags
 *
 * RETURNED:    nothing
 *
 * REVISION HISTORY:
 *			Name	Date		Description
 *			----	----		-----------
 *			Winter	9/20/98		Initial Revision
 *
 ***********************************************************************/
DWord
PilotMain (Word cmd, Ptr cmdPBP, Word launchFlags)
{
	PBLaunchParameterPtr	pmP = (PBLaunchParameterPtr) cmdPBP;

	// Get detailed imformation of the plugin by PlugBase
	if (cmd == PBLaunchCmd_GetInformation)
	{
		// This plugin support information panel
		// and can response PBLaunchCmd_ActivePluginInfoPanel Launch code
		pmP->data.getInformation.supportInfoPanel   = true;

		// This plugin support config panel
		// and can response PBLaunchCmd_ActivePluginControlPanel Launch code
		pmP->data.getInformation.supportConfigPanel = true;
		pmP->err = 0;
	}

	// Active infomation panel
	else if (cmd == PBLaunchCmd_ActivePluginInfoPanel)
	{
		doDialog (AboutForm);
		pmP->err = 0;
	}

	// Active Control panel
	else if (cmd == PBLaunchCmd_ActivePluginControlPanel)
	{
		doConfig ();
		pmP->err = 0;
	}

	// PlugBase send these Launch code to Attach/Detach plugin
	else if (cmd == PBLaunchCmd_PluginAttach || cmd == PBLaunchCmd_PluginDetach)
	{
		DmOpenRef			pluginDB;
		VoidHand			codeResH;
		HookTrapType		trapItem;
		DWord				romVersion;

		// Get PalmOS Rom Version to determine which version of
		// sysTrapSysKeyboardDialog will be patched.   
		FtrGet (sysFtrCreator, sysFtrNumROMVersion, &romVersion);

		pluginDB = DmOpenDatabaseByTypeCreator (PlugBasePluginType, appCreator, dmModeReadOnly);

		// Lock/Unlock code segment.
		// the code segment must be Locked/Unlocked by yourself,
		// if there has patch code in the code segment.
		codeResH  = DmGet1Resource (CodeResType, 1);
		if (cmd == PBLaunchCmd_PluginAttach)
			MemHandleLock (codeResH);
		else
			MemHandleUnlock (codeResH);
		DmReleaseResource (codeResH);
		DmCloseDatabase (pluginDB);

		// patch/unpatch sysTrapSysKeyboardDialog according to difference PalmOS
		trapItem.type        = PlugBasePluginType;
		trapItem.creator     = appCreator;
		if (romVersion < version20)
		{
			trapItem.trapNum     = sysTrapSysKeyboardDialogV10;
			trapItem.newTrapAddr = mySysKeyboardDialogV10;
		}
		else {
			trapItem.trapNum     = sysTrapSysKeyboardDialog;
			trapItem.newTrapAddr = mySysKeyboardDialog;
		}
		if (cmd == PBLaunchCmd_PluginAttach)
			(*(pmP->apiP->hookSysTrap)) (&trapItem);
		else
			(*(pmP->apiP->unhookSysTrap)) (&trapItem);

		// install/uninstall SoftPenStroke used by example1
		if (cmd == PBLaunchCmd_PluginAttach)
			installSoftPenStrokeOfExample (pmP->apiP, PenStroke1From, PenStroke1To, PenStroke2From, PenStroke2To);
		else
			uninstallSoftPenStrokeOfExample (pmP->apiP);

		pmP->err = 0;
	}

	// The installed SoftPenStroke has inputed by user, your must response it
	// by ID of SoftPenStroke installed by you. 
	else if (cmd == PBLaunchCmd_SoftPenStroke)
	{
		CharPtr	msg = 0;

		if (pmP->data.softPenStroke.id == SoftPenStroke1ID)
			msg = "SoftPenStroke1";
		else if (pmP->data.softPenStroke.id == SoftPenStroke2ID)
			msg = "SoftPenStroke2";

		if (msg) msgBox (msg, 100);

		pmP->err = 0;
	}

	return 0;
}

